/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.p3order.AbstractCrossingsCounter;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;

public class HyperedgeCrossingsCounter
extends AbstractCrossingsCounter {
    private final int[] portPos;

    public HyperedgeCrossingsCounter(int[] inLayerEdgeCount, boolean[] hasNorthSouthPorts, int[] portPos) {
        super(inLayerEdgeCount, hasNorthSouthPorts);
        this.portPos = portPos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int countCrossings(NodeGroup[] leftLayer, NodeGroup[] rightLayer) {
        int n;
        void var13_60;
        void var12_46;
        Object node232;
        int sourceCount = 0;
        NodeGroup[] nodeGroupArray = leftLayer;
        int n2 = leftLayer.length;
        int n22 = 0;
        while (n22 < n2) {
            NodeGroup nodeGroup = nodeGroupArray[n22];
            node232 = nodeGroup.getNode();
            if (((PortConstraints)node232.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort port : node232.getPorts()) {
                    int portEdges = 0;
                    for (LEdge lEdge : port.getOutgoingEdges()) {
                        if (node232.getLayer() == lEdge.getTarget().getNode().getLayer()) continue;
                        ++portEdges;
                    }
                    if (portEdges <= 0) continue;
                    this.portPos[port.id] = sourceCount++;
                }
            } else {
                int nodeEdges = 0;
                for (LPort port : node232.getPorts()) {
                    for (LEdge lEdge : port.getOutgoingEdges()) {
                        if (node232.getLayer() == lEdge.getTarget().getNode().getLayer()) continue;
                        ++nodeEdges;
                    }
                    this.portPos[port.id] = sourceCount;
                }
                if (nodeEdges > 0) {
                    ++sourceCount;
                }
            }
            ++n22;
        }
        int targetCount = 0;
        node232 = rightLayer;
        int n3 = rightLayer.length;
        n2 = 0;
        while (n2 < n3) {
            Object nodeGroup = node232[n2];
            LNode node = ((NodeGroup)nodeGroup).getNode();
            if (((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                int northInputPorts = 0;
                block14: for (LPort port : node.getPorts()) {
                    if (port.getSide() != PortSide.NORTH) break;
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++northInputPorts;
                        continue block14;
                    }
                }
                int otherInputPorts = 0;
                ListIterator<LPort> listIterator = node.getPorts().listIterator(node.getPorts().size());
                while (listIterator.hasPrevious()) {
                    LPort lPort = listIterator.previous();
                    int portEdges = 0;
                    for (LEdge lEdge : lPort.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++portEdges;
                    }
                    if (portEdges <= 0) continue;
                    if (lPort.getSide() == PortSide.NORTH) {
                        this.portPos[lPort.id] = targetCount++;
                        continue;
                    }
                    this.portPos[lPort.id] = targetCount + northInputPorts + otherInputPorts;
                    ++otherInputPorts;
                }
                targetCount += otherInputPorts;
            } else {
                int nodeEdges = 0;
                for (LPort port : node.getPorts()) {
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++nodeEdges;
                    }
                    this.portPos[port.id] = targetCount;
                }
                if (nodeEdges > 0) {
                    ++targetCount;
                }
            }
            ++n2;
        }
        HashMap port2HyperedgeMap = Maps.newHashMap();
        LinkedHashSet hyperedgeSet = Sets.newLinkedHashSet();
        NodeGroup[] nodeEdges = leftLayer;
        int node = leftLayer.length;
        int node232 = 0;
        while (node232 < node) {
            NodeGroup nodeGroup = nodeEdges[node232];
            LNode node3 = nodeGroup.getNode();
            for (LPort lPort : node3.getPorts()) {
                for (LEdge edge5 : lPort.getOutgoingEdges()) {
                    LPort targetPort = edge5.getTarget();
                    if (node3.getLayer() == targetPort.getNode().getLayer()) continue;
                    Hyperedge sourceHE = (Hyperedge)port2HyperedgeMap.get((Object)lPort);
                    Hyperedge targetHE = (Hyperedge)port2HyperedgeMap.get((Object)targetPort);
                    if (sourceHE == null && targetHE == null) {
                        Hyperedge hyperedge = new Hyperedge();
                        hyperedgeSet.add(hyperedge);
                        hyperedge.edges.add(edge5);
                        hyperedge.ports.add(lPort);
                        port2HyperedgeMap.put(lPort, hyperedge);
                        hyperedge.ports.add(targetPort);
                        port2HyperedgeMap.put(targetPort, hyperedge);
                        continue;
                    }
                    if (sourceHE == null) {
                        targetHE.edges.add(edge5);
                        targetHE.ports.add(lPort);
                        port2HyperedgeMap.put(lPort, targetHE);
                        continue;
                    }
                    if (targetHE == null) {
                        sourceHE.edges.add(edge5);
                        sourceHE.ports.add(targetPort);
                        port2HyperedgeMap.put(targetPort, sourceHE);
                        continue;
                    }
                    if (sourceHE == targetHE) {
                        sourceHE.edges.add(edge5);
                        continue;
                    }
                    sourceHE.edges.add(edge5);
                    for (LPort p : targetHE.ports) {
                        port2HyperedgeMap.put(p, sourceHE);
                    }
                    sourceHE.edges.addAll(targetHE.edges);
                    sourceHE.ports.addAll(targetHE.ports);
                    hyperedgeSet.remove(targetHE);
                }
            }
            ++node232;
        }
        Object[] hyperedges = hyperedgeSet.toArray(new Hyperedge[hyperedgeSet.size()]);
        Layer leftLayerRef = leftLayer[0].getNode().getLayer();
        Layer rightLayerRef = rightLayer[0].getNode().getLayer();
        Object[] objectArray = hyperedges;
        int n4 = hyperedges.length;
        int node3 = 0;
        while (node3 < n4) {
            Object he = objectArray[node3];
            ((Hyperedge)he).upperLeft = sourceCount;
            ((Hyperedge)he).upperRight = targetCount;
            for (LPort port : ((Hyperedge)he).ports) {
                int pos = this.portPos[port.id];
                if (port.getNode().getLayer() == leftLayerRef) {
                    if (pos < ((Hyperedge)he).upperLeft) {
                        ((Hyperedge)he).upperLeft = pos;
                    }
                    if (pos <= ((Hyperedge)he).lowerLeft) continue;
                    ((Hyperedge)he).lowerLeft = pos;
                    continue;
                }
                if (port.getNode().getLayer() != rightLayerRef) continue;
                if (pos < ((Hyperedge)he).upperRight) {
                    ((Hyperedge)he).upperRight = pos;
                }
                if (pos <= ((Hyperedge)he).lowerRight) continue;
                ((Hyperedge)he).lowerRight = pos;
            }
            ++node3;
        }
        Arrays.sort(hyperedges);
        int[] southSequence = new int[hyperedges.length];
        int[] compressDeltas = new int[targetCount + 1];
        boolean bl = false;
        while (var12_46 < hyperedges.length) {
            southSequence[var12_46] = ((Hyperedge)hyperedges[var12_46]).upperRight;
            compressDeltas[southSequence[var12_46]] = 1;
            ++var12_46;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        while (var13_60 < compressDeltas.length) {
            if (compressDeltas[var13_60] == 1) {
                compressDeltas[var13_60] = var12_48;
            } else {
                --var12_48;
            }
            ++var13_60;
        }
        boolean bl4 = false;
        int i3 = 0;
        while (i3 < southSequence.length) {
            int n5 = i3;
            southSequence[n5] = southSequence[n5] + compressDeltas[southSequence[i3]];
            n = Math.max(n, southSequence[i3] + 1);
            ++i3;
        }
        int firstIndex = 1;
        while (firstIndex < n) {
            firstIndex *= 2;
        }
        int n6 = 2 * firstIndex - 1;
        --firstIndex;
        int[] tree = new int[n6];
        int crossings = 0;
        int k = 0;
        while (k < southSequence.length) {
            int index;
            int n7 = index = southSequence[k] + firstIndex;
            tree[n7] = tree[n7] + 1;
            while (index > 0) {
                if (index % 2 > 0) {
                    crossings += tree[index + 1];
                }
                int n8 = index = (index - 1) / 2;
                tree[n8] = tree[n8] + 1;
            }
            ++k;
        }
        Object[] leftCorners = new HyperedgeCorner[hyperedges.length * 2];
        int i4 = 0;
        while (i4 < hyperedges.length) {
            leftCorners[2 * i4] = new HyperedgeCorner((Hyperedge)hyperedges[i4], ((Hyperedge)hyperedges[i4]).upperLeft, ((Hyperedge)hyperedges[i4]).lowerLeft, HyperedgeCorner.Type.UPPER);
            leftCorners[2 * i4 + 1] = new HyperedgeCorner((Hyperedge)hyperedges[i4], ((Hyperedge)hyperedges[i4]).lowerLeft, ((Hyperedge)hyperedges[i4]).upperLeft, HyperedgeCorner.Type.LOWER);
            ++i4;
        }
        Arrays.sort(leftCorners);
        int openHyperedges = 0;
        int i5 = 0;
        while (i5 < leftCorners.length) {
            switch (((HyperedgeCorner)leftCorners[i5]).type) {
                case UPPER: {
                    ++openHyperedges;
                    break;
                }
                case LOWER: {
                    crossings += --openHyperedges;
                }
            }
            ++i5;
        }
        Object[] rightCorners = new HyperedgeCorner[hyperedges.length * 2];
        int i6 = 0;
        while (i6 < hyperedges.length) {
            rightCorners[2 * i6] = new HyperedgeCorner((Hyperedge)hyperedges[i6], ((Hyperedge)hyperedges[i6]).upperRight, ((Hyperedge)hyperedges[i6]).lowerRight, HyperedgeCorner.Type.UPPER);
            rightCorners[2 * i6 + 1] = new HyperedgeCorner((Hyperedge)hyperedges[i6], ((Hyperedge)hyperedges[i6]).lowerRight, ((Hyperedge)hyperedges[i6]).upperRight, HyperedgeCorner.Type.LOWER);
            ++i6;
        }
        Arrays.sort(rightCorners);
        openHyperedges = 0;
        int i = 0;
        while (i < rightCorners.length) {
            switch (((HyperedgeCorner)rightCorners[i]).type) {
                case UPPER: {
                    ++openHyperedges;
                    break;
                }
                case LOWER: {
                    crossings += --openHyperedges;
                }
            }
            ++i;
        }
        return crossings;
    }

    private static class Hyperedge
    implements Comparable<Hyperedge> {
        private List<LEdge> edges = Lists.newArrayList();
        private List<LPort> ports = Lists.newArrayList();
        private int upperLeft;
        private int lowerLeft;
        private int upperRight;
        private int lowerRight;

        private Hyperedge() {
        }

        @Override
        public int compareTo(Hyperedge other) {
            if (this.upperLeft < other.upperLeft) {
                return -1;
            }
            if (this.upperLeft > other.upperLeft) {
                return 1;
            }
            if (this.upperRight < other.upperRight) {
                return -1;
            }
            if (this.upperRight > other.upperRight) {
                return 1;
            }
            return this.hashCode() - other.hashCode();
        }
    }

    private static class HyperedgeCorner
    implements Comparable<HyperedgeCorner> {
        private Hyperedge hyperedge;
        private int position;
        private int oppositePosition;
        private Type type;

        HyperedgeCorner(Hyperedge hyperedge, int position, int oppositePosition, Type type) {
            this.hyperedge = hyperedge;
            this.position = position;
            this.oppositePosition = oppositePosition;
            this.type = type;
        }

        @Override
        public int compareTo(HyperedgeCorner other) {
            if (this.position < other.position) {
                return -1;
            }
            if (this.position > other.position) {
                return 1;
            }
            if (this.oppositePosition < other.oppositePosition) {
                return -1;
            }
            if (this.oppositePosition > other.oppositePosition) {
                return 1;
            }
            if (this.hyperedge != other.hyperedge) {
                return this.hyperedge.hashCode() - other.hyperedge.hashCode();
            }
            if (this.type == Type.UPPER && other.type == Type.LOWER) {
                return -1;
            }
            if (this.type == Type.LOWER && other.type == Type.UPPER) {
                return 1;
            }
            return 0;
        }

        static enum Type {
            UPPER,
            LOWER;

        }
    }
}

