/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import de.cau.cs.kieler.klay.layered.p3order.AbstractCrossingsCounter;
import de.cau.cs.kieler.klay.layered.p3order.AbstractPortDistributor;
import de.cau.cs.kieler.klay.layered.p3order.BarthJuengerMutzelCrossingsCounter;
import de.cau.cs.kieler.klay.layered.p3order.BarycenterHeuristic;
import de.cau.cs.kieler.klay.layered.p3order.ForsterConstraintResolver;
import de.cau.cs.kieler.klay.layered.p3order.HyperedgeCrossingsCounter;
import de.cau.cs.kieler.klay.layered.p3order.ICrossingMinimizationHeuristic;
import de.cau.cs.kieler.klay.layered.p3order.LayerTotalPortDistributor;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.p3order.NodeRelativePortDistributor;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;

public final class LayerSweepCrossingMinimizer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.LONG_EDGE_SPLITTER).addBeforePhase4(IntermediateProcessorStrategy.PORT_DISTRIBUTER).addBeforePhase4(IntermediateProcessorStrategy.GREEDY_SWITCH).addBeforePhase4(IntermediateProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.LONG_EDGE_JOINER);
    private float[] portRanks;
    private NodeGroup[][] bestSweep;
    private NodeGroup[][] curSweep;
    private NodeGroup[][] prevSweep;
    private BarthJuengerMutzelCrossingsCounter normalCrossingsCounter;
    private HyperedgeCrossingsCounter hyperedgeCrossingsCounter;
    private AbstractCrossingsCounter inlayerCrossingsCounter;
    private boolean[] hasHyperedgesEast;
    private boolean[] hasHyperedgesWest;
    private final Multimap<LNode, LNode> layoutUnits = LinkedListMultimap.create();

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        IntermediateProcessingConfiguration configuration = IntermediateProcessingConfiguration.fromExisting(INTERMEDIATE_PROCESSING_CONFIGURATION);
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.NON_FREE_PORTS)) {
            configuration.addBeforePhase3(IntermediateProcessorStrategy.PORT_LIST_SORTER);
        }
        return configuration;
    }

    private void initialize(LGraph layeredGraph) {
        int layerCount = layeredGraph.getLayers().size();
        this.bestSweep = new NodeGroup[layerCount][];
        this.curSweep = new NodeGroup[layerCount][];
        this.prevSweep = new NodeGroup[layerCount][];
        int[] inLayerEdgeCount = new int[layerCount];
        boolean[] hasNorthSouthPorts = new boolean[layerCount];
        this.hasHyperedgesEast = new boolean[layerCount];
        this.hasHyperedgesWest = new boolean[layerCount];
        int nodeCount = 0;
        int portCount = 0;
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerIndex = layerIter.previousIndex();
            int layerNodeCount = layer.getNodes().size();
            assert (layerNodeCount > 0);
            this.bestSweep[layerIndex] = new NodeGroup[layerNodeCount];
            this.prevSweep[layerIndex] = new NodeGroup[layerNodeCount];
            this.curSweep[layerIndex] = new NodeGroup[layerNodeCount];
            inLayerEdgeCount[layerIndex] = 0;
            hasNorthSouthPorts[layerIndex] = false;
            ListIterator<LNode> nodeIter = layer.getNodes().listIterator();
            while (nodeIter.hasNext()) {
                NodeGroup nodeGroup;
                LNode node = nodeIter.next();
                this.curSweep[layerIndex][nodeIter.previousIndex()] = nodeGroup = new NodeGroup(node);
                node.id = nodeCount++;
                node.setProperty(InternalProperties.NODE_GROUP, nodeGroup);
                LNode layoutUnit = (LNode)((Object)node.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT));
                if (layoutUnit != null) {
                    this.layoutUnits.put((Object)layoutUnit, (Object)node);
                }
                for (LPort port : node.getPorts()) {
                    port.id = portCount++;
                    for (LEdge edge : port.getOutgoingEdges()) {
                        if (edge.getTarget().getNode().getLayer() != layer) continue;
                        int n = layerIndex;
                        inLayerEdgeCount[n] = inLayerEdgeCount[n] + 1;
                    }
                    if (port.getSide() == PortSide.EAST) {
                        if (port.getOutgoingEdges().size() + port.getIncomingEdges().size() <= 1) continue;
                        this.hasHyperedgesEast[layerIndex] = true;
                        continue;
                    }
                    if (port.getSide() == PortSide.WEST) {
                        if (port.getOutgoingEdges().size() + port.getIncomingEdges().size() <= 1) continue;
                        this.hasHyperedgesWest[layerIndex] = true;
                        continue;
                    }
                    assert (port.getOutgoingEdges().isEmpty() && port.getIncomingEdges().isEmpty());
                }
                if (node.getType() != LNode.NodeType.NORTH_SOUTH_PORT) continue;
                int n = layerIndex;
                inLayerEdgeCount[n] = inLayerEdgeCount[n] + 1;
                hasNorthSouthPorts[layerIndex] = true;
            }
        }
        boolean allLayerCombinationsHaveHyperedges = true;
        boolean noLayerCombinationHasHyperedges = true;
        int i = 0;
        while (i < this.hasHyperedgesWest.length - 1) {
            boolean b = this.hasHyperedgesEast[i] || this.hasHyperedgesWest[i + 1];
            allLayerCombinationsHaveHyperedges &= b;
            noLayerCombinationHasHyperedges &= !b;
            ++i;
        }
        this.portRanks = new float[portCount];
        int[] portPos = new int[portCount];
        if (!allLayerCombinationsHaveHyperedges) {
            this.normalCrossingsCounter = new BarthJuengerMutzelCrossingsCounter(inLayerEdgeCount, hasNorthSouthPorts, portPos);
            this.inlayerCrossingsCounter = this.normalCrossingsCounter;
        }
        if (!noLayerCombinationHasHyperedges) {
            this.hyperedgeCrossingsCounter = new HyperedgeCrossingsCounter(inLayerEdgeCount, hasNorthSouthPorts, portPos);
            this.inlayerCrossingsCounter = this.hyperedgeCrossingsCounter;
        }
    }

    private void dispose() {
        this.portRanks = null;
        this.bestSweep = null;
        this.curSweep = null;
        this.prevSweep = null;
        this.normalCrossingsCounter = null;
        this.hyperedgeCrossingsCounter = null;
        this.hasHyperedgesEast = null;
        this.hasHyperedgesWest = null;
        this.layoutUnits.clear();
    }

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Layer sweep crossing minimization", 1.0f);
        Random random = (Random)layeredGraph.getProperty(InternalProperties.RANDOM);
        int layerCount = layeredGraph.getLayers().size();
        if (layerCount < 2) {
            monitor.done();
            return;
        }
        this.initialize(layeredGraph);
        int bestSweepCrossings = Integer.MAX_VALUE;
        int runCount = (Integer)layeredGraph.getProperty(Properties.THOROUGHNESS);
        ForsterConstraintResolver constraintResolver = new ForsterConstraintResolver(this.layoutUnits);
        BarycenterHeuristic crossminHeuristic = new BarycenterHeuristic(constraintResolver, random, this.portRanks);
        NodeRelativePortDistributor nodeRelativePortDistributor = new NodeRelativePortDistributor(this.portRanks);
        LayerTotalPortDistributor layerTotalPortDistributor = new LayerTotalPortDistributor(this.portRanks);
        int run = 0;
        while (run < runCount && bestSweepCrossings > 0) {
            boolean forward = random.nextBoolean();
            int fixedLayerIndex = forward ? 0 : layerCount - 1;
            NodeGroup[] fixedLayer = this.curSweep[fixedLayerIndex];
            AbstractPortDistributor portDistributor = random.nextBoolean() ? nodeRelativePortDistributor : layerTotalPortDistributor;
            this.minimizeCrossings(fixedLayer, crossminHeuristic, forward, false, true);
            int curSweepCrossings = Integer.MAX_VALUE;
            int prevSweepCrossings = Integer.MAX_VALUE;
            boolean firstSweep = true;
            do {
                LayerSweepCrossingMinimizer.copySweep(this.curSweep, this.prevSweep);
                prevSweepCrossings = curSweepCrossings;
                curSweepCrossings = 0;
                curSweepCrossings += this.inlayerCrossingsCounter.countCrossings(fixedLayer, fixedLayerIndex);
                if (forward) {
                    layerIndex = 1;
                    while (layerIndex < layerCount) {
                        freeLayer = this.curSweep[layerIndex];
                        portDistributor.calculatePortRanks(fixedLayer, PortType.OUTPUT);
                        this.minimizeCrossings(freeLayer, crossminHeuristic, true, !firstSweep, false);
                        curSweepCrossings += this.inlayerCrossingsCounter.countCrossings(freeLayer, layerIndex);
                        curSweepCrossings = this.hasHyperedgesWest[layerIndex] || this.hasHyperedgesEast[layerIndex - 1] ? (curSweepCrossings += this.hyperedgeCrossingsCounter.countCrossings(fixedLayer, freeLayer)) : (curSweepCrossings += this.normalCrossingsCounter.countCrossings(fixedLayer, freeLayer));
                        fixedLayer = freeLayer;
                        ++layerIndex;
                    }
                    fixedLayerIndex = layerCount - 1;
                } else {
                    layerIndex = layerCount - 2;
                    while (layerIndex >= 0) {
                        freeLayer = this.curSweep[layerIndex];
                        portDistributor.calculatePortRanks(fixedLayer, PortType.INPUT);
                        this.minimizeCrossings(freeLayer, crossminHeuristic, false, !firstSweep, false);
                        curSweepCrossings += this.inlayerCrossingsCounter.countCrossings(freeLayer, layerIndex);
                        curSweepCrossings = this.hasHyperedgesEast[layerIndex] || this.hasHyperedgesWest[layerIndex + 1] ? (curSweepCrossings += this.hyperedgeCrossingsCounter.countCrossings(freeLayer, fixedLayer)) : (curSweepCrossings += this.normalCrossingsCounter.countCrossings(freeLayer, fixedLayer));
                        fixedLayer = freeLayer;
                        --layerIndex;
                    }
                    fixedLayerIndex = 0;
                }
                firstSweep = false;
                boolean bl = forward = !forward;
            } while (curSweepCrossings < prevSweepCrossings && curSweepCrossings > 0);
            if (curSweepCrossings < bestSweepCrossings || prevSweepCrossings < bestSweepCrossings) {
                if (curSweepCrossings <= prevSweepCrossings) {
                    LayerSweepCrossingMinimizer.copySweep(this.curSweep, this.bestSweep);
                    bestSweepCrossings = curSweepCrossings;
                } else {
                    LayerSweepCrossingMinimizer.copySweep(this.prevSweep, this.bestSweep);
                    bestSweepCrossings = prevSweepCrossings;
                }
            }
            ++run;
        }
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            NodeGroup[] nodes = this.bestSweep[layerIter.previousIndex()];
            ListIterator<LNode> nodeIter = layer.getNodes().listIterator();
            while (nodeIter.hasNext()) {
                nodeIter.next();
                nodeIter.set(nodes[nodeIter.previousIndex()].getNode());
            }
        }
        this.dispose();
        monitor.done();
    }

    private void minimizeCrossings(NodeGroup[] layer, ICrossingMinimizationHeuristic heuristic, boolean forward, boolean preOrdered, boolean randomize) {
        ArrayList nodeGroups = Lists.newArrayList();
        NodeGroup[] nodeGroupArray = layer;
        int n = layer.length;
        int n2 = 0;
        while (n2 < n) {
            NodeGroup ng = nodeGroupArray[n2];
            nodeGroups.add(ng);
            ++n2;
        }
        heuristic.minimizeCrossings(nodeGroups, preOrdered, randomize, forward);
        int index = 0;
        for (NodeGroup nodeGroup : nodeGroups) {
            LNode[] lNodeArray = nodeGroup.getNodes();
            int n3 = lNodeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                LNode node = lNodeArray[n4];
                layer[index++] = (NodeGroup)node.getProperty(InternalProperties.NODE_GROUP);
                ++n4;
            }
        }
    }

    private static void copySweep(NodeGroup[][] source, NodeGroup[][] dest) {
        int i = 0;
        while (i < dest.length) {
            int j = 0;
            while (j < dest[i].length) {
                dest[i][j] = source[i][j];
                ++j;
            }
            ++i;
        }
    }
}

