/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p3order.AbstractPortDistributor;
import de.cau.cs.kieler.klay.layered.properties.PortType;

public final class NodeRelativePortDistributor
extends AbstractPortDistributor {
    private static final float INCR_ONE = 0.3f;
    private static final float INCR_TWO = 0.5f;
    private static final float INCR_THREE = 0.7f;
    private static final float INCR_FOUR = 0.9f;

    public NodeRelativePortDistributor(float[] portRanks) {
        super(portRanks);
    }

    @Override
    protected float calculatePortRanks(LNode node, float rankSum, PortType type) {
        block11: {
            block10: {
                float[] portRanks = this.getPortRanks();
                if (!((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) break block10;
                switch (type) {
                    case INPUT: {
                        int inputCount = 0;
                        int northInputCount = 0;
                        for (LPort port : node.getPorts()) {
                            if (port.getIncomingEdges().isEmpty()) continue;
                            ++inputCount;
                            if (port.getSide() != PortSide.NORTH) continue;
                            ++northInputCount;
                        }
                        float incr = 1.0f / (float)(inputCount + 1);
                        float northPos = rankSum + (float)northInputCount * incr;
                        float restPos = rankSum + 1.0f - incr;
                        for (LPort port : node.getPorts(PortType.INPUT)) {
                            if (port.getSide() == PortSide.NORTH) {
                                portRanks[port.id] = northPos;
                                northPos -= incr;
                                continue;
                            }
                            portRanks[port.id] = restPos;
                            restPos -= incr;
                        }
                        break block11;
                    }
                    case OUTPUT: {
                        int outputCount = 0;
                        for (LPort port : node.getPorts()) {
                            if (port.getOutgoingEdges().isEmpty()) continue;
                            ++outputCount;
                        }
                        float incr = 1.0f / (float)(outputCount + 1);
                        float pos = rankSum + incr;
                        for (LPort port : node.getPorts(PortType.OUTPUT)) {
                            portRanks[port.id] = pos;
                            pos += incr;
                        }
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Port type is undefined");
                    }
                }
            }
            for (LPort port : node.getPorts(type)) {
                portRanks[port.id] = rankSum + NodeRelativePortDistributor.getPortIncr(type, port.getSide());
            }
        }
        return 1.0f;
    }

    private static float getPortIncr(PortType type, PortSide side) {
        switch (type) {
            case INPUT: {
                switch (side) {
                    case NORTH: {
                        return 0.3f;
                    }
                    case WEST: {
                        return 0.5f;
                    }
                    case SOUTH: {
                        return 0.7f;
                    }
                    case EAST: {
                        return 0.9f;
                    }
                }
                break;
            }
            case OUTPUT: {
                switch (side) {
                    case NORTH: {
                        return 0.3f;
                    }
                    case EAST: {
                        return 0.5f;
                    }
                    case SOUTH: {
                        return 0.7f;
                    }
                    case WEST: {
                        return 0.9f;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Port type is undefined");
            }
        }
        return 0.0f;
    }
}

