/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p4nodes;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Spacings;
import java.util.Set;

public final class InteractiveNodePlacer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration HIERARCHY_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase5(IntermediateProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);
    private Spacings spacings;

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Interactive node placement", 1.0f);
        this.spacings = (Spacings)layeredGraph.getProperty(InternalProperties.SPACINGS);
        for (Layer layer : layeredGraph) {
            this.placeNodes(layer);
        }
        monitor.done();
    }

    private void placeNodes(Layer layer) {
        double minValidY = Double.NEGATIVE_INFINITY;
        LNode.NodeType prevNodeType = LNode.NodeType.NORMAL;
        for (LNode node : layer) {
            float spacing;
            LNode.NodeType nodeType = node.getType();
            if (nodeType != LNode.NodeType.NORMAL) {
                Double originalYCoordinate = (Double)node.getProperty(InternalProperties.ORIGINAL_DUMMY_NODE_POSITION);
                if (originalYCoordinate == null) {
                    minValidY = Math.max(minValidY, 0.0);
                    node.getPosition().y = minValidY + (double)this.spacings.getVerticalSpacing(nodeType, prevNodeType);
                } else {
                    node.getPosition().y = originalYCoordinate;
                }
            }
            if (node.getPosition().y < minValidY + (double)(spacing = this.spacings.getVerticalSpacing(nodeType, prevNodeType)) + node.getMargin().top) {
                node.getPosition().y = minValidY + (double)spacing + node.getMargin().top;
            }
            minValidY = node.getPosition().y + node.getSize().y + node.getMargin().bottom;
            prevNodeType = nodeType;
        }
    }
}

