/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p4nodes;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.DebugUtil;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.Spacings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class LinearSegmentsNodePlacer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration HIERARCHY_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase5(IntermediateProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);
    private static final Property<Integer> INPUT_PRIO = new Property("linearSegments.inputPrio", (Object)0);
    private static final Property<Integer> OUTPUT_PRIO = new Property("linearSegments.outputPrio", (Object)0);
    private LinearSegment[] linearSegments;
    private Spacings spacings;
    private static final double THRESHOLD_FACTOR = 20.0;
    private static final int PENDULUM_ITERS = 4;
    private static final int FINAL_ITERS = 3;
    private static final double OVERLAP_DETECT = 1.0E-4;

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Linear segments node placement", 1.0f);
        this.spacings = (Spacings)layeredGraph.getProperty(InternalProperties.SPACINGS);
        this.sortLinearSegments(layeredGraph);
        this.createUnbalancedPlacement(layeredGraph);
        this.balancePlacement(layeredGraph);
        this.postProcess(layeredGraph);
        this.linearSegments = null;
        this.spacings = null;
        monitor.done();
    }

    private LinearSegment[] sortLinearSegments(LGraph layeredGraph) {
        ArrayList segmentList = Lists.newArrayList();
        for (Layer layer : layeredGraph) {
            for (Object node : layer) {
                ((LNode)((Object)node)).id = -1;
                int inprio = Integer.MIN_VALUE;
                int outprio = Integer.MIN_VALUE;
                for (LPort port : ((LNode)((Object)node)).getPorts()) {
                    int prio;
                    for (LEdge edge : port.getIncomingEdges()) {
                        prio = (Integer)edge.getProperty(InternalProperties.PRIORITY);
                        inprio = Math.max(inprio, prio);
                    }
                    for (LEdge edge : port.getOutgoingEdges()) {
                        prio = (Integer)edge.getProperty(InternalProperties.PRIORITY);
                        outprio = Math.max(outprio, prio);
                    }
                }
                node.setProperty(INPUT_PRIO, (Object)inprio);
                node.setProperty(OUTPUT_PRIO, (Object)outprio);
            }
        }
        int nextLinearSegmentID = 0;
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                if (node.id >= 0) continue;
                LinearSegment segment = new LinearSegment();
                segment.id = nextLinearSegmentID++;
                this.fillSegment(node, segment);
                segmentList.add(segment);
            }
        }
        ArrayList outgoingList = Lists.newArrayListWithCapacity((int)segmentList.size());
        ArrayList incomingCountList = Lists.newArrayListWithCapacity((int)segmentList.size());
        int i = 0;
        while (i < segmentList.size()) {
            outgoingList.add(new ArrayList());
            incomingCountList.add(0);
            ++i;
        }
        this.createDependencyGraphEdges(layeredGraph, segmentList, outgoingList, incomingCountList);
        LinearSegment[] segments = segmentList.toArray(new LinearSegment[segmentList.size()]);
        List[] outgoing = outgoingList.toArray(new List[outgoingList.size()]);
        int[] incomingCount = new int[incomingCountList.size()];
        int i2 = 0;
        while (i2 < incomingCount.length) {
            incomingCount[i2] = (Integer)incomingCountList.get(i2);
            ++i2;
        }
        int nextRank = 0;
        ArrayList noIncoming = Lists.newArrayList();
        int i3 = 0;
        while (i3 < segments.length) {
            if (incomingCount[i3] == 0) {
                noIncoming.add(segments[i3]);
            }
            ++i3;
        }
        int[] newRanks = new int[segments.length];
        while (!noIncoming.isEmpty()) {
            LinearSegment segment = (LinearSegment)noIncoming.remove(0);
            newRanks[segment.id] = nextRank++;
            while (!outgoing[segment.id].isEmpty()) {
                LinearSegment target = (LinearSegment)outgoing[segment.id].remove(0);
                int n = target.id;
                incomingCount[n] = incomingCount[n] - 1;
                if (incomingCount[target.id] != 0) continue;
                noIncoming.add(target);
            }
        }
        this.linearSegments = new LinearSegment[segments.length];
        int i4 = 0;
        while (i4 < segments.length) {
            assert (outgoing[i4].isEmpty());
            LinearSegment ls = segments[i4];
            int rank = newRanks[i4];
            this.linearSegments[rank] = ls;
            ls.id = rank;
            for (LNode node : ls.nodes) {
                node.id = rank;
            }
            ++i4;
        }
        return this.linearSegments;
    }

    private void createDependencyGraphEdges(LGraph layeredGraph, List<LinearSegment> segmentList, List<List<LinearSegment>> outgoingList, List<Integer> incomingCountList) {
        int nextLinearSegmentID = segmentList.size();
        int layerIndex = 0;
        for (Layer layer : layeredGraph) {
            List<LNode> nodes = layer.getNodes();
            if (nodes.isEmpty()) continue;
            Iterator<LNode> nodeIter = nodes.iterator();
            int indexInLayer = 0;
            LNode previousNode = null;
            LNode currentNode = nodeIter.next();
            LinearSegment currentSegment = null;
            while (currentNode != null) {
                currentSegment = segmentList.get(currentNode.id);
                if (currentSegment.indexInLastLayer >= 0) {
                    LinearSegment cycleSegment = null;
                    ListIterator<LNode> cycleNodesIter = layer.getNodes().listIterator(indexInLayer + 1);
                    while (cycleNodesIter.hasNext()) {
                        LNode cycleNode = (LNode)((Object)cycleNodesIter.next());
                        cycleSegment = segmentList.get(cycleNode.id);
                        if (cycleSegment.lastLayer == currentSegment.lastLayer && cycleSegment.indexInLastLayer < currentSegment.indexInLastLayer) break;
                        cycleSegment = null;
                    }
                    if (cycleSegment != null) {
                        if (previousNode != null) {
                            incomingCountList.set(currentNode.id, incomingCountList.get(currentNode.id) - 1);
                            outgoingList.get(previousNode.id).remove(currentSegment);
                        }
                        currentSegment = currentSegment.split(currentNode, nextLinearSegmentID++);
                        segmentList.add(currentSegment);
                        outgoingList.add(new ArrayList());
                        if (previousNode != null) {
                            outgoingList.get(previousNode.id).add(currentSegment);
                            incomingCountList.add(1);
                        } else {
                            incomingCountList.add(0);
                        }
                    }
                }
                LNode nextNode = null;
                if (nodeIter.hasNext()) {
                    nextNode = nodeIter.next();
                    LinearSegment nextSegment = segmentList.get(nextNode.id);
                    outgoingList.get(currentNode.id).add(nextSegment);
                    incomingCountList.set(nextNode.id, incomingCountList.get(nextNode.id) + 1);
                }
                currentSegment.lastLayer = layerIndex;
                currentSegment.indexInLastLayer = indexInLayer++;
                previousNode = currentNode;
                currentNode = nextNode;
            }
            ++layerIndex;
        }
        if (((Boolean)layeredGraph.getProperty(LayoutOptions.DEBUG_MODE)).booleanValue()) {
            DebugUtil.writeDebugGraph(layeredGraph, segmentList, outgoingList);
        }
    }

    private boolean fillSegment(LNode node, LinearSegment segment) {
        LNode.NodeType nodeType = node.getType();
        if (((Boolean)node.getProperty(InternalProperties.BIG_NODE_INITIAL)).booleanValue()) {
            nodeType = LNode.NodeType.BIG_NODE;
        }
        if (node.id >= 0) {
            return false;
        }
        if (segment.nodeType != null && nodeType == LNode.NodeType.BIG_NODE && nodeType != segment.nodeType) {
            return false;
        }
        node.id = segment.id;
        segment.nodes.add(node);
        segment.nodeType = nodeType;
        if (nodeType == LNode.NodeType.LONG_EDGE || nodeType == LNode.NodeType.NORTH_SOUTH_PORT || nodeType == LNode.NodeType.BIG_NODE) {
            for (LPort sourcePort : node.getPorts()) {
                for (LPort targetPort : sourcePort.getSuccessorPorts()) {
                    LNode targetNode = targetPort.getNode();
                    LNode.NodeType targetNodeType = targetNode.getType();
                    if (node.getLayer() == targetNode.getLayer() || !(nodeType == LNode.NodeType.BIG_NODE ? targetNodeType == LNode.NodeType.BIG_NODE && this.fillSegment(targetNode, segment) : (targetNodeType == LNode.NodeType.LONG_EDGE || targetNodeType == LNode.NodeType.NORTH_SOUTH_PORT) && this.fillSegment(targetNode, segment))) continue;
                    return true;
                }
            }
        }
        return true;
    }

    private void createUnbalancedPlacement(LGraph layeredGraph) {
        int[] nodeCount = new int[layeredGraph.getLayers().size()];
        LNode.NodeType[] recentNodeType = new LNode.NodeType[layeredGraph.getLayers().size()];
        LinearSegment[] linearSegmentArray = this.linearSegments;
        int n = this.linearSegments.length;
        int n2 = 0;
        while (n2 < n) {
            LinearSegment segment = linearSegmentArray[n2];
            double uppermostPlace = 0.0;
            for (LNode node : segment.nodes) {
                int layerIndex;
                LNode.NodeType nodeType = node.getType();
                int n3 = layerIndex = node.getLayer().getIndex();
                nodeCount[n3] = nodeCount[n3] + 1;
                float spacing = this.spacings.edgeEdgeSpacing * this.spacings.inLayerSpacingFactor;
                if (nodeCount[layerIndex] > 0 && recentNodeType[layerIndex] != null) {
                    spacing = this.spacings.getVerticalSpacing(recentNodeType[layerIndex], nodeType);
                }
                uppermostPlace = Math.max(uppermostPlace, node.getLayer().getSize().y + (double)spacing);
            }
            for (LNode node : segment.nodes) {
                node.getPosition().y = uppermostPlace + node.getMargin().top;
                Layer layer = node.getLayer();
                layer.getSize().y = uppermostPlace + node.getMargin().top + node.getSize().y + node.getMargin().bottom;
                recentNodeType[layer.getIndex()] = node.getType();
            }
            ++n2;
        }
    }

    private void balancePlacement(LGraph layeredGraph) {
        double deflectionDampening = ((Float)layeredGraph.getProperty(Properties.LINEAR_SEGMENTS_DEFLECTION_DAMPENING)).doubleValue();
        int thoroughness = (Integer)layeredGraph.getProperty(Properties.THOROUGHNESS);
        int pendulumIters = 4;
        int finalIters = 3;
        double threshold = 20.0 / (double)thoroughness;
        boolean ready = false;
        Mode mode = Mode.FORW_PENDULUM;
        double lastTotalDeflection = 2.147483647E9;
        do {
            boolean merged;
            boolean incoming = mode != Mode.BACKW_PENDULUM;
            boolean outgoing = mode != Mode.FORW_PENDULUM;
            double totalDeflection = 0.0;
            LinearSegment[] linearSegmentArray = this.linearSegments;
            int n = this.linearSegments.length;
            int n2 = 0;
            while (n2 < n) {
                LinearSegment segment = linearSegmentArray[n2];
                segment.refSegment = null;
                this.calcDeflection(segment, incoming, outgoing, deflectionDampening);
                totalDeflection += Math.abs(segment.deflection);
                ++n2;
            }
            while (merged = this.mergeRegions(layeredGraph)) {
            }
            LinearSegment[] linearSegmentArray2 = this.linearSegments;
            int n3 = this.linearSegments.length;
            n = 0;
            while (n < n3) {
                LinearSegment segment = linearSegmentArray2[n];
                double deflection = segment.region().deflection;
                if (deflection != 0.0) {
                    for (LNode node : segment.nodes) {
                        node.getPosition().y += deflection;
                    }
                }
                ++n;
            }
            if (mode == Mode.FORW_PENDULUM || mode == Mode.BACKW_PENDULUM) {
                if (--pendulumIters <= 0 && (totalDeflection < lastTotalDeflection || -pendulumIters > thoroughness)) {
                    mode = Mode.RUBBER;
                    lastTotalDeflection = 2.147483647E9;
                    continue;
                }
                if (mode == Mode.FORW_PENDULUM) {
                    mode = Mode.BACKW_PENDULUM;
                    lastTotalDeflection = totalDeflection;
                    continue;
                }
                mode = Mode.FORW_PENDULUM;
                lastTotalDeflection = totalDeflection;
                continue;
            }
            ready = totalDeflection >= lastTotalDeflection || lastTotalDeflection - totalDeflection < threshold;
            lastTotalDeflection = totalDeflection;
            if (!ready) continue;
            --finalIters;
        } while (!ready || finalIters > 0);
    }

    private void calcDeflection(LinearSegment segment, boolean incoming, boolean outgoing, double deflectionDampening) {
        double segmentDeflection = 0.0;
        int nodeWeightSum = 0;
        for (LNode node : segment.nodes) {
            double nodeDeflection = 0.0;
            int edgeWeightSum = 0;
            int inputPrio = incoming ? (Integer)node.getProperty((IProperty)INPUT_PRIO) : Integer.MIN_VALUE;
            int outputPrio = outgoing ? (Integer)node.getProperty((IProperty)OUTPUT_PRIO) : Integer.MIN_VALUE;
            int minPrio = Math.max(inputPrio, outputPrio);
            for (LPort port : node.getPorts()) {
                int prio;
                int otherPrio;
                LNode otherNode;
                LPort otherPort;
                double portpos = node.getPosition().y + port.getPosition().y + port.getAnchor().y;
                if (outgoing) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        otherPort = edge.getTarget();
                        otherNode = otherPort.getNode();
                        if (segment == this.linearSegments[otherNode.id]) continue;
                        otherPrio = Math.max((Integer)otherNode.getProperty((IProperty)INPUT_PRIO), (Integer)otherNode.getProperty((IProperty)OUTPUT_PRIO));
                        prio = (Integer)edge.getProperty(InternalProperties.PRIORITY);
                        if (prio < minPrio || prio < otherPrio) continue;
                        nodeDeflection += otherNode.getPosition().y + otherPort.getPosition().y + otherPort.getAnchor().y - portpos;
                        ++edgeWeightSum;
                    }
                }
                if (!incoming) continue;
                for (LEdge edge : port.getIncomingEdges()) {
                    otherPort = edge.getSource();
                    otherNode = otherPort.getNode();
                    if (segment == this.linearSegments[otherNode.id]) continue;
                    otherPrio = Math.max((Integer)otherNode.getProperty((IProperty)INPUT_PRIO), (Integer)otherNode.getProperty((IProperty)OUTPUT_PRIO));
                    prio = (Integer)edge.getProperty(InternalProperties.PRIORITY);
                    if (prio < minPrio || prio < otherPrio) continue;
                    nodeDeflection += otherNode.getPosition().y + otherPort.getPosition().y + otherPort.getAnchor().y - portpos;
                    ++edgeWeightSum;
                }
            }
            if (edgeWeightSum <= 0) continue;
            segmentDeflection += nodeDeflection / (double)edgeWeightSum;
            ++nodeWeightSum;
        }
        if (nodeWeightSum > 0) {
            segment.deflection = deflectionDampening * segmentDeflection / (double)nodeWeightSum;
            segment.weight = nodeWeightSum;
        } else {
            segment.deflection = 0.0;
            segment.weight = 0;
        }
    }

    private boolean mergeRegions(LGraph layeredGraph) {
        boolean changed = false;
        double threshold = 1.0E-4 * (double)this.spacings.nodeSpacing * (double)this.spacings.inLayerSpacingFactor;
        for (Layer layer : layeredGraph) {
            Iterator<LNode> nodeIter = layer.getNodes().iterator();
            LNode node1 = nodeIter.next();
            LinearSegment region1 = this.linearSegments[node1.id].region();
            while (nodeIter.hasNext()) {
                double node2Extent;
                double spacing;
                double node1Extent;
                LNode node2 = nodeIter.next();
                LinearSegment region2 = this.linearSegments[node2.id].region();
                if (region1 != region2 && (node1Extent = node1.getPosition().y + node1.getSize().y + node1.getMargin().bottom + region1.deflection + (spacing = (double)this.spacings.getVerticalSpacing(node1, node2))) > (node2Extent = node2.getPosition().y - node2.getMargin().top + region2.deflection) + threshold) {
                    int weightSum = region1.weight + region2.weight;
                    assert (weightSum > 0);
                    region2.deflection = ((double)region2.weight * region2.deflection + (double)region1.weight * region1.deflection) / (double)weightSum;
                    region2.weight = weightSum;
                    region1.refSegment = region2;
                    changed = true;
                }
                node1 = node2;
                region1 = region2;
            }
        }
        return changed;
    }

    private void postProcess(LGraph layeredGraph) {
        LinearSegment[] linearSegmentArray = this.linearSegments;
        int n = this.linearSegments.length;
        int n2 = 0;
        while (n2 < n) {
            LinearSegment segment = linearSegmentArray[n2];
            double minRoomAbove = 2.147483647E9;
            double minRoomBelow = 2.147483647E9;
            for (LNode node : segment.nodes) {
                double roomBelow;
                double roomAbove;
                float spacing;
                LNode neighbor;
                int index = node.getIndex();
                if (index > 0) {
                    neighbor = node.getLayer().getNodes().get(index - 1);
                    spacing = this.spacings.getVerticalSpacing(node, neighbor);
                    roomAbove = node.getPosition().y - node.getMargin().top - (neighbor.getPosition().y + neighbor.getSize().y + neighbor.getMargin().bottom + (double)spacing);
                } else {
                    roomAbove = node.getPosition().y - node.getMargin().top;
                }
                minRoomAbove = Math.min(roomAbove, minRoomAbove);
                if (index < node.getLayer().getNodes().size() - 1) {
                    neighbor = node.getLayer().getNodes().get(index + 1);
                    spacing = this.spacings.getVerticalSpacing(node, neighbor);
                    roomBelow = neighbor.getPosition().y - neighbor.getMargin().top - (node.getPosition().y + node.getSize().y + node.getMargin().bottom + (double)spacing);
                } else {
                    roomBelow = 2.0 * node.getPosition().y;
                }
                minRoomBelow = Math.min(roomBelow, minRoomBelow);
            }
            double minDisplacement = 2.147483647E9;
            boolean foundPlace = false;
            LNode firstNode = segment.nodes.get(0);
            for (LPort target : firstNode.getPorts()) {
                double pos = firstNode.getPosition().y + target.getPosition().y + target.getAnchor().y;
                for (LEdge edge : target.getIncomingEdges()) {
                    LPort source = edge.getSource();
                    double d = source.getNode().getPosition().y + source.getPosition().y + source.getAnchor().y - pos;
                    if (!(Math.abs(d) < Math.abs(minDisplacement))) continue;
                    double d2 = Math.abs(d);
                    double d3 = d < 0.0 ? minRoomAbove : minRoomBelow;
                    if (!(d2 < d3)) continue;
                    minDisplacement = d;
                    foundPlace = true;
                }
            }
            LNode lastNode = segment.nodes.get(segment.nodes.size() - 1);
            for (LPort source : lastNode.getPorts()) {
                double pos = lastNode.getPosition().y + source.getPosition().y + source.getAnchor().y;
                for (LEdge edge : source.getOutgoingEdges()) {
                    LPort target = edge.getTarget();
                    double d = target.getNode().getPosition().y + target.getPosition().y + target.getAnchor().y - pos;
                    if (!(Math.abs(d) < Math.abs(minDisplacement))) continue;
                    double d4 = Math.abs(d);
                    double d5 = d < 0.0 ? minRoomAbove : minRoomBelow;
                    if (!(d4 < d5)) continue;
                    minDisplacement = d;
                    foundPlace = true;
                }
            }
            if (foundPlace && minDisplacement != 0.0) {
                for (LNode node : segment.nodes) {
                    node.getPosition().y += minDisplacement;
                }
            }
            ++n2;
        }
    }

    public static class LinearSegment
    implements Comparable<LinearSegment> {
        private List<LNode> nodes = Lists.newArrayList();
        private int id;
        private int indexInLastLayer = -1;
        private int lastLayer = -1;
        private double deflection;
        private int weight;
        private LinearSegment refSegment;
        private LNode.NodeType nodeType;

        LinearSegment region() {
            LinearSegment seg = this;
            while (seg.refSegment != null) {
                seg = seg.refSegment;
            }
            return seg;
        }

        LinearSegment split(LNode node, int newId) {
            int nodeIndex = this.nodes.indexOf((Object)node);
            LinearSegment newSegment = new LinearSegment();
            newSegment.id = newId;
            ListIterator<LNode> iterator = this.nodes.listIterator(nodeIndex);
            while (iterator.hasNext()) {
                LNode movedNode = iterator.next();
                movedNode.id = newId;
                newSegment.nodes.add(movedNode);
                iterator.remove();
            }
            return newSegment;
        }

        public String toString() {
            return "ls" + this.nodes.toString();
        }

        @Override
        public int compareTo(LinearSegment other) {
            return this.id - other.id;
        }

        public boolean equals(Object object) {
            if (object instanceof LinearSegment) {
                LinearSegment other = (LinearSegment)object;
                return this.id == other.id;
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }
    }

    private static enum Mode {
        FORW_PENDULUM,
        BACKW_PENDULUM,
        RUBBER;

    }
}

