/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p4nodes;

import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.ILayoutPhaseFactory;
import de.cau.cs.kieler.klay.layered.p4nodes.InteractiveNodePlacer;
import de.cau.cs.kieler.klay.layered.p4nodes.LinearSegmentsNodePlacer;
import de.cau.cs.kieler.klay.layered.p4nodes.NetworkSimplexPlacer;
import de.cau.cs.kieler.klay.layered.p4nodes.SimpleNodePlacer;
import de.cau.cs.kieler.klay.layered.p4nodes.bk.BKNodePlacer;

public enum NodePlacementStrategy implements ILayoutPhaseFactory
{
    SIMPLE,
    INTERACTIVE,
    LINEAR_SEGMENTS,
    BRANDES_KOEPF,
    NETWORK_SIMPLEX;


    @Override
    public ILayoutPhase create() {
        switch (this) {
            case SIMPLE: {
                return new SimpleNodePlacer();
            }
            case INTERACTIVE: {
                return new InteractiveNodePlacer();
            }
            case LINEAR_SEGMENTS: {
                return new LinearSegmentsNodePlacer();
            }
            case BRANDES_KOEPF: {
                return new BKNodePlacer();
            }
            case NETWORK_SIMPLEX: {
                return new NetworkSimplexPlacer();
            }
        }
        throw new IllegalArgumentException("No implementation is available for the node placer " + this.toString());
    }
}

