/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p4nodes;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Spacings;
import java.util.Set;

public final class SimpleNodePlacer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration HIERARCHY_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase5(IntermediateProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        KVector layerSize;
        monitor.begin("Simple node placement", 1.0f);
        Spacings spacings = (Spacings)layeredGraph.getProperty(InternalProperties.SPACINGS);
        double maxHeight = 0.0;
        for (Layer layer : layeredGraph.getLayers()) {
            layerSize = layer.getSize();
            layerSize.y = 0.0;
            LNode lastNode = null;
            for (LNode node : layer.getNodes()) {
                if (lastNode != null) {
                    layerSize.y += (double)spacings.getVerticalSpacing(node, lastNode);
                }
                layerSize.y += node.getMargin().top + node.getSize().y + node.getMargin().bottom;
                lastNode = node;
            }
            maxHeight = Math.max(maxHeight, layerSize.y);
        }
        for (Layer layer : layeredGraph.getLayers()) {
            layerSize = layer.getSize();
            double pos = (maxHeight - layerSize.y) / 2.0;
            LNode lastNode = null;
            for (LNode node : layer.getNodes()) {
                if (lastNode != null) {
                    pos += (double)spacings.getVerticalSpacing(node, lastNode);
                }
                node.getPosition().y = pos += node.getMargin().top;
                pos += node.getSize().y + node.getMargin().bottom;
                lastNode = node;
            }
        }
        monitor.done();
    }
}

