/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.p4nodes.bk.BKAlignedLayout;
import de.cau.cs.kieler.klay.layered.p4nodes.bk.CompactionStrategy;
import de.cau.cs.kieler.klay.layered.p4nodes.bk.ICompactor;
import de.cau.cs.kieler.klay.layered.p4nodes.bk.NeighborhoodInformation;
import de.cau.cs.kieler.klay.layered.p4nodes.bk.ThresholdStrategy;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.Spacings;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BKCompactor
implements ICompactor {
    private LGraph layeredGraph;
    private ThresholdStrategy threshStrategy;
    private NeighborhoodInformation ni;
    private Spacings spacings;
    private Map<LNode, ClassNode> sinkNodes = Maps.newHashMap();

    public BKCompactor(LGraph layeredGraph, NeighborhoodInformation ni) {
        this.layeredGraph = layeredGraph;
        this.ni = ni;
        this.spacings = (Spacings)layeredGraph.getProperty(InternalProperties.SPACINGS);
        this.threshStrategy = layeredGraph.getProperty(Properties.COMPACTION_STRATEGY) == CompactionStrategy.IMPROVE_STRAIGHTNESS ? new ThresholdStrategy.SimpleThresholdStrategy() : new ThresholdStrategy.NullThresholdStrategy();
    }

    @Override
    public void horizontalCompaction(BKAlignedLayout bal) {
        for (Layer layer : this.layeredGraph.getLayers()) {
            Iterator<LNode> iterator = layer.getNodes().iterator();
            while (iterator.hasNext()) {
                LNode node;
                bal.sink[node.id] = node = iterator.next();
                bal.shift[node.id] = bal.vdir == BKAlignedLayout.VDirection.UP ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        }
        List layers = this.layeredGraph.getLayers();
        if (bal.hdir == BKAlignedLayout.HDirection.LEFT) {
            layers = Lists.reverse(layers);
        }
        this.threshStrategy.init(bal);
        Arrays.fill((Object[])bal.y, null);
        for (Layer layer : layers) {
            List nodes = layer.getNodes();
            if (bal.vdir == BKAlignedLayout.VDirection.UP) {
                nodes = Lists.reverse(nodes);
            }
            for (LNode v : nodes) {
                if (!((Object)((Object)bal.root[v.id])).equals((Object)v)) continue;
                this.placeBlock(v, bal);
            }
        }
        this.placeClasses(bal);
        for (Layer layer : layers) {
            for (LNode v : layer.getNodes()) {
                bal.y[v.id] = bal.y[bal.root[v.id].id];
                if (!((Object)((Object)v)).equals((Object)bal.root[v.id])) continue;
                double sinkShift = bal.shift[bal.sink[v.id].id];
                if (!(bal.vdir == BKAlignedLayout.VDirection.UP && sinkShift > Double.NEGATIVE_INFINITY) && (bal.vdir != BKAlignedLayout.VDirection.DOWN || !(sinkShift < Double.POSITIVE_INFINITY))) continue;
                bal.y[v.id] = bal.y[v.id] + sinkShift;
            }
        }
        this.threshStrategy.postProcess();
    }

    private void placeBlock(LNode root, BKAlignedLayout bal) {
        if (bal.y[root.id] != null) {
            return;
        }
        boolean isInitialAssignment = true;
        bal.y[root.id] = 0.0;
        LNode currentNode = root;
        double thresh = bal.vdir == BKAlignedLayout.VDirection.DOWN ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        do {
            int currentIndexInLayer = this.ni.nodeIndex[currentNode.id];
            int currentLayerSize = currentNode.getLayer().getNodes().size();
            LNode.NodeType currentNodeType = currentNode.getType();
            if (bal.vdir == BKAlignedLayout.VDirection.DOWN && currentIndexInLayer > 0 || bal.vdir == BKAlignedLayout.VDirection.UP && currentIndexInLayer < currentLayerSize - 1) {
                double requiredSpace;
                double spacing;
                LNode neighbor = null;
                LNode neighborRoot = null;
                neighbor = bal.vdir == BKAlignedLayout.VDirection.UP ? currentNode.getLayer().getNodes().get(currentIndexInLayer + 1) : currentNode.getLayer().getNodes().get(currentIndexInLayer - 1);
                neighborRoot = bal.root[neighbor.id];
                LNode.NodeType neighborNodeType = neighbor.getType();
                this.placeBlock(neighborRoot, bal);
                thresh = this.threshStrategy.calculateThreshold(thresh, root, currentNode);
                if (((Object)((Object)bal.sink[root.id])).equals((Object)root)) {
                    bal.sink[root.id] = bal.sink[neighborRoot.id];
                }
                if (((Object)((Object)bal.sink[root.id])).equals((Object)bal.sink[neighborRoot.id])) {
                    double newPosition;
                    spacing = this.spacings.getVerticalSpacing(currentNodeType, neighborNodeType);
                    if (bal.vdir == BKAlignedLayout.VDirection.UP) {
                        double currentBlockPosition = bal.y[root.id];
                        newPosition = bal.y[neighborRoot.id] + bal.innerShift[neighbor.id] - neighbor.getMargin().top - spacing - currentNode.getMargin().bottom - currentNode.getSize().y - bal.innerShift[currentNode.id];
                        if (isInitialAssignment) {
                            isInitialAssignment = false;
                            bal.y[root.id] = Math.min(newPosition, thresh);
                            continue;
                        }
                        bal.y[root.id] = Math.min(currentBlockPosition, Math.min(newPosition, thresh));
                        continue;
                    }
                    double currentBlockPosition = bal.y[root.id];
                    newPosition = bal.y[neighborRoot.id] + bal.innerShift[neighbor.id] + neighbor.getSize().y + neighbor.getMargin().bottom + spacing + currentNode.getMargin().top - bal.innerShift[currentNode.id];
                    if (isInitialAssignment) {
                        isInitialAssignment = false;
                        bal.y[root.id] = Math.max(newPosition, thresh);
                        continue;
                    }
                    bal.y[root.id] = Math.max(currentBlockPosition, Math.max(newPosition, thresh));
                    continue;
                }
                spacing = this.spacings.nodeSpacing;
                ClassNode sinkNode = this.getOrCreateClassNode(bal.sink[root.id]);
                ClassNode neighborSink = this.getOrCreateClassNode(bal.sink[neighborRoot.id]);
                if (bal.vdir == BKAlignedLayout.VDirection.UP) {
                    requiredSpace = bal.y[root.id] + bal.innerShift[currentNode.id] + currentNode.getSize().y + currentNode.getMargin().bottom + spacing - (bal.y[neighborRoot.id] + bal.innerShift[neighbor.id] - neighbor.getMargin().top);
                    sinkNode.addEdge(neighborSink, requiredSpace);
                    continue;
                }
                requiredSpace = bal.y[root.id] + bal.innerShift[currentNode.id] - currentNode.getMargin().top - bal.y[neighborRoot.id] - bal.innerShift[neighbor.id] - neighbor.getSize().y - neighbor.getMargin().bottom - spacing;
                sinkNode.addEdge(neighborSink, requiredSpace);
                continue;
            }
            thresh = this.threshStrategy.calculateThreshold(thresh, root, currentNode);
        } while ((currentNode = bal.align[currentNode.id]) != root);
        this.threshStrategy.finishBlock(root);
    }

    private void placeClasses(BKAlignedLayout bal) {
        LinkedList sinks = Lists.newLinkedList();
        for (ClassNode n : this.sinkNodes.values()) {
            if (n.indegree != 0) continue;
            sinks.add(n);
        }
        while (!sinks.isEmpty()) {
            ClassNode n;
            n = (ClassNode)sinks.poll();
            for (ClassEdge e : n.outgoing) {
                e.target.classShift = bal.vdir == BKAlignedLayout.VDirection.DOWN ? Math.min(e.target.classShift, n.classShift + e.separation) : Math.max(e.target.classShift, n.classShift + e.separation);
                --e.target.indegree;
                if (e.target.indegree != 0) continue;
                sinks.add(e.target);
            }
        }
        for (ClassNode n : this.sinkNodes.values()) {
            bal.shift[n.node.id] = n.classShift;
        }
    }

    private ClassNode getOrCreateClassNode(LNode sinkNode) {
        ClassNode node = this.sinkNodes.get((Object)sinkNode);
        if (node == null) {
            node = new ClassNode();
            node.node = sinkNode;
            this.sinkNodes.put(node.node, node);
        }
        return node;
    }

    private static class ClassEdge {
        double separation = 0.0;
        ClassNode target;

        private ClassEdge() {
        }
    }

    private static class ClassNode {
        double classShift = 0.0;
        LNode node;
        List<ClassEdge> outgoing = Lists.newArrayList();
        int indegree = 0;

        private ClassNode() {
        }

        private void addEdge(ClassNode target, double separation) {
            ClassEdge se = new ClassEdge();
            se.target = target;
            se.separation = separation;
            ++target.indegree;
            this.outgoing.add(se);
        }
    }
}

