/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class NeighborhoodInformation {
    public int nodeCount;
    public int[] layerIndex;
    public int[] nodeIndex;
    public List<List<Pair<LNode, LEdge>>> leftNeighbors;
    public List<List<Pair<LNode, LEdge>>> rightNeighbors;
    private NeighborComparator neighborComparator;

    private NeighborhoodInformation() {
    }

    public void cleanup() {
        this.layerIndex = null;
        this.nodeIndex = null;
        this.leftNeighbors.clear();
        this.rightNeighbors.clear();
        this.neighborComparator = null;
    }

    public static NeighborhoodInformation buildFor(LGraph graph) {
        NeighborhoodInformation ni = new NeighborhoodInformation();
        ni.nodeCount = 0;
        for (Layer layer : graph) {
            ni.nodeCount += layer.getNodes().size();
        }
        int lId = 0;
        int lIndex = 0;
        ni.layerIndex = new int[graph.getLayers().size()];
        int nId = 0;
        int nIndex = 0;
        ni.nodeIndex = new int[ni.nodeCount];
        for (Layer l : graph.getLayers()) {
            l.id = lId++;
            ni.layerIndex[l.id] = lIndex++;
            nIndex = 0;
            for (LNode n : l.getNodes()) {
                n.id = nId++;
                ni.nodeIndex[n.id] = nIndex++;
            }
        }
        ni.neighborComparator = ni.new NeighborComparator();
        ni.leftNeighbors = Lists.newArrayListWithCapacity((int)ni.nodeCount);
        NeighborhoodInformation.determineAllLeftNeighbors(ni, graph);
        ni.rightNeighbors = Lists.newArrayListWithCapacity((int)ni.nodeCount);
        NeighborhoodInformation.determineAllRightNeighbors(ni, graph);
        return ni;
    }

    private static void determineAllRightNeighbors(NeighborhoodInformation ni, LGraph graph) {
        for (Layer l : graph) {
            for (LNode n : l) {
                ArrayList result = Lists.newArrayList();
                int maxPriority = 0;
                for (LEdge edge : n.getOutgoingEdges()) {
                    if ((Integer)edge.getProperty(InternalProperties.PRIORITY) <= maxPriority) continue;
                    maxPriority = (Integer)edge.getProperty(InternalProperties.PRIORITY);
                }
                for (LEdge edge : n.getOutgoingEdges()) {
                    if (n.getLayer() == edge.getTarget().getNode().getLayer() || (Integer)edge.getProperty(InternalProperties.PRIORITY) != maxPriority) continue;
                    result.add(Pair.of((Object)((Object)edge.getTarget().getNode()), (Object)((Object)edge)));
                }
                Collections.sort(result, ni.neighborComparator);
                ni.rightNeighbors.add(n.id, result);
            }
        }
    }

    private static void determineAllLeftNeighbors(NeighborhoodInformation ni, LGraph graph) {
        for (Layer l : graph) {
            for (LNode n : l) {
                ArrayList result = Lists.newArrayList();
                int maxPriority = 0;
                for (LEdge edge : n.getIncomingEdges()) {
                    if ((Integer)edge.getProperty(InternalProperties.PRIORITY) <= maxPriority) continue;
                    maxPriority = (Integer)edge.getProperty(InternalProperties.PRIORITY);
                }
                for (LEdge edge : n.getIncomingEdges()) {
                    if (n.getLayer() == edge.getSource().getNode().getLayer() || (Integer)edge.getProperty(InternalProperties.PRIORITY) != maxPriority) continue;
                    result.add(Pair.of((Object)((Object)edge.getSource().getNode()), (Object)((Object)edge)));
                }
                Collections.sort(result, ni.neighborComparator);
                ni.leftNeighbors.add(n.id, result);
            }
        }
    }

    private final class NeighborComparator
    implements Comparator<Pair<LNode, LEdge>> {
        private NeighborComparator() {
        }

        @Override
        public int compare(Pair<LNode, LEdge> o1, Pair<LNode, LEdge> o2) {
            int cmp = NeighborhoodInformation.this.nodeIndex[((LNode)((Object)o1.getFirst())).id] - NeighborhoodInformation.this.nodeIndex[((LNode)((Object)o2.getFirst())).id];
            return (int)Math.signum(cmp);
        }
    }
}

