/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p4nodes.bk.BKAlignedLayout;
import java.util.Queue;
import java.util.Set;

public abstract class ThresholdStrategy {
    private static final double THRESHOLD = Double.MAX_VALUE;
    protected BKAlignedLayout bal;
    protected Set<LNode> blockFinished = Sets.newHashSet();
    protected Queue<Pair<LNode, Boolean>> postProcessables = Lists.newLinkedList();

    public void init(BKAlignedLayout theBal) {
        this.bal = theBal;
        this.blockFinished.clear();
        this.postProcessables.clear();
    }

    public void finishBlock(LNode n) {
        this.blockFinished.add(n);
    }

    public abstract double calculateThreshold(double var1, LNode var3, LNode var4);

    public abstract void postProcess();

    protected LNode getOther(LEdge edge, LNode n) {
        if (edge.getSource().getNode() == n) {
            return edge.getTarget().getNode();
        }
        if (edge.getTarget().getNode() == n) {
            return edge.getSource().getNode();
        }
        throw new IllegalArgumentException("Node " + (Object)((Object)n) + " is neither source nor target of edge " + (Object)((Object)edge));
    }

    public static class NullThresholdStrategy
    extends ThresholdStrategy {
        @Override
        public double calculateThreshold(double oldThresh, LNode blockRoot, LNode currentNode) {
            if (this.bal.vdir == BKAlignedLayout.VDirection.UP) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public void postProcess() {
        }
    }

    public static class SimpleThresholdStrategy
    extends ThresholdStrategy {
        @Override
        public double calculateThreshold(double oldThresh, LNode blockRoot, LNode currentNode) {
            boolean isRoot = ((Object)((Object)blockRoot)).equals((Object)currentNode);
            boolean isLast = ((Object)((Object)this.bal.align[currentNode.id])).equals((Object)blockRoot);
            if (!isRoot && !isLast) {
                return oldThresh;
            }
            double t = oldThresh;
            if (this.bal.hdir == BKAlignedLayout.HDirection.RIGHT) {
                if (isRoot) {
                    t = this.getBound(blockRoot, true);
                }
                if (Double.isInfinite(t) && isLast) {
                    t = this.getBound(currentNode, false);
                }
            } else {
                if (isRoot) {
                    t = this.getBound(blockRoot, true);
                }
                if (Double.isInfinite(t) && isLast) {
                    t = this.getBound(currentNode, false);
                }
            }
            return t;
        }

        private Pair<LEdge, Boolean> pickEdge(LNode currentNode, boolean isRoot) {
            Iterable<LEdge> edges = isRoot ? (this.bal.hdir == BKAlignedLayout.HDirection.RIGHT ? currentNode.getIncomingEdges() : currentNode.getOutgoingEdges()) : (this.bal.hdir == BKAlignedLayout.HDirection.LEFT ? currentNode.getIncomingEdges() : currentNode.getOutgoingEdges());
            boolean hasEdges = false;
            for (LEdge e : edges) {
                hasEdges = true;
                if (!this.blockFinished.contains((Object)this.bal.root[this.getOther((LEdge)e, (LNode)currentNode).id])) continue;
                return Pair.of((Object)((Object)e), (Object)true);
            }
            return Pair.of(null, (Object)hasEdges);
        }

        private double getBound(LNode blockNode, boolean isRoot) {
            double invalid = this.bal.vdir == BKAlignedLayout.VDirection.UP ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            Pair<LEdge, Boolean> pick = this.pickEdge(blockNode, isRoot);
            if (pick.getFirst() == null && ((Boolean)pick.getSecond()).booleanValue()) {
                this.postProcessables.add(Pair.of((Object)((Object)blockNode), (Object)isRoot));
                return invalid;
            }
            if (pick.getFirst() != null) {
                double threshold;
                LPort left = ((LEdge)((Object)pick.getFirst())).getSource();
                LPort right = ((LEdge)((Object)pick.getFirst())).getTarget();
                if (isRoot) {
                    LPort rootPort = this.bal.hdir == BKAlignedLayout.HDirection.RIGHT ? right : left;
                    LPort otherPort = this.bal.hdir == BKAlignedLayout.HDirection.RIGHT ? left : right;
                    LNode otherRoot = this.bal.root[otherPort.getNode().id];
                    threshold = this.bal.y[otherRoot.id] + this.bal.innerShift[otherPort.getNode().id] + otherPort.getPosition().y + otherPort.getAnchor().y - this.bal.innerShift[rootPort.getNode().id] - rootPort.getPosition().y - rootPort.getAnchor().y;
                } else {
                    LPort rootPort = this.bal.hdir == BKAlignedLayout.HDirection.LEFT ? right : left;
                    LPort otherPort = this.bal.hdir == BKAlignedLayout.HDirection.LEFT ? left : right;
                    threshold = this.bal.y[this.bal.root[otherPort.getNode().id].id] + this.bal.innerShift[otherPort.getNode().id] + otherPort.getPosition().y + otherPort.getAnchor().y - this.bal.innerShift[rootPort.getNode().id] - rootPort.getPosition().y - rootPort.getAnchor().y;
                }
                return threshold;
            }
            return invalid;
        }

        @Override
        public void postProcess() {
            while (!this.postProcessables.isEmpty()) {
                double availableSpace;
                LPort block;
                Pair pair = (Pair)this.postProcessables.poll();
                Pair<LEdge, Boolean> pick = this.pickEdge((LNode)((Object)pair.getFirst()), (Boolean)pair.getSecond());
                if (pick.getFirst() == null) continue;
                LEdge edge = (LEdge)((Object)pick.getFirst());
                LPort left = edge.getSource();
                LPort right = edge.getTarget();
                LPort fix = this.bal.hdir == BKAlignedLayout.HDirection.LEFT ? left : right;
                double delta = this.bal.calculateDelta(fix, block = this.bal.hdir == BKAlignedLayout.HDirection.LEFT ? right : left);
                if (delta > 0.0 && delta < Double.MAX_VALUE) {
                    availableSpace = this.bal.checkSpaceAbove(block.getNode(), delta);
                    this.bal.shiftBlock(block.getNode(), -availableSpace);
                    continue;
                }
                if (!(delta < 0.0) || !(-delta < Double.MAX_VALUE)) continue;
                availableSpace = this.bal.checkSpaceBelow(block.getNode(), -delta);
                this.bal.shiftBlock(block.getNode(), availableSpace);
            }
        }
    }

    public static class SophisticatedThresholdStrategy
    extends ThresholdStrategy {
        @Override
        public double calculateThreshold(double oldThresh, LNode blockRoot, LNode currentNode) {
            this.calculateThreshold(this.bal, oldThresh, 0.0, blockRoot, currentNode);
            return 0.0;
        }

        private double calculateThreshold(BKAlignedLayout bal, double currentThreshold, double suggestion, LNode root, LNode currentNode) {
            double t = currentThreshold;
            boolean isRoot = ((Object)((Object)root)).equals((Object)currentNode);
            boolean isLast = ((Object)((Object)bal.align[currentNode.id])).equals((Object)root);
            if (!isRoot && !isLast) {
                return t;
            }
            if (bal.hdir == BKAlignedLayout.HDirection.RIGHT) {
                if (isRoot) {
                    t = this.getBound(bal, root, true, suggestion);
                }
                if (Double.isInfinite(t) && isLast) {
                    t = this.getBound(bal, currentNode, false, suggestion);
                }
            } else {
                if (isRoot) {
                    t = this.getBound(bal, root, true, suggestion);
                }
                if (Double.isInfinite(t) && isLast) {
                    t = this.getBound(bal, currentNode, false, suggestion);
                }
            }
            return t;
        }

        private Pair<LEdge, Boolean> pickEdge(BKAlignedLayout bal, LNode root, boolean isRoot, double suggestion, boolean inverted) {
            Iterable<LEdge> edges = isRoot ? (bal.hdir == BKAlignedLayout.HDirection.RIGHT ? root.getIncomingEdges() : root.getOutgoingEdges()) : (bal.hdir == BKAlignedLayout.HDirection.LEFT ? root.getIncomingEdges() : root.getOutgoingEdges());
            LEdge pick = null;
            double distance = Double.MAX_VALUE;
            boolean hasEdges = false;
            for (LEdge e : edges) {
                LPort otherPort;
                LPort rootPort;
                hasEdges = true;
                LPort left = e.getSource();
                LPort right = e.getTarget();
                if (isRoot) {
                    rootPort = bal.hdir == BKAlignedLayout.HDirection.RIGHT ? right : left;
                    otherPort = bal.hdir == BKAlignedLayout.HDirection.RIGHT ? left : right;
                } else {
                    rootPort = bal.hdir == BKAlignedLayout.HDirection.LEFT ? right : left;
                    LPort lPort = otherPort = bal.hdir == BKAlignedLayout.HDirection.LEFT ? left : right;
                }
                if (!this.blockFinished.contains((Object)bal.root[otherPort.getNode().id])) continue;
                LNode otherRoot = bal.root[otherPort.getNode().id];
                double otherPos = bal.y[otherRoot.id] + bal.innerShift[otherPort.getNode().id] + otherPort.getPosition().y + otherPort.getAnchor().y;
                double rootPos = suggestion + bal.innerShift[rootPort.getNode().id] + rootPort.getPosition().y + rootPort.getAnchor().y;
                double curDistance = Math.abs(otherPos - rootPos);
                if (!inverted) {
                    if (bal.vdir == BKAlignedLayout.VDirection.DOWN) {
                        if (!(otherPos > rootPos) || !(curDistance < distance)) continue;
                        pick = e;
                        distance = curDistance;
                        continue;
                    }
                    if (!(otherPos < rootPos) || !(curDistance < distance)) continue;
                    pick = e;
                    distance = curDistance;
                    continue;
                }
                if (bal.vdir == BKAlignedLayout.VDirection.DOWN) {
                    if (!(otherPos < rootPos) || !(curDistance < distance)) continue;
                    pick = e;
                    distance = curDistance;
                    continue;
                }
                if (!(otherPos > rootPos) || !(curDistance < distance)) continue;
                pick = e;
                distance = curDistance;
            }
            return Pair.of(pick, (Object)hasEdges);
        }

        private double getBound(BKAlignedLayout bal, LNode blockNode, boolean isRoot, double suggestion) {
            double invalid = bal.vdir == BKAlignedLayout.VDirection.UP ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            Pair<LEdge, Boolean> pick = this.pickEdge(bal, blockNode, isRoot, suggestion, false);
            if (pick.getFirst() == null && ((Boolean)pick.getSecond()).booleanValue()) {
                this.postProcessables.add(Pair.of((Object)((Object)blockNode), (Object)isRoot));
                return invalid;
            }
            if (pick.getFirst() != null) {
                double threshold;
                LPort left = ((LEdge)((Object)pick.getFirst())).getSource();
                LPort right = ((LEdge)((Object)pick.getFirst())).getTarget();
                if (isRoot) {
                    LPort rootPort = bal.hdir == BKAlignedLayout.HDirection.RIGHT ? right : left;
                    LPort otherPort = bal.hdir == BKAlignedLayout.HDirection.RIGHT ? left : right;
                    LNode otherRoot = bal.root[otherPort.getNode().id];
                    threshold = bal.y[otherRoot.id] + bal.innerShift[otherPort.getNode().id] + otherPort.getPosition().y + otherPort.getAnchor().y - bal.innerShift[rootPort.getNode().id] - rootPort.getPosition().y - rootPort.getAnchor().y;
                } else {
                    LPort rootPort = bal.hdir == BKAlignedLayout.HDirection.LEFT ? right : left;
                    LPort otherPort = bal.hdir == BKAlignedLayout.HDirection.LEFT ? left : right;
                    threshold = bal.y[bal.root[otherPort.getNode().id].id] + bal.innerShift[otherPort.getNode().id] + otherPort.getPosition().y + otherPort.getAnchor().y - bal.innerShift[rootPort.getNode().id] - rootPort.getPosition().y - rootPort.getAnchor().y;
                }
                return threshold;
            }
            return invalid;
        }

        @Override
        public void postProcess() {
            while (!this.postProcessables.isEmpty()) {
                LPort block;
                Pair pair = (Pair)this.postProcessables.poll();
                System.out.println("PostProcesS: " + pair);
                Pair<LEdge, Boolean> pick = this.pickEdge(this.bal, (LNode)((Object)pair.getFirst()), (Boolean)pair.getSecond(), this.bal.y[((LNode)((Object)pair.getFirst())).id], true);
                if (pick.getFirst() == null) {
                    pick = this.pickEdge(this.bal, (LNode)((Object)pair.getFirst()), (Boolean)pair.getSecond(), this.bal.y[((LNode)((Object)pair.getFirst())).id], false);
                }
                if (!((Boolean)pick.getSecond()).booleanValue() || pick.getFirst() == null) continue;
                LEdge edge = (LEdge)((Object)pick.getFirst());
                LPort left = edge.getSource();
                LPort right = edge.getTarget();
                LPort fix = this.bal.hdir == BKAlignedLayout.HDirection.LEFT ? left : right;
                double delta = this.bal.calculateDelta(fix, block = this.bal.hdir == BKAlignedLayout.HDirection.LEFT ? right : left);
                if (delta > 0.0 && delta < Double.MAX_VALUE) {
                    if (this.bal.checkSpaceAbove(block.getNode(), delta) != delta) continue;
                    this.bal.shiftBlock(block.getNode(), -delta);
                    continue;
                }
                if (!(delta < 0.0) || !(-delta < Double.MAX_VALUE) || this.bal.checkSpaceBelow(block.getNode(), -delta) != delta) continue;
                this.bal.shiftBlock(block.getNode(), -delta);
            }
        }
    }
}

