/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphUtil;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import de.cau.cs.kieler.klay.layered.p5edges.OrthogonalRoutingGenerator;
import de.cau.cs.kieler.klay.layered.p5edges.PolylineEdgeRouter;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.Spacings;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class OrthogonalEdgeRouter
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration HYPEREDGE_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase4(IntermediateProcessorStrategy.HYPEREDGE_DUMMY_MERGER);
    private static final IntermediateProcessingConfiguration INVERTED_PORT_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.INVERTED_PORT_PROCESSOR);
    private static final IntermediateProcessingConfiguration NORTH_SOUTH_PORT_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.NORTH_SOUTH_PORT_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.NORTH_SOUTH_PORT_POSTPROCESSOR);
    private static final IntermediateProcessingConfiguration HIERARCHICAL_PORT_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.HIERARCHICAL_PORT_CONSTRAINT_PROCESSOR).addBeforePhase4(IntermediateProcessorStrategy.HIERARCHICAL_PORT_DUMMY_SIZE_PROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.HIERARCHICAL_PORT_ORTHOGONAL_EDGE_ROUTER);
    private static final IntermediateProcessingConfiguration SELF_LOOP_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.SELF_LOOP_PROCESSOR);
    private static final IntermediateProcessingConfiguration HYPERNODE_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addAfterPhase5(IntermediateProcessorStrategy.HYPERNODE_PROCESSOR);
    private static final IntermediateProcessingConfiguration CENTER_EDGE_LABEL_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase2(IntermediateProcessorStrategy.LABEL_DUMMY_INSERTER).addBeforePhase3(IntermediateProcessorStrategy.LABEL_DUMMY_SWITCHER).addBeforePhase4(IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addAfterPhase5(IntermediateProcessorStrategy.LABEL_DUMMY_REMOVER);
    private static final IntermediateProcessingConfiguration END_EDGE_LABEL_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase4(IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addAfterPhase5(IntermediateProcessorStrategy.END_LABEL_PROCESSOR);

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        Set graphProperties = (Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        IntermediateProcessingConfiguration configuration = IntermediateProcessingConfiguration.createEmpty();
        if (graphProperties.contains((Object)GraphProperties.HYPEREDGES)) {
            configuration.addAll(HYPEREDGE_PROCESSING_ADDITIONS);
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.NON_FREE_PORTS) || ((Boolean)graph.getProperty(Properties.FEEDBACK_EDGES)).booleanValue()) {
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
            if (graphProperties.contains((Object)GraphProperties.NORTH_SOUTH_PORTS)) {
                configuration.addAll(NORTH_SOUTH_PORT_PROCESSING_ADDITIONS);
            }
        }
        if (graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            configuration.addAll(HIERARCHICAL_PORT_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.SELF_LOOPS)) {
            configuration.addAll(SELF_LOOP_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.HYPERNODES)) {
            configuration.addAll(HYPERNODE_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.CENTER_LABELS)) {
            configuration.addAll(CENTER_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.END_LABELS)) {
            configuration.addAll(END_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        return configuration;
    }

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Orthogonal edge routing", 1.0f);
        Spacings spacings = (Spacings)layeredGraph.getProperty(InternalProperties.SPACINGS);
        boolean debug = (Boolean)layeredGraph.getProperty(LayoutOptions.DEBUG_MODE);
        OrthogonalRoutingGenerator routingGenerator = new OrthogonalRoutingGenerator(OrthogonalRoutingGenerator.RoutingDirection.WEST_TO_EAST, spacings.edgeEdgeSpacing, debug ? "phase5" : null);
        float xpos = 0.0f;
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        Layer leftLayer = null;
        Layer rightLayer = null;
        List<LNode> leftLayerNodes = null;
        List<LNode> rightLayerNodes = null;
        int leftLayerIndex = -1;
        int rightLayerIndex = -1;
        do {
            boolean isRightLayerExternal;
            rightLayer = layerIter.hasNext() ? layerIter.next() : null;
            rightLayerNodes = rightLayer == null ? null : rightLayer.getNodes();
            rightLayerIndex = layerIter.previousIndex();
            if (leftLayer != null) {
                LGraphUtil.placeNodesHorizontally(leftLayer, xpos);
                xpos = (float)((double)xpos + leftLayer.getSize().x);
            }
            double startPos = leftLayer == null ? xpos : xpos + spacings.edgeNodeSpacing;
            int slotsCount = routingGenerator.routeEdges(layeredGraph, leftLayerNodes, leftLayerIndex, rightLayerNodes, startPos);
            boolean isLeftLayerExternal = leftLayer == null || Iterables.all(leftLayerNodes, PolylineEdgeRouter.PRED_EXTERNAL_WEST_OR_EAST_PORT);
            boolean bl = isRightLayerExternal = rightLayer == null || Iterables.all(rightLayerNodes, PolylineEdgeRouter.PRED_EXTERNAL_WEST_OR_EAST_PORT);
            if (slotsCount > 0) {
                double increment = spacings.edgeNodeSpacing + (float)(slotsCount - 1) * spacings.edgeEdgeSpacing;
                if (rightLayer != null) {
                    increment += (double)spacings.edgeNodeSpacing;
                }
                if (increment < (double)spacings.nodeSpacing && !isLeftLayerExternal && !isRightLayerExternal) {
                    increment = spacings.nodeSpacing;
                }
                xpos = (float)((double)xpos + increment);
            } else if (!isLeftLayerExternal && !isRightLayerExternal) {
                xpos += spacings.nodeSpacing;
            }
            leftLayer = rightLayer;
            leftLayerNodes = rightLayerNodes;
            leftLayerIndex = rightLayerIndex;
        } while (rightLayer != null);
        layeredGraph.getSize().x = xpos;
        monitor.done();
    }
}

