/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges.splines;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p5edges.splines.LoopSide;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class ConnectedSelfLoopComponent {
    private final LNode owner;
    private final Set<LEdge> edges = Sets.newLinkedHashSet();
    private final Set<LEdge> hiddenEdges = Sets.newLinkedHashSet();
    private final Set<LPort> exclusiveLoopSourcePorts = Sets.newLinkedHashSet();
    private final Set<LPort> exclusiveLoopTargetPorts = Sets.newLinkedHashSet();
    private final Set<LPort> portsWithNonLoopEdge = Sets.newLinkedHashSet();
    private final Set<LPort> portsWithPortSide = Sets.newLinkedHashSet();
    private double textWidth;
    private double textHeight;
    private LoopSide loopSide;

    public ConnectedSelfLoopComponent(LNode node) {
        this.owner = node;
    }

    private boolean addPort(LPort port) {
        if (this.hasNonLoopEdge(port)) {
            this.portsWithNonLoopEdge.add(port);
            return true;
        }
        if (port.getSide() != PortSide.UNDEFINED) {
            this.portsWithPortSide.add(port);
        }
        if (port.getOutgoingEdges().isEmpty()) {
            this.exclusiveLoopTargetPorts.add(port);
        } else {
            this.exclusiveLoopSourcePorts.add(port);
        }
        return false;
    }

    public boolean tryAddEdge(LEdge edge, boolean isFixedOrder) {
        LPort source = edge.getSource();
        LPort target = edge.getTarget();
        boolean edgeMustBeHidden = isFixedOrder;
        if (this.edges.add(edge)) {
            if (this.addPort(source)) {
                edgeMustBeHidden = true;
            }
            if (this.addPort(target)) {
                edgeMustBeHidden = true;
            }
            if (edgeMustBeHidden) {
                edge.getSource().getOutgoingEdges().remove((Object)edge);
                edge.getTarget().getIncomingEdges().remove((Object)edge);
                this.hiddenEdges.add(edge);
            }
            this.calculateNewTextSize(edge);
            return true;
        }
        return false;
    }

    private void calculateNewTextSize(LEdge edge) {
        double edgeMaxTextWidth = 0.0;
        double edgeTextHeight = 0.0;
        for (LLabel label : edge.getLabels()) {
            edgeMaxTextWidth = Math.max(edgeMaxTextWidth, label.getSize().x);
            edgeTextHeight += label.getSize().y;
        }
        edge.setProperty(InternalProperties.SPLINE_LABEL_SIZE, new KVector(edgeMaxTextWidth, edgeTextHeight));
        if (this.textWidth < edgeMaxTextWidth) {
            this.textWidth = edgeMaxTextWidth;
        }
        this.textHeight += edgeTextHeight;
    }

    private boolean hasNonLoopEdge(LPort port) {
        for (LEdge edge : port.getOutgoingEdges()) {
            if (edge.getTarget().getNode() == this.owner) continue;
            return true;
        }
        for (LEdge edge : port.getIncomingEdges()) {
            if (edge.getSource().getNode() == this.owner) continue;
            return true;
        }
        return false;
    }

    public Set<LEdge> getEdges() {
        return this.edges;
    }

    public Set<LEdge> getHiddenEdges() {
        return this.hiddenEdges;
    }

    public Set<LPort> getSourceLoopPorts() {
        return this.exclusiveLoopSourcePorts;
    }

    public Set<LPort> getSourceLoopPortsReversed() {
        LinkedHashSet retVal = Sets.newLinkedHashSet();
        ArrayList list = Lists.newArrayList(this.exclusiveLoopSourcePorts);
        Collections.reverse(list);
        for (LPort port : list) {
            retVal.add(port);
        }
        return retVal;
    }

    public Set<LPort> getTargetLoopPorts() {
        return this.exclusiveLoopTargetPorts;
    }

    public Set<LPort> getTargetLoopPortsReversed() {
        LinkedHashSet retVal = Sets.newLinkedHashSet();
        ArrayList<LPort> list = new ArrayList<LPort>(this.exclusiveLoopTargetPorts);
        Collections.reverse(list);
        for (LPort port : list) {
            retVal.add(port);
        }
        return retVal;
    }

    public List<LPort> getHidablePorts() {
        LinkedList allPorts = Lists.newLinkedList(this.exclusiveLoopSourcePorts);
        allPorts.addAll(this.exclusiveLoopTargetPorts);
        allPorts.addAll(this.portsWithPortSide);
        return allPorts;
    }

    public Set<LPort> getNonLoopPorts() {
        return this.portsWithNonLoopEdge;
    }

    public List<LPort> getPorts() {
        List<LPort> allPorts = this.getHidablePorts();
        allPorts.addAll(this.portsWithNonLoopEdge);
        return allPorts;
    }

    public Set<LPort> getConstrainedPorts() {
        HashSet constrainedPorts = Sets.newHashSet(this.getNonLoopPorts());
        constrainedPorts.addAll(this.portsWithPortSide);
        return constrainedPorts;
    }

    public Set<LPort> getPortsWithPortSide() {
        return this.portsWithPortSide;
    }

    public LNode getNode() {
        return this.owner;
    }

    public double getTextWidth() {
        return this.textWidth;
    }

    public void setTextWidth(double width) {
        this.textWidth = width;
    }

    public double getTextHeight() {
        return this.textHeight;
    }

    public void setTextHeight(double height) {
        this.textHeight = height;
    }

    public LNode getParent() {
        return this.owner;
    }

    public LoopSide getLoopSide() {
        return this.loopSide;
    }

    public void setLoopSide(LoopSide side, boolean alsoForEdges) {
        this.loopSide = side;
        if (alsoForEdges) {
            for (LEdge edge : this.edges) {
                edge.setProperty(InternalProperties.SPLINE_LOOPSIDE, (Object)this.loopSide);
                edge.getSource().setSide(side.getSourceSide());
                edge.getTarget().setSide(side.getTargetSide());
            }
        }
    }

    public void unhideEdges() {
        for (LEdge edge : this.hiddenEdges) {
            edge.getSource().getOutgoingEdges().add(edge);
            edge.getTarget().getIncomingEdges().add(edge);
        }
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        if (this.getLoopSide() != null) {
            retVal.append(this.getLoopSide().toString()).append(": ");
        }
        for (LPort port : this.getHidablePorts()) {
            retVal.append(port.toString()).append(' ').append(port.getSide().toString()).append(" / ");
        }
        return retVal.substring(0, retVal.length() - 2 - 1);
    }
}

