/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges.splines;

import com.google.common.collect.ImmutableSet;
import de.cau.cs.kieler.kiml.options.PortSide;
import java.util.Set;

public enum LoopSide {
    N(PortSide.NORTH, PortSide.NORTH, LoopSideType.SIDE),
    EN(PortSide.EAST, PortSide.NORTH, LoopSideType.CORNER),
    E(PortSide.EAST, PortSide.EAST, LoopSideType.SIDE),
    SE(PortSide.SOUTH, PortSide.EAST, LoopSideType.CORNER),
    S(PortSide.SOUTH, PortSide.SOUTH, LoopSideType.SIDE),
    WS(PortSide.WEST, PortSide.SOUTH, LoopSideType.CORNER),
    W(PortSide.WEST, PortSide.WEST, LoopSideType.SIDE),
    NW(PortSide.NORTH, PortSide.WEST, LoopSideType.CORNER),
    ENW(PortSide.EAST, PortSide.WEST, LoopSideType.ACROSS),
    ESW(PortSide.EAST, PortSide.WEST, LoopSideType.ACROSS),
    SEN(PortSide.SOUTH, PortSide.NORTH, LoopSideType.ACROSS),
    SWN(PortSide.SOUTH, PortSide.NORTH, LoopSideType.ACROSS),
    UNDEFINED(PortSide.UNDEFINED, PortSide.UNDEFINED, LoopSideType.UNDEFINED);

    private static final Set<LoopSide> ALL;
    private static final Set<LoopSide> ALL_STRAIGHTS;
    private static final Set<LoopSide> ALL_CORNERS;
    private static final Set<PortSide> SIDES_N;
    private static final Set<PortSide> SIDES_EN;
    private static final Set<PortSide> SIDES_E;
    private static final Set<PortSide> SIDES_SE;
    private static final Set<PortSide> SIDES_S;
    private static final Set<PortSide> SIDES_WS;
    private static final Set<PortSide> SIDES_W;
    private static final Set<PortSide> SIDES_NW;
    private static final Set<PortSide> SIDES_ENW;
    private static final Set<PortSide> SIDES_ESW;
    private static final Set<PortSide> SIDES_SWN;
    private static final Set<PortSide> SIDES_SEN;
    private static final Set<PortSide> SIDES_UNDEF;
    private final PortSide source;
    private final PortSide target;
    private final LoopSideType type;

    static {
        ALL = ImmutableSet.of((Object)((Object)N), (Object)((Object)EN), (Object)((Object)E), (Object)((Object)SE), (Object)((Object)S), (Object)((Object)WS), (Object[])new LoopSide[]{W, NW, ENW, ESW, SEN, SWN});
        ALL_STRAIGHTS = ImmutableSet.of((Object)((Object)N), (Object)((Object)E), (Object)((Object)S), (Object)((Object)W));
        ALL_CORNERS = ImmutableSet.of((Object)((Object)EN), (Object)((Object)SE), (Object)((Object)WS), (Object)((Object)NW));
        SIDES_N = ImmutableSet.of((Object)PortSide.NORTH);
        SIDES_EN = ImmutableSet.of((Object)PortSide.EAST, (Object)PortSide.NORTH);
        SIDES_E = ImmutableSet.of((Object)PortSide.EAST);
        SIDES_SE = ImmutableSet.of((Object)PortSide.SOUTH, (Object)PortSide.EAST);
        SIDES_S = ImmutableSet.of((Object)PortSide.SOUTH);
        SIDES_WS = ImmutableSet.of((Object)PortSide.WEST, (Object)PortSide.SOUTH);
        SIDES_W = ImmutableSet.of((Object)PortSide.WEST);
        SIDES_NW = ImmutableSet.of((Object)PortSide.NORTH, (Object)PortSide.WEST);
        SIDES_ENW = ImmutableSet.of((Object)PortSide.EAST, (Object)PortSide.NORTH, (Object)PortSide.WEST);
        SIDES_ESW = ImmutableSet.of((Object)PortSide.EAST, (Object)PortSide.SOUTH, (Object)PortSide.WEST);
        SIDES_SWN = ImmutableSet.of((Object)PortSide.SOUTH, (Object)PortSide.WEST, (Object)PortSide.NORTH);
        SIDES_SEN = ImmutableSet.of((Object)PortSide.SOUTH, (Object)PortSide.EAST, (Object)PortSide.NORTH);
        SIDES_UNDEF = ImmutableSet.of();
    }

    private LoopSide(PortSide source, PortSide target, LoopSideType type) {
        this.source = source;
        this.target = target;
        this.type = type;
    }

    public static LoopSide fromPortSides(PortSide side) {
        switch (side) {
            case NORTH: {
                return N;
            }
            case EAST: {
                return E;
            }
            case SOUTH: {
                return S;
            }
            case WEST: {
                return W;
            }
        }
        return UNDEFINED;
    }

    public static LoopSide fromPortSide(PortSide side0, PortSide side1) {
        if (side0.equals((Object)side1)) {
            return LoopSide.fromPortSides(side0);
        }
        switch (side0) {
            case NORTH: {
                switch (side1) {
                    case WEST: {
                        return NW;
                    }
                    case NORTH: {
                        return N;
                    }
                    case EAST: {
                        return EN;
                    }
                    case SOUTH: {
                        return SEN;
                    }
                }
            }
            case EAST: {
                switch (side1) {
                    case NORTH: {
                        return EN;
                    }
                    case EAST: {
                        return E;
                    }
                    case SOUTH: {
                        return SE;
                    }
                    case WEST: {
                        return ENW;
                    }
                }
            }
            case SOUTH: {
                switch (side1) {
                    case EAST: {
                        return SE;
                    }
                    case SOUTH: {
                        return S;
                    }
                    case WEST: {
                        return WS;
                    }
                    case NORTH: {
                        return SEN;
                    }
                }
            }
            case WEST: {
                switch (side1) {
                    case SOUTH: {
                        return WS;
                    }
                    case WEST: {
                        return W;
                    }
                    case NORTH: {
                        return NW;
                    }
                    case EAST: {
                        return ENW;
                    }
                }
            }
        }
        return UNDEFINED;
    }

    public LoopSide opposite() {
        switch (this) {
            case N: {
                return S;
            }
            case EN: {
                return WS;
            }
            case E: {
                return W;
            }
            case SE: {
                return NW;
            }
            case S: {
                return N;
            }
            case WS: {
                return EN;
            }
            case W: {
                return E;
            }
            case NW: {
                return SE;
            }
            case ENW: {
                return ESW;
            }
            case ESW: {
                return ENW;
            }
            case SEN: {
                return SWN;
            }
            case SWN: {
                return SEN;
            }
        }
        return UNDEFINED;
    }

    public LoopSide right() {
        switch (this) {
            case N: {
                return EN;
            }
            case EN: {
                return E;
            }
            case E: {
                return SE;
            }
            case SE: {
                return S;
            }
            case S: {
                return WS;
            }
            case WS: {
                return W;
            }
            case W: {
                return NW;
            }
            case NW: {
                return N;
            }
            case ENW: {
                return ESW;
            }
            case ESW: {
                return ENW;
            }
            case SEN: {
                return SWN;
            }
            case SWN: {
                return SEN;
            }
        }
        return UNDEFINED;
    }

    public LoopSide left() {
        switch (this) {
            case N: {
                return NW;
            }
            case EN: {
                return N;
            }
            case E: {
                return EN;
            }
            case SE: {
                return E;
            }
            case S: {
                return SE;
            }
            case WS: {
                return S;
            }
            case W: {
                return WS;
            }
            case NW: {
                return W;
            }
            case ENW: {
                return ESW;
            }
            case ESW: {
                return ENW;
            }
            case SEN: {
                return SWN;
            }
            case SWN: {
                return SEN;
            }
        }
        return UNDEFINED;
    }

    public boolean isCorner() {
        return this.type == LoopSideType.CORNER;
    }

    public boolean isAcross() {
        return this.type == LoopSideType.ACROSS;
    }

    public boolean isStraight() {
        return this.type == LoopSideType.SIDE;
    }

    public LoopSideType getType() {
        return this.type;
    }

    public PortSide getMiddleSide() {
        switch (this) {
            case ENW: {
                return PortSide.NORTH;
            }
            case ESW: {
                return PortSide.SOUTH;
            }
            case SEN: {
                return PortSide.EAST;
            }
            case SWN: {
                return PortSide.WEST;
            }
        }
        return PortSide.UNDEFINED;
    }

    public PortSide getTargetSide() {
        return this.target;
    }

    public PortSide getSourceSide() {
        return this.source;
    }

    public Set<PortSide> getPortSides() {
        switch (this) {
            case N: {
                return SIDES_N;
            }
            case EN: {
                return SIDES_EN;
            }
            case E: {
                return SIDES_E;
            }
            case SE: {
                return SIDES_SE;
            }
            case S: {
                return SIDES_S;
            }
            case WS: {
                return SIDES_WS;
            }
            case W: {
                return SIDES_W;
            }
            case NW: {
                return SIDES_NW;
            }
            case ENW: {
                return SIDES_ENW;
            }
            case ESW: {
                return SIDES_ESW;
            }
            case SWN: {
                return SIDES_SWN;
            }
            case SEN: {
                return SIDES_SEN;
            }
        }
        return SIDES_UNDEF;
    }

    public static Set<LoopSide> getAllDefinedSides() {
        return ALL;
    }

    public static Set<LoopSide> getAllStraightSides() {
        return ALL_STRAIGHTS;
    }

    public static Set<LoopSide> getAllCornerSides() {
        return ALL_CORNERS;
    }

    public boolean viaNW() {
        return this == NW || this == ENW;
    }

    public PortSide getPortSide(int i) {
        switch (this) {
            case N: {
                return PortSide.NORTH;
            }
            case E: {
                return PortSide.EAST;
            }
            case S: {
                return PortSide.SOUTH;
            }
            case W: {
                return PortSide.WEST;
            }
            case EN: {
                if (i == 0) {
                    return PortSide.NORTH;
                }
                return PortSide.EAST;
            }
            case NW: {
                if (i == 0) {
                    return PortSide.NORTH;
                }
                return PortSide.WEST;
            }
            case SE: {
                if (i == 0) {
                    return PortSide.SOUTH;
                }
                return PortSide.EAST;
            }
            case WS: {
                if (i == 0) {
                    return PortSide.SOUTH;
                }
                return PortSide.WEST;
            }
            case ENW: {
                if (i == 0) {
                    return PortSide.WEST;
                }
                if (i == 1) {
                    return PortSide.NORTH;
                }
                return PortSide.EAST;
            }
            case ESW: {
                if (i == 0) {
                    return PortSide.WEST;
                }
                if (i == 1) {
                    return PortSide.SOUTH;
                }
                return PortSide.EAST;
            }
            case SEN: {
                if (i == 0) {
                    return PortSide.NORTH;
                }
                if (i == 1) {
                    return PortSide.EAST;
                }
                return PortSide.SOUTH;
            }
            case SWN: {
                if (i == 0) {
                    return PortSide.NORTH;
                }
                if (i == 1) {
                    return PortSide.WEST;
                }
                return PortSide.SOUTH;
            }
        }
        return PortSide.UNDEFINED;
    }

    public static enum LoopSideType {
        SIDE,
        CORNER,
        ACROSS,
        UNDEFINED;

    }
}

