/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges.splines;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphUtil;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import de.cau.cs.kieler.klay.layered.p5edges.PolylineEdgeRouter;
import de.cau.cs.kieler.klay.layered.p5edges.splines.NubSpline;
import de.cau.cs.kieler.klay.layered.p5edges.splines.SplinesMath;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public final class SplineEdgeRouter
implements ILayoutPhase {
    private static final double MAX_VERTICAL_DIFF_FOR_STRAIGHT = 0.2;
    private double edgeSpacing = 3.0;
    private static final double ONE_HALF = 0.5;
    private static final int DIMENSION = 3;
    private static final double NODE_TO_VERTICAL_SEGMENT_GAP = 10.0;
    private static final double NODE_TO_STRAIGHTENING_CP_GAP = 5.0;
    private static final double RELEVANT_POS_OUTER_RATE = 0.9;
    private static final double RELEVANT_POS_MID_RATE = 0.09999999999999998;
    private static final IntermediateProcessingConfiguration SELF_LOOP_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase1(IntermediateProcessorStrategy.SPLINE_SELF_LOOP_PREPROCESSOR).addBeforePhase4(IntermediateProcessorStrategy.SPLINE_SELF_LOOP_POSITIONER).addBeforePhase4(IntermediateProcessorStrategy.SPLINE_SELF_LOOP_ROUTER);
    private static final IntermediateProcessingConfiguration CENTER_EDGE_LABEL_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase2(IntermediateProcessorStrategy.LABEL_DUMMY_INSERTER).addBeforePhase3(IntermediateProcessorStrategy.LABEL_DUMMY_SWITCHER).addBeforePhase4(IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addAfterPhase5(IntermediateProcessorStrategy.LABEL_DUMMY_REMOVER);
    private static final IntermediateProcessingConfiguration INVERTED_PORT_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.INVERTED_PORT_PROCESSOR);
    private static final IntermediateProcessingConfiguration NORTH_SOUTH_PORT_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.NORTH_SOUTH_PORT_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.NORTH_SOUTH_PORT_POSTPROCESSOR);
    private static final IntermediateProcessingConfiguration END_EDGE_LABEL_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase4(IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addAfterPhase5(IntermediateProcessorStrategy.END_LABEL_PROCESSOR);

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        Layer rightLayer;
        monitor.begin("Spline edge routing", 1.0f);
        float nodeSpacing = ((Float)layeredGraph.getProperty(InternalProperties.SPACING)).floatValue();
        this.edgeSpacing = nodeSpacing * ((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        double xpos = 0.0;
        Iterator<Layer> layerIterator = layeredGraph.iterator();
        Layer leftLayer = null;
        HashMap successingEdge = Maps.newHashMap();
        ArrayList startEdges = Lists.newArrayList();
        boolean externalLeftLayer = true;
        boolean externalRightLayer = true;
        do {
            rightLayer = layerIterator.hasNext() ? layerIterator.next() : null;
            ArrayList hyperEdges = Lists.newArrayList();
            ArrayList edgesRemaining = Lists.newArrayList();
            LinkedHashSet leftPorts = Sets.newLinkedHashSet();
            LinkedHashSet rightPorts = Sets.newLinkedHashSet();
            LinkedHashSet selfLoops = Sets.newLinkedHashSet();
            this.fillMappings((Pair<Layer, Layer>)Pair.of(leftLayer, (Object)rightLayer), (Pair<Set<LPort>, Set<LPort>>)Pair.of((Object)leftPorts, (Object)rightPorts), edgesRemaining, successingEdge, startEdges, selfLoops);
            this.createHyperEdges(leftPorts, rightPorts, SideToProcess.LEFT, true, edgesRemaining, hyperEdges);
            this.createHyperEdges(leftPorts, rightPorts, SideToProcess.LEFT, false, edgesRemaining, hyperEdges);
            this.createHyperEdges(leftPorts, rightPorts, SideToProcess.RIGHT, true, edgesRemaining, hyperEdges);
            this.createHyperEdges(leftPorts, rightPorts, SideToProcess.RIGHT, false, edgesRemaining, hyperEdges);
            this.createHyperEdges(edgesRemaining, leftPorts, rightPorts, hyperEdges);
            ListIterator sourceIter = hyperEdges.listIterator();
            while (sourceIter.hasNext()) {
                SplineHyperEdge hyperEdge1 = (SplineHyperEdge)sourceIter.next();
                ListIterator targetIter = hyperEdges.listIterator(sourceIter.nextIndex());
                while (targetIter.hasNext()) {
                    SplineHyperEdge hyperEdge2 = (SplineHyperEdge)targetIter.next();
                    this.createDependency(hyperEdge1, hyperEdge2);
                }
            }
            SplineEdgeRouter.breakCycles(hyperEdges, (Random)layeredGraph.getProperty(InternalProperties.RANDOM));
            SplineEdgeRouter.topologicalNumbering(hyperEdges);
            double rightLayersPosition = xpos + 10.0;
            if (rightLayer != null) {
                externalRightLayer = rightLayer == null || Iterables.all(rightLayer.getNodes(), PolylineEdgeRouter.PRED_EXTERNAL_WEST_OR_EAST_PORT);
                int maxRank = -1;
                for (SplineHyperEdge edge : hyperEdges) {
                    maxRank = Math.max(maxRank, edge.rank);
                }
                if (++maxRank > 0) {
                    double increment = (double)(maxRank + 1) * this.edgeSpacing;
                    if (increment < (double)nodeSpacing && !externalLeftLayer && !externalRightLayer) {
                        increment = nodeSpacing;
                    }
                    rightLayersPosition += increment;
                } else if (!(externalLeftLayer || externalRightLayer || this.layerOnlyContainsDummies(leftLayer) || this.layerOnlyContainsDummies(rightLayer))) {
                    rightLayersPosition += (double)nodeSpacing;
                }
                LGraphUtil.placeNodesHorizontally(rightLayer, rightLayersPosition);
            }
            for (LEdge selfLoop : selfLoops) {
                KVector offset = selfLoop.getSource().getNode().getPosition();
                selfLoop.getBendPoints().offset(offset);
                for (LLabel label : selfLoop.getLabels()) {
                    label.getPosition().add(offset);
                }
            }
            for (SplineHyperEdge edge : hyperEdges) {
                if (edge.isStraight) {
                    this.calculateNUBSBendPointStraight(edge, xpos);
                    continue;
                }
                this.calculateNUBSBendPoints(edge, xpos, rightLayersPosition);
            }
            if (rightLayer != null) {
                xpos = rightLayersPosition + rightLayer.getSize().x + 10.0;
            } else {
                int maxRank = -1;
                for (SplineHyperEdge edge : hyperEdges) {
                    maxRank = Math.max(maxRank, edge.rank);
                }
                if (maxRank >= 0) {
                    xpos += (double)(maxRank + 2) * this.edgeSpacing;
                }
            }
            leftLayer = rightLayer;
            externalLeftLayer = externalRightLayer;
        } while (rightLayer != null);
        for (LEdge edge : startEdges) {
            this.calculateBezierBendPoints(edge, successingEdge);
        }
        layeredGraph.getSize().x = xpos;
        monitor.done();
    }

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        IntermediateProcessingConfiguration configuration = IntermediateProcessingConfiguration.createEmpty();
        Set graphProperties = (Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        if (graphProperties.contains((Object)GraphProperties.SELF_LOOPS)) {
            configuration.addAll(SELF_LOOP_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.CENTER_LABELS)) {
            configuration.addAll(CENTER_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.NON_FREE_PORTS) || ((Boolean)graph.getProperty(Properties.FEEDBACK_EDGES)).booleanValue()) {
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
            if (graphProperties.contains((Object)GraphProperties.NORTH_SOUTH_PORTS)) {
                configuration.addAll(NORTH_SOUTH_PORT_PROCESSING_ADDITIONS);
            }
        }
        if (graphProperties.contains((Object)GraphProperties.END_LABELS)) {
            configuration.addAll(END_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        return configuration;
    }

    private static boolean isStraight(double firstY, double secondY) {
        return Math.abs(firstY - secondY) < 0.2;
    }

    private void fillMappings(Pair<Layer, Layer> leftRightLayer, Pair<Set<LPort>, Set<LPort>> leftRightPorts, List<LEdge> allEdges, Map<LEdge, LEdge> succeedingEdge, List<LEdge> startingEdges, Set<LEdge> selfLoops) {
        LPort targetPort;
        Layer targetLayer;
        LNode.NodeType sourceNodeType;
        Layer leftLayer = (Layer)leftRightLayer.getFirst();
        Layer rightLayer = (Layer)leftRightLayer.getSecond();
        Set leftPorts = (Set)leftRightPorts.getFirst();
        Set rightPorts = (Set)leftRightPorts.getSecond();
        if (leftLayer != null) {
            for (LNode node : leftLayer.getNodes()) {
                for (LPort sourcePort : node.getPorts(PortSide.EAST)) {
                    leftPorts.add(sourcePort);
                    for (LEdge edge : sourcePort.getOutgoingEdges()) {
                        if (edge.isSelfLoop()) continue;
                        allEdges.add(edge);
                        this.findAndAddSuccessor(edge, succeedingEdge);
                        sourceNodeType = edge.getSource().getNode().getType();
                        if (sourceNodeType == LNode.NodeType.NORMAL || sourceNodeType == LNode.NodeType.NORTH_SOUTH_PORT) {
                            startingEdges.add(edge);
                        }
                        if ((targetLayer = (targetPort = edge.getTarget()).getNode().getLayer()).equals(rightLayer)) {
                            rightPorts.add(targetPort);
                            continue;
                        }
                        if (targetLayer.equals(leftLayer)) {
                            leftPorts.add(targetPort);
                            continue;
                        }
                        allEdges.remove((Object)edge);
                    }
                }
            }
        }
        if (rightLayer != null) {
            for (LNode node : rightLayer.getNodes()) {
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        if (!edge.isSelfLoop()) continue;
                        selfLoops.add(edge);
                    }
                }
                for (LPort sourcePort : node.getPorts(PortSide.WEST)) {
                    rightPorts.add(sourcePort);
                    for (LEdge edge : sourcePort.getOutgoingEdges()) {
                        if (edge.isSelfLoop()) continue;
                        allEdges.add(edge);
                        this.findAndAddSuccessor(edge, succeedingEdge);
                        sourceNodeType = edge.getSource().getNode().getType();
                        if (sourceNodeType == LNode.NodeType.NORMAL || sourceNodeType == LNode.NodeType.NORTH_SOUTH_PORT) {
                            startingEdges.add(edge);
                        }
                        if ((targetLayer = (targetPort = edge.getTarget()).getNode().getLayer()).equals(rightLayer)) {
                            rightPorts.add(targetPort);
                            continue;
                        }
                        if (targetLayer.equals(leftLayer)) {
                            leftPorts.add(targetPort);
                            continue;
                        }
                        allEdges.remove((Object)edge);
                    }
                }
            }
        }
    }

    private void findAndAddSuccessor(LEdge edge, Map<LEdge, LEdge> succeedingEdge) {
        LNode targetNode = edge.getTarget().getNode();
        if (targetNode.getType() == LNode.NodeType.NORMAL) {
            return;
        }
        Iterator<LEdge> iter = targetNode.getOutgoingEdges().iterator();
        if (iter.hasNext()) {
            succeedingEdge.put(edge, iter.next());
        }
    }

    private void createHyperEdges(List<LEdge> edges, Set<LPort> leftPorts, Set<LPort> rightPorts, List<SplineHyperEdge> hyperEdges) {
        for (LEdge edge : edges) {
            SideToProcess targetSide;
            SideToProcess sourceSide;
            LPort sourcePort = edge.getSource();
            if (leftPorts.contains((Object)sourcePort)) {
                sourceSide = SideToProcess.LEFT;
            } else if (rightPorts.contains((Object)sourcePort)) {
                sourceSide = SideToProcess.RIGHT;
            } else {
                throw new IllegalArgumentException("Source port must be in one of the port sets.");
            }
            LPort targetPort = edge.getTarget();
            if (leftPorts.contains((Object)targetPort)) {
                targetSide = SideToProcess.LEFT;
            } else if (rightPorts.contains((Object)targetPort)) {
                targetSide = SideToProcess.RIGHT;
            } else {
                throw new IllegalArgumentException("Target port must be in one of the port sets.");
            }
            hyperEdges.add(new SplineHyperEdge(edge, sourceSide, targetSide));
        }
    }

    private void createHyperEdges(Set<LPort> leftPorts, Set<LPort> rightPorts, SideToProcess sideToProcess, boolean reversed, List<LEdge> edgesRemaining, List<SplineHyperEdge> hyperEdges) {
        Set<LPort> portsToProcess = null;
        if (sideToProcess == SideToProcess.LEFT) {
            portsToProcess = leftPorts;
        } else if (sideToProcess == SideToProcess.RIGHT) {
            portsToProcess = rightPorts;
        } else assert (false) : "sideToProcess must be either LEFT or RIGHT.";
        if (portsToProcess == null) {
            return;
        }
        for (LPort singlePort : portsToProcess) {
            double singlePortPosition = singlePort.getAbsoluteAnchor().y;
            HashSet upEdges = Sets.newHashSet();
            HashSet downEdges = Sets.newHashSet();
            for (LEdge edge : singlePort.getConnectedEdges()) {
                if ((Boolean)edge.getProperty(InternalProperties.REVERSED) != reversed || !edgesRemaining.contains((Object)edge)) continue;
                LPort targetPort = edge.getTarget() == singlePort ? edge.getSource() : edge.getTarget();
                double targetPortPosition = targetPort.getAbsoluteAnchor().y;
                if (SplineEdgeRouter.isStraight(targetPortPosition, singlePortPosition)) continue;
                if (targetPortPosition < singlePortPosition) {
                    if (leftPorts.contains((Object)targetPort)) {
                        upEdges.add(Pair.of((Object)((Object)SideToProcess.LEFT), (Object)((Object)edge)));
                        continue;
                    }
                    upEdges.add(Pair.of((Object)((Object)SideToProcess.RIGHT), (Object)((Object)edge)));
                    continue;
                }
                if (leftPorts.contains((Object)targetPort)) {
                    downEdges.add(Pair.of((Object)((Object)SideToProcess.LEFT), (Object)((Object)edge)));
                    continue;
                }
                downEdges.add(Pair.of((Object)((Object)SideToProcess.RIGHT), (Object)((Object)edge)));
            }
            if (upEdges.size() > 1) {
                hyperEdges.add(new SplineHyperEdge(singlePort, upEdges, sideToProcess));
                for (Pair pair : upEdges) {
                    edgesRemaining.remove(pair.getSecond());
                }
            }
            if (downEdges.size() <= 1) continue;
            hyperEdges.add(new SplineHyperEdge(singlePort, downEdges, sideToProcess));
            for (Pair pair : downEdges) {
                edgesRemaining.remove(pair.getSecond());
            }
        }
    }

    private void createDependency(SplineHyperEdge edge0, SplineHyperEdge edge1) {
        if (edge0.topYPos > edge1.bottomYPos || edge1.topYPos > edge0.bottomYPos) {
            return;
        }
        int edge0Counter = 0;
        int edge1Counter = 0;
        for (LPort port : edge0.rightPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge1.topYPos, edge1.bottomYPos)) continue;
            ++edge0Counter;
        }
        for (LPort port : edge0.leftPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge1.topYPos, edge1.bottomYPos)) continue;
            --edge0Counter;
        }
        for (LPort port : edge1.rightPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge0.topYPos, edge0.bottomYPos)) continue;
            ++edge1Counter;
        }
        for (LPort port : edge1.leftPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge0.topYPos, edge0.bottomYPos)) continue;
            --edge1Counter;
        }
        if (edge0Counter < edge1Counter) {
            new Dependency(edge0, edge1, edge1Counter - edge0Counter);
        } else if (edge1Counter < edge0Counter) {
            new Dependency(edge1, edge0, edge0Counter - edge1Counter);
        } else {
            new Dependency(edge1, edge0, 0);
            new Dependency(edge0, edge1, 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void breakCycles(List<SplineHyperEdge> edges, Random random) {
        sources = Lists.newLinkedList();
        sinks = Lists.newLinkedList();
        nextMark = -1;
        for (SplineHyperEdge edge : edges) {
            edge.mark = nextMark--;
            inweight = 0;
            outweight = 0;
            for (Dependency dependency : edge.outgoing) {
                outweight += dependency.weight;
            }
            for (Dependency dependency : edge.incoming) {
                inweight += dependency.weight;
            }
            edge.inweight = inweight;
            edge.outweight = outweight;
            if (outweight == 0) {
                sinks.add(edge);
                continue;
            }
            if (inweight != 0) continue;
            sources.add(edge);
        }
        unprocessed = Sets.newLinkedHashSet(edges);
        markBase = edges.size();
        nextLeft = markBase + 1;
        nextRight = markBase - 1;
        maxEdges = Lists.newArrayList();
        ** GOTO lbl61
        {
            sink = (SplineHyperEdge)sinks.removeFirst();
            unprocessed.remove(sink);
            sink.mark = nextRight--;
            SplineEdgeRouter.updateNeighbors(sink, sources, sinks);
            do {
                if (!sinks.isEmpty()) continue block3;
                while (!sources.isEmpty()) {
                    source = (SplineHyperEdge)sources.removeFirst();
                    unprocessed.remove(source);
                    source.mark = nextLeft++;
                    SplineEdgeRouter.updateNeighbors(source, sources, sinks);
                }
                maxOutflow = -2147483648;
                for (SplineHyperEdge edge : unprocessed) {
                    outflow = edge.outweight - edge.inweight;
                    if (outflow < maxOutflow) continue;
                    if (outflow > maxOutflow) {
                        maxEdges.clear();
                        maxOutflow = outflow;
                    }
                    maxEdges.add(edge);
                }
                if (maxEdges.isEmpty()) continue;
                maxEdge = (SplineHyperEdge)maxEdges.get(random.nextInt(maxEdges.size()));
                unprocessed.remove(maxEdge);
                maxEdge.mark = nextLeft++;
                SplineEdgeRouter.updateNeighbors(maxEdge, sources, sinks);
                maxEdges.clear();
lbl61:
                // 3 sources

            } while (!unprocessed.isEmpty());
        }
        shiftBase = edges.size() + 1;
        for (SplineHyperEdge edge : edges) {
            if (edge.mark >= markBase) continue;
            edge.mark += shiftBase;
        }
        for (SplineHyperEdge source : edges) {
            depIter = source.outgoing.listIterator();
            while (depIter.hasNext()) {
                dependency = depIter.next();
                target = dependency.target;
                if (source.mark <= target.mark) continue;
                depIter.remove();
                target.incoming.remove(dependency);
                if (dependency.weight <= 0) continue;
                dependency.source = target;
                target.outgoing.add(dependency);
                dependency.target = source;
                source.incoming.add(dependency);
            }
        }
    }

    private static void updateNeighbors(SplineHyperEdge edge, List<SplineHyperEdge> sources, List<SplineHyperEdge> sinks) {
        for (Dependency dep : edge.outgoing) {
            if (dep.target.mark >= 0 || dep.weight <= 0) continue;
            dep.target.inweight -= dep.weight;
            if (dep.target.inweight > 0 || dep.target.outweight <= 0) continue;
            sources.add(dep.target);
        }
        for (Dependency dep : edge.incoming) {
            if (dep.source.mark >= 0 || dep.weight <= 0) continue;
            dep.source.outweight -= dep.weight;
            if (dep.source.outweight > 0 || dep.source.inweight <= 0) continue;
            sinks.add(dep.source);
        }
    }

    private static void topologicalNumbering(List<SplineHyperEdge> edges) {
        LinkedList sources = Lists.newLinkedList();
        LinkedList rightwardTargets = Lists.newLinkedList();
        for (SplineHyperEdge edge2 : edges) {
            edge2.inweight = edge2.incoming.size();
            edge2.outweight = edge2.outgoing.size();
            if (edge2.inweight == 0) {
                sources.add(edge2);
            }
            if (edge2.outweight != 0 || !edge2.leftPorts.isEmpty()) continue;
            rightwardTargets.add(edge2);
        }
        int maxRank = -1;
        while (!sources.isEmpty()) {
            SplineHyperEdge edge3 = (SplineHyperEdge)sources.remove(0);
            for (Dependency dependency : edge3.outgoing) {
                SplineHyperEdge target = dependency.target;
                target.rank = Math.max(target.rank, edge3.rank + 1);
                maxRank = Math.max(maxRank, target.rank);
                --target.inweight;
                if (target.inweight != 0) continue;
                sources.add(target);
            }
        }
        if (maxRank > -1) {
            for (SplineHyperEdge edge : rightwardTargets) {
                edge.rank = maxRank;
            }
            while (!rightwardTargets.isEmpty()) {
                SplineHyperEdge edge;
                edge = (SplineHyperEdge)rightwardTargets.remove(0);
                for (Dependency dependency : edge.incoming) {
                    SplineHyperEdge source = dependency.source;
                    if (!source.leftPorts.isEmpty()) continue;
                    source.rank = Math.min(source.rank, edge.rank - 1);
                    --source.outweight;
                    if (source.outweight != 0) continue;
                    rightwardTargets.add(source);
                }
            }
        }
    }

    private void calculateBezierBendPoints(LEdge edge, Map<LEdge, LEdge> succeedingEdge) {
        KVectorChain allCP = new KVectorChain();
        KVector northSouthBendPoint = null;
        LPort sourcePort = edge.getSource();
        LNode.NodeType sourceNodeType = sourcePort.getNode().getType();
        if (sourceNodeType != LNode.NodeType.NORMAL && sourceNodeType != LNode.NodeType.NORTH_SOUTH_PORT) {
            throw new IllegalArgumentException("The target node of the edge must be a normal node or a northSouthPort.");
        }
        if (sourceNodeType == LNode.NodeType.NORTH_SOUTH_PORT) {
            LPort originPort = (LPort)((Object)sourcePort.getProperty(InternalProperties.ORIGIN));
            northSouthBendPoint = new KVector(originPort.getAbsoluteAnchor().x, sourcePort.getAbsoluteAnchor().y);
            sourcePort = originPort;
        }
        allCP.addLast((Object)sourcePort.getAbsoluteAnchor());
        double gap = Math.max(5.0, SplinesMath.getMarginOnPortSide(sourcePort.getNode(), sourcePort.getSide()));
        KVector offsetOfStraightening = new KVector(SplinesMath.portSideToDirection(sourcePort.getSide()));
        offsetOfStraightening.scale(gap);
        allCP.add((Object)offsetOfStraightening.add(sourcePort.getAbsoluteAnchor()));
        if (northSouthBendPoint != null) {
            allCP.addLast((Object)northSouthBendPoint);
            northSouthBendPoint = null;
        }
        LEdge currentEdge = edge;
        LEdge lastEdge = edge;
        KVector lastCP = new KVector();
        boolean addMidPoint = false;
        while (currentEdge != null) {
            KVectorChain currentBendPoints = currentEdge.getBendPoints();
            if (!currentBendPoints.isEmpty()) {
                if (addMidPoint) {
                    allCP.add((Object)lastCP.add((KVector)currentBendPoints.getFirst()).scale(0.5));
                    addMidPoint = false;
                } else {
                    addMidPoint = true;
                }
                lastCP = ((KVector)currentBendPoints.getLast()).clone();
                allCP.addAll((Collection)currentBendPoints);
                currentBendPoints.clear();
            }
            lastEdge = currentEdge;
            currentEdge = succeedingEdge.get((Object)currentEdge);
        }
        LPort targetPort = lastEdge.getTarget();
        if (targetPort.getNode().getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
            LPort originPort = (LPort)((Object)targetPort.getProperty(InternalProperties.ORIGIN));
            allCP.add((Object)new KVector(originPort.getAbsoluteAnchor().x, targetPort.getAbsoluteAnchor().y));
            targetPort = originPort;
        }
        gap = Math.max(5.0, SplinesMath.getMarginOnPortSide(targetPort.getNode(), targetPort.getSide()));
        offsetOfStraightening = new KVector(SplinesMath.portSideToDirection(targetPort.getSide()));
        offsetOfStraightening.scale(gap);
        allCP.add((Object)offsetOfStraightening.add(targetPort.getAbsoluteAnchor()));
        allCP.addLast((Object)targetPort.getAbsoluteAnchor());
        NubSpline nubSpline = new NubSpline(true, 3, (List<KVector>)allCP);
        edge.getBendPoints().addAll((Collection)nubSpline.getBezierCP());
    }

    private void calculateNUBSBendPointStraight(SplineHyperEdge hyperEdge, double startPos) {
        Set<LEdge> edges = hyperEdge.edges;
        if (edges.size() > 1) {
            throw new IllegalArgumentException("In straight hyperEdges there may be only one edge.");
        }
        edges.iterator().next().getBendPoints().add((Object)new KVector(startPos, hyperEdge.centerYPos));
    }

    private void calculateNUBSBendPoints(SplineHyperEdge hyperEdge, double startXPos, double endXPos) {
        double centerXPos = startXPos + (double)(hyperEdge.rank + 1) * this.edgeSpacing;
        double centerYPos = hyperEdge.centerYPos;
        KVector center = new KVector(centerXPos, centerYPos);
        for (LEdge edge : hyperEdge.edges) {
            KVector targetAnchor = edge.getTarget().getAbsoluteAnchor();
            KVector sourceAnchor = edge.getSource().getAbsoluteAnchor();
            KVector sourceVerticalCP = new KVector(centerXPos, sourceAnchor.y);
            KVector targetVerticalCP = new KVector(centerXPos, targetAnchor.y);
            KVector sourceStraightCP = new KVector(startXPos - 10.0, sourceAnchor.y);
            KVector targetStraightCP = new KVector(endXPos, targetAnchor.y);
            if (targetAnchor.x >= endXPos && sourceAnchor.x >= endXPos) {
                sourceStraightCP.x = endXPos;
            }
            if (targetAnchor.x <= startXPos && sourceAnchor.x <= startXPos) {
                targetStraightCP.x = startXPos - 10.0;
            }
            if (hyperEdge.edges.size() == 1) {
                edge.getBendPoints().addAll(new KVector[]{sourceStraightCP, sourceVerticalCP, targetVerticalCP, targetStraightCP});
                continue;
            }
            edge.getBendPoints().addAll(new KVector[]{sourceStraightCP, sourceVerticalCP, center, targetVerticalCP, targetStraightCP});
        }
    }

    private boolean layerOnlyContainsDummies(Layer layer) {
        for (LNode n : layer.getNodes()) {
            if (n.getType() != LNode.NodeType.NORMAL && n.getType() != LNode.NodeType.BIG_NODE) continue;
            return false;
        }
        return true;
    }

    private final class Dependency {
        private SplineHyperEdge source;
        private SplineHyperEdge target;
        private final int weight;

        Dependency(SplineHyperEdge source, SplineHyperEdge target, int weight) {
            this.source = source;
            this.target = target;
            this.weight = weight;
            source.outgoing.add(this);
            target.incoming.add(this);
        }

        public String toString() {
            return this.source + " ->(" + this.weight + ") " + this.target;
        }
    }

    private static enum SideToProcess {
        LEFT,
        RIGHT;

    }

    private static final class SplineHyperEdge
    implements Comparable<SplineHyperEdge> {
        private final Set<LPort> leftPorts = Sets.newHashSet();
        private final Set<LPort> rightPorts = Sets.newHashSet();
        private final Set<LEdge> edges = Sets.newHashSet();
        private boolean isStraight;
        private double topYPos;
        private double centerYPos;
        private double bottomYPos;
        private final List<Dependency> outgoing = Lists.newArrayList();
        private final List<Dependency> incoming = Lists.newArrayList();
        private int mark;
        private int inweight;
        private int outweight;
        private int rank;

        public SplineHyperEdge(LPort singlePort, Set<Pair<SideToProcess, LEdge>> edges, SideToProcess sourceSide) {
            if (sourceSide == SideToProcess.LEFT) {
                this.leftPorts.add(singlePort);
            } else {
                this.rightPorts.add(singlePort);
            }
            double yMinPosOfTarget = Double.MAX_VALUE;
            double yMaxPosOfTarget = Double.MIN_VALUE;
            for (Pair<SideToProcess, LEdge> pair : edges) {
                SideToProcess side = (SideToProcess)((Object)pair.getFirst());
                LEdge edge = (LEdge)((Object)pair.getSecond());
                LPort targetPort = edge.getSource();
                if (((Object)((Object)targetPort)).equals((Object)singlePort)) {
                    targetPort = edge.getTarget();
                }
                if (side == SideToProcess.LEFT) {
                    this.leftPorts.add(targetPort);
                } else {
                    this.rightPorts.add(targetPort);
                }
                double yPosOfTarget = targetPort.getAbsoluteAnchor().y;
                yMinPosOfTarget = Math.min(yMinPosOfTarget, yPosOfTarget);
                yMaxPosOfTarget = Math.max(yMaxPosOfTarget, yPosOfTarget);
            }
            double yPosOfSingleSide = singlePort.getAbsoluteAnchor().y;
            this.setRelevantPositions(yPosOfSingleSide, yMinPosOfTarget, yMaxPosOfTarget);
            for (Pair<SideToProcess, LEdge> pair : edges) {
                this.edges.add((LEdge)((Object)pair.getSecond()));
            }
            this.isStraight = false;
        }

        public SplineHyperEdge(LEdge edge, SideToProcess sourceSide, SideToProcess targetSide) {
            if (sourceSide == SideToProcess.LEFT) {
                this.leftPorts.add(edge.getSource());
            } else {
                this.rightPorts.add(edge.getSource());
            }
            if (targetSide == SideToProcess.LEFT) {
                this.leftPorts.add(edge.getTarget());
            } else {
                this.rightPorts.add(edge.getTarget());
            }
            this.edges.add(edge);
            double sourceY = edge.getSource().getAbsoluteAnchor().y;
            double targetY = edge.getTarget().getAbsoluteAnchor().y;
            this.setRelevantPositions(sourceY, targetY, targetY);
            this.isStraight = SplineEdgeRouter.isStraight(edge.getSource().getAbsoluteAnchor().y, edge.getTarget().getAbsoluteAnchor().y);
        }

        @Override
        public int compareTo(SplineHyperEdge other) {
            return this.mark - other.mark;
        }

        private void setRelevantPositions(double sourceY, double targetYMin, double targetYMax) {
            if (sourceY < targetYMin) {
                this.centerYPos = 0.5 * (sourceY + targetYMin);
                this.topYPos = 0.09999999999999998 * this.centerYPos + 0.9 * sourceY;
                this.bottomYPos = 0.09999999999999998 * this.centerYPos + 0.9 * targetYMin;
            } else {
                this.centerYPos = 0.5 * (sourceY + targetYMax);
                this.topYPos = 0.09999999999999998 * this.centerYPos + 0.9 * targetYMax;
                this.bottomYPos = 0.09999999999999998 * this.centerYPos + 0.9 * sourceY;
            }
        }
    }
}

