/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.properties;

import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;

public final class Spacings {
    public final float nodeSpacing;
    public final float edgeEdgeSpacing;
    public final float edgeNodeSpacing;
    public final float portSpacing;
    public final float externalPortSpacing;
    public final float labelSpacing;
    public final float inLayerSpacingFactor;
    private final float[][] nodeTypeSpacings;

    public Spacings(LGraph graph) {
        this.nodeSpacing = ((Float)graph.getProperty(InternalProperties.SPACING)).floatValue();
        this.inLayerSpacingFactor = ((Float)graph.getProperty(Properties.OBJ_SPACING_IN_LAYER_FACTOR)).floatValue();
        this.edgeEdgeSpacing = this.nodeSpacing * ((Float)graph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        this.edgeNodeSpacing = this.nodeSpacing * ((Float)graph.getProperty((IProperty)Properties.EDGE_NODE_SPACING_FACTOR)).floatValue();
        this.portSpacing = ((Float)graph.getProperty(InternalProperties.PORT_SPACING)).floatValue();
        this.externalPortSpacing = ((Float)graph.getProperty(InternalProperties.PORT_SPACING)).floatValue();
        this.labelSpacing = ((Float)graph.getProperty(LayoutOptions.LABEL_SPACING)).floatValue();
        int n = LNode.NodeType.values().length;
        this.nodeTypeSpacings = new float[n][n];
        this.precalculateNodeTypeSpacings();
    }

    private void precalculateNodeTypeSpacings() {
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, this.nodeSpacing);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.LONG_EDGE, this.edgeNodeSpacing);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.NORTH_SOUTH_PORT, this.edgeNodeSpacing);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.EXTERNAL_PORT, this.externalPortSpacing);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.LABEL, this.edgeNodeSpacing);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.BIG_NODE, this.edgeNodeSpacing);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, this.edgeEdgeSpacing);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.NORTH_SOUTH_PORT, this.edgeEdgeSpacing);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.EXTERNAL_PORT, this.externalPortSpacing);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.LABEL, this.labelSpacing);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.BIG_NODE, this.edgeNodeSpacing);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, this.edgeEdgeSpacing);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LNode.NodeType.EXTERNAL_PORT, this.externalPortSpacing);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LNode.NodeType.LABEL, this.labelSpacing);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LNode.NodeType.BIG_NODE, this.edgeNodeSpacing);
        this.nodeTypeSpacing(LNode.NodeType.EXTERNAL_PORT, this.externalPortSpacing);
        this.nodeTypeSpacing(LNode.NodeType.EXTERNAL_PORT, LNode.NodeType.LABEL, this.externalPortSpacing);
        this.nodeTypeSpacing(LNode.NodeType.EXTERNAL_PORT, LNode.NodeType.BIG_NODE, this.externalPortSpacing);
        this.nodeTypeSpacing(LNode.NodeType.LABEL, this.labelSpacing);
        this.nodeTypeSpacing(LNode.NodeType.LABEL, LNode.NodeType.BIG_NODE, this.labelSpacing);
        this.nodeTypeSpacing(LNode.NodeType.BIG_NODE, this.nodeSpacing);
    }

    private void nodeTypeSpacing(LNode.NodeType nt, float spacing) {
        this.nodeTypeSpacings[nt.ordinal()][nt.ordinal()] = spacing;
    }

    private void nodeTypeSpacing(LNode.NodeType n1, LNode.NodeType n2, float spacing) {
        this.nodeTypeSpacings[n1.ordinal()][n2.ordinal()] = spacing;
        this.nodeTypeSpacings[n2.ordinal()][n1.ordinal()] = spacing;
    }

    public float getHorizontalSpacing(LGraphElement e1, LGraphElement e2) {
        if (e1 instanceof LNode && e2 instanceof LNode) {
            return this.getHorizontalSpacing((LNode)e1, (LNode)e2);
        }
        throw new UnspecifiedSpacingException();
    }

    public float getHorizontalSpacing(LNode n1, LNode n2) {
        return this.getHorizontalSpacing(n1.getType(), n2.getType());
    }

    public float getHorizontalSpacing(LNode.NodeType t1, LNode.NodeType t2) {
        return this.nodeTypeSpacings[t1.ordinal()][t2.ordinal()];
    }

    public float getVerticalSpacing(LNode n1, LNode n2) {
        return this.getHorizontalSpacing(n1, n2) * this.inLayerSpacingFactor;
    }

    public float getVerticalSpacing(LNode.NodeType t1, LNode.NodeType t2) {
        return this.getHorizontalSpacing(t1, t2) * this.inLayerSpacingFactor;
    }

    public static class UnspecifiedSpacingException
    extends RuntimeException {
        private static final long serialVersionUID = 1609767701465615319L;

        public UnspecifiedSpacingException() {
        }

        public UnspecifiedSpacingException(String msg) {
            super(msg);
        }
    }
}

