/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.krendering;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Arc implements Enumerator
{
    OPEN(0, "OPEN", "OPEN"),
    CHORD(1, "CHORD", "CHORD"),
    PIE(2, "PIE", "PIE");

    public static final int OPEN_VALUE = 0;
    public static final int CHORD_VALUE = 1;
    public static final int PIE_VALUE = 2;
    private static final Arc[] VALUES_ARRAY;
    public static final List<Arc> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Arc[]{OPEN, CHORD, PIE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Arc get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Arc result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Arc getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Arc result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Arc get(int value) {
        switch (value) {
            case 0: {
                return OPEN;
            }
            case 1: {
                return CHORD;
            }
            case 2: {
                return PIE;
            }
        }
        return null;
    }

    private Arc(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

