/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.krendering;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import de.cau.cs.kieler.core.krendering.Colors;
import de.cau.cs.kieler.core.krendering.KAreaPlacementData;
import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KColoring;
import de.cau.cs.kieler.core.krendering.KContainerRendering;
import de.cau.cs.kieler.core.krendering.KGridPlacement;
import de.cau.cs.kieler.core.krendering.KGridPlacementData;
import de.cau.cs.kieler.core.krendering.KPlacement;
import de.cau.cs.kieler.core.krendering.KPlacementData;
import de.cau.cs.kieler.core.krendering.KPointPlacementData;
import de.cau.cs.kieler.core.krendering.KPosition;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KRenderingFactory;
import de.cau.cs.kieler.core.krendering.KRenderingPackage;
import de.cau.cs.kieler.core.krendering.KRenderingRef;
import de.cau.cs.kieler.core.krendering.KXPosition;
import de.cau.cs.kieler.core.krendering.KYPosition;
import java.util.Collections;
import java.util.Iterator;

public final class KRenderingUtil {
    private static final KRenderingFactory FACTORY = KRenderingFactory.eINSTANCE;
    private static final KRenderingPackage PACKAGE = KRenderingPackage.eINSTANCE;
    public static final KPosition LEFT_TOP_POS = KRenderingUtil.createLeftTopKPosition();
    public static final KPosition RIGHT_BOTTOM_POS = KRenderingUtil.createRightBottomKPosition();

    private KRenderingUtil() {
    }

    public static KRendering dereference(KRendering rendering) {
        KRendering r = rendering;
        while (r instanceof KRenderingRef) {
            r = ((KRenderingRef)r).getRendering();
        }
        return r;
    }

    public static Iterator<KRendering> selfAndAllChildren(KRendering rendering) {
        Iterator<Object> children = rendering instanceof KRenderingRef ? KRenderingUtil.selfAndAllChildren(((KRenderingRef)rendering).getRendering()) : (rendering instanceof KContainerRendering ? Iterators.concat((Iterator)Iterators.transform((Iterator)((KContainerRendering)rendering).getChildren().iterator(), (Function)new Function<KRendering, Iterator<KRendering>>(){

            public Iterator<KRendering> apply(KRendering rendering) {
                return KRenderingUtil.selfAndAllChildren(rendering);
            }
        })) : Collections.emptyIterator());
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)rendering), children);
    }

    public static KPlacementData getPlacementData(KRendering rendering) {
        if (rendering.getPlacementData() != null) {
            return rendering.getPlacementData();
        }
        if (PACKAGE.getKRenderingRef().isInstance((Object)rendering)) {
            KRenderingRef ref = (KRenderingRef)rendering;
            if (ref.getRendering() == null) {
                return null;
            }
            return KRenderingUtil.getPlacementData(((KRenderingRef)rendering).getRendering());
        }
        return null;
    }

    public static KAreaPlacementData asAreaPlacementData(KPlacementData data) {
        if (data instanceof KAreaPlacementData) {
            return (KAreaPlacementData)data;
        }
        return null;
    }

    public static KPointPlacementData asPointPlacementData(KPlacementData data) {
        if (data instanceof KPointPlacementData) {
            return (KPointPlacementData)data;
        }
        return null;
    }

    public static KGridPlacementData asGridPlacementData(KPlacementData data) {
        if (data instanceof KGridPlacementData) {
            return (KGridPlacementData)data;
        }
        return null;
    }

    public static KGridPlacement asGridPlacement(KPlacement placement) {
        if (placement instanceof KGridPlacement) {
            return (KGridPlacement)placement;
        }
        return null;
    }

    public static KPosition createLeftTopKPosition() {
        return KRenderingUtil.setPositions(FACTORY.createKPosition(), FACTORY.createKLeftPosition(), FACTORY.createKTopPosition());
    }

    public static KPosition createRightBottomKPosition() {
        return KRenderingUtil.setPositions(FACTORY.createKPosition(), FACTORY.createKRightPosition(), FACTORY.createKBottomPosition());
    }

    public static KPosition toNonNullLeftTopPosition(KPosition position) {
        return position != null ? position : LEFT_TOP_POS;
    }

    public static KPosition toNonNullRightBottomPosition(KPosition position) {
        return position != null ? position : RIGHT_BOTTOM_POS;
    }

    public static KXPosition<?> toNonNullLeftPosition(KXPosition<?> position) {
        return position != null ? position : LEFT_TOP_POS.getX();
    }

    public static KXPosition<?> toNonNullRightPosition(KXPosition<?> position) {
        return position != null ? position : RIGHT_BOTTOM_POS.getX();
    }

    public static KYPosition<?> toNonNullTopPosition(KYPosition<?> position) {
        return position != null ? position : LEFT_TOP_POS.getY();
    }

    public static KYPosition<?> toNonNullBottomPosition(KYPosition<?> position) {
        return position != null ? position : RIGHT_BOTTOM_POS.getY();
    }

    public static KPosition setPositions(KPosition pos, KXPosition<?> xPart, KYPosition<?> yPart) {
        pos.setX(xPart);
        pos.setY(yPart);
        return pos;
    }

    public static boolean equals(KPosition it, Object other) {
        if (it == other) {
            return true;
        }
        if (it != null && other instanceof KPosition) {
            KPosition position = (KPosition)other;
            return it.getClass() == position.getClass() && KRenderingUtil.equals(it.getX(), position.getY()) && KRenderingUtil.equals(it.getY(), position.getY());
        }
        return false;
    }

    public static <T extends KXPosition<T>> T setPosition(T xPos, float absolute, float relative) {
        xPos.setAbsolute(absolute);
        xPos.setRelative(relative);
        return xPos;
    }

    public static boolean equals(KXPosition<?> it, Object other) {
        if (it == other) {
            return true;
        }
        if (it != null && other instanceof KXPosition) {
            KXPosition xPos = (KXPosition)other;
            return it.getClass() == other.getClass() && it.getAbsolute() == xPos.getAbsolute() && it.getRelative() == xPos.getRelative();
        }
        return false;
    }

    public static <T extends KYPosition<T>> T setPosition(T yPos, float absolute, float relative) {
        yPos.setAbsolute(absolute);
        yPos.setRelative(relative);
        return yPos;
    }

    public static boolean equals(KYPosition<?> it, Object other) {
        if (it == other) {
            return true;
        }
        if (it != null && other instanceof KYPosition) {
            KYPosition yPos = (KYPosition)other;
            return it.getClass() == other.getClass() && it.getAbsolute() == yPos.getAbsolute() && it.getRelative() == yPos.getRelative();
        }
        return false;
    }

    public static KColor setColor(KColor color, int red, int green, int blue) {
        color.setRed(red);
        color.setGreen(green);
        color.setBlue(blue);
        return color;
    }

    public static KColor setColor(KColor color, Colors colorConstant) {
        return KRenderingUtil.setColor(color, colorConstant.getRed(), colorConstant.getGreen(), colorConstant.getBlue());
    }

    public static KColor setColor(KColor color, KColor kColor) {
        return KRenderingUtil.setColor(color, kColor.getRed(), kColor.getBlue(), kColor.getGreen());
    }

    public static boolean equals(KColor it, Object other) {
        if (it == other) {
            return true;
        }
        if (it != null && other instanceof KColor) {
            KColor color = (KColor)other;
            return it.getRed() == color.getRed() && it.getGreen() == color.getGreen() && it.getBlue() == color.getBlue();
        }
        return false;
    }

    public static <T extends KColoring<T>> T setColor(T coloring, int red, int green, int blue) {
        coloring.setColor(KRenderingUtil.setColor(FACTORY.createKColor(), red, green, blue));
        return coloring;
    }

    public static <T extends KColoring<T>> T setColor(T coloring, Colors color) {
        coloring.setColor(KRenderingUtil.setColor(FACTORY.createKColor(), color));
        return coloring;
    }

    public static <T extends KColoring<T>> T setColorCopyOf(T coloring, KColor kColor) {
        coloring.setColor(KRenderingUtil.setColor(FACTORY.createKColor(), kColor));
        return coloring;
    }

    public static <T extends KColoring<T>> T setColor(T coloring, int red, int green, int blue, int alpha) {
        coloring.setColor(red, green, blue);
        coloring.setAlpha(alpha);
        return coloring;
    }

    public static <T extends KColoring<T>> T setColor(T coloring, Colors color, int alpha) {
        coloring.setColor(KRenderingUtil.setColor(FACTORY.createKColor(), color));
        coloring.setAlpha(alpha);
        return coloring;
    }

    public static <T extends KColoring<T>> T setColorCopyOf(T coloring, KColor kColor, int alpha) {
        coloring.setColor(KRenderingUtil.setColor(FACTORY.createKColor(), kColor));
        coloring.setAlpha(alpha);
        return coloring;
    }

    public static <T extends KColoring<T>> T setTargetColor(T coloring, int red, int green, int blue) {
        coloring.setTargetColor(KRenderingUtil.setColor(FACTORY.createKColor(), red, green, blue));
        return coloring;
    }

    public static <T extends KColoring<T>> T setTargetColor(T coloring, Colors color) {
        coloring.setTargetColor(KRenderingUtil.setColor(FACTORY.createKColor(), color));
        return coloring;
    }

    public static <T extends KColoring<T>> T setTargetColorCopyOf(T coloring, KColor kColor) {
        coloring.setTargetColor(KRenderingUtil.setColor(FACTORY.createKColor(), kColor));
        return coloring;
    }

    public static <T extends KColoring<T>> T setTargetColor(T coloring, int red, int green, int blue, int alpha) {
        coloring.setTargetColor(red, green, blue);
        coloring.setTargetAlpha(alpha);
        return coloring;
    }

    public static <T extends KColoring<T>> T setTargetColor(T coloring, Colors color, int alpha) {
        coloring.setTargetColor(KRenderingUtil.setColor(FACTORY.createKColor(), color));
        coloring.setTargetAlpha(alpha);
        return coloring;
    }

    public static <T extends KColoring<T>> T setTargetColorCopyOf(T coloring, KColor kColor, int alpha) {
        coloring.setTargetColor(KRenderingUtil.setColor(FACTORY.createKColor(), kColor));
        coloring.setAlpha(alpha);
        return coloring;
    }

    public static boolean equals(KColoring<?> it, Object other) {
        if (it == other) {
            return true;
        }
        if (it != null && other instanceof KColoring) {
            KColoring coloring = (KColoring)other;
            return it.getClass() == coloring.getClass() && it.getAlpha() == coloring.getAlpha() && it.getTargetAlpha() == coloring.getTargetAlpha() && KRenderingUtil.equals(it.getColor(), (Object)coloring.getColor()) && KRenderingUtil.equals(it.getTargetColor(), (Object)coloring.getTargetColor());
        }
        return false;
    }

    public static KColor getColor(String colorString) {
        if (colorString.startsWith("#")) {
            KColor kcolor = KRenderingFactory.eINSTANCE.createKColor();
            try {
                if (colorString.length() == 4) {
                    String r = colorString.substring(1, 2);
                    kcolor.setRed(Integer.valueOf(String.valueOf(r) + r, 16));
                    String g = colorString.substring(2, 3);
                    kcolor.setGreen(Integer.valueOf(String.valueOf(g) + g, 16));
                    String b = colorString.substring(3, 4);
                    kcolor.setBlue(Integer.valueOf(String.valueOf(b) + b, 16));
                    return kcolor;
                }
                kcolor.setRed(Integer.valueOf(colorString.substring(1, 3), 16));
                kcolor.setGreen(Integer.valueOf(colorString.substring(3, 5), 16));
                kcolor.setBlue(Integer.valueOf(colorString.substring(5, 7), 16));
                return kcolor;
            }
            catch (Exception exception) {}
        } else {
            Colors c = Colors.getColorByName(colorString);
            if (c != null) {
                return KRenderingFactory.eINSTANCE.createKColor().setColor(c);
            }
        }
        return null;
    }
}

