/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.krendering;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LineCap implements Enumerator
{
    CAP_FLAT(0, "CAP_FLAT", "CAP_FLAT"),
    CAP_ROUND(1, "CAP_ROUND", "CAP_ROUND"),
    CAP_SQUARE(2, "CAP_SQUARE", "CAP_SQUARE");

    public static final int CAP_FLAT_VALUE = 0;
    public static final int CAP_ROUND_VALUE = 1;
    public static final int CAP_SQUARE_VALUE = 2;
    private static final LineCap[] VALUES_ARRAY;
    public static final List<LineCap> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LineCap[]{CAP_FLAT, CAP_ROUND, CAP_SQUARE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LineCap get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineCap result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineCap getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineCap result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineCap get(int value) {
        switch (value) {
            case 0: {
                return CAP_FLAT;
            }
            case 1: {
                return CAP_ROUND;
            }
            case 2: {
                return CAP_SQUARE;
            }
        }
        return null;
    }

    private LineCap(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

