/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.krendering;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LineJoin implements Enumerator
{
    JOIN_MITER(0, "JOIN_MITER", "JOIN_MITER"),
    JOIN_ROUND(1, "JOIN_ROUND", "JOIN_ROUND"),
    JOIN_BEVEL(2, "JOIN_BEVEL", "JOIN_BEVEL");

    public static final int JOIN_MITER_VALUE = 0;
    public static final int JOIN_ROUND_VALUE = 1;
    public static final int JOIN_BEVEL_VALUE = 2;
    private static final LineJoin[] VALUES_ARRAY;
    public static final List<LineJoin> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LineJoin[]{JOIN_MITER, JOIN_ROUND, JOIN_BEVEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LineJoin get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineJoin result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineJoin getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineJoin result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineJoin get(int value) {
        switch (value) {
            case 0: {
                return JOIN_MITER;
            }
            case 1: {
                return JOIN_ROUND;
            }
            case 2: {
                return JOIN_BEVEL;
            }
        }
        return null;
    }

    private LineJoin(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

