/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.krendering;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Trigger implements Enumerator
{
    SINGLECLICK(0, "SINGLECLICK", "SINGLECLICK"),
    DOUBLECLICK(1, "DOUBLECLICK", "DOUBLECLICK"),
    SINGLE_OR_MULTICLICK(2, "SINGLE_OR_MULTICLICK", "SINGLE_OR_MULTICLICK"),
    MIDDLE_SINGLECLICK(3, "MIDDLE_SINGLECLICK", "MIDDLE_SINGLECLICK"),
    MIDDLE_DOUBLECLICK(4, "MIDDLE_DOUBLECLICK", "MIDDLE_DOUBLECLICK"),
    MIDDLE_SINGLE_OR_MULTICLICK(5, "MIDDLE_SINGLE_OR_MULTICLICK", "MIDDLE_SINGLE_OR_MULTICLICK");

    public static final int SINGLECLICK_VALUE = 0;
    public static final int DOUBLECLICK_VALUE = 1;
    public static final int SINGLE_OR_MULTICLICK_VALUE = 2;
    public static final int MIDDLE_SINGLECLICK_VALUE = 3;
    public static final int MIDDLE_DOUBLECLICK_VALUE = 4;
    public static final int MIDDLE_SINGLE_OR_MULTICLICK_VALUE = 5;
    private static final Trigger[] VALUES_ARRAY;
    public static final List<Trigger> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Trigger[]{SINGLECLICK, DOUBLECLICK, SINGLE_OR_MULTICLICK, MIDDLE_SINGLECLICK, MIDDLE_DOUBLECLICK, MIDDLE_SINGLE_OR_MULTICLICK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Trigger get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Trigger result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Trigger getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Trigger result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Trigger get(int value) {
        switch (value) {
            case 0: {
                return SINGLECLICK;
            }
            case 1: {
                return DOUBLECLICK;
            }
            case 2: {
                return SINGLE_OR_MULTICLICK;
            }
            case 3: {
                return MIDDLE_SINGLECLICK;
            }
            case 4: {
                return MIDDLE_DOUBLECLICK;
            }
            case 5: {
                return MIDDLE_SINGLE_OR_MULTICLICK;
            }
        }
        return null;
    }

    private Trigger(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

