/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.krendering;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VerticalAlignment implements Enumerator
{
    TOP(0, "TOP", "TOP"),
    CENTER(1, "CENTER", "CENTER"),
    BOTTOM(2, "BOTTOM", "BOTTOM");

    public static final int TOP_VALUE = 0;
    public static final int CENTER_VALUE = 1;
    public static final int BOTTOM_VALUE = 2;
    private static final VerticalAlignment[] VALUES_ARRAY;
    public static final List<VerticalAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VerticalAlignment[]{TOP, CENTER, BOTTOM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VerticalAlignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VerticalAlignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VerticalAlignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VerticalAlignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VerticalAlignment get(int value) {
        switch (value) {
            case 0: {
                return TOP;
            }
            case 1: {
                return CENTER;
            }
            case 2: {
                return BOTTOM;
            }
        }
        return null;
    }

    private VerticalAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

