/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.builders;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.AbstractBuildContributor;
import ro.amiq.dvt.model.BuildState;
import ro.amiq.dvt.model.BuildStateProvider;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.MD5InputStream;
import ro.amiq.edt.base.builders.EBuilderUtils;
import ro.amiq.edt.base.builders.ECompilationOrderSorter;
import ro.amiq.edt.base.builders.EPoolingCancelThread;
import ro.amiq.edt.base.builders.PePe;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.IEModel;
import ro.amiq.edt.base.model.IEModule;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedProcessor;
import ro.amiq.edt.base.test.AbstractTestHelper;
import ro.amiq.edt.base.utils.Utils;
import ro.amiq.etools.eparser.EParser;
import ro.amiq.etools.eparser.ESV;
import ro.amiq.etools.eparser.EToolsException;
import ro.amiq.etools.eparser.IParsingInfo;
import ro.amiq.etools.eparser.IParsingListener;
import ro.amiq.etools.eparser.ModuleLoadedParsingInfo;
import ro.amiq.etools.eparser.ModuleStartedParsingInfo;
import ro.amiq.etools.eparser.PreLoadParsingInfo;
import ro.amiq.etools.eparser.ScanningParsingInfo;

public abstract class AbstractEContributor
extends AbstractBuildContributor
implements IParsingListener,
EBuilderUtils.IBuildStatusProvider {
    private final IPath FILE_NOT_FOUND_PREFIX = Path.fromOSString((String)"__etools__file_not_found");
    private final Set<FileCompileInfo> fDeltaChanged = new LinkedHashSet<FileCompileInfo>();
    private final Set<IFile> fDeltaRemoved = new LinkedHashSet<IFile>();
    private SubProgressMonitor fIncrMonitor;
    private boolean fIncrMonitorBegin;
    private boolean fIncrMonitorDone;
    private SubProgressMonitor fScanMonitor;
    private boolean fScanMonitorBegin;
    private boolean fScanMonitorDone;
    private IProgressMonitor fCurrentMonitor;
    private EParser fCurrentParser;
    private IProgressMonitor fLoadMonitor;
    private boolean fLoadMonitorBegin;
    private boolean fLoadMonitorDone;
    private SubProgressMonitor fTestsMonitor;
    private boolean fTestsMonitorBegin;
    private boolean fTestsMonitorDone;
    private boolean fBuildSuccess;
    private int fFullBuildTotalNofModules;
    private int fFullBuildNofNotFound;
    private int fFullBuildTotalNofTests;
    private ParserPath fFullBuildTestName;
    private int fFullBuildTestIndex;
    private List<ParserPath> fImportedByCurrentTest = new ArrayList<ParserPath>();
    private EPoolingCancelThread fCancelPoolingThread;
    private boolean fDisableMD5ChangeDetection;
    private boolean fAutoLinkedResourcesEnable;
    private Map<String, AutoLinkRoot> fAutoLinkedRoots;
    private Set<ParserPath> fAlreadyCompiledFiles;
    private int fInvocationIndex;
    private int fModuleIndex;
    private int fMaxModuleIndex;
    private int fClusterIndex;
    private final List<IResource> fRefreshTopFilesList = new ArrayList<IResource>();
    private long fWalkerTime;
    private boolean fNotifyAfterIncremental;
    private long fGenerationTime;
    private long fExecutionTime;
    private long fCompilationTime;
    private AsComputedProcessor fAsComputedProcessor;
    private final Map<ParserPath, EModuleInfo> fResources2CreateMap = new LinkedHashMap<ParserPath, EModuleInfo>();
    private int fOnlyTestsModuleIndex;

    public abstract IEPluginConfig getPluginConfig();

    public abstract String getMonitorLabelPrefix();

    public abstract String getBuilderCallerName();

    public boolean notifyAfterIncremental() {
        return this.fNotifyAfterIncremental;
    }

    public boolean isEnabled(IProject project) {
        try {
            return project.hasNature(this.getPluginConfig().getNature());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasNature(String natureID) {
        return this.getPluginConfig().getNature().equals(natureID);
    }

    public IProject[] build(int kind, Map args, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        this.fNotifyAfterIncremental = true;
        if (args != null && args.containsKey("justClean") && args.get("justClean").equals("true")) {
            return null;
        }
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        if (!DVTPlugin.getDefault().collect().c(project, this.getPluginConfig().feature())) {
            return null;
        }
        this.fRefreshTopFilesList.clear();
        this.fResources2CreateMap.clear();
        AbstractEModelManager modelManager = this.getPluginConfig().getModelManager();
        IEProject eProject = modelManager.getEModel().getEProject(project);
        if (eProject == null) {
            return null;
        }
        Utils.setReadOnlyBreadcrumbs();
        this.fDisableMD5ChangeDetection = BuildConfigManager.isDisableMD5ChangeDetection((IProject)project);
        this.fAutoLinkedResourcesEnable = BuildConfigManager.isAutoLinkedResources((IProject)project);
        this.fAutoLinkedRoots = BuildConfigManager.getAutoLinkedRoots((IProject)project);
        if (kind == 6) {
            FIncrementalNotificationTracker.INSTANCE.unregisterProject(this.getProject());
            boolean isOnlyTests = args != null && args.containsKey("testsOnly") && args.get("testsOnly").equals("true");
            EParser newParser = this.fullBuild(monitor, isOnlyTests);
            eProject.setEParser(newParser);
            this.createAutoLinkedResources(project, monitor);
            modelManager.cbPostFullBuild(project, this.fBuildSuccess);
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(project);
            if (rfProject != null) {
                rfProject.getChangedFilesManager().clear();
                RfModule[] uniqueModules = rfProject.getImportedModules();
                int uniqueFiles = uniqueModules == null ? 0 : uniqueModules.length;
                this.consolePrintSection("Files summary [" + this.fFullBuildTotalNofModules + " total, " + uniqueFiles + " unique]");
            }
        } else if (kind == 10 || kind == 9) {
            IResourceDelta delta = this.getDelta(project);
            if (delta == null) {
                EParser newParser = this.fullBuild(monitor, false);
                eProject.setEParser(newParser);
                this.createAutoLinkedResources(project, monitor);
                modelManager.cbPostFullBuild(project, this.fBuildSuccess);
            } else {
                this.fAlreadyCompiledFiles = null;
                RfProject rfProject = this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(project);
                if (rfProject != null) {
                    this.fAlreadyCompiledFiles = rfProject.getCompiledFilesSet();
                }
                this.incrementalBuild(monitor);
            }
        }
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])this.fRefreshTopFilesList.toArray());
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.DifferentColorsDecorator", (Object[])this.fRefreshTopFilesList.toArray());
        this.fRefreshTopFilesList.clear();
        this.fResources2CreateMap.clear();
        return null;
    }

    public abstract void deleteMarkersAndProperties(IProject var1);

    public static void deleteMarkersAndProperties(IProject project, DVTProblemCategory syntaxCategory, DVTProblemCategory nameCheckCategory, String persistentTaskID) {
        try {
            DVTProblemsUiUpdaterRegistry.get((String)syntaxCategory.getId()).resetNofMarkers(project);
            project.deleteMarkers(syntaxCategory.getMarkerId(), true, 2);
            DVTProblemManager.getInstance().removeProblemsWithCategory(project, syntaxCategory);
            if (nameCheckCategory != null) {
                DVTProblemsUiUpdaterRegistry.get((String)nameCheckCategory.getId()).resetNofMarkers(project);
                project.deleteMarkers(nameCheckCategory.getMarkerId(), true, 2);
                DVTProblemManager.getInstance().removeProblemsWithCategory(project, nameCheckCategory);
            }
            project.deleteMarkers(persistentTaskID, true, 2);
            final ArrayList refreshList = new ArrayList();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE) != null || PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_TEST_FILE) != null || PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_ACTIVE_TEST_FILE) != null || PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_ENCRYPTED_FILE) != null) {
                        PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_ENCRYPTED_FILE, null);
                        PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE, null);
                        PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_ACTIVE_TEST_FILE, null);
                        PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_TEST_FILE, null);
                        refreshList.add(resource);
                        return true;
                    }
                    return false;
                }
            });
            DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])refreshList.toArray());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void clean(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        this.fWalkerTime = 0L;
        this.fAlreadyCompiledFiles = null;
        this.fAsComputedProcessor = null;
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            this.fAlreadyCompiledFiles = rfProject.getCompiledFilesSet();
            this.fAsComputedProcessor = rfProject.getAsComputedProcessor();
        }
        this.deleteMarkersAndProperties(project);
        AbstractEModelManager modelManager = this.getPluginConfig().getModelManager();
        modelManager.cleanEProject(project);
        IEProject eProject = modelManager.getEModel().getEProject(project);
        List<Invocation> invocations = eProject.getInvocations();
        int invocNumber = 0;
        while (invocations != null && invocNumber < invocations.size()) {
            IPath topPath = eProject.getTopPath(invocNumber);
            File file = topPath.toFile();
            if (file.exists()) {
                file.delete();
            }
            ++invocNumber;
        }
        IPath esvPath = eProject.getESVPath();
        File file = esvPath.toFile();
        if (file.exists()) {
            file.delete();
        }
        try {
            EParser newParser = eProject.createNewEParser();
            modelManager.restoreToCore(newParser);
            eProject.setEParser(newParser);
        }
        catch (EToolsException eToolsException) {}
        modelManager.cbClean(project);
    }

    protected EParser fullBuild(IProgressMonitor monitor, boolean isOnlyTests) {
        EParser eParser = null;
        this.fBuildSuccess = false;
        IProject project = this.getProject();
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(project);
        if (isOnlyTests) {
            try {
                this.fOnlyTestsModuleIndex = rfProject.cleanTests();
                DVTBuildConsoleRegistry.getConsole((IProject)project).clearConsole();
                Collection<EModuleInfo> topModuleInfos = rfProject.getModuleInfos();
                for (EModuleInfo eModuleInfo : topModuleInfos) {
                    if (eModuleInfo == null) continue;
                    this.createResource(eModuleInfo.getParserPath(), eModuleInfo);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        } else {
            rfProject.clean();
        }
        rfProject.setLastFullBuildStartMemory();
        rfProject.setLastFullBuildStartTime();
        AbstractTestHelper.fParseTime = 0.0;
        try {
            try {
                if (project.exists() && this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(project) != null) {
                    this.fScanMonitorBegin = false;
                    this.fLoadMonitorBegin = false;
                    this.fTestsMonitorBegin = false;
                    this.fScanMonitorDone = false;
                    this.fLoadMonitorDone = false;
                    this.fTestsMonitorDone = false;
                    monitor.beginTask(String.valueOf(this.getMonitorLabelPrefix()) + "Init ...", 100);
                    monitor.subTask(String.valueOf(this.getMonitorLabelPrefix()) + "Init ...");
                    this.fScanMonitor = new SubProgressMonitor(monitor, 10);
                    this.fLoadMonitor = new SubProgressMonitor(monitor, 70);
                    this.fTestsMonitor = new SubProgressMonitor(monitor, 20);
                    AbstractEModelManager modelManager = this.getPluginConfig().getModelManager();
                    IEProject eProject = modelManager.getEModel().getEProject(project);
                    eProject.clean();
                    eParser = eProject.createNewEParser();
                    PePe.setFollowImports(eParser, true);
                    this.fCurrentMonitor = monitor;
                    this.fCurrentParser = eParser;
                    rfProject.fFullBuildEParser = eParser;
                    rfProject.setBuildProgressMonitor(monitor);
                    long parseStartTimestamp = System.currentTimeMillis();
                    this.fWalkerTime = 0L;
                    this.fScanMonitor.beginTask(String.valueOf(this.getMonitorLabelPrefix()) + "Scanning ...", 10);
                    this.fScanMonitor.subTask(String.valueOf(this.getMonitorLabelPrefix()) + "Scanning ...");
                    this.fBuildSuccess = EBuilderUtils.internalFullBuild(this.getPluginConfig(), this, this, eParser, eProject, isOnlyTests);
                    if (this.fScanMonitorBegin && !this.fScanMonitorDone) {
                        this.fScanMonitor.done();
                    }
                    if (this.fLoadMonitorBegin && !this.fLoadMonitorDone) {
                        this.fLoadMonitor.done();
                    }
                    if (this.fTestsMonitorBegin && !this.fTestsMonitorDone) {
                        this.fTestsMonitor.done();
                    }
                    monitor.done();
                    AbstractTestHelper.fParseTime = (double)System.currentTimeMillis() - (double)parseStartTimestamp;
                    this.consolePrint("*** Done parsing [total: " + AbstractTestHelper.fParseTime + " ms, elab: " + this.fWalkerTime + " ms] ***");
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.fCurrentParser = null;
                rfProject.fFullBuildEParser = null;
                BuildStateProvider.getInstance().setBuildState(BuildState.SEMANTIC);
            }
        }
        finally {
            this.fCurrentParser = null;
            rfProject.fFullBuildEParser = null;
            BuildStateProvider.getInstance().setBuildState(BuildState.SEMANTIC);
        }
        return eParser;
    }

    @Override
    public boolean checkCancel() {
        if (this.fCurrentMonitor != null && this.fCurrentParser != null && (this.fCurrentMonitor.isCanceled() || MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState()))) {
            PePe.interrupt(this.fCurrentParser);
            try {
                this.getPluginConfig().getModelManager().restoreToCore(this.fCurrentParser);
            }
            catch (EToolsException eToolsException) {}
            if (this.fScanMonitorBegin && !this.fScanMonitorDone) {
                this.fScanMonitor.done();
            }
            if (this.fLoadMonitorBegin && !this.fLoadMonitorDone) {
                this.fLoadMonitor.done();
            }
            if (this.fTestsMonitorBegin && !this.fTestsMonitorDone) {
                this.fTestsMonitor.done();
            }
            return true;
        }
        return false;
    }

    public void parsing(IParsingInfo info) {
        long walkerTime = 0L;
        int infoKind = info.getKind();
        String topPathPrefix = this.getPluginConfig().getTopPathPrefix();
        switch (infoKind) {
            case 0: {
                this.fCancelPoolingThread.resetPoolingThread();
                ScanningParsingInfo sInfo = (ScanningParsingInfo)info;
                ParserPath parserPath = new ParserPath(sInfo.getModuleFullName());
                if (parserPath.path.indexOf(topPathPrefix) != -1) break;
                this.consolePrint("Scanning " + parserPath + " [" + sInfo.getDuration() + " ms] ...");
                break;
            }
            case 1: {
                this.fCancelPoolingThread.resetPoolingThread();
                if (this.checkCancel() || this.fTestsMonitorBegin) {
                    return;
                }
                PreLoadParsingInfo plInfo = (PreLoadParsingInfo)info;
                this.fScanMonitor.done();
                this.fScanMonitorDone = true;
                this.fFullBuildTotalNofModules += plInfo.getNofModules();
                this.fLoadMonitor.beginTask(String.valueOf(this.getMonitorLabelPrefix()) + "Loading top files ...", plInfo.getNofModules());
                this.fLoadMonitor.subTask(String.valueOf(this.getMonitorLabelPrefix()) + "Loading top files ...");
                this.fLoadMonitorBegin = true;
                this.fMaxModuleIndex = -1;
                this.fClusterIndex = -1;
                break;
            }
            case 2: {
                if (this.fAsComputedProcessor != null) {
                    this.fGenerationTime = this.fAsComputedProcessor.totalGenerationType;
                    this.fExecutionTime = this.fAsComputedProcessor.totalExecutionType;
                    this.fCompilationTime = this.fAsComputedProcessor.totalCompilerTime;
                }
                this.fCancelPoolingThread.resetPoolingThread();
                if (this.checkCancel()) {
                    return;
                }
                ModuleStartedParsingInfo msInfo = (ModuleStartedParsingInfo)info;
                ParserPath parserPath = new ParserPath(msInfo.getModuleFullName());
                if (this.FILE_NOT_FOUND_PREFIX.isPrefixOf(Path.fromOSString((String)parserPath.path)) || parserPath.path.indexOf(topPathPrefix) != -1) break;
                if (!this.fTestsMonitorBegin) {
                    String message = "Loading (" + (this.fModuleIndex - 8) + "/" + (this.fFullBuildTotalNofModules - 11) + ") " + parserPath + " ...";
                    this.consolePrint(message);
                    this.fLoadMonitor.subTask(String.valueOf(this.getMonitorLabelPrefix()) + message);
                    break;
                }
                String message = "Loading " + parserPath + "\n    imported by test (" + (this.fFullBuildTestIndex + 1) + "/" + this.fFullBuildTotalNofTests + ") " + this.fFullBuildTestName + " ...";
                this.consolePrint(message);
                this.fTestsMonitor.subTask(String.valueOf(this.getMonitorLabelPrefix()) + "Loading test " + this.fFullBuildTestName + " (" + (this.fFullBuildTestIndex + 1) + "/" + this.fFullBuildTotalNofTests + ") " + parserPath + " ...");
                break;
            }
            case 3: {
                this.fCancelPoolingThread.resetPoolingThread();
                if (this.checkCancel()) {
                    return;
                }
                IProject project = this.getProject();
                ModuleLoadedParsingInfo mlInfo = (ModuleLoadedParsingInfo)info;
                ParserPath parserPath = new ParserPath(mlInfo.getModuleFullName());
                parserPath.setMd5(mlInfo.getMD5());
                parserPath.setSize(mlInfo.getFileSize());
                IPath pathFromParserPath = Path.fromOSString((String)parserPath.path);
                if (this.FILE_NOT_FOUND_PREFIX.isPrefixOf(pathFromParserPath)) {
                    ++this.fFullBuildNofNotFound;
                    break;
                }
                EModuleInfo eModuleInfo = null;
                if (!this.fTestsMonitorBegin) {
                    if (this.fModuleIndex + 3 <= this.fFullBuildTotalNofModules - this.fFullBuildNofNotFound) {
                        this.updateModuleIndex(mlInfo, false);
                        eModuleInfo = new EModuleInfo(project, parserPath, mlInfo.getModuleAST(), mlInfo.getModuleErrors(), mlInfo.getModuleWarnings(), mlInfo.getModuleComments(), mlInfo.isDVTEncrypted(), mlInfo.isSNEncrypted(), null, this.fClusterIndex, this.fModuleIndex, this.fMaxModuleIndex, mlInfo.getClusterNofModules(), true, null, null, true, this.fInvocationIndex, this.getLanguageKind());
                    }
                    this.fLoadMonitor.worked(1);
                } else {
                    this.updateModuleIndex(mlInfo, true);
                    this.fImportedByCurrentTest.add(parserPath);
                    eModuleInfo = !this.fFullBuildTestName.equals((Object)parserPath) ? new EModuleInfo(project, parserPath, mlInfo.getModuleAST(), mlInfo.getModuleErrors(), mlInfo.getModuleWarnings(), mlInfo.getModuleComments(), mlInfo.isDVTEncrypted(), mlInfo.isSNEncrypted(), null, this.fClusterIndex, this.fModuleIndex, this.fMaxModuleIndex, mlInfo.getClusterNofModules(), false, null, this.fFullBuildTestName, true, this.fInvocationIndex, this.getLanguageKind()) : new EModuleInfo(project, parserPath, mlInfo.getModuleAST(), mlInfo.getModuleErrors(), mlInfo.getModuleWarnings(), mlInfo.getModuleComments(), mlInfo.isDVTEncrypted(), mlInfo.isSNEncrypted(), null, this.fClusterIndex, this.fModuleIndex, this.fMaxModuleIndex, mlInfo.getClusterNofModules(), false, this.fImportedByCurrentTest, parserPath, true, this.fInvocationIndex, this.getLanguageKind());
                }
                this.createResource(parserPath, eModuleInfo);
                if (eModuleInfo != null) {
                    this.getPluginConfig().getModelManager().notifyBuildListenersFullBuild(eModuleInfo);
                }
                this.createResource(parserPath, eModuleInfo);
                walkerTime = System.currentTimeMillis();
                if (parserPath.path.indexOf(topPathPrefix) != -1) break;
                long diff = System.currentTimeMillis() - walkerTime;
                this.fWalkerTime += diff;
                if (this.fAsComputedProcessor != null && this.fAsComputedProcessor.debugLog()) {
                    long genTime = this.fAsComputedProcessor.totalGenerationType - this.fGenerationTime;
                    long compTime = this.fAsComputedProcessor.totalCompilerTime - this.fCompilationTime;
                    long execTime = this.fAsComputedProcessor.totalExecutionType - this.fExecutionTime;
                    if (genTime > 100L || compTime > 100L || execTime > 100L) {
                        String message = "*** Info: 'as computed' generation time [" + genTime + " ms] compilation time [" + compTime + " ms] execution time [" + execTime + " ms] ... ";
                        this.consolePrint(message);
                    }
                }
                this.consolePrint("Done " + parserPath + " [" + mlInfo.getDuration() + " ms] ...");
                break;
            }
        }
    }

    private final void updateModuleIndex(ModuleLoadedParsingInfo mlInfo, boolean isTestModule) {
        int clusterIndex = mlInfo.getClusterIndex();
        if (clusterIndex != this.fClusterIndex || isTestModule && clusterIndex == 0) {
            this.fMaxModuleIndex = this.fModuleIndex + mlInfo.getClusterNofModules();
        }
        ++this.fModuleIndex;
        this.fClusterIndex = clusterIndex;
    }

    private <T extends EToolsException> List<T> filenameRemap(List<T> exceptions, String originalPath, String mapingPath) {
        if (exceptions == null) {
            return null;
        }
        for (EToolsException exception : exceptions) {
            if (!exception.getFilename().equals(originalPath)) continue;
            exception.setFilename(mapingPath);
        }
        return exceptions;
    }

    private void createResource(ParserPath parserPath, EModuleInfo eModuleInfo) {
        this.fResources2CreateMap.put(parserPath, eModuleInfo);
    }

    private void createAutoLinkedResources(final IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.fResources2CreateMap.isEmpty()) {
            AbstractTestHelper.fAutoLinkTime -= (double)System.currentTimeMillis();
        }
        DVTAutoLinkManager.getInstance().startWorkspaceOperation(project, true);
        DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

            public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                SkipCompileFilter skipCompileFilter = BuildConfigManager.getSkipCompileFilter((IProject)project);
                RfProject rfProject = AbstractEContributor.this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(project);
                long time = System.currentTimeMillis();
                HashSet<String> files = new HashSet<String>();
                for (ParserPath parserPath : AbstractEContributor.this.fResources2CreateMap.keySet()) {
                    files.add(new File(parserPath.path).getName());
                }
                HashMap<String, List<IFile>> fileCandidates = new HashMap<String, List<IFile>>();
                HashMap<IPath, IPath> directorySymlinks = new HashMap<IPath, IPath>();
                DVTFileUtils.getInstance().cacheDirectories(project, files, fileCandidates, directorySymlinks);
                DVTLogger.INSTANCE.logDebug("AUTO_LINKED: Time to collect " + directorySymlinks.size() + " symlinked directories takes " + (System.currentTimeMillis() - time));
                for (Map.Entry<ParserPath, EModuleInfo> resourceEntry : AbstractEContributor.this.fResources2CreateMap.entrySet()) {
                    ParserPath parserPath = resourceEntry.getKey();
                    EModuleInfo eModuleInfo = resourceEntry.getValue();
                    IFile resource = AbstractEContributor.this.createAutoLinkedResource(project, Path.fromOSString((String)parserPath.path), fileCandidates, directorySymlinks, cachedLinksMap);
                    String languageSyntax = IBuildConfigParserConstants.LanguageSyntax.E_1647_2011.id;
                    if (DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)AbstractEContributor.this.getPluginConfig())) {
                        languageSyntax = IBuildConfigParserConstants.LanguageSyntax.SLN.id;
                    }
                    PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE, (String)languageSyntax);
                    if (eModuleInfo != null && resource != null) {
                        try {
                            eModuleInfo.setResource(resource);
                            String resourcePath = resource.getLocation().toOSString();
                            eModuleInfo.setModuleErrors(AbstractEContributor.this.filenameRemap(eModuleInfo.getModuleErrors(), parserPath.path, resourcePath));
                            eModuleInfo.setModuleWarnings(AbstractEContributor.this.filenameRemap(eModuleInfo.getModuleWarnings(), parserPath.path, resourcePath));
                            rfProject.filenameRemap(parserPath.path, resourcePath);
                            String encryptedProperty = null;
                            if (eModuleInfo.isSNEncrypted()) {
                                encryptedProperty = "SN";
                            } else if (eModuleInfo.isDVTEncrypted()) {
                                encryptedProperty = "DVT";
                            }
                            PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_ENCRYPTED_FILE, (String)encryptedProperty);
                            if (!eModuleInfo.isInTop()) {
                                PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_TEST_FILE, (String)"*");
                                PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE, null);
                            }
                            if (skipCompileFilter.shouldSkip(parserPath, true)) {
                                eModuleInfo.setIgnoredFile(true);
                            }
                            IFile parent = resource;
                            while ((parent = parent.getParent()) != null && PropertiesManager.getSessionProperty((IResource)parent, (String)PropertyTypes.QN_IMPORTED_FILE) == null) {
                                PropertiesManager.addSessionProperty((IResource)parent, (String)PropertyTypes.QN_IMPORTED_FILE, (String)languageSyntax);
                            }
                            AbstractEContributor.this.fRefreshTopFilesList.add((IResource)resource);
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    if (eModuleInfo == null) continue;
                    AbstractEContributor.this.getPluginConfig().getModelManager().cbBuild(eModuleInfo);
                    eModuleInfo.setModuleAST(null);
                }
            }
        };
        DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, this.getBuilderCallerName(), op, false);
        DVTAutoLinkManager.getInstance().endWorkspaceOperation(project, false);
        if (!this.fResources2CreateMap.isEmpty()) {
            AbstractTestHelper.fAutoLinkTime += (double)System.currentTimeMillis();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFile createAutoLinkedResource(IProject project, IPath parserPath, Map<String, List<IFile>> fileCandidates, Map<IPath, IPath> directorySymlinks, Map<IPath, LinkDescription> cachedLinksMap) {
        try {
            if (parserPath.lastSegment().startsWith(this.getPluginConfig().getTopPathPrefix())) {
                return null;
            }
            IFile file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, fileCandidates, directorySymlinks);
            if (file != null && file.getLocation() != null) {
                if (this.fAutoLinkedResourcesEnable) {
                    DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
                    return file;
                }
                if (!file.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) return file;
                return null;
            }
            if (!this.fAutoLinkedResourcesEnable) {
                return null;
            }
            if (this.FILE_NOT_FOUND_PREFIX.isPrefixOf(parserPath)) {
                return null;
            }
            if (DVTAutoLinkManager.getInstance().hasError(project, 2)) return null;
            if (DVTAutoLinkManager.getInstance().hasError(project, 1)) {
                return null;
            }
            file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, fileCandidates, directorySymlinks);
            if (file == null || file.getLocation() == null) {
                IFile projectFile = project.getFile(".project");
                boolean autolinkUsingLinks = DVTAutoLinkManager.getInstance().autolinkUsingLinksForProject(project);
                boolean readOnly = projectFile.getResourceAttributes().isReadOnly();
                if (readOnly && autolinkUsingLinks) {
                    DVTAutoLinkManager.getInstance().reportError(project, 1);
                } else {
                    file = DVTAutoLinkManager.getInstance().createAutoLink(project, parserPath, this.fAutoLinkedRoots, cachedLinksMap, false);
                }
            } else {
                DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
            }
            if (file == null) return file;
            String resourcePath = file.getProjectRelativePath().toOSString();
            PropertiesManager.addParser2ResourceMapProperty((IProject)project, (String)parserPath.toOSString(), (String)resourcePath);
            return file;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            DVTAutoLinkManager.getInstance().reportError(project, 2);
            return null;
        }
    }

    public int analyzeDelta(IResourceDelta delta, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        IProject project = this.getProject();
        String projectPrefix = String.valueOf(project.getName()) + ": ";
        monitor.beginTask(String.valueOf(projectPrefix) + "Analyzing Deltas ...", 1000);
        this.fDeltaChanged.clear();
        this.fDeltaRemoved.clear();
        this.fAlreadyCompiledFiles = null;
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            this.fAlreadyCompiledFiles = rfProject.getCompiledFilesSet();
        }
        String contTypeId = "ro.amiq.edt.ESource";
        if (DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)this.getPluginConfig())) {
            contTypeId = "ro.amiq.slndt.SLNSource";
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType(contTypeId, false);
        delta.accept((IResourceDeltaVisitor)new ChangedModulesVisitor(fileExtensions));
        changedFiles.put(this.getLanguageKind(), this.fDeltaChanged);
        return this.fDeltaChanged.size() + this.fDeltaRemoved.size();
    }

    public abstract LanguageKind getLanguageKind();

    protected void incrementalBuild(IProgressMonitor monitor) throws CoreException {
        String projectPrefix = String.valueOf(this.getProject().getName()) + ": ";
        boolean notifyAfterIncremental = false;
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(this.getProject());
        boolean cancelIncremental = PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE");
        if (cancelIncremental) {
            ChangedFilesManager changedFilesManager = rfProject.getChangedFilesManager();
            this.fDeltaChanged.addAll(changedFilesManager.getBacklogElements());
            changedFilesManager.addBacklogElements(this.fDeltaChanged);
        }
        Map documentsInEditors = DVTFileUtils.getInstance().evalNonFileBufferParserPathDocuments();
        if (this.fDeltaChanged.size() + this.fDeltaRemoved.size() != 0) {
            ESV beforeContext;
            EParser eparser;
            IEProject eProject;
            block15: {
                this.fIncrMonitor = new SubProgressMonitor(monitor, 1000);
                int deltaStep = 1000 / (this.fDeltaChanged.size() + this.fDeltaRemoved.size());
                this.fIncrMonitor.beginTask(String.valueOf(projectPrefix) + "Processing Deltas ...", 1000);
                this.fIncrMonitorBegin = true;
                AbstractEModelManager modelManager = this.getPluginConfig().getModelManager();
                eProject = modelManager.getEModel().getEProject(this.getProject());
                eparser = eProject.getEParser();
                beforeContext = eparser.getCurrentContext();
                int i = 0;
                int workSize = this.fDeltaRemoved.size();
                for (IFile file : this.fDeltaRemoved) {
                    ++i;
                    if (!this.fIncrMonitor.isCanceled()) {
                        this.fIncrMonitor.subTask(String.valueOf(projectPrefix) + "Removing (" + i + "/" + workSize + ") " + file.getLocation().toOSString() + "...");
                        modelManager.cbRemove(file);
                        this.fIncrMonitor.worked(deltaStep);
                        continue;
                    }
                    break block15;
                }
                i = 0;
                workSize = this.fDeltaChanged.size();
                ArrayList<FileCompileInfo> fileCompileInfos = new ArrayList<FileCompileInfo>(this.fDeltaChanged);
                if (rfProject != null) {
                    fileCompileInfos.sort(new ECompilationOrderSorter(rfProject));
                }
                for (FileCompileInfo fileCompileInfo : fileCompileInfos) {
                    IFile file;
                    if (fileCompileInfo == null || (file = fileCompileInfo.getFile()) == null) continue;
                    ++i;
                    if (this.fIncrMonitor.isCanceled()) break;
                    this.fIncrMonitor.subTask(String.valueOf(projectPrefix) + "Loading (" + i + "/" + workSize + ") " + file.getLocation().toOSString() + "...");
                    IEModule eModule = modelManager.getEModel().getOrCreateEModule(file);
                    if (eModule != null) {
                        eModule.cancelReparse();
                    }
                    if (DVTFileUtils.getInstance().shouldIncrementalBuild(null, fileCompileInfo, this.getProject())) {
                        modelManager.cbIncrementalBuild(monitor, fileCompileInfo, eModule == null ? null : (IDocument)documentsInEditors.get(eModule.getParserPath()), true);
                        notifyAfterIncremental = true;
                    } else {
                        this.updateFloatingNotification(this.getProject(), fileCompileInfo.getFile());
                    }
                    this.fIncrMonitor.worked(deltaStep);
                }
            }
            ESV afterContext = eparser.getCurrentContext();
            if (!beforeContext.equals((Object)afterContext)) {
                try {
                    PePe.save(eparser, eProject.getESVPath().toOSString());
                }
                catch (EToolsException eToolsException) {
                }
                catch (Exception x) {
                    DVTLogger.INSTANCE.logError((Throwable)x);
                }
            }
            if (this.fIncrMonitorBegin && !this.fIncrMonitorDone) {
                this.fIncrMonitor.done();
                this.fIncrMonitorDone = true;
            }
        }
        if (!notifyAfterIncremental) {
            this.fNotifyAfterIncremental = false;
        }
    }

    private void updateFloatingNotification(IProject project, IFile iFile) {
        if (project == null) {
            return;
        }
        IEPluginConfig pluginConfig = this.getPluginConfig();
        if (pluginConfig == null) {
            return;
        }
        AbstractEModelManager modelManager = pluginConfig.getModelManager();
        if (modelManager == null) {
            return;
        }
        IEModel eModel = modelManager.getEModel();
        if (eModel == null) {
            return;
        }
        IEProject eProject = eModel.getEProject(project);
        if (eProject == null) {
            return;
        }
        FIncrementalNotificationTracker.INSTANCE.addDirtyResource(project, (FNotificationDirtyResource)new FIncrementalDirtyFile(iFile, FNotificationDirtyReason.MAX_LINES_EXCEEDED, eProject.getFNotificationProvider()));
        FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC);
    }

    @Override
    public void consolePrint(String message) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(message);
    }

    @Override
    public void setLoadMonitorBeginTask(String name, int totalWork) {
        this.fLoadMonitor.beginTask(name, totalWork);
    }

    @Override
    public void setLoadMonitorDone() {
        this.fLoadMonitor.done();
        this.fLoadMonitorDone = true;
    }

    @Override
    public void setLoadMonitorSubTask(String name) {
        this.fLoadMonitor.subTask(name);
    }

    @Override
    public void consolePrintSection(String message) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection(message);
    }

    @Override
    public void newCancelPoolingThread() {
        this.fCancelPoolingThread = new EPoolingCancelThread();
    }

    @Override
    public void startCancelPoolingThread(EParser eParser, IEProject eProject) {
        this.fCancelPoolingThread.startPoolingThread(this.fCurrentMonitor, eParser, eProject, false);
    }

    @Override
    public void stopCancelPoolingThread() {
        this.fCancelPoolingThread.stopPoolingThread();
    }

    @Override
    public void setCancelPoolingThreadFileName(String fileName) {
        this.fCancelPoolingThread.setFileName(fileName);
    }

    @Override
    public void setTimestamp() {
    }

    @Override
    public void setTestsMonitorBeginTask(String name, int totalWork) {
        this.fTestsMonitor.beginTask(name, totalWork);
        this.fTestsMonitorBegin = true;
    }

    @Override
    public void setTestsMonitorSubTask(String name) {
        this.fTestsMonitor.subTask(String.valueOf(this.getMonitorLabelPrefix()) + name);
    }

    @Override
    public void setTestsMonitorWorked(int work) {
        this.fTestsMonitor.worked(work);
    }

    @Override
    public void clearImportedByCurrentTest() {
        this.fImportedByCurrentTest = new ArrayList<ParserPath>();
    }

    @Override
    public void setTotalNofTests(int totalNofTests) {
        this.fFullBuildTotalNofTests = totalNofTests;
        this.fFullBuildTestIndex = 0;
    }

    @Override
    public void setTestProperties(ParserPath parserPath, int testIndex) {
        this.fFullBuildTestIndex = testIndex;
        this.fFullBuildTestName = parserPath;
    }

    @Override
    public void restoreModuleIndex() {
        this.fModuleIndex = this.fOnlyTestsModuleIndex;
    }

    @Override
    public void setInvocationIndex(int index) {
        this.fInvocationIndex = index;
        this.fModuleIndex = -1;
        this.fMaxModuleIndex = -1;
        this.fClusterIndex = -1;
        this.fFullBuildTotalNofModules = 0;
        this.fFullBuildNofNotFound = 0;
    }

    private class ChangedModulesVisitor
    implements IResourceDeltaVisitor {
        private String[] fFileExtensions;

        public ChangedModulesVisitor(String[] fileExtensions) {
            this.fFileExtensions = fileExtensions;
        }

        public boolean visit(IResourceDelta delta) {
            block33: {
                RfProject rfProject;
                ParserPath parserPath;
                IPath location;
                IResource resource;
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block32: {
                                    if (AbstractEContributor.this.fDeltaRemoved.size() + AbstractEContributor.this.fDeltaChanged.size() <= 50) break block32;
                                    return false;
                                }
                                resource = delta.getResource();
                                if (resource.getType() == 4) {
                                    IProject project = (IProject)resource;
                                    return project.hasNature(AbstractEContributor.this.getPluginConfig().getNature());
                                }
                                if (resource.getType() != 1) break block33;
                                if (delta.getFlags() != 0x100000) break block34;
                                return false;
                            }
                            location = resource.getLocation();
                            if (location != null) break block35;
                            return false;
                        }
                        parserPath = DVTFileUtils.getInstance().resource2parser(resource);
                        if (parserPath != null) break block36;
                        return false;
                    }
                    rfProject = AbstractEContributor.this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(resource.getProject());
                    if (rfProject != null) break block37;
                    return false;
                }
                try {
                    boolean isAlreadyCompiled;
                    boolean bl = isAlreadyCompiled = AbstractEContributor.this.fAlreadyCompiledFiles != null && AbstractEContributor.this.fAlreadyCompiledFiles.contains(parserPath);
                    if (delta.getKind() == 2) {
                        DVTAutoLinkManager.getInstance().removeFileInfo(location);
                        rfProject.disconnectModuleFromDocument(parserPath);
                    }
                    if (isAlreadyCompiled || DVTFileUtils.getInstance().validExtension(this.fFileExtensions, resource.getName())) {
                        RfModule rfModule = rfProject.getModule(parserPath);
                        if (rfModule != null && rfModule.getModuleIndex() > -1) {
                            if (delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0) {
                                boolean disableMD5ChangeDetection;
                                long oldSize = rfModule.getParserPath().getSize();
                                byte[] oldMd5 = rfModule.getParserPath().getMd5();
                                boolean bl2 = disableMD5ChangeDetection = AbstractEContributor.this.fDisableMD5ChangeDetection || resource.getSessionProperty(DISABLE_MD5) != null;
                                if (!disableMD5ChangeDetection && new File(parserPath.path).length() == oldSize) {
                                    byte[] newMd5 = new byte[]{};
                                    Throwable throwable = null;
                                    Object var14_16 = null;
                                    try (MD5InputStream currentVerifFileStream = new MD5InputStream(new File(parserPath.path));){
                                        while (currentVerifFileStream.read() != -1) {
                                        }
                                        newMd5 = currentVerifFileStream.getMD5();
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                    if (!Arrays.equals(oldMd5, newMd5)) {
                                        AbstractEContributor.this.fDeltaChanged.add(new FileCompileInfo((IFile)resource));
                                    } else if (DVTLogger.INSTANCE.isDebugMode()) {
                                        TestHelper.out.println("Skip compiling touched file (md5 unchanged): " + resource.getFullPath());
                                    }
                                } else {
                                    AbstractEContributor.this.fDeltaChanged.add(new FileCompileInfo((IFile)resource));
                                }
                            }
                        } else if (rfProject.getEditor(parserPath) != null) {
                            if (delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0) {
                                AbstractEContributor.this.fDeltaChanged.add(new FileCompileInfo((IFile)resource));
                            } else if (delta.getKind() == 2) {
                                AbstractEContributor.this.fDeltaRemoved.add((IFile)resource);
                            }
                        }
                    }
                    return false;
                }
                catch (Exception x) {
                    DVTLogger.INSTANCE.logError((Throwable)x);
                }
            }
            return true;
        }
    }
}

