/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.builders;

import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.builders.PePe;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.predefined.ecode.RfPredefinedCodeLoader;
import ro.amiq.etools.eparser.EParser;
import ro.amiq.etools.eparser.EToolsException;
import ro.amiq.etools.eparser.IParsingInfo;
import ro.amiq.etools.eparser.IParsingListener;
import ro.amiq.etools.eparser.ModuleLoadedParsingInfo;
import ro.amiq.etools.eparser.ModuleStartedParsingInfo;

public class EBuilderUtils {
    private static final Pattern WS_EQUALS_WS = Pattern.compile("\\s*=\\s*");

    public static boolean internalFullBuild(IEPluginConfig pluginConfig, IBuildStatusProvider buildStatusProvider, IParsingListener eParsingListener, EParser eParser, IEProject eProject, boolean isOnlyTests) {
        String esvPath;
        boolean hasTestFiles;
        List<ParserPath> testFiles;
        IParsingListener poolingListener;
        block40: {
            block39: {
                boolean inSLNMode;
                String slnDashfPath;
                String specmanPath;
                CompilationUnitProperties compilationUnitProperties;
                block37: {
                    block36: {
                        File esvFile;
                        poolingListener = EBuilderUtils.getParsingListener(pluginConfig, buildStatusProvider);
                        compilationUnitProperties = eProject.getCompilationUnitProperties(false);
                        specmanPath = compilationUnitProperties.getDvtSpecmanPath();
                        slnDashfPath = compilationUnitProperties.getSlnDashfPaths();
                        testFiles = compilationUnitProperties.testFiles();
                        hasTestFiles = !testFiles.isEmpty();
                        esvPath = eProject.getESVPath().toOSString();
                        buildStatusProvider.setInvocationIndex(0);
                        eParser.addParsingListener(eParsingListener);
                        AbstractEModelManager modelManager = pluginConfig.getModelManager();
                        modelManager.removeCoreESV(eParser);
                        modelManager.restoreToCore(eParser);
                        if (!isOnlyTests) break block36;
                        buildStatusProvider.restoreModuleIndex();
                        PePe.setSpecmanPath(eParser, specmanPath);
                        inSLNMode = DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)pluginConfig);
                        if (inSLNMode) {
                            PePe.setSLNDashfPath(eParser, slnDashfPath);
                        }
                        if (!(esvFile = new File(String.valueOf(esvPath) + "_top")).exists()) {
                            Files.copy((File)new File(esvPath), (File)esvFile);
                        }
                        if (hasTestFiles) {
                            PePe.restore(eParser, String.valueOf(esvPath) + "_top");
                        } else {
                            PePe.restore(eParser, esvPath);
                        }
                        PePe.getAST(eParser);
                        if (buildStatusProvider.checkCancel()) {
                            eParser.removeParsingListener(eParsingListener);
                            return false;
                        }
                    }
                    if (!buildStatusProvider.checkCancel()) break block37;
                    eParser.removeParsingListener(eParsingListener);
                    return false;
                }
                PePe.setSpecmanPath(eParser, specmanPath);
                inSLNMode = DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)pluginConfig);
                if (inSLNMode) {
                    PePe.setSLNDashfPath(eParser, slnDashfPath);
                }
                String topFilePath = eProject.getTopPath(0).toOSString();
                String topDefinesFilePath = eProject.getTopDefinesPath(0).toOSString();
                String content = EBuilderUtils.importTopFiles(pluginConfig, eProject, topDefinesFilePath, compilationUnitProperties.topFiles());
                StringBuilder definesContent = new StringBuilder().append("<'\n\n");
                definesContent.append(EBuilderUtils.definesToString(compilationUnitProperties.defines()));
                definesContent.append("#define DVT_INTERNAL_PATCH;\n");
                definesContent.append("#define DVT_PATCH;\n\n");
                definesContent.append("'>\n\n");
                EBuilderUtils.writeFile(topDefinesFilePath, definesContent.toString());
                EBuilderUtils.writeFile(topFilePath, content);
                try {
                    try {
                        buildStatusProvider.newCancelPoolingThread();
                        buildStatusProvider.startCancelPoolingThread(eParser, eProject);
                        eParser.addParsingListener(poolingListener);
                        PePe.load(eParser, topFilePath);
                    }
                    catch (EToolsException eToolsException) {
                        eParser.removeParsingListener(poolingListener);
                        buildStatusProvider.stopCancelPoolingThread();
                        break block39;
                    }
                }
                catch (Throwable throwable) {
                    eParser.removeParsingListener(poolingListener);
                    buildStatusProvider.stopCancelPoolingThread();
                    throw throwable;
                }
                eParser.removeParsingListener(poolingListener);
                buildStatusProvider.stopCancelPoolingThread();
            }
            PePe.getAST(eParser);
            if (!buildStatusProvider.checkCancel()) break block40;
            eParser.removeParsingListener(eParsingListener);
            return false;
        }
        try {
            if (hasTestFiles) {
                PePe.save(eParser, String.valueOf(esvPath) + "_top");
            } else {
                PePe.save(eParser, esvPath);
            }
        }
        catch (EToolsException eToolsException) {
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        buildStatusProvider.setLoadMonitorDone();
        if (hasTestFiles) {
            int totalNofTests = testFiles.size();
            buildStatusProvider.setTotalNofTests(totalNofTests);
            buildStatusProvider.setTestsMonitorBeginTask("Loading test files ...", totalNofTests);
            buildStatusProvider.setTestsMonitorSubTask("Loading test files ...");
            int i = 0;
            while (i < testFiles.size()) {
                block43: {
                    ParserPath parserPath = testFiles.get(i);
                    if (buildStatusProvider.checkCancel()) {
                        return false;
                    }
                    buildStatusProvider.setTestProperties(parserPath, i);
                    buildStatusProvider.setTestsMonitorSubTask("Loading test " + parserPath + " ...");
                    buildStatusProvider.clearImportedByCurrentTest();
                    try {
                        try {
                            if (i != 0) {
                                if (i == 1) {
                                    PePe.restore(eParser, String.valueOf(esvPath) + "_top");
                                } else {
                                    PePe.restore(eParser, null);
                                }
                            }
                            buildStatusProvider.newCancelPoolingThread();
                            buildStatusProvider.startCancelPoolingThread(eParser, eProject);
                            eParser.addParsingListener(poolingListener);
                            PePe.load(eParser, parserPath.path);
                        }
                        catch (EToolsException eToolsException) {
                            buildStatusProvider.stopCancelPoolingThread();
                            eParser.removeParsingListener(poolingListener);
                            break block43;
                        }
                    }
                    catch (Throwable topDefinesFilePath) {
                        buildStatusProvider.stopCancelPoolingThread();
                        eParser.removeParsingListener(poolingListener);
                        throw topDefinesFilePath;
                    }
                    buildStatusProvider.stopCancelPoolingThread();
                    eParser.removeParsingListener(poolingListener);
                }
                PePe.getAST(eParser);
                try {
                    if (i == 0) {
                        PePe.save(eParser, esvPath);
                    }
                }
                catch (EToolsException eToolsException) {
                }
                catch (Exception x) {
                    DVTLogger.INSTANCE.logError((Throwable)x);
                }
                buildStatusProvider.setTestsMonitorWorked(1);
                ++i;
            }
        }
        try {
            if (hasTestFiles) {
                PePe.restore(eParser, esvPath);
            }
        }
        catch (EToolsException eToolsException) {
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        eParser.removeParsingListener(eParsingListener);
        return true;
    }

    private static IParsingListener getParsingListener(final IEPluginConfig pluginConfig, final IBuildStatusProvider buildStatusProvider) {
        return new IParsingListener(){
            Deque<String> fFilesStack = new ArrayDeque<String>();

            public void parsing(IParsingInfo info) {
                if (info.getKind() == 2 && !((ModuleStartedParsingInfo)info).getModuleName().startsWith(pluginConfig.getTopPathPrefix())) {
                    String fileName = ((ModuleStartedParsingInfo)info).getModuleFullName();
                    this.fFilesStack.push(fileName);
                    buildStatusProvider.setCancelPoolingThreadFileName(fileName);
                } else if (info.getKind() == 3 && !((ModuleLoadedParsingInfo)info).getModuleName().startsWith(pluginConfig.getTopPathPrefix())) {
                    this.fFilesStack.pop();
                    if (!this.fFilesStack.isEmpty()) {
                        buildStatusProvider.setCancelPoolingThreadFileName(this.fFilesStack.peek());
                    }
                }
            }
        };
    }

    public static void writeFile(String filePath, String content) {
        DVTFileUtils.getInstance().writeStringToFile(new File(filePath), content, false);
    }

    public static String importTopFiles(IEPluginConfig pluginConfig, IEProject eProject, String definesFilePath, Collection<ParserPath> topFiles) {
        IPath projectPath;
        IPath patchPath;
        StringBuilder content = new StringBuilder();
        content.append("<'\n\n");
        content.append(BuildConfigManager.getSpecmanVersionDefines((IProject)eProject.getProject()));
        content.append("import ").append(definesFilePath).append(";");
        boolean inSLNMode = DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)pluginConfig);
        if (inSLNMode) {
            content.append("#define sml_config_file_info_table csv_to_table;\n\n");
        }
        if ((patchPath = (projectPath = eProject.getProject().getLocation()).append(".dvt/dvt_patch.e")).toFile().exists()) {
            content.append("import " + patchPath.toOSString() + ";\n\n");
        }
        RfPredefinedCodeLoader.importPredefinedFiles(eProject, content);
        content.append("\n\n");
        if (topFiles != null) {
            AbstractEModelManager modelManager = pluginConfig.getModelManager();
            for (ParserPath topFile : topFiles) {
                modelManager.addTopFile(topFile);
                String nextImport = "import " + topFile + ";\n";
                content.append(nextImport);
            }
        }
        content.append("\n'>");
        return content.toString();
    }

    private static String definesToString(Collection<String> defines) {
        StringBuilder result = new StringBuilder();
        String newline = System.getProperty("line.separator");
        if (defines == null || defines.isEmpty()) {
            return result.toString();
        }
        LinkedHashMap<String, String> defineValuesMap = new LinkedHashMap<String, String>();
        for (String string : defines) {
            String defineBody = DVTStringUtil.replaceFirst((Pattern)WS_EQUALS_WS, (CharSequence)string, (String)" ").trim();
            StringBuilder defineName = new StringBuilder();
            int i = 0;
            while (i < defineBody.length()) {
                char ch = defineBody.charAt(i);
                if (Character.isWhitespace(ch)) break;
                defineName.append(ch);
                ++i;
            }
            String defineValue = defineBody.substring(defineName.length()).trim();
            defineValuesMap.put(defineName.toString(), defineValue);
        }
        for (Map.Entry entry : defineValuesMap.entrySet()) {
            String value = (String)entry.getValue();
            result.append("#define ").append((String)entry.getKey());
            if (value != null && !value.isEmpty()) {
                result.append(" ").append(value);
            }
            result.append(";").append(newline);
        }
        return result + newline;
    }

    public static interface IBuildStatusProvider {
        public void setLoadMonitorBeginTask(String var1, int var2);

        public void setLoadMonitorSubTask(String var1);

        public void setLoadMonitorDone();

        public void consolePrint(String var1);

        public void consolePrintSection(String var1);

        public void newCancelPoolingThread();

        public void startCancelPoolingThread(EParser var1, IEProject var2);

        public void stopCancelPoolingThread();

        public void setCancelPoolingThreadFileName(String var1);

        public void setTimestamp();

        public void setTestsMonitorBeginTask(String var1, int var2);

        public void setTestsMonitorSubTask(String var1);

        public void setTestsMonitorWorked(int var1);

        public boolean checkCancel();

        public void clearImportedByCurrentTest();

        public void setTotalNofTests(int var1);

        public void setTestProperties(ParserPath var1, int var2);

        public void setInvocationIndex(int var1);

        public void restoreModuleIndex();
    }
}

