/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.builders;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import ro.amiq.dvt.builders.DVTConsoleButtonsDescription;
import ro.amiq.dvt.builders.DVTMessageConsole;
import ro.amiq.dvt.externaltools.ConsoleHighlightModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.IMacroTraceListener;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.utils.EDTFileUtils;

public class EMacroTraceConsoleViewer
implements IMacroTraceListener {
    private DVTMessageConsole fConsole;
    private IConsoleScanListener fListener;
    private IProject fProject;
    private IConsoleManager fConsoleManager;
    private AbstractRfManager fRfManager;

    public EMacroTraceConsoleViewer(AbstractRfManager rfManager) {
        this.fRfManager = rfManager;
    }

    public void dispose() {
        if (this.fConsole == null || this.fListener == null) {
            return;
        }
        this.fConsole.removePatternMatchListener((IPatternMatchListener)this.fListener);
        this.fConsoleManager.removeConsoles(new IConsole[]{this.fConsole});
    }

    private void createConsole() {
        if (this.fConsole != null) {
            return;
        }
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        this.fConsoleManager = plugin.getConsoleManager();
        this.fConsole = new DVTMessageConsole(this.fProject, "[" + this.fProject.getName() + "] trace macro error", null, new DVTConsoleButtonsDescription(false, false, true));
        this.fConsoleManager.addConsoles(new IConsole[]{this.fConsole});
        this.setListeners();
    }

    private void setListeners() {
        ConsoleHighlightModelManager.getInstance().fConsoleToListeners.putIfAbsent(this.fConsole, new ConcurrentLinkedQueue());
        Queue listeners = (Queue)ConsoleHighlightModelManager.getInstance().fConsoleToListeners.get(this.fConsole);
        this.fListener = new ConsoleListener(this.fProject, this.fRfManager);
        if (!listeners.contains(this.fListener)) {
            this.fConsole.addPatternMatchListener((IPatternMatchListener)this.fListener);
            listeners.add(this.fListener);
        }
        this.setProcessConsole();
    }

    private void setProcessConsole() {
        ExternalToolsConfiguration config = new ExternalToolsConfiguration();
        ExternalToolsModelManager.getInstance().setProcessConsole((IConsole)this.fConsole, this.fProject, (IExternalToolsConfiguration)config, null, 1, this.fProject.getLocation().toOSString());
    }

    public void notifyMacroTraceError(final String message, String projectName) {
        if (message == null || projectName == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.fProject = workspace.getRoot().getProject(projectName);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (EMacroTraceConsoleViewer.this.fConsole == null) {
                        EMacroTraceConsoleViewer.this.createConsole();
                    }
                    EMacroTraceConsoleViewer.this.fConsole.getDocument().set("");
                    EMacroTraceConsoleViewer.this.setListeners();
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (MessageConsoleStream out = EMacroTraceConsoleViewer.this.fConsole.newMessageStream();){
                        out.setColor(DVTColorUtil.INSTANCE.getColor(255, 0, 0));
                        out.setActivateOnWrite(true);
                        out.println(message);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    static class ConsoleListener
    implements IConsoleScanListener {
        private static final Pattern fPattern = Pattern.compile("at\\sline\\s(\\d+)\\sin\\s[']([^']+)[']");
        private TextConsole fConsole;
        private TextConsoleViewer fConsoleViewer;
        private IProject fProject;
        private AbstractRfManager fRfManage;

        public ConsoleListener(IProject project, AbstractRfManager rfManager) {
            this.fProject = project;
            this.fRfManage = rfManager;
        }

        public TextConsole getConsole() {
            return this.fConsole;
        }

        public TextConsoleViewer getConsoleViewer() {
            return this.fConsoleViewer;
        }

        public void connect(TextConsole console) {
            this.fConsole = console;
        }

        public void disconnect() {
            this.fConsole = null;
            this.fConsoleViewer = null;
        }

        public void addHyperlink(int offset, int length) {
            try {
                IDocument document = this.fConsole.getDocument();
                int line = -1;
                String file = "";
                Matcher m = fPattern.matcher(document.get(offset, length));
                if (!m.matches() || m.groupCount() != 2) {
                    return;
                }
                line = Integer.parseInt(m.group(1));
                file = m.group(2);
                if (this.fProject == null) {
                    return;
                }
                if (line != -1) {
                    Hyperlink link = new Hyperlink(this.fProject, file, line, this.fRfManage);
                    this.fConsole.addHyperlink((IHyperlink)link, offset, length);
                }
            }
            catch (Exception x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
            }
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return "at line";
        }

        public String getPattern() {
            return fPattern.pattern();
        }

        public Pattern getWholePattern() {
            return fPattern;
        }

        public void setConsoleViewer(TextConsoleViewer newConsoleViewer) {
            this.fConsoleViewer = newConsoleViewer;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fProject == null ? 0 : this.fProject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConsoleListener other = (ConsoleListener)obj;
            return !(this.fProject == null ? other.fProject != null : !this.fProject.equals((Object)other.fProject));
        }
    }

    private static class Hyperlink
    implements IHyperlink {
        private IProject fProject;
        private String fFileName;
        private int fLine;
        private AbstractRfManager fRfManager;

        Hyperlink(IProject project, String file, int line, AbstractRfManager rfManager) {
            this.fProject = project;
            this.fFileName = file;
            this.fLine = line;
            this.fRfManager = rfManager;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            IFile file;
            if (this.fProject == null) {
                return;
            }
            RfProject rfProject = this.fRfManager.getRfProject(this.fProject);
            if (rfProject == null) {
                return;
            }
            RfModule module = null;
            if (!Path.fromOSString((String)this.fFileName).isAbsolute() && (file = EDTFileUtils.getInstance().findProjectFile(this.fProject, this.fFileName)) != null) {
                module = rfProject.getModule((IResource)file);
            }
            if (module == null) {
                module = rfProject.getModule(new ParserPath(this.fFileName));
            }
            if (module == null) {
                module = rfProject.getModuleUsingLastSegment(this.fFileName);
            }
            if (module == null) {
                return;
            }
            EDTFileUtils.getInstance().openFile(this.fRfManager.getPluginConfig().getModelManager(), this.fProject, module.getParserPath().path, this.fLine, null);
        }
    }
}

