/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.debug.ui.editor.hover;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.variables.Value;
import ro.amiq.dvt.debug.ui.editor.hover.ITextHoverParticipant;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.edt.base.ui.editor.EWordFinder;

public class EDebugTextHoverParticipant
implements ITextHoverParticipant {
    public void makeInfo(ITextViewer textViewer, IRegion region, DVTTooltipContent tooltipContent) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        StringBuilder info = new StringBuilder();
        int i = 0;
        while (i < launches.length) {
            String subInfo;
            IDebugTarget target;
            if (launches[i] != null && (target = launches[i].getDebugTarget()) instanceof DebugTarget && (subInfo = this.getInfo(textViewer, region, (DebugTarget)target)) != null) {
                if (launches.length > 1) {
                    String targetName;
                    try {
                        targetName = target.getName();
                    }
                    catch (DebugException debugException) {
                        targetName = String.valueOf(i);
                    }
                    info.append("<br>[").append(targetName).append("]: ").append(subInfo).append("</br>");
                } else {
                    info.append("<br>").append(subInfo).append("</br>");
                }
            }
            ++i;
        }
        tooltipContent.set(DVTTooltipContent.TooltipContent.DEBUG_INFO, info.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getInfo(ITextViewer textViewer, IRegion region, DebugTarget target) {
        IWatchExpressionResult request;
        String result;
        block9: {
            block8: {
                IDocument document;
                block7: {
                    block6: {
                        try {
                            document = textViewer.getDocument();
                            result = "";
                            if (document != null) break block6;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    if (region.getLength() != 0) break block7;
                    int offset = region.getOffset();
                    region = EWordFinder.getDefault().getExpressionAtOffset(document, offset);
                    if (region != null) break block7;
                    return null;
                }
                result = document.get(region.getOffset(), region.getLength());
                if (result != null) break block8;
                return null;
            }
            result = result.trim();
            if (target.getActiveThread() == null || target.getActiveThread().getCurrentStackFrame() == null) return "<b>" + result + "</b>";
            StackFrame stack = target.getActiveThread().getCurrentStackFrame();
            request = target.tGetWatchExpressionResult(result, (IDebugElement)stack);
            if (request != null && !request.hasErrors()) break block9;
            return null;
        }
        result = String.valueOf(result) + " = " + ((Value)request.getValue()).getValueString();
        return "<b>" + result + "</b>";
    }

    public void setTextEditor(ITextEditor textEditor) {
    }
}

