/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.diagrams.chd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.ICHModel;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHDesign;
import ro.amiq.dvt.diagrams.ch.model.CHInterface;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.model.CHUVMPort;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfBindMethodCall;
import ro.amiq.edt.base.model.reflection.RfDummyElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfSpecman;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.VHViewUtil;

public class ECHModel
implements ICHModel {
    private IEPluginConfig fPluginConfig;
    private static ECHModel instance;
    private static final Object syncInstance;

    static {
        syncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ECHModel getInstance() {
        if (instance == null) {
            Object object = syncInstance;
            synchronized (object) {
                instance = new ECHModel();
            }
        }
        return instance;
    }

    public void setPluginConfig(IEPluginConfig pluginConfig) {
        this.fPluginConfig = pluginConfig;
    }

    public CHRoot makeComponentDiagramFor(ICHDiagram input, DProgressMonitor monitor) throws DCanceledException {
        String path;
        monitor.checkCanceled();
        IDVTElementWrapper wrapper = input.getWrapper();
        if (wrapper == null) {
            return null;
        }
        Object rfElement = wrapper.getRfElement();
        if (rfElement == null) {
            return null;
        }
        RfStruct struct = this.getStruct(rfElement);
        if (struct == null) {
            return null;
        }
        Determinant determinant = this.getDeterminant(rfElement);
        if (determinant == null) {
            return null;
        }
        boolean isTop = false;
        if (wrapper.getParent() != null && wrapper.getParent().getParent() == null) {
            isTop = true;
        }
        AbstractRfTreeElementWrapper root = this.fPluginConfig.createElementTreeWrapper(rfElement);
        VHViewUtil.getRecursiveInstances(this.fPluginConfig, root, struct, determinant, new LinkedHashSet<Determinant>(), false, false, null);
        int depth = input.getDepth();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] currentDepth = nArray;
        Bundle bundle = new Bundle();
        bundle.modules = struct.getRfProject() != null ? struct.getRfProject().getAllModules() : Collections.emptyList();
        bundle.project = wrapper.getProject();
        if (wrapper.getParent() != null && wrapper.getParent().getParent() != null) {
            bundle.topInstanceParentType = this.getType(wrapper.getParent().getRfElement());
        }
        if ((path = this.getPath(wrapper, "")).contains(".")) {
            bundle.initialPathSegment = path.substring(0, path.lastIndexOf(46) + 1);
        }
        CHContainer firstComponent = this.createCHObjects(root, null, currentDepth, depth, isTop, bundle, monitor);
        LinkedHashSet<CHConnection> connections = new LinkedHashSet<CHConnection>();
        this.createCHConnections(root, connections, bundle, monitor);
        this.createCHStrayConnections(connections, bundle, monitor);
        CHRoot chRoot = new CHRoot((CHUVMComponent)firstComponent, bundle.designNode, new ArrayList<CHConnection>(connections), currentDepth[0] - 1, this.fPluginConfig.getLanguageKind());
        chRoot.setCustomDepth(depth);
        return chRoot;
    }

    private CHContainer createCHObjects(IDVTElementWrapper wrapper, CHUVMComponent parent, int[] currentDepth, int maxDepth, boolean isTop, Bundle bundle, DProgressMonitor monitor) throws DCanceledException {
        List<RfField> ports;
        monitor.checkCanceled();
        if (wrapper == null) {
            return parent;
        }
        Object rfElement = wrapper.getRfElement();
        if (rfElement instanceof RfDummyElement && parent != null) {
            String name = ((RfDummyElement)rfElement).getName();
            if ("[...max_random_depth]".equals(name) || "[...recurrence detected]".equals(name)) {
                parent.setProblemLabel(name);
            }
            return parent;
        }
        currentDepth[1] = currentDepth[1] + 1;
        currentDepth[0] = Math.max(currentDepth[0], currentDepth[1]);
        String type = !isTop ? this.getType(rfElement) : null;
        String name = this.getName(rfElement);
        CHUVMComponent component = new CHUVMComponent(this.getPath(wrapper, bundle.initialPathSegment), name, type, type, parent, this.getLanguageKind(), bundle.topInstanceParentType, bundle.project, wrapper);
        component.setDepth(currentDepth[1] - 1);
        if (component.getDepth() > maxDepth) {
            component.setIsVisible(false, true);
            component.setIsRelevant(false);
        }
        if (parent != null) {
            parent.addChild((CHContainer)component);
        } else {
            component.setIsRelevant(false);
        }
        if (rfElement instanceof RfField && (ports = this.getPortsForField(wrapper)) != null) {
            for (RfField port : ports) {
                String portName = port.getName();
                String svType = this.getSVTypeForPort(port);
                RfType associatedType = port.getAssociatedType();
                String portType = associatedType != null ? associatedType.getName() : "";
                String portPath = String.valueOf(this.getPath(wrapper, bundle.initialPathSegment)) + "." + portName;
                CHUVMPort chPort = new CHUVMPort(portPath, portName, portType, svType, CHPort.Kind.fromString((String)this.getPortKind(svType), (String)type), CHPort.DirectionKind.fromString((String)type), component);
                component.addPort((CHPort)chPort);
                bundle.portsMap.put(portPath, (CHPort)chPort);
            }
        }
        if (wrapper.getChildren() != null) {
            for (IDVTElementWrapper child : wrapper.getChildren()) {
                this.createCHObjects(child, component, currentDepth, maxDepth, false, bundle, monitor);
                currentDepth[1] = currentDepth[1] - 1;
            }
        }
        return component;
    }

    private String getType(Object rfElement) {
        Determinant determinant = this.getDeterminant(rfElement);
        return determinant != null ? determinant.toString(false) : "";
    }

    private void createCHConnections(IDVTElementWrapper wrapper, Set<CHConnection> result, Bundle bundle, DProgressMonitor monitor) throws DCanceledException {
        List children;
        monitor.checkCanceled();
        if (wrapper == null || result == null) {
            return;
        }
        Object object = wrapper.getRfElement();
        RfStruct struct = this.getStruct(object);
        Determinant determinant = this.getDeterminant(object);
        if (struct != null) {
            ArrayList<RfBindMethodCall> collectedCalls = new ArrayList<RfBindMethodCall>();
            struct.collectBindMethodCalls(determinant, collectedCalls);
            this.createCHConnectionsWithPorts(result, wrapper, collectedCalls, bundle, monitor);
        }
        if ((children = wrapper.getChildren()) == null || children.isEmpty()) {
            return;
        }
        for (IDVTElementWrapper child : children) {
            this.createCHConnections(child, result, bundle, monitor);
        }
    }

    private void createCHConnectionsWithPorts(Set<CHConnection> result, IDVTElementWrapper wrapper, List<RfBindMethodCall> collectedCalls, Bundle bundle, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        if (collectedCalls.isEmpty()) {
            return;
        }
        String path = this.getPath(wrapper, bundle.initialPathSegment);
        path = path == null ? "" : path;
        for (RfBindMethodCall call : collectedCalls) {
            String rhComplete;
            String lhComplete = call.getLHSideText();
            if (!(bundle.initialPathSegment.length() != 0 && lhComplete.startsWith(bundle.initialPathSegment) || lhComplete.startsWith(path))) {
                lhComplete = String.valueOf(path) + "." + lhComplete;
            }
            if ("external".equals(rhComplete = call.getRHSideText())) {
                this.addExternalConnection(result, bundle, lhComplete, call);
                continue;
            }
            String start = "";
            start = path.contains(".") ? path.substring(0, path.indexOf(46)) : path;
            if (!rhComplete.startsWith(start) || bundle.initialPathSegment.length() != 0 && !rhComplete.startsWith(bundle.initialPathSegment)) {
                rhComplete = String.valueOf(path) + "." + rhComplete;
            }
            this.createConnection(lhComplete, rhComplete, bundle, result, call);
        }
    }

    private void createCHStrayConnections(Set<CHConnection> connections, Bundle bundle, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        ArrayList<RfBindMethodCall> collectedCalls = new ArrayList<RfBindMethodCall>();
        for (RfModule module : bundle.modules) {
            module.collectBindMethodsCalls(collectedCalls, null);
        }
        bundle.initialPathSegment = "";
        for (RfBindMethodCall bind : collectedCalls) {
            String lhSideText = bind.getLHSideText();
            String rhSideText = bind.getRHSideText();
            if (!lhSideText.startsWith("sys")) continue;
            if ("external".equals(rhSideText)) {
                this.addExternalConnection(connections, bundle, lhSideText, bind);
                continue;
            }
            if (!rhSideText.startsWith("sys")) continue;
            this.createConnection(lhSideText, rhSideText, bundle, connections, bind);
        }
    }

    private void createConnection(String sourcePath, String destinationPath, Bundle bundle, Set<CHConnection> connections, RfBindMethodCall bind) {
        CHPort source = bundle.portsMap.get(sourcePath);
        if (source == null) {
            return;
        }
        CHPort destination = bundle.portsMap.get(destinationPath);
        if (destination == null) {
            return;
        }
        CHConnection connection = new CHConnection(source, destination, this.getLanguageKind(), bundle.project);
        source.addConnection(connection);
        destination.addConnection(connection);
        connections.add(connection);
        GoToInfo marker = GoToInfo.sourceOf((IRfNamedElement)bind);
        if (marker != null) {
            connection.setInspectViewMarker(marker);
        }
    }

    private Determinant getDeterminant(Object object) {
        if (object instanceof RfField) {
            return ((RfField)object).getAssociatedTypeDeterminant();
        }
        if (object instanceof RfStructLayer) {
            return ((RfStructLayer)object).getDeterminant();
        }
        if (object instanceof RfStruct) {
            return ((RfStruct)object).getDeterminant();
        }
        return null;
    }

    private void addExternalConnection(Set<CHConnection> connections, Bundle bundle, String path, RfBindMethodCall bind) {
        CHPort port = bundle.portsMap.get(path);
        if (port == null) {
            return;
        }
        CHPort destination = null;
        for (CHPort dPort : bundle.designNode.getPorts()) {
            if (!port.getName().equals(dPort.getName())) continue;
            destination = dPort;
            break;
        }
        if (destination == null) {
            String name = port.getName();
            destination = new CHInterface("design." + name, name, name, (CHContainer)bundle.designNode);
            bundle.designNode.addPort(destination);
        }
        CHConnection connection = new CHConnection(port, destination, this.getLanguageKind(), bundle.project);
        port.addConnection(connection);
        destination.addConnection(connection);
        connection.setInspectViewMarker(GoToInfo.sourceOf((IRfNamedElement)bind));
        connections.add(connection);
        port.getParent().setIsConnected();
        destination.getParent().setIsConnected();
    }

    private RfStruct getStruct(Object rfElement) {
        RfStruct struct = null;
        if (rfElement instanceof RfStructLayer) {
            struct = ((RfStructLayer)rfElement).getStruct();
        } else if (rfElement instanceof RfField) {
            struct = ((RfField)rfElement).getAssociatedType() instanceof RfStruct ? (RfStruct)((RfField)rfElement).getAssociatedType() : (RfStruct)((RfField)rfElement).getAssociatedBaseType();
        } else if (rfElement instanceof RfStruct) {
            struct = (RfStruct)rfElement;
        }
        return struct;
    }

    private String getName(Object rfElement) {
        String name = "";
        if (rfElement instanceof RfField) {
            boolean addArrayIndication;
            name = ((RfField)rfElement).getName();
            boolean bl = ((RfField)rfElement).getTypeInfo() != null ? ((RfField)rfElement).getTypeInfo().listDepth > 0 : (addArrayIndication = false);
            if (addArrayIndication) {
                name = String.valueOf(name) + "[]";
            }
        } else if (rfElement instanceof RfStructLayer) {
            name = ((RfStructLayer)rfElement).getName();
        } else if (rfElement instanceof RfStruct) {
            name = ((RfStruct)rfElement).getName();
        }
        return name;
    }

    public List<RfField> getPortsForField(IDVTElementWrapper element) {
        Map<String, ListContainer<RfStructMember>> rawFields;
        RfType associatedType;
        if (element == null) {
            return null;
        }
        Object obj = element.getRfElement();
        if (!(obj instanceof RfStructMember)) {
            return null;
        }
        Determinant determinant = null;
        if (obj instanceof RfField) {
            determinant = ((RfField)obj).getAssociatedTypeDeterminant();
        }
        if (!((associatedType = ((RfStructMember)obj).getAssociatedType()) instanceof RfStruct)) {
            return null;
        }
        RfStruct struct = (RfStruct)associatedType;
        if (struct instanceof RfListType) {
            if (((RfListType)struct).getAssociatedType() instanceof RfStruct) {
                struct = (RfStruct)((RfListType)struct).getAssociatedType();
            } else {
                return null;
            }
        }
        if ((rawFields = struct.getRawFields()) == null) {
            return null;
        }
        ArrayList<RfField> results = new ArrayList<RfField>(4);
        for (ListContainer<RfStructMember> fields : rawFields.values()) {
            for (RfStructMember field : fields) {
                String associatedTypeName;
                associatedType = field.getAssociatedType();
                if (!((RfField)field).isInstance() || !(associatedType instanceof RfStruct) || associatedType instanceof RfListType && !(((RfListType)associatedType).getAssociatedType() instanceof RfStruct) || determinant != null && !determinant.contains(field.getFullName().getDeterminant(), true) || !(field instanceof RfField) || !(associatedTypeName = ((RfField)field).getAssociatedTypeName()).equals("any_simple_port") && !associatedTypeName.equals("any_event_port") && !associatedTypeName.equals("any_buffer_port") && !associatedTypeName.equals("any_method_port") && !RfSpecman.isTLMPort(associatedTypeName)) continue;
                results.add((RfField)field);
            }
        }
        return results;
    }

    public String getPath(IDVTElementWrapper wrapper, String initialPath) {
        String path = ViewsUtils.pathToRoot((Object)wrapper, (String)".", (ViewsUtils.ITreePathAccessor)new ViewsUtils.ITreePathAccessor<Object>(){

            public String getNameForPath(Object wrapper) {
                if (!(wrapper instanceof IDVTElementWrapper)) {
                    return "";
                }
                StringBuilder result = new StringBuilder();
                Object obj = ((IDVTElementWrapper)wrapper).getRfElement();
                if (obj instanceof IRfNamedElement) {
                    result.append(((IRfNamedElement)obj).getName());
                }
                if (obj instanceof RfStructLayer) {
                    result.append(((RfStructLayer)obj).getName());
                }
                return result.toString();
            }
        });
        return String.valueOf(initialPath) + path;
    }

    public String getNameFor(Object object) {
        if (object instanceof RfStructLayer) {
            return ((RfStructLayer)object).getName();
        }
        return object instanceof IRfNamedElement ? ((IRfNamedElement)object).getName() : "";
    }

    private String getSVTypeForPort(RfField port) {
        if (port == null || port.getAssociatedFullTypeName() == null) {
            return "";
        }
        String svType = port.getAssociatedFullTypeName().replace("\n", " ");
        if (svType.contains(" using ")) {
            svType = svType.substring(0, svType.indexOf(" using "));
        }
        return svType;
    }

    private String getPortKind(String type) {
        if (type != null) {
            if (type.startsWith("in ")) {
                return "port";
            }
            if (type.startsWith("out")) {
                return "export";
            }
            if (type.contains("interface")) {
                return "implementation";
            }
        }
        return "port";
    }

    public static String getCopyHierarchyPathSegmentSeparator() {
        return DVTPlugin.getDefault().getPreferenceStore().getString("copyHierarchyPathSegmentSeparator");
    }

    public LanguageKind getLanguageKind() {
        return this.fPluginConfig.getLanguageKind();
    }

    static class Bundle {
        Map<String, CHPort> portsMap = new LinkedHashMap<String, CHPort>();
        Collection<RfModule> modules;
        CHDesign designNode = new CHDesign();
        String initialPathSegment = "";
        String topInstanceParentType = "";
        IProject project;

        Bundle() {
        }
    }
}

