/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.diagrams.uml;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.editor.DUMLEditorFactory;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.diagrams.uml.model.EUMLModel;

public enum EUMLHelper {
    INSTANCE;


    public UMLDiagram makeStructDiagramFor(Set<Object> structList, IProject project, IEPluginConfig pluginConfig) {
        UMLDiagramConfiguration config = UMLDiagramConfiguration.getDefault();
        EUMLModel model = EUMLModel.createModel(config, project, pluginConfig);
        if (model == null) {
            return null;
        }
        model.setRightTypes(structList);
        model.setGatherAllTypes(true);
        return new UMLDiagram(model.getTooltip(), model.getName(), (UMLModel)model);
    }

    public void openUMLDiagramEditor(UMLDiagram diagram) {
        DUMLEditorFactory.getInstance().newUMLDiagram(diagram).openEditor();
    }

    public UMLDiagram makeArchitectureDiagramFor(String uvmIncludePrefConst, String uvmExcludePrefConst, IProject project, UMLModel.DiagramKind kind, IEPluginConfig pluginConfig) {
        UMLDiagramConfiguration config = UMLDiagramConfiguration.getArchDefault();
        EUMLModel model = EUMLModel.createModel(config, project, pluginConfig);
        if (model == null) {
            return null;
        }
        model.setGatherAllTypes(true);
        model.setDiagramKind(kind);
        String includePrefVal = DVTPlugin.getDefault().getPreferenceStore().getString(uvmIncludePrefConst);
        String excludePrefVal = DVTPlugin.getDefault().getPreferenceStore().getString(uvmExcludePrefConst);
        model.setIncludePrefVal(includePrefVal);
        model.setExcludePrefVal(excludePrefVal);
        return new UMLDiagram(model.getTooltip(), model.getName(), (UMLModel)model);
    }
}

