/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.diagrams.uml.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.diagrams.uml.model.UMLNodeMember;
import ro.amiq.dvt.diagrams.uml.model.UMLPackage;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStringType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;

public class EUMLModel
extends UMLModel {
    private IEPluginConfig pluginConfig;
    private static final Predicate<Object> CHECK_VALID = obj -> {
        RfStruct struct = null;
        if (obj instanceof RfStruct) {
            struct = (RfStruct)obj;
        } else if (obj instanceof RfStructLayer) {
            struct = ((RfStructLayer)obj).getStruct();
        } else if (obj instanceof ExtendedDeterminant) {
            struct = ((ExtendedDeterminant)obj).rfStruct;
        }
        return struct != null && !struct.hasNoDefs(false);
    };

    private EUMLModel(UMLDiagramConfiguration config, IEPluginConfig pluginConfig) {
        super(config);
        this.pluginConfig = pluginConfig;
    }

    public static EUMLModel createModel(UMLDiagramConfiguration config, IProject project, IEPluginConfig pluginConfig) {
        if (project == null || config == null) {
            return null;
        }
        EUMLModel model = new EUMLModel(config, pluginConfig);
        model.setProject(project);
        model.setElementPathChecker(CHECK_VALID);
        return model;
    }

    public String generateID(Object element) {
        if (element instanceof RfStruct) {
            return RfElementPath.path((IRfNamedElement)((RfStruct)element)).toNiceString();
        }
        if (element instanceof RfStructLayer) {
            return String.valueOf(((RfStructLayer)element).getDeterminant().toString()) + ((RfStructLayer)element).getPackageName();
        }
        if (element instanceof ExtendedDeterminant) {
            return ((ExtendedDeterminant)element).getID();
        }
        return "";
    }

    public List<Object> getAllClasses(IProject aIProject, IProgressMonitor monitor) {
        RfProject project = this.pluginConfig.getRfManager().getRfProject(aIProject);
        ArrayList<Object> result = new ArrayList<Object>();
        if (project != null) {
            List<RfStruct> allStructs = project.getAllStructs();
            Iterator<RfStruct> iterator = allStructs.iterator();
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    return null;
                }
                RfStruct struct = iterator.next();
                if (this.internalStruct(struct)) continue;
                result.add(struct);
                List<RfStructLayer> subTypeLayers = struct.getSubTypeLayers();
                if (subTypeLayers == null) continue;
                Iterator<RfStructLayer> iterator2 = subTypeLayers.iterator();
                while (iterator2.hasNext()) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    RfStructLayer rfStructLayer = iterator2.next();
                    result.add(rfStructLayer);
                }
            }
        }
        return result;
    }

    public boolean internalStruct(Object object) {
        Object result = object;
        if (object instanceof ExtendedDeterminant) {
            result = ((ExtendedDeterminant)object).rfStruct;
        } else if (object instanceof RfStructLayer) {
            result = ((RfStructLayer)object).getStruct();
        }
        if (result instanceof RfStringType) {
            return true;
        }
        if (result instanceof RfType && "base_struct".equals(((RfType)result).getName())) {
            return true;
        }
        return result instanceof RfType && ((RfType)result).isNonStandard();
    }

    public String getDetails(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RfStruct) {
            RfStruct struct = (RfStruct)object;
            return String.valueOf(struct.getPackageName()) + "::" + struct.getName() + this.getClassGenericParams(struct);
        }
        if (object instanceof RfStructLayer) {
            RfStructLayer structLayer = (RfStructLayer)object;
            return String.valueOf(structLayer.getPackageName()) + "::" + structLayer.getDeterminant().toString();
        }
        return null;
    }

    protected String getClassGenericParams(Object object) {
        return object instanceof RfStruct ? ((RfStruct)object).getParametersInfo(false).replace(" of ", "") : "";
    }

    public String getFullNodeName(Object struct) {
        String name = "";
        if (struct instanceof RfStruct) {
            name = String.valueOf(((RfStruct)struct).getPackageName()) + "::" + ((RfStruct)struct).getName();
        } else if (struct instanceof RfStructLayer) {
            name = ((RfStructLayer)struct).getDeterminant().toString();
        } else if (struct instanceof ExtendedDeterminant) {
            name = ((ExtendedDeterminant)struct).getFullName();
        }
        return name;
    }

    public String getNodeName(Object struct) {
        String name = "";
        if (struct instanceof RfStruct) {
            name = ((RfStruct)struct).getName();
        } else if (struct instanceof RfStructLayer) {
            name = ((RfStructLayer)struct).getDeterminant().toString();
        } else if (struct instanceof ExtendedDeterminant) {
            name = ((ExtendedDeterminant)struct).determinant.toString();
        }
        return name;
    }

    protected List<UMLNode> getClassParents(UMLNode structNode) {
        Object element = structNode.getElement();
        if (element instanceof RfStruct) {
            RfStruct parent = ((RfStruct)element).getParentStruct();
            return parent != null ? Collections.singletonList(this.createNode(parent)) : null;
        }
        Determinant determinant = null;
        RfStruct struct = null;
        if (element instanceof ExtendedDeterminant) {
            struct = ((ExtendedDeterminant)element).rfStruct;
            determinant = ((ExtendedDeterminant)element).determinant;
        } else if (element instanceof RfStructLayer) {
            struct = ((RfStructLayer)element).getStruct();
            determinant = ((RfStructLayer)element).getDeterminant();
        }
        if (struct == null || determinant == null) {
            return null;
        }
        List<RfStructLayer> subTypeLayers = struct.getSubTypeLayers();
        if (subTypeLayers == null) {
            return null;
        }
        ArrayList<UMLNode> result = new ArrayList<UMLNode>();
        for (RfStructLayer siblingRfStructLayer : subTypeLayers) {
            if (!determinant.contains(siblingRfStructLayer.getDeterminant())) continue;
            this.addParentLayer(siblingRfStructLayer, result);
        }
        if (result.isEmpty()) {
            result.add(this.createNode(struct));
        }
        return result;
    }

    private void addParentLayer(RfStructLayer newParent, List<UMLNode> parents) {
        ArrayList<UMLNode> parentsToRemove = new ArrayList<UMLNode>();
        boolean shouldAddParent = true;
        for (UMLNode parentNode : parents) {
            RfStructLayer parentLayer = (RfStructLayer)parentNode.getElement();
            if (newParent.getDeterminant().contains(parentLayer.getDeterminant())) {
                parentsToRemove.add(parentNode);
                continue;
            }
            if (!parentLayer.getDeterminant().contains(newParent.getDeterminant())) continue;
            shouldAddParent = false;
        }
        for (UMLNode parent : parentsToRemove) {
            parents.remove(parent);
        }
        if (shouldAddParent) {
            parents.add(this.createNode(newParent));
        }
    }

    public UMLNode createNode(Object element) {
        RfStruct struct = null;
        if (element instanceof RfStruct) {
            struct = (RfStruct)element;
        } else if (element instanceof RfStructLayer) {
            struct = ((RfStructLayer)element).getStruct();
        } else if (element instanceof ExtendedDeterminant) {
            struct = ((ExtendedDeterminant)element).rfStruct;
        }
        if (struct == null) {
            return null;
        }
        UMLNode node = super.createNode(element, element instanceof RfPredefinedStruct);
        if (node == null) {
            return null;
        }
        node.isExtendedDeterminant = node.getElement() instanceof ExtendedDeterminant;
        node.setPackage(this.getPackages().get(struct.getPackageName()) != null ? (UMLPackage)this.getPackages().get(struct.getPackageName()) : new UMLPackage(struct.getPackageName(), null));
        return node;
    }

    public List<UMLNode> getClassChildren(Object object) {
        ArrayList<UMLNode> result;
        block7: {
            block6: {
                List<RfStructLayer> subTypeLayers;
                result = new ArrayList<UMLNode>();
                if (!(object instanceof RfStruct)) break block6;
                RfStruct rfStruct = (RfStruct)object;
                List<RfStruct> children = rfStruct.getChildStructs();
                if (children != null) {
                    for (RfStruct child : children) {
                        result.add(this.createNode(child));
                    }
                }
                if ((subTypeLayers = rfStruct.getSubTypeLayers()) == null) break block7;
                for (RfStructLayer layer : subTypeLayers) {
                    result.add(this.createNode(layer));
                }
                break block7;
            }
            if (object instanceof RfStructLayer) {
                List<RfStructLayer> subTypeLayers = ((RfStructLayer)object).getStruct().getSubTypeLayers();
                if (subTypeLayers == null) {
                    return Collections.emptyList();
                }
                for (RfStructLayer siblingRfStructLayer : subTypeLayers) {
                    if (!siblingRfStructLayer.getDeterminant().contains(((RfStructLayer)object).getDeterminant())) continue;
                    result.add(this.createNode(siblingRfStructLayer));
                }
            }
        }
        return result;
    }

    protected List<UMLNodeMember> getFields(Object object, boolean publicOnly) {
        if (object == null || object instanceof ExtendedDeterminant) {
            return Collections.emptyList();
        }
        if (object instanceof RfTemplateStructInstance) {
            object = ((RfTemplateStructInstance)object).getTemplateStruct();
        }
        RfStruct structElement = null;
        Determinant determinant = null;
        if (object instanceof RfStruct) {
            structElement = (RfStruct)object;
            determinant = structElement.getDeterminant();
        } else if (object instanceof RfStructLayer) {
            structElement = ((RfStructLayer)object).getStruct();
            determinant = ((RfStructLayer)object).getDeterminant();
        }
        if (structElement == null || determinant == null) {
            return Collections.emptyList();
        }
        List<RfField> members = structElement.getFields(null, determinant, false, publicOnly ? 16 : 31);
        if (members == null) {
            return Collections.emptyList();
        }
        ArrayList<UMLNodeMember> result = new ArrayList<UMLNodeMember>();
        for (RfField member : members) {
            DVTGUIFilterMatcher.GUIFilterResult filtered;
            if (member.isNonStandard() || (filtered = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.DIAGRAM, (IRfNamedElement)member, () -> member.getName())) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
            String fieldName = this.getFieldName(member);
            if (this.isArray(member)) {
                fieldName = String.valueOf(fieldName) + "[]";
            }
            result.add(new UMLNodeMember((IRfNamedElement)member, fieldName, this.getFieldLabelText(member), GoToInfo.sourceOf((IRfNamedElement)member), member.isPublic()));
        }
        return result;
    }

    protected List<UMLNodeMember> getMethods(Object object, boolean publicOnly) {
        if (object == null || object instanceof ExtendedDeterminant) {
            return Collections.emptyList();
        }
        RfStruct structElement = null;
        Determinant determinant = null;
        if (object instanceof RfStruct) {
            structElement = (RfStruct)object;
            determinant = structElement.getDeterminant();
        } else if (object instanceof RfStructLayer) {
            structElement = ((RfStructLayer)object).getStruct();
            determinant = ((RfStructLayer)object).getDeterminant();
        }
        if (structElement == null || determinant == null) {
            return Collections.emptyList();
        }
        List<RfMethod> members = structElement.getMethods(null, determinant, false, publicOnly ? 16 : 31);
        if (members == null) {
            return Collections.emptyList();
        }
        ArrayList<UMLNodeMember> result = new ArrayList<UMLNodeMember>();
        for (RfMethod member : members) {
            DVTGUIFilterMatcher.GUIFilterResult filtered;
            if (member.isNonStandard() || (filtered = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.DIAGRAM, (IRfNamedElement)member, () -> member.getName())) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
            result.add(new UMLNodeMember((IRfNamedElement)member, member.getName(), this.getMethodLabelText(member), GoToInfo.sourceOf((IRfNamedElement)member), member.isPublic()));
        }
        return result;
    }

    protected List<UMLNodeMember> getEvents(Object object, boolean publicOnly) {
        if (object == null || object instanceof ExtendedDeterminant) {
            return Collections.emptyList();
        }
        RfStruct structElement = null;
        Determinant determinant = null;
        if (object instanceof RfStruct) {
            structElement = (RfStruct)object;
            determinant = structElement.getDeterminant();
        } else if (object instanceof RfStructLayer) {
            structElement = ((RfStructLayer)object).getStruct();
            determinant = ((RfStructLayer)object).getDeterminant();
        }
        if (structElement == null || determinant == null) {
            return Collections.emptyList();
        }
        List<RfEvent> members = structElement.getEvents(null, determinant, false, publicOnly ? 16 : 31);
        if (members == null) {
            return Collections.emptyList();
        }
        ArrayList<UMLNodeMember> result = new ArrayList<UMLNodeMember>();
        for (RfEvent member : members) {
            DVTGUIFilterMatcher.GUIFilterResult filtered;
            if (member.isNonStandard() || (filtered = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.DIAGRAM, (IRfNamedElement)member, () -> member.getName())) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
            result.add(new UMLNodeMember((IRfNamedElement)member, member.getName(), this.getEventLabelText(member), GoToInfo.sourceOf((IRfNamedElement)member), member.isPublic()));
        }
        return result;
    }

    private String getFieldName(RfField field) {
        return field.getName();
    }

    protected String getFieldParameters(Object object) {
        StringBuilder result = new StringBuilder();
        RfField field = (RfField)object;
        try {
            RfType type = field.getAssociatedType();
            if (!(type instanceof RfTemplateStructInstance)) {
                return result.toString();
            }
            List<IRfAssociatedType> parameters = ((RfTemplateStructInstance)type).getParameters();
            if (parameters == null || parameters.isEmpty()) {
                return result.toString();
            }
            for (IRfAssociatedType dataType : parameters) {
                if (result.length() == 0) {
                    result.append(" (").append(dataType.getAssociatedTypeName());
                    continue;
                }
                result.append(", ").append(dataType.getAssociatedTypeName());
            }
            result.append(")");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result.toString();
    }

    protected Object getClassTypeOfField(UMLNodeMember nodeMember) {
        IRfNamedElement field = nodeMember.member;
        RfType associatedType = ((RfField)field).getAssociatedType();
        if (associatedType instanceof RfStruct) {
            boolean ok = false;
            Determinant determinant = null;
            RfStruct struct = null;
            if (associatedType instanceof RfListType) {
                RfType listType = ((RfListType)associatedType).getAssociatedType();
                if (listType instanceof RfStruct) {
                    ok = true;
                    determinant = ((RfField)field).getAssociatedTypeDeterminant();
                    struct = (RfStruct)listType;
                }
            } else {
                ok = true;
                determinant = ((RfField)field).getAssociatedTypeDeterminant();
                struct = (RfStruct)associatedType;
            }
            if (!ok) {
                return null;
            }
            if (determinant == null) {
                return struct;
            }
            if (determinant.toArray().length == 1) {
                return struct;
            }
            RfStructLayer structLayer = this.getLayerForDeterminant(determinant, struct);
            if (structLayer != null) {
                return structLayer;
            }
            return new ExtendedDeterminant(determinant, struct);
        }
        return null;
    }

    private RfStructLayer getLayerForDeterminant(Determinant determinant, RfStruct struct) {
        List<RfDefElement> structLayers = struct.getLayers();
        for (RfDefElement structLayer : structLayers) {
            Determinant layerDeterminant;
            if (!(structLayer instanceof RfStructLayer) || !determinant.equals(layerDeterminant = ((RfStructLayer)structLayer).getDeterminant())) continue;
            return (RfStructLayer)structLayer;
        }
        return null;
    }

    protected String getFieldLabelText(Object object) {
        RfField field = (RfField)object;
        String prefix = "";
        if (!field.isGenerated()) {
            prefix = String.valueOf(prefix) + "!";
        }
        if (field.isPhysical()) {
            prefix = String.valueOf(prefix) + "%";
        }
        String text = String.valueOf(prefix) + this.getFieldName(field) + " : " + field.getTypeInfo().def;
        text = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)text, (String)" ");
        text = field.isPublic() ? "+ " + text : (field.isProtected() ? "# " + text : (field.isPackage() ? "~ " + text : "- " + text));
        return text;
    }

    protected String getMethodLabelText(Object object) {
        RfMethod method = (RfMethod)object;
        String event = method.getEvent();
        String result = method.getAssociatedFullTypeName();
        if ("void".equals(result)) {
            result = "";
        }
        String args = "";
        if (this.config.fullMethodSignature()) {
            args = method.getArgs();
        }
        String text = String.valueOf(method.getName()) + "(" + args + ")" + (result == null || result.length() == 0 ? "" : " : " + result) + (event == null ? "" : "@" + event);
        text = method.isPublic() ? "+ " + text : (method.isProtected() ? "# " + text : (method.isPackage() ? "~ " + text : "- " + text));
        return text;
    }

    protected String getEventLabelText(Object object) {
        RfEvent field = (RfEvent)object;
        String text = field.getName();
        text = field.isPublic() ? "+ " + text : (field.isProtected() ? "# " + text : (field.isPackage() ? "~ " + text : "- " + text));
        return text;
    }

    public static boolean hasClassDiagram(Object elem) {
        return elem instanceof RfStruct || elem instanceof RfStructLayer;
    }

    public LanguageKind getLanguageKind() {
        return this.pluginConfig.getLanguageKind();
    }

    public Image getIcon(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RfStruct) {
            RfStruct struct = (RfStruct)object;
            if (struct.isUnit()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT);
            }
            if (struct.isLike("any_sequence")) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE);
            }
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT);
        }
        if (object instanceof RfStructLayer) {
            RfStructLayer layer = (RfStructLayer)object;
            if (layer.isUnit()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_WHEN);
            }
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_WHEN);
        }
        return null;
    }

    public UMLModel getCopy(UMLDiagramConfiguration config) {
        EUMLModel copy = new EUMLModel(config, this.pluginConfig);
        copy.setRightTypes(this.rightTypes.values());
        Set leftTypesSet = Collections.newSetFromMap(new IdentityHashMap());
        leftTypesSet.addAll(this.leftTypes);
        copy.setLeftTypes(leftTypesSet);
        copy.setProject(this.project);
        copy.setElementPathChecker(this.elementPathChecker);
        copy.setGatherAllTypes(this.gatherAllTypes);
        copy.setDiagramKind(this.getDiagramKind());
        copy.publicAssociationsOnly = this.publicAssociationsOnly;
        copy.setIncludePrefVal(this.getIncludePrefVal());
        copy.setExcludePrefVal(this.getExcludePrefVal());
        copy.copyNodes(this);
        return copy;
    }

    protected GoToInfo getSourceMarker(Object struct) {
        if (struct instanceof IRfNamedElement) {
            return GoToInfo.sourceOf((IRfNamedElement)((IRfNamedElement)struct));
        }
        if (struct instanceof ExtendedDeterminant) {
            return null;
        }
        return GoToInfo.sourceOf((IRfDefElement)((IRfDefElement)struct), (String)"");
    }

    public boolean isValid(Object element) {
        if (this.elementPathChecker == null) {
            this.setElementPathChecker(CHECK_VALID);
        }
        return this.elementPathChecker.test(element);
    }

    public boolean isPredefined(Object struct) {
        if (struct instanceof RfStruct) {
            return ((RfStruct)struct).isPredefined();
        }
        if (struct instanceof RfStructLayer) {
            return ((RfStructLayer)struct).isPredefined();
        }
        if (struct instanceof ExtendedDeterminant) {
            return ((ExtendedDeterminant)struct).rfStruct.isPredefined();
        }
        return false;
    }

    protected Object resolveTemplateStructInstance(Object object) {
        if (object instanceof RfTemplateStructInstance) {
            return ((RfTemplateStructInstance)object).getTemplateStruct();
        }
        return object;
    }

    protected boolean isPort(UMLNodeMember nodeMember) {
        return nodeMember.member instanceof RfField ? ((RfField)nodeMember.member).isPort() : false;
    }

    private boolean isArray(RfField field) {
        WrapperType typeInfo = field.getTypeInfo();
        return typeInfo != null && typeInfo.listDepth > 0;
    }

    private static class ExtendedDeterminant {
        private RfStruct rfStruct;
        private Determinant determinant;

        public ExtendedDeterminant(Determinant determinant, RfStruct rfStruct) {
            this.determinant = determinant;
            this.rfStruct = rfStruct;
        }

        public String getID() {
            return String.valueOf(RfElementPath.path((IRfNamedElement)this.rfStruct).toNiceString()) + " " + this.determinant.toString();
        }

        public String getFullName() {
            return String.valueOf(this.rfStruct.getPackageName()) + "::" + this.determinant.toString();
        }
    }
}

