/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.IEModel;
import ro.amiq.edt.base.model.IEModule;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.PePe;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.etools.eparser.Comment;
import ro.amiq.etools.eparser.EParser;
import ro.amiq.etools.eparser.EToolsException;

public abstract class AbstractEModelManagerCommon
extends DVTModelManager {
    protected HashMap<ParserPath, List> fTopFiles = new HashMap();
    protected List<EToolsException> fUnreportedErrors = new NullProtectedList<EToolsException>();

    public IEProject getIEProject(IDVTProject iDVTProject) {
        return (IEProject)iDVTProject;
    }

    public IEModule getIEModule(IDVTFile iDVTFile) {
        return (IEModule)iDVTFile;
    }

    public EModuleInfo getModuleInfo(DVTFileInfo dvtFileInfo) {
        return (EModuleInfo)dvtFileInfo;
    }

    public void saveUnfinishedJobs(IProject project) {
    }

    public void cbClean(IProject project) {
        this.fTopFiles.clear();
        this.fUnreportedErrors.clear();
        IEProject eProject = this.getEModel().getEProject(project);
        if (eProject == null) {
            return;
        }
        eProject.clean();
        this.notifyReparseListeners(2, project);
        this.notifyBuildListenersClean(eProject, true);
    }

    /*
     * Unable to fully structure code
     */
    public void cbBuild(DVTFileInfo dvtFileInfo) {
        block13: {
            info = null;
            eModule = null;
            try {
                info = this.getModuleInfo(dvtFileInfo);
                file = info.getResource();
                errors = info.getModuleErrors();
                warnings = info.getModuleWarnings();
                comments = info.getComments();
                if (file == null) ** GOTO lbl27
                parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
                if (parserPath == null) {
                    return;
                }
                try {
                    eModule = this.getEModel().getOrCreateEModule(file);
                    if (eModule != null) {
                        eModule.setAST(info.getModuleAST());
                        if (info.isIgnoredFile()) {
                            eModule.setErrors(new ArrayList<E>(0));
                            eModule.setWarnings(new ArrayList<E>(0));
                            this.notifyReparseListeners(1, 6, eModule);
                        } else {
                            eModule.setErrors(errors);
                            eModule.setWarnings(warnings);
                            eModule.setComments(comments);
                            this.notifyReparseListeners(1, 6, eModule);
                        }
                    }
                    break block13;
lbl27:
                    // 1 sources

                    if (errors != null && !errors.isEmpty()) {
                        this.fUnreportedErrors.addAll(errors);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            finally {
                if (eModule != null) {
                    eModule.setAST(null);
                }
                if (info != null) {
                    info.setModuleAST(null);
                }
            }
        }
    }

    public void cbPostFullBuild(IProject iProject, boolean success) {
        IEProject eProject = this.getEModel().getEProject(iProject);
        if (eProject == null) {
            return;
        }
        IProject project = eProject.getProject();
        this.notifyReparseListeners(3, project);
        this.notifyBuildListenersPostFullBuild(eProject, success);
        if (!this.fUnreportedErrors.isEmpty()) {
            this.reportOutsideErrors(project, this.fUnreportedErrors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cbIncrementalBuild(IProgressMonitor monitor, FileCompileInfo fileInfo, IDocument document, boolean saveRFDM) {
        if (fileInfo == null) {
            return;
        }
        IFile file = fileInfo.getFile();
        if (file == null || !file.exists()) {
            return;
        }
        IProject project = file.getProject();
        if (project == null) {
            fileInfo.setIncrCompiled(false);
            return;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (parserPath == null) {
            return;
        }
        if (!this.isTopFile(parserPath) && this.isNonTopFileCompilationDisabled(file)) {
            return;
        }
        IEProject eProject = this.getEModel().getEProject(project);
        if (eProject == null) {
            fileInfo.setIncrCompiled(false);
            return;
        }
        List<Invocation> invocations = eProject.getInvocations();
        if (invocations == null || invocations.isEmpty()) {
            fileInfo.setIncrCompiled(false);
            return;
        }
        this.cbClean(file);
        IEModule eModule = this.getEModel().getOrCreateEModule(file);
        if (eModule == null) {
            return;
        }
        try {
            if (document != null) {
                eModule.reparse(monitor, document.get(), saveRFDM);
            } else {
                eModule.reparse(monitor, saveRFDM);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (eModule.isAutoBuildStop()) {
            return;
        }
        List moduleErrors = eModule.getErrors();
        List moduleWarnings = eModule.getWarnings();
        Map<Integer, Comment> comments = eModule.getComments();
        int type = 7;
        if (this.isTopFile(parserPath)) {
            List unreportedErrors = this.fTopFiles.get(parserPath);
            if (unreportedErrors != null) {
                if (moduleErrors != null) {
                    ArrayList allErrors = new ArrayList();
                    allErrors.addAll(moduleErrors);
                    allErrors.addAll(unreportedErrors);
                    eModule.setErrors(allErrors);
                } else {
                    eModule.setErrors(unreportedErrors);
                }
                type |= 8;
            } else {
                eModule.setErrors(moduleErrors);
            }
        }
        eModule.setErrors(moduleErrors);
        eModule.setWarnings(moduleWarnings);
        moduleErrors = eModule.getErrors();
        moduleWarnings = eModule.getWarnings();
        AST moduleAST = (AST)eModule.getAST();
        this.notifyReparseListeners(0, type, eModule);
        EParser eParser = eProject.getEParser();
        if (eParser != null) {
            EParser eParser2 = eParser;
            synchronized (eParser2) {
                RfProject rfProject = this.getRfManager().getRfProject(eProject.getProject());
                RfModule rfModule = rfProject.getModule(eModule.getParserPath());
                ParserPath actualParserPath = rfModule == null ? eModule.getParserPath() : rfModule.getParserPath();
                ParserPath importedByTest = rfModule == null ? null : rfModule.getImportedByTest();
                boolean isInTop = rfModule != null && rfModule.isInTop();
                boolean isDVTEncrypted = rfModule != null && rfModule.isDVTEncrypted();
                int clusterIndex = rfModule == null ? -1 : rfModule.getClusterIndex();
                int maxModuleIndex = rfModule == null ? -1 : rfModule.getMaxModuleIndex();
                int moduleIndex = rfModule == null ? -1 : rfModule.getModuleIndex();
                int invocationIndex = rfModule == null ? invocations.size() - 1 : rfModule.getInvocationIndex();
                LanguageKind languageKind = this.getRfManager().getPluginConfig().getLanguageKind();
                EModuleInfo info = rfModule == null ? null : rfProject.getModuleInfo(rfModule.getModuleReference());
                boolean isIgnoredFile = info != null && info.isIgnoredFile();
                EModuleInfo newInfo = new EModuleInfo(project, actualParserPath, moduleAST, moduleErrors, moduleWarnings, comments, isDVTEncrypted, false, file, clusterIndex, moduleIndex, maxModuleIndex, 1, isInTop, null, importedByTest, saveRFDM, invocationIndex, languageKind);
                newInfo.setIgnoredFile(isIgnoredFile);
                this.handleFloatingNotification(eProject, project, file);
                this.notifyBuildListenersIncrementalBuild(newInfo);
            }
        }
    }

    public void cbClean(IFile file) {
        IEModule eModule = this.getEModel().getOrCreateEModule(file);
        if (eModule == null) {
            return;
        }
        this.notifyBuildListenersClean(eModule);
    }

    public void cbRemove(IFile file) {
        IEModule eModule = this.getEModel().getOrCreateEModule(file);
        if (eModule == null) {
            return;
        }
        this.notifyBuildListenersRemove(eModule);
    }

    public void cleanEProject(IProject project) {
        this.getEModel().cleanIDVTProject(project);
    }

    private boolean isTopFile(ParserPath parserPath) {
        return this.fTopFiles.containsKey(parserPath);
    }

    private boolean isNonTopFileCompilationDisabled(IFile file) {
        IProject project = file.getProject();
        if (project == null) {
            return false;
        }
        return BuildConfigManager.isNonTopFileCompilationDisabled((IProject)project);
    }

    public void addTopFile(ParserPath parserPath) {
        this.fTopFiles.put(parserPath, null);
    }

    public static String getCoreEsvFile(boolean isSLN, boolean isSDL) {
        return EDTFileUtils.getInstance().getCoreEsvFile(isSLN, isSDL);
    }

    public void removeCoreESV(EParser eParser) {
        if (eParser != null) {
            try {
                String coreEsvFile = AbstractEModelManagerCommon.getCoreEsvFile(eParser.isSLNMode(), eParser.isSDLMode());
                PePe.removeESV(eParser, coreEsvFile);
                coreEsvFile = AbstractEModelManagerCommon.getCoreEsvFile(eParser.isSLNMode(), eParser.isSDLMode());
                PePe.restore(eParser, coreEsvFile);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void restoreToCore(EParser eParser) throws EToolsException {
        String coreEsvFile;
        if (eParser != null && !(coreEsvFile = AbstractEModelManagerCommon.getCoreEsvFile(eParser.isSLNMode(), eParser.isSDLMode())).equals(PePe.getRestoreFileName(eParser))) {
            try {
                PePe.restore(eParser, coreEsvFile);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public abstract String getNature();

    public abstract IEModel getEModel();

    public abstract AbstractRfManager getRfManager();

    protected abstract void reportOutsideErrors(IProject var1, List<EToolsException> var2);

    protected abstract void handleFloatingNotification(IEProject var1, IProject var2, IFile var3);
}

