/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.floatingwidgets.DVTFNotificationProvider;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.persistenttask.DVTTaskInfoWrapper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.AbstractEModuleCommon;
import ro.amiq.edt.base.model.IEModel;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.floatingwidgets.AbstractEFNotificationProvider;
import ro.amiq.etools.eparser.Comment;
import ro.amiq.etools.eparser.EToolsException;
import ro.amiq.etools.eparser.EToolsWarning;

public abstract class AbstractEModule
extends AbstractEModuleCommon {
    private static final int TASK_TAG_MAX_DESCRIPTION_LENGTH = 100;
    private static final int TASK_TAG_LIMIT = 100;
    private List<DVTTaskInfoWrapper> fTasks;
    private boolean fTaskNamesCaseSensitive = this.getPersistentTaskManager().getCaseSensitiveTaskTags();
    private boolean fHideTaskName = this.getPersistentTaskManager().getHideTaskTags();

    protected AbstractEModule(IFile iFile) {
        super(iFile);
    }

    @Override
    public boolean isAutoBuildStop() {
        return this.fAutobuildStop;
    }

    @Override
    public void setErrors(List<EToolsException> problems, boolean updatePath, String resourcePath) {
        if (problems == null || problems.isEmpty() || !updatePath) {
            this.setErrors(problems);
            return;
        }
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        int maxIssuesKindNumber = BuildConfigManager.getMaxNofSyntacticProblemsPerFile((IProject)file.getProject());
        int i = 0;
        while (i < Math.min(maxIssuesKindNumber, problems.size())) {
            EToolsException problem = problems.get(i);
            problem.setFileName(resourcePath);
            ++i;
        }
        super.setErrors(problems);
    }

    @Override
    public void setWarnings(List<EToolsWarning> problems, boolean updatePath, String resourcePath) {
        if (problems == null || problems.isEmpty() || !updatePath) {
            this.setWarnings(problems);
            return;
        }
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        int maxIssuesKindNumber = BuildConfigManager.getMaxNofSyntacticProblemsPerFile((IProject)file.getProject());
        int i = 0;
        while (i < Math.min(maxIssuesKindNumber, problems.size())) {
            EToolsWarning problem = problems.get(i);
            problem.setFileName(resourcePath);
            ++i;
        }
        super.setWarnings(problems);
    }

    @Override
    protected void setFNotificationState() {
        AbstractEModelManager modelManager = this.getModelManager();
        if (modelManager == null) {
            return;
        }
        IEModel eModel = modelManager.getEModel();
        if (eModel == null) {
            return;
        }
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        IProject project = file.getProject();
        if (project == null) {
            return;
        }
        IEProject eProject = eModel.getEProject(project);
        if (eProject == null) {
            return;
        }
        DVTFNotificationProvider notificationProvider = eProject.getFNotificationProvider();
        if (!(notificationProvider instanceof AbstractEFNotificationProvider)) {
            return;
        }
        ((AbstractEFNotificationProvider)notificationProvider).setParseInterrupt(true);
    }

    @Override
    public void setComments(Map<Integer, Comment> comments) {
        this.fComments = comments;
        this.fTasks = null;
    }

    public List getTasks() {
        if (this.fComments == null) {
            return null;
        }
        if (this.fTasks != null) {
            return this.fTasks;
        }
        HashSet<DVTTaskInfoWrapper> taskTable = new HashSet<DVTTaskInfoWrapper>();
        try {
            Set taskNames = this.getPersistentTaskManager().getAllTaskNames();
            boolean hideTaskTags = this.getPersistentTaskManager().getHideTaskTags();
            block2: for (Map.Entry commentEntry : this.fComments.entrySet()) {
                int line = (Integer)commentEntry.getKey();
                Comment commentWrapper = (Comment)commentEntry.getValue();
                if (commentWrapper == null || commentWrapper.comment == null) continue;
                String comment = commentWrapper.comment;
                int offsetStart = commentWrapper.offset;
                String commentToScan = !this.fTaskNamesCaseSensitive ? comment.toUpperCase() : comment;
                for (String taskName : taskNames) {
                    taskName = !this.fTaskNamesCaseSensitive ? taskName.toUpperCase() : taskName;
                    int index = commentToScan.indexOf(taskName);
                    if ((index < 0 || commentToScan.length() <= index + taskName.length() || Character.isJavaIdentifierPart(comment.charAt(index + taskName.length())) || index != 0 && Character.isJavaIdentifierPart(comment.charAt(index - 1))) && (index < 0 || commentToScan.length() != index + taskName.length()) || taskTable.size() >= 100 && !taskName.equals("@DVT_EXPAND_MACRO_INLINE_START")) continue;
                    int offsetEnd = offsetStart + comment.length();
                    offsetStart += index;
                    int startCommentIndex = index;
                    if (hideTaskTags) {
                        startCommentIndex += taskName.length();
                        while (startCommentIndex < comment.length()) {
                            char ch = comment.charAt(startCommentIndex);
                            if (!Character.isWhitespace(ch) && ch != ':') break;
                            ++startCommentIndex;
                        }
                    }
                    comment = comment.substring(startCommentIndex);
                    comment = DVTFileUtils.getInstance().cropFirstLine(comment, 100);
                    comment = DVTFileUtils.getInstance().displayUpperCaseTaskTag(this.fTaskNamesCaseSensitive, this.fHideTaskName, comment, taskName);
                    DVTTaskInfoWrapper taskInfoWrapper = this.getPersistentTaskManager().makeTaskInfoWrapper(taskName, line, offsetStart, offsetEnd, comment);
                    if (taskTable.contains(taskInfoWrapper)) continue block2;
                    taskTable.add(taskInfoWrapper);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fTasks = new ArrayList<DVTTaskInfoWrapper>(taskTable);
        return this.fTasks;
    }
}

