/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model;

import antlr.Token;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AsComputedMethodsToTranslate;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.DVTProject;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.ELogger;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.PePe;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.etools.eparser.EParser;
import ro.amiq.etools.eparser.IIdentifierIndexer;

public abstract class AbstractEProjectCommon
extends DVTProject
implements IEProject {
    private static final String DVT_SPECMAN_PATH = "DVT_SPECMAN_PATH";
    private EParser fParser;
    private final Object fParserSynch = new Object();
    private Map<Invocation, Object> fLastSpecmanPathCacheUpdate = new HashMap<Invocation, Object>();
    private Map<Invocation, String> fCachedSpecmanPath = new HashMap<Invocation, String>();
    private Map<Invocation, String> fCachedDvtSpecmanPath = new HashMap<Invocation, String>();
    private Map<Invocation, String> fCachedSLNDashfPath = new HashMap<Invocation, String>();
    private CompilationUnitProperties fCachedCompilationUnitProperties;
    @Deprecated
    private AsComputedMethodsToTranslate fAsComputedMethodsToTranslate = new AsComputedMethodsToTranslate(null);

    protected AbstractEProjectCommon(IProject project) {
        super(project);
        this.addDefaultMethodsToTranslate();
    }

    public abstract IEPluginConfig getPluginConfig();

    @Override
    public String getNature() {
        return this.getPluginConfig().getNature();
    }

    public abstract String getTopPathPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EParser getEParser() {
        if (this.fParser == null) {
            Object object = this.fParserSynch;
            synchronized (object) {
                IPath esvPath = this.getESVPath();
                File f = esvPath.toFile();
                IProject project = this.getProject();
                IIdentifierIndexer indexer = (IIdentifierIndexer)IdentifierIndexerManager.getInstance().getProjectIndexer(this.getPluginConfig().getIndexerClass(), project);
                boolean inSLNMode = DVTUtilsCommon.INSTANCE.isInSLNMode(this.getNature());
                boolean inSDLMode = DVTUtilsCommon.INSTANCE.isInSDLMode(this.getNature());
                this.fParser = f.exists() ? PePe.newParser(esvPath.toOSString(), ELogger.INSTANCE, indexer, inSLNMode, inSDLMode) : PePe.newParser(AbstractEModelManager.getCoreEsvFile(inSLNMode, inSDLMode), ELogger.INSTANCE, indexer, inSLNMode, inSDLMode);
                PePe.setESVSaveAST(this.fParser, false);
                PePe.setMultipleErrors(this.fParser, true);
                PePe.setFollowImports(this.fParser, false);
                PePe.setForceReturnAST(this.fParser, true);
                PePe.setOverrideSysVars(this.fParser, this.getUserDefEnvVars());
                PePe.set(this.fParser, path -> BuildConfigManager.getSkipCompileFilter((IProject)this.getProject()).shouldSkip(new ParserPath(path), true));
                PePe.set(this.fParser, DVTStringUtil::intern);
                boolean strictChecking = BuildConfigManager.isStrictCheckingEnabled((IProject)project);
                PePe.strictChecking(this.fParser, strictChecking);
                boolean backTracking = BuildConfigManager.isBackTrackingEnabled((IProject)project);
                PePe.backTracking(this.fParser, backTracking);
                RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
                if (rfProject != null) {
                    PePe.setAsComputedExecutionConsole(this.fParser, rfProject.getAsComputedProcessor().getExecPrintStream());
                    PePe.setAsComputedExecutionProvider(this.fParser, rfProject.getAsComputedProcessor().getExecProvider());
                    PePe.setRfManager(this.fParser, rfProject);
                }
            }
        }
        return this.fParser;
    }

    @Deprecated
    private Map<String, String> getUserDefEnvVars() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.getCompactedProperties() != null) {
            for (BuildConfigProperty property : this.getCompactedProperties()) {
                if (property.getKind() != 13) continue;
                for (String key : property.getAttributes().keySet()) {
                    result.put(key, (String)property.getAttribute(key));
                }
            }
        }
        return result;
    }

    @Deprecated
    private String getUserDefinedEnvVar(String name) {
        for (BuildConfigProperty p : this.getCompactedProperties()) {
            if (p.getKind() != 13 || !(p.getAttribute(name) instanceof String)) continue;
            return (String)p.getAttribute(name);
        }
        return null;
    }

    @Deprecated
    public String getenv(String name) {
        String result = this.getUserDefinedEnvVar(name);
        if (result == null) {
            result = System.getenv(name);
        }
        return result;
    }

    @Override
    public EParser createNewEParser() {
        IPath esvPath = this.getESVPath();
        File f = esvPath.toFile();
        IProject project = this.getProject();
        IIdentifierIndexer indexer = (IIdentifierIndexer)IdentifierIndexerManager.getInstance().getProjectIndexer(this.getPluginConfig().getIndexerClass(), project);
        boolean inSLNMode = DVTUtilsCommon.INSTANCE.isInSLNMode(this.getNature());
        boolean inSDLMode = DVTUtilsCommon.INSTANCE.isInSDLMode(this.getNature());
        EParser newParser = f.exists() ? PePe.newParser(esvPath.toOSString(), ELogger.INSTANCE, indexer, inSLNMode, inSDLMode) : PePe.newParser(AbstractEModelManager.getCoreEsvFile(inSLNMode, inSDLMode), ELogger.INSTANCE, indexer, inSLNMode, inSDLMode);
        PePe.setESVSaveAST(newParser, false);
        PePe.setMultipleErrors(newParser, true);
        PePe.setFollowImports(newParser, false);
        PePe.setForceReturnAST(newParser, true);
        PePe.setOverrideSysVars(newParser, this.getUserDefEnvVars());
        PePe.set(newParser, path -> BuildConfigManager.getSkipCompileFilter((IProject)this.getProject()).shouldSkip(new ParserPath(path), true));
        PePe.set(newParser, DVTStringUtil::intern);
        boolean strictChecking = BuildConfigManager.isStrictCheckingEnabled((IProject)project);
        PePe.strictChecking(newParser, strictChecking);
        boolean backTracking = BuildConfigManager.isBackTrackingEnabled((IProject)project);
        PePe.backTracking(newParser, backTracking);
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            PePe.setAsComputedExecutionConsole(newParser, rfProject.getAsComputedProcessor().getExecPrintStream());
            PePe.setAsComputedExecutionProvider(newParser, rfProject.getAsComputedProcessor().getExecProvider());
            PePe.setRfManager(newParser, rfProject);
        }
        return newParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEParser(EParser newParser) {
        Object object = this.fParserSynch;
        synchronized (object) {
            if (newParser != null) {
                PePe.setESVSaveAST(newParser, false);
                PePe.setMultipleErrors(newParser, true);
                PePe.setFollowImports(newParser, false);
                PePe.setForceReturnAST(newParser, true);
                PePe.setOverrideSysVars(newParser, this.getUserDefEnvVars());
                PePe.set(newParser, path -> BuildConfigManager.getSkipCompileFilter((IProject)this.getProject()).shouldSkip(new ParserPath(path), true));
                PePe.set(newParser, DVTStringUtil::intern);
                IProject project = this.getProject();
                boolean strictChecking = BuildConfigManager.isStrictCheckingEnabled((IProject)project);
                PePe.strictChecking(newParser, strictChecking);
                boolean backTracking = BuildConfigManager.isBackTrackingEnabled((IProject)project);
                PePe.backTracking(newParser, backTracking);
                this.fParser = newParser;
            }
        }
    }

    @Override
    public IPath getTopPath(int invocNumber) {
        IPath stateLocation = this.getPlugin().getStateLocation();
        IPath topLocation = stateLocation.addTrailingSeparator().append(String.valueOf(this.getTopPathPrefix()) + this.getProject().getName() + "__top_" + invocNumber + ".e");
        return topLocation;
    }

    @Override
    public IPath getTopDefinesPath(int invocNumber) {
        IPath stateLocation = this.getPlugin().getStateLocation();
        IPath topLocation = stateLocation.addTrailingSeparator().append(String.valueOf(this.getTopPathPrefix()) + this.getProject().getName() + "__top_defines_" + invocNumber + ".e");
        return topLocation;
    }

    public abstract AbstractUIPlugin getPlugin();

    @Override
    public IPath getExtensionsPath(String name) {
        IPath stateLocation = this.getPlugin().getStateLocation();
        IPath topLocation = stateLocation.addTrailingSeparator().append(String.valueOf(this.getTopPathPrefix()) + this.getProject().getName() + name);
        return topLocation;
    }

    @Override
    public IPath getESVPath() {
        IPath stateLocation = this.getPlugin().getStateLocation();
        IPath projectESVLocation = stateLocation.addTrailingSeparator().append(String.valueOf(this.getProject().getName()) + ".esv");
        return projectESVLocation;
    }

    private String getSpecmanPath(Invocation invocation) {
        if (this.fCachedSpecmanPath.get(invocation) == null || this.fLastSpecmanPathCacheUpdate.get(invocation) != BuildConfigManager.getActiveBuildConfigLastCacheUpdate((IProject)this.getProject())) {
            this.updateSpecmanPath(invocation);
        }
        return this.fCachedSpecmanPath.get(invocation);
    }

    private String getDvtSpecmanPath(Invocation invocation) {
        if (this.fCachedDvtSpecmanPath.get(invocation) == null || this.fLastSpecmanPathCacheUpdate.get(invocation) != BuildConfigManager.getActiveBuildConfigLastCacheUpdate((IProject)this.getProject())) {
            this.updateSpecmanPath(invocation);
        }
        return this.fCachedDvtSpecmanPath.get(invocation);
    }

    private String getSLNDashfPath(Invocation invocation) {
        if (this.fCachedSLNDashfPath.get(invocation) == null || this.fLastSpecmanPathCacheUpdate.get(invocation) != BuildConfigManager.getActiveBuildConfigLastCacheUpdate((IProject)this.getProject())) {
            this.updateSpecmanPath(invocation);
        }
        return this.fCachedSLNDashfPath.get(invocation);
    }

    private List<ParserPath> getTopFiles(Invocation invocation) {
        LanguageKind languageKind = this.getPluginConfig().getLanguageKind();
        return this.propertyValuesToParserPath(BuildConfigParser.compact(Arrays.asList(invocation), (LanguageKind)languageKind), p -> !p.hasAttribute("ATTRIBUTE_TEST_FILE") && p.getKind() == 0);
    }

    private List<ParserPath> getTestFiles(Invocation invocation) {
        LanguageKind languageKind = this.getPluginConfig().getLanguageKind();
        return this.propertyValuesToParserPath(BuildConfigParser.compact(Arrays.asList(invocation), (LanguageKind)languageKind), p -> p.hasAttribute("ATTRIBUTE_TEST_FILE") && p.getKind() == 0);
    }

    private List<ParserPath> propertyValuesToParserPath(List<BuildConfigProperty> properties, IPropertyFilter filter) {
        ArrayList<ParserPath> result = new ArrayList<ParserPath>();
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty property : properties) {
            if (!filter.accept(property) || property.getKind() != 0 && property.getKind() != 1) continue;
            result.add(new ParserPath(property.getValue()));
        }
        return result;
    }

    @Override
    public List<Invocation> getInvocations() {
        return BuildConfigManager.getInvocations((IProject)this.getProject());
    }

    @Override
    public List<BuildConfigProperty> getCompactedProperties() {
        List activeBuildConfigCompactedCachedInfo = BuildConfigManager.getActiveBuildConfigCompactedCachedInfo((IProject)this.getProject());
        if (activeBuildConfigCompactedCachedInfo == null) {
            return new ArrayList<BuildConfigProperty>();
        }
        return activeBuildConfigCompactedCachedInfo;
    }

    private List<String> getDefines(Invocation invocation) {
        ArrayList<String> defines = new ArrayList<String>();
        List topFiles = invocation.getProperties();
        int i = 0;
        while (i < topFiles.size()) {
            BuildConfigProperty topFileProperty = (BuildConfigProperty)topFiles.get(i);
            if (topFileProperty.getKind() == 1) {
                if (topFileProperty.getValue() == null) {
                    defines.add(topFileProperty.getName());
                } else {
                    defines.add(String.valueOf(topFileProperty.getName()) + "=" + topFileProperty.getValue());
                }
            }
            ++i;
        }
        return defines;
    }

    public IDVTProject getIDVTProject() {
        IProject project = this.getProject();
        return this.getPluginConfig().getModelManager().getEModel().getIDVTProject(project);
    }

    @Override
    public ParserPath getActiveTest() {
        if (this.fCachedCompilationUnitProperties == null) {
            return null;
        }
        List<ParserPath> testFiles = this.fCachedCompilationUnitProperties.testFiles();
        if (!testFiles.isEmpty()) {
            return testFiles.get(0);
        }
        return null;
    }

    @Override
    public List<ParserPath> getNonActiveTests() {
        if (this.fCachedCompilationUnitProperties == null) {
            return null;
        }
        List<ParserPath> testFiles = this.fCachedCompilationUnitProperties.testFiles();
        if (!testFiles.isEmpty()) {
            return testFiles.subList(1, testFiles.size());
        }
        return null;
    }

    private void updateSpecmanPath(Invocation invocation) {
        block6: {
            this.fLastSpecmanPathCacheUpdate.put(invocation, BuildConfigManager.getActiveBuildConfigLastCacheUpdate((IProject)this.getProject()));
            boolean inSLNMode = DVTUtilsCommon.INSTANCE.isInSLNMode(this.getNature());
            try {
                String sysvarDvtSpecmanPath;
                this.fCachedSpecmanPath.put(invocation, "");
                this.fCachedDvtSpecmanPath.put(invocation, "");
                if (inSLNMode) {
                    this.fCachedSLNDashfPath.put(invocation, "");
                }
                if ((sysvarDvtSpecmanPath = this.getUserDefinedEnvVar(DVT_SPECMAN_PATH)) == null) {
                    sysvarDvtSpecmanPath = System.getenv(DVT_SPECMAN_PATH);
                }
                sysvarDvtSpecmanPath = sysvarDvtSpecmanPath == null ? "" : DVTUtilsCommon.INSTANCE.getCrossPlatformPath(sysvarDvtSpecmanPath);
                ArrayList<IBuildConfigParserConstants.SpecmanPathSource> specmanPathSources = new ArrayList<IBuildConfigParserConstants.SpecmanPathSource>();
                specmanPathSources.addAll(Arrays.asList(IBuildConfigParserConstants.SpecmanPathSource.COMPILATION_ROOT, IBuildConfigParserConstants.SpecmanPathSource.SPECMAN_PATH, IBuildConfigParserConstants.SpecmanPathSource.DVT_SN_WHICH));
                if (invocation.getToolCompat() == IBuildConfigParserConstants.ToolCompat.SVR) {
                    specmanPathSources.add(IBuildConfigParserConstants.SpecmanPathSource.PERSPEC_PATH);
                    specmanPathSources.add(IBuildConfigParserConstants.SpecmanPathSource.SVR_PATH);
                }
                this.fCachedSpecmanPath.put(invocation, new PathBuilder(BuildConfigManager.getSpecmanPath((IProject)this.getProject(), (Invocation)invocation, (IBuildConfigParserConstants.SpecmanPathSource[])specmanPathSources.toArray(new IBuildConfigParserConstants.SpecmanPathSource[specmanPathSources.size()]))).toString());
                this.fCachedDvtSpecmanPath.put(invocation, new PathBuilder(this.fCachedSpecmanPath.get(invocation)).prepend(BuildConfigManager.getSpecmanPath((IProject)this.getProject(), (Invocation)invocation, (IBuildConfigParserConstants.SpecmanPathSource[])new IBuildConfigParserConstants.SpecmanPathSource[]{IBuildConfigParserConstants.SpecmanPathSource.DVT_SPECMAN_PATH})).toString());
                if (inSLNMode) {
                    this.fCachedSLNDashfPath.put(invocation, new PathBuilder(invocation.getState().fDashfPaths).toString());
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.fCachedSpecmanPath.put(invocation, "");
                this.fCachedDvtSpecmanPath.put(invocation, "");
                if (!inSLNMode) break block6;
                this.fCachedSLNDashfPath.put(invocation, "");
            }
        }
    }

    @Override
    public void clean() {
        this.fParser = null;
        this.fCachedCompilationUnitProperties = null;
    }

    @Deprecated
    private void addDefaultMethodsToTranslate() {
        this.fAsComputedMethodsToTranslate.add("main::global.vr_ad_reg_def_macro_2_e");
        this.fAsComputedMethodsToTranslate.add("main::global.vr_ad_reg_fld_cov");
        this.fAsComputedMethodsToTranslate.add("main::global.vr_ad_mem_fld_cov");
        this.fAsComputedMethodsToTranslate.add("main::global.rw_reg_gen_op");
        this.fAsComputedMethodsToTranslate.add("main::global.rw_reg_static_reg");
        this.fAsComputedMethodsToTranslate.add("main::global.rw_reg_new_reg");
        this.fAsComputedMethodsToTranslate.add("main::global.rw_reg_do");
        this.fAsComputedMethodsToTranslate.add("main::global.vr_ad_add_sc_model");
        this.fAsComputedMethodsToTranslate.add("main::global.vr_ad_sc_ports_for_reg_file");
        this.fAsComputedMethodsToTranslate.add("main::global.vr_ad_tlm_reg_api_for_reg_file");
    }

    @Override
    @Deprecated
    public Set<String> getAsComputedMethodsToTranslate(String packageName, String structName) {
        this.updateAsComputedMethodsToTranslate();
        return this.fAsComputedMethodsToTranslate.get(packageName, structName);
    }

    @Override
    @Deprecated
    public boolean hasAsComputedMethodsToTranslate(String structName) {
        this.updateAsComputedMethodsToTranslate();
        return this.fAsComputedMethodsToTranslate.has(structName);
    }

    @Deprecated
    private void updateAsComputedMethodsToTranslate() {
        if (this.fAsComputedMethodsToTranslate.isUpdated(BuildConfigManager.getActiveBuildConfigLastCacheUpdate((IProject)this.getProject()))) {
            return;
        }
        this.fAsComputedMethodsToTranslate = new AsComputedMethodsToTranslate(BuildConfigManager.getActiveBuildConfigLastCacheUpdate((IProject)this.getProject()));
        this.addDefaultMethodsToTranslate();
        if (BuildConfigManager.getActiveBuildConfigCompactedCachedInfo((IProject)this.getProject()) == null) {
            return;
        }
        for (BuildConfigProperty p : BuildConfigManager.getActiveBuildConfigCompactedCachedInfo((IProject)this.getProject())) {
            List attributes;
            if (p.getKind() != 11 || !p.hasAttribute("ATTRIBUTE_AS_COMPUTED_TRANSLATE_METHOD") || (attributes = (List)p.getAttribute("ATTRIBUTE_AS_COMPUTED_TRANSLATE_METHOD")) == null || attributes.isEmpty()) continue;
            for (Token attribute : attributes) {
                this.fAsComputedMethodsToTranslate.add(attribute.getText());
            }
        }
    }

    @Override
    public CompilationUnitProperties getCompilationUnitProperties(boolean doNotComputeIfNotAlreadyCached) {
        if (this.fCachedCompilationUnitProperties != null) {
            return this.fCachedCompilationUnitProperties;
        }
        String natureID = this.getNature();
        if (doNotComputeIfNotAlreadyCached) {
            return new CompilationUnitProperties(natureID);
        }
        this.fCachedCompilationUnitProperties = new CompilationUnitProperties(natureID);
        List<Invocation> invocations = this.getInvocations();
        boolean inSLNMode = DVTUtilsCommon.INSTANCE.isInSLNMode(natureID);
        ParserPath activeTest = null;
        IProject project = this.getProject();
        int invocNumber = 0;
        while (invocations != null && invocNumber < invocations.size()) {
            Invocation invocation = invocations.get(invocNumber);
            if (invocation.hasEFiles()) {
                List<ParserPath> topFiles;
                boolean hasTopFiles;
                boolean hasTestFiles;
                List<ParserPath> testFiles = this.getTestFiles(invocation);
                boolean bl = hasTestFiles = testFiles != null && !testFiles.isEmpty();
                if (hasTestFiles) {
                    this.fCachedCompilationUnitProperties.testFiles().addAll(testFiles);
                }
                boolean bl2 = hasTopFiles = (topFiles = this.getTopFiles(invocation)) != null && !topFiles.isEmpty();
                if (hasTopFiles) {
                    this.fCachedCompilationUnitProperties.topFiles().addAll(topFiles);
                }
                if (hasTestFiles || hasTopFiles) {
                    String slnDashfPath;
                    List<String> defines;
                    String specmanPath;
                    activeTest = BuildConfigManager.getActiveTest((IProject)project, (Invocation)invocation);
                    String specmanDvtPath = this.getDvtSpecmanPath(invocation);
                    if (specmanDvtPath != null) {
                        String[] specmanDvtPaths = DVTStringUtil.split((String)IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR, (String)specmanDvtPath);
                        this.fCachedCompilationUnitProperties.specmanDvtPaths().addAll(Arrays.asList(specmanDvtPaths));
                    }
                    if ((specmanPath = this.getSpecmanPath(invocation)) != null) {
                        String[] specmanPaths = DVTStringUtil.split((String)IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR, (String)specmanPath);
                        this.fCachedCompilationUnitProperties.specmanPaths().addAll(Arrays.asList(specmanPaths));
                    }
                    if ((defines = this.getDefines(invocation)) != null && !defines.isEmpty()) {
                        this.fCachedCompilationUnitProperties.defines().addAll(defines);
                    }
                    if (inSLNMode && (slnDashfPath = this.getSLNDashfPath(invocation)) != null) {
                        String[] slnDashfPathChuncks = DVTStringUtil.split((String)IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR, (String)slnDashfPath);
                        this.fCachedCompilationUnitProperties.slnDashfPaths().addAll(Arrays.asList(slnDashfPathChuncks));
                    }
                }
            }
            ++invocNumber;
        }
        if (activeTest != null && this.fCachedCompilationUnitProperties.testFiles().contains(activeTest)) {
            this.fCachedCompilationUnitProperties.testFiles().remove(activeTest);
            this.fCachedCompilationUnitProperties.testFiles().add(0, activeTest);
        }
        return this.fCachedCompilationUnitProperties;
    }

    public static interface IPropertyFilter {
        public static final IPropertyFilter ACCEPT_ALL = p -> true;

        public boolean accept(BuildConfigProperty var1);
    }

    static class PathBuilder {
        private StringBuilder fStringBuilder = new StringBuilder();

        public PathBuilder() {
        }

        public PathBuilder(String path) {
            this();
            if (path == null) {
                return;
            }
            this.append(path);
        }

        public PathBuilder(List<String> paths) {
            this();
            if (paths == null) {
                return;
            }
            this.append(paths);
        }

        public PathBuilder prepend(String path) {
            if (path == null || path.length() == 0) {
                return this;
            }
            if (this.fStringBuilder.length() != 0) {
                this.fStringBuilder.insert(0, IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR);
            }
            this.fStringBuilder.insert(0, path);
            return this;
        }

        public PathBuilder append(String path) {
            if (path == null || path.length() == 0) {
                return this;
            }
            if (this.fStringBuilder.length() != 0) {
                this.fStringBuilder.append(IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR);
            }
            this.fStringBuilder.append(path);
            return this;
        }

        public PathBuilder append(List<String> paths) {
            if (paths == null) {
                return this;
            }
            for (String path : paths) {
                this.append(path);
            }
            return this;
        }

        public PathBuilder prepend(List<String> paths) {
            if (paths == null) {
                return this;
            }
            for (String path : paths) {
                this.prepend(path);
            }
            return this;
        }

        public String toString() {
            return this.fStringBuilder.toString();
        }
    }
}

