/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class CompilationUnitProperties {
    private final List<ParserPath> topFiles = new ArrayList<ParserPath>();
    private final List<ParserPath> testFiles = new ArrayList<ParserPath>();
    private final Set<String> specmanPaths = new LinkedHashSet<String>();
    private final Set<String> specmanDvtPaths = new LinkedHashSet<String>();
    private final Set<String> defines = new LinkedHashSet<String>();
    private final Set<String> slnDashfPaths = new LinkedHashSet<String>();
    private String natureID;

    public CompilationUnitProperties(String natureID) {
        this.natureID = natureID;
    }

    public boolean hasFilesToCompile() {
        return this.topFiles != null && !this.topFiles.isEmpty() || this.testFiles != null && !this.testFiles.isEmpty();
    }

    public String getSpecmanPath() {
        String specmanPath = DVTStringUtil.join(this.specmanPaths, (String)File.pathSeparator);
        if (specmanPath == null || specmanPath.isEmpty()) {
            return null;
        }
        return specmanPath;
    }

    public String getDvtSpecmanPath() {
        String specmanDvtPath = DVTStringUtil.join(this.specmanDvtPaths, (String)File.pathSeparator);
        if (specmanDvtPath == null || specmanDvtPath.isEmpty()) {
            return null;
        }
        return specmanDvtPath;
    }

    public String getSlnDashfPaths() {
        boolean inSLNMode = DVTUtilsCommon.INSTANCE.isInSLNMode(this.getNature());
        if (!inSLNMode) {
            return null;
        }
        String slnDashfPath = DVTStringUtil.join(this.slnDashfPaths, (String)File.pathSeparator);
        if (slnDashfPath == null || slnDashfPath.isEmpty()) {
            return null;
        }
        return slnDashfPath;
    }

    public String getNature() {
        return this.natureID;
    }

    @NotNull
    public Set<String> defines() {
        return this.defines;
    }

    @NotNull
    public List<ParserPath> testFiles() {
        return this.testFiles;
    }

    @NotNull
    public List<ParserPath> topFiles() {
        return this.topFiles;
    }

    @NotNull
    public Set<String> specmanDvtPaths() {
        return this.specmanDvtPaths;
    }

    @NotNull
    public Set<String> specmanPaths() {
        return this.specmanPaths;
    }

    @NotNull
    public Set<String> slnDashfPaths() {
        return this.slnDashfPaths;
    }
}

