/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model;

import antlr.collections.AST;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.ASTUtils;
import ro.amiq.etools.eparser.Comment;
import ro.amiq.etools.eparser.EAST;
import ro.amiq.etools.eparser.EToolsException;
import ro.amiq.etools.eparser.EToolsWarning;

public class EModuleInfo
extends DVTFileInfo
implements Serializable {
    private static final long serialVersionUID = 1914L;
    private ParserPath fParserPath;
    private int fClusterIndex;
    private int fModuleIndex;
    private int fMaxModuleIndex;
    private int fClusterNofModules;
    private boolean fModuleIsInTop;
    private List<ParserPath> fModuleLoadedByTest;
    private boolean fDVTEncrypted;
    private boolean fSNEncrypted;
    private boolean fSaveRFDM;
    private boolean fIgnoredFile;
    private int fInvocationIndex;
    private Map<Integer, Comment> fComments;
    private ParserPath fImportedByTest;
    private LanguageKind fLanguageKind;
    private transient AST fModuleAST;
    private transient IProject fProject;
    private transient List<EToolsException> fModuleErrors;
    private transient List<EToolsWarning> fModuleWarnings;
    private transient IFile fResource;

    public EModuleInfo(IProject project, ParserPath parserPath, AST moduleAST, List<EToolsException> moduleErrors, List<EToolsWarning> moduleWarnings, Map<Integer, Comment> comments, boolean isDVTEncrypted, boolean isSNEncrypted, IFile resource, int clusterIndex, int moduleIndex, int maxModuleIndex, int clusterNofModules, boolean isInTop, List<ParserPath> byTest, ParserPath importedByTest, boolean saveRFDM, int invocationIndex, LanguageKind languageKind) {
        this.fProject = project;
        this.fParserPath = parserPath;
        this.fModuleAST = moduleAST;
        this.fModuleErrors = moduleErrors;
        this.fModuleWarnings = moduleWarnings;
        this.fDVTEncrypted = isDVTEncrypted;
        this.fSNEncrypted = isSNEncrypted;
        this.fResource = resource;
        this.fClusterIndex = clusterIndex;
        this.fModuleIndex = moduleIndex;
        this.fMaxModuleIndex = maxModuleIndex;
        this.fClusterNofModules = clusterNofModules;
        this.fModuleIsInTop = isInTop;
        this.fModuleLoadedByTest = byTest;
        this.fImportedByTest = importedByTest;
        this.fSaveRFDM = saveRFDM;
        this.fInvocationIndex = invocationIndex;
        this.fComments = comments;
        this.fLanguageKind = languageKind;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public int getInvocationIndex() {
        return this.fInvocationIndex;
    }

    public LanguageKind getLanguageKind() {
        return this.fLanguageKind;
    }

    public String getModuleName() {
        return Path.fromOSString((String)this.fParserPath.path).lastSegment();
    }

    public ParserPath getParserPath() {
        return this.fParserPath;
    }

    public ParserPath getImportedByTest() {
        return this.fImportedByTest;
    }

    public void setParserPath(ParserPath parserPath) {
        this.fParserPath = parserPath;
    }

    public AST getModuleAST() {
        return this.fModuleAST;
    }

    public void setModuleAST(AST moduleAST) {
        if (moduleAST != null) {
            this.fModuleAST = moduleAST;
        }
    }

    public void cleanModuleAST() {
        ASTUtils.scanAST(new ASTUtils.ASTRunnable(){

            @Override
            public void run(AST node) throws Exception {
                if (node instanceof EAST) {
                    ((EAST)node).transientResult = null;
                    ((EAST)node).transientScope = null;
                }
            }
        }, this.fModuleAST);
        this.fModuleAST = null;
    }

    public List<EToolsException> getModuleErrors() {
        return this.fModuleErrors;
    }

    public List<EToolsWarning> getModuleWarnings() {
        return this.fModuleWarnings;
    }

    public void setModuleErrors(List<EToolsException> moduleErrors) {
        this.fModuleErrors = moduleErrors;
    }

    public void setModuleWarnings(List<EToolsWarning> moduleWarnings) {
        this.fModuleWarnings = moduleWarnings;
    }

    public int getModuleIndex() {
        return this.fModuleIndex;
    }

    public int getMaxModuleIndex() {
        return this.fMaxModuleIndex;
    }

    public boolean isInTop() {
        return this.fModuleIsInTop;
    }

    public List<ParserPath> getByTest() {
        return this.fModuleLoadedByTest;
    }

    public IFile getResource() {
        return this.fResource;
    }

    public void setResource(IFile resource) {
        this.fResource = resource;
    }

    public boolean isSaveRFDM() {
        return this.fSaveRFDM;
    }

    private void readAST(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        try {
            boolean hasAST = ois.readBoolean();
            if (!hasAST) {
                return;
            }
            this.fModuleAST = null;
            do {
                this.fModuleAST = (EAST)ois.readObject();
                if (this.fModuleAST.getNextSibling() != null) {
                    ((EAST)this.fModuleAST.getNextSibling()).setPrevSibling((EAST)this.fModuleAST);
                }
                if (this.fModuleAST.getFirstChild() == null) continue;
                ((EAST)this.fModuleAST.getFirstChild()).setParent((EAST)this.fModuleAST);
            } while (!((EAST)this.fModuleAST).isRootElement());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void writeAST(final ObjectOutputStream oos) throws IOException {
        try {
            EAST node = (EAST)this.fModuleAST;
            if (node == null) {
                oos.writeBoolean(false);
                return;
            }
            oos.writeBoolean(true);
            ASTUtils.scanAST(new ASTUtils.ASTRunnable(){

                @Override
                public void run(AST node) throws Exception {
                    oos.writeObject(node);
                }
            }, this.fModuleAST);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        this.writeAST(oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.readAST(ois);
    }

    public boolean isSNEncrypted() {
        return this.fSNEncrypted;
    }

    public boolean isDVTEncrypted() {
        return this.fDVTEncrypted;
    }

    public void setIgnoredFile(boolean ignoredFile) {
        this.fIgnoredFile = ignoredFile;
    }

    public boolean isIgnoredFile() {
        return this.fIgnoredFile;
    }

    public int getClusterIndex() {
        return this.fClusterIndex;
    }

    public int getClusterNofModules() {
        return this.fClusterNofModules;
    }

    public Map<Integer, Comment> getComments() {
        if (this.fComments == null) {
            return null;
        }
        return new HashMap<Integer, Comment>(this.fComments);
    }

    public void cleanComments() {
        if (this.fComments == null || this.fComments.isEmpty()) {
            return;
        }
        Iterator<Integer> iterator = this.fComments.keySet().iterator();
        while (iterator.hasNext()) {
            Integer lineNumber = iterator.next();
            Comment comment = this.fComments.get(lineNumber);
            if (comment.keepForRestore) continue;
            iterator.remove();
        }
    }
}

