/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.ui.reportissue.IncrementalBuildThreadDumpHandler;
import ro.amiq.dvt.ui.reportissue.IncrementalInfoCallbackFactory;
import ro.amiq.edt.base.model.AbstractEModuleCommon;
import ro.amiq.edt.base.model.RebuildTriggerJobCommon;
import ro.amiq.edt.base.model.reflection.RfProject;

public class RebuildTriggerJob
extends RebuildTriggerJobCommon {
    public RebuildTriggerJob(AbstractEModuleCommon module) {
        super(module);
    }

    public boolean shouldSchedule() {
        block3: {
            try {
                IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
                if (preferences != null && DVTPlugin.getDefault() != null && DVTPlugin.getDefault().getPreferenceStore() != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return super.shouldSchedule() && (ResourcesPlugin.getWorkspace().isAutoBuilding() && DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.TRIGGER_AUTOBUILD_ENABLE") || this.module.fForceBuild) && this.module.isBuilderEnabled(this.module.getNature());
    }

    public boolean shouldRun() {
        block3: {
            try {
                IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
                if (preferences != null && DVTPlugin.getDefault() != null && DVTPlugin.getDefault().getPreferenceStore() != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return super.shouldRun() && (ResourcesPlugin.getWorkspace().isAutoBuilding() && DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.TRIGGER_AUTOBUILD_ENABLE") || this.module.fForceBuild) && this.module.isBuilderEnabled(this.module.getNature());
    }

    public IStatus run(IProgressMonitor monitor) {
        EnumMap<LanguageKind, Set> changedFiles = new EnumMap<LanguageKind, Set>(LanguageKind.class);
        try {
            block19: {
                IFile file = this.module.getFile();
                IProject project = file.getProject();
                if (!DVTPlugin.getDefault().collect().c(this.module.getFile().getProject(), "F65")) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                monitor.beginTask("Parse: " + this.module.getFile().getName(), 5);
                monitor.worked(2);
                RfProject rfProject = this.module.getRfManager().getRfProjectWithoutRestore(project);
                try {
                    try {
                        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
                        IncrementalBuildThreadDumpHandler.INSTANCE.createSession(IncrementalInfoCallbackFactory.INSTANCE.createIncrementalDeltaFilesCallback(rfMixedLangProject, changedFiles), IncrementalInfoCallbackFactory.INSTANCE.createIncrementalDeltaInfoCallback(rfMixedLangProject), project);
                        FileCompileInfo fileCompileInfo = new FileCompileInfo(file);
                        ObjectionManager.getInstance().clear(Objection.BUILD);
                        LanguageKind languageKind = this.module.getLanguageKind();
                        boolean cancelIncremental = PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE");
                        if (cancelIncremental) {
                            ChangedFilesManager.handleCanceledIncremental(new HashSet<FileCompileInfo>(Arrays.asList(fileCompileInfo)), (LanguageKind)languageKind, (IProject)project, (IProgressMonitor)monitor, changedFiles);
                        }
                        this.module.getModelManager().cbIncrementalBuild(monitor, fileCompileInfo, this.fDocument, this.fSaveRFDM);
                        changedFiles.computeIfAbsent(languageKind, x -> new LinkedHashSet()).add(fileCompileInfo);
                        DVTMixedLangModelManager.getInstance().notifyBuildListenersPostIncrementalBuild(project, changedFiles);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        DVTMixedLangModelManager.getInstance().fireBuildDone(IBuildDoneListener.BuildFinishReason.computeBuildFinishReason((int)9, (boolean)monitor.isCanceled()), project.getName());
                        IncrementalBuildThreadDumpHandler.INSTANCE.destroySession();
                        if (rfProject != null) {
                            rfProject.cleanIncrementalDeltaContainer();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    DVTMixedLangModelManager.getInstance().fireBuildDone(IBuildDoneListener.BuildFinishReason.computeBuildFinishReason((int)9, (boolean)monitor.isCanceled()), project.getName());
                    IncrementalBuildThreadDumpHandler.INSTANCE.destroySession();
                    if (rfProject != null) {
                        rfProject.cleanIncrementalDeltaContainer();
                    }
                    throw throwable;
                }
                DVTMixedLangModelManager.getInstance().fireBuildDone(IBuildDoneListener.BuildFinishReason.computeBuildFinishReason((int)9, (boolean)monitor.isCanceled()), project.getName());
                IncrementalBuildThreadDumpHandler.INSTANCE.destroySession();
                if (rfProject != null) {
                    rfProject.cleanIncrementalDeltaContainer();
                }
            }
            monitor.worked(3);
            monitor.setTaskName("");
            monitor.done();
            ObjectionManager.getInstance().clear(Objection.BUILD_DONE);
            this.setName("");
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            this.setName("");
            DVTLogger.INSTANCE.logError((Throwable)e);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            if (!monitor.isCanceled()) {
                RfMixedLangManager.getInstance().clearBacklogElements(this.module.getFile().getProject());
            }
        }
    }
}

