/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.problems;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemKind;
import ro.amiq.dvt.model.problems.DVTProblemKinds;
import ro.amiq.dvt.model.problems.EProblemKinds;
import ro.amiq.dvt.model.problems.ISourceProblem;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.model.problems.EToolsExceptionWrapper;
import ro.amiq.edt.base.model.reflection.semantic.RfSemanticError;
import ro.amiq.etools.eparser.EToolsException;
import ro.amiq.etools.eparser.EToolsWarning;

public class Bridge {
    private static final String IMPORTED_FILE_NOT_FOUND = "IMPORTED_FILE_NOT_FOUND";

    public static DVTProblem from(IProject project, RfSemanticError e, boolean toConsole, boolean inSLNMode) {
        DVTProblemKind problemKind = DVTProblemKinds.GENERIC;
        if (e.getSeverity() == 1) {
            problemKind = inSLNMode ? EProblemKinds.SLN_SEMANTIC_ERROR : EProblemKinds.E_SEMANTIC_ERROR;
        } else if (e.getSeverity() == 2) {
            problemKind = inSLNMode ? EProblemKinds.SLN_SEMANTIC_WARNING : EProblemKinds.E_SEMANTIC_WARNING;
        }
        int offsetStart = e.getOffsetStart();
        int offsetEnd = e.getOffsetEnd();
        DVTProblem result = new DVTProblem(project, problemKind, e.getResourcePath(), toConsole, e.getLineNumber(), new String[]{e.getMessage()});
        result.setObsolete(e.isObsolete());
        result.setSourceProblem((ISourceProblem)e);
        if (offsetEnd > offsetStart) {
            result.setAttribute("charStart", (Object)offsetStart);
            result.setAttribute("charEnd", (Object)offsetEnd);
        }
        result.addAttributes(e.getAttributes());
        return result;
    }

    private static String getMessage(EToolsException e) {
        return String.valueOf(e.getErrorCode()) + ": " + e.getMessage();
    }

    private static String getMacroStackTrace(String message) {
        StringBuilder result = new StringBuilder();
        try {
            String[] lines = DVTStringUtil.split((Pattern)DVTStringUtil.NEW_LINE, (String)message);
            int index = -1;
            int i = 0;
            while (i < lines.length) {
                String line;
                if (i != 0) {
                    result.append("\n");
                }
                if ((index = (line = lines[i]).indexOf("Detected at line")) != -1 && i + 1 < lines.length) {
                    result.append(String.valueOf(line.substring(0, index)) + "detected at line" + line.substring(index + 16));
                    line = lines[i + 1];
                    index = line.indexOf("in");
                    result.append(" in '").append(Utils.canonicPath((String)line.substring(index + 2).trim())).append("'");
                    ++i;
                } else {
                    result.append(line);
                }
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result.toString();
    }

    public static DVTProblem from(IProject project, EToolsException p, String reportedPath, boolean toConsole, boolean inSLNMode) {
        boolean hasMacroStackTrace;
        DVTProblemKind problemKind = null;
        problemKind = p instanceof EToolsWarning ? (inSLNMode ? EProblemKinds.SLN_SYNTAX_WARNING : EProblemKinds.E_SYNTAX_WARNING) : (inSLNMode ? EProblemKinds.SLN_SYNTAX_ERROR : EProblemKinds.E_SYNTAX_ERROR);
        boolean outsideProject = false;
        if (reportedPath != null) {
            IPath reportedProblemPath;
            IPath actualProblemPath = Path.fromOSString((String)p.getFilename());
            outsideProject = !actualProblemPath.equals((Object)(reportedProblemPath = Path.fromOSString((String)reportedPath)));
        }
        String path = outsideProject ? reportedPath : p.getFilename();
        int line = p.getLine();
        String message = Bridge.getMessage(p);
        if (outsideProject) {
            message = "[Outside Project] " + message;
        }
        if (hasMacroStackTrace = p.toString().contains("inside macro")) {
            message = String.valueOf(message) + " [Right click to show macro trace]";
        }
        DVTProblem result = new DVTProblem(project, problemKind, path, toConsole, line, new String[]{message});
        result.setSourceProblem((ISourceProblem)new EToolsExceptionWrapper(p));
        if (outsideProject) {
            result.setAttribute("ro.amiq.dvt.file_name", (Object)p.getFilename());
            result.setAttribute("ro.amiq.dvt.line_number", (Object)p.getLine());
        }
        if (hasMacroStackTrace) {
            result.setAttribute("ro.amiq.dvt.ui.editor.MacroStackTrace", (Object)Bridge.getMacroStackTrace(p.toString()));
            result.setAttribute("ro.amiq.dvt.ui.editor.MacroPluginID", (Object)(inSLNMode ? "ro.amiq.slndt" : "ro.amiq.edt"));
            result.setAttribute("ro.amiq.dvt.ui.editor.MacroProjectName", (Object)project.getName());
        }
        if (problemKind == EProblemKinds.E_SYNTAX_ERROR && IMPORTED_FILE_NOT_FOUND.equals(p.getErrorCode())) {
            String errorMessage = p.getMessage();
            int startIndex = errorMessage.indexOf(39) + 1;
            int endIndex = errorMessage.indexOf(39, startIndex);
            String fileName = errorMessage.substring(startIndex, endIndex);
            HashMap<String, Object> attributes = new HashMap<String, Object>(2);
            attributes.put("QUICKFIX_ELEMENT_NAME", fileName);
            attributes.put("QUICKFIX_KIND", 39);
            result.addAttributes(attributes);
        }
        return result;
    }
}

