/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.model.reflection.AbstractEReflectionContributorCommon;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.RfVarLayer;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.TypesViewMembersLabelProvider;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class AbstractEReflectionContributor
extends AbstractEReflectionContributorCommon {
    public boolean gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return false;
        }
        RfDefElement customDef = (RfDefElement)element.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TYPES_MEMBERS_DEF);
        if (customDef != null) {
            RfUtils.createOpenAction(this.getPluginConfig(), customDef, project, null, false).open();
            return false;
        }
        Object namedElement = element.getRfElement();
        if (!(namedElement instanceof RfNamedElement)) {
            return false;
        }
        RfNamedElementActionHyperlink createOpenAction = RfUtils.createOpenAction(this.getPluginConfig(), (RfNamedElement)namedElement, project, null);
        if (createOpenAction == null) {
            return false;
        }
        createOpenAction.open();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean gotoElement(IProject project, Object wrapper) {
        try {
            Object element = null;
            if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
                if (!(wrapper instanceof RfMacro)) {
                    return false;
                }
                element = wrapper;
            } else {
                element = ((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
            }
            if (element == null || !(element instanceof RfNamedElement)) {
                return false;
            }
            RfNamedElement namedElement = (RfNamedElement)element;
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), namedElement, project, null);
            if (actionHyperlink == null) {
                return false;
            }
            actionHyperlink.open();
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public MembersViewInput getMembersInput(IDVTElementWrapper wrapper, StringMatcher stringMatcher, IMembersLabelProvider defaultLabelProvider, boolean applyContentFilters) {
        ArrayList<IDVTElementWrapper> elements;
        boolean hasGUIFilteredMembers;
        block7: {
            RfNamedElement namedElemet;
            block6: {
                hasGUIFilteredMembers = false;
                MembersViewInput emptyResult = new MembersViewInput(Collections.emptyList(), false);
                if (wrapper == null) {
                    return emptyResult;
                }
                Object rfElement = wrapper.getRfElement();
                if (!(rfElement instanceof RfNamedElement)) {
                    return emptyResult;
                }
                namedElemet = (RfNamedElement)rfElement;
                elements = new ArrayList<IDVTElementWrapper>();
                if (!(namedElemet instanceof RfScalarType)) break block6;
                for (RfDefElement enumLayer : namedElemet.getLayers()) {
                    Collection<RfEnum> enums;
                    if (!(enumLayer instanceof RfScalarTypeLayer) || (enums = ((RfScalarTypeLayer)enumLayer).getEnums()) == null) continue;
                    for (RfNamedElement rfNamedElement : enums) {
                        boolean bl = hasGUIFilteredMembers = this.checkAndWrapMember(elements, null, rfNamedElement, stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
                    }
                }
                break block7;
            }
            if (!(namedElemet instanceof RfStruct)) break block7;
            HashSet<RfNamedElement> visited = new HashSet<RfNamedElement>();
            for (RfDefElement structLayer : ((RfStruct)namedElemet).getDeclarations()) {
                for (RfDefElement rfDefElement : structLayer.getChildren()) {
                    if (rfDefElement instanceof RfVarLayer || !visited.add(rfDefElement.getNamedElement())) continue;
                    boolean bl = hasGUIFilteredMembers = this.checkAndWrapMember(elements, rfDefElement, rfDefElement.getNamedElement(), stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
                }
            }
        }
        return new MembersViewInput(elements, hasGUIFilteredMembers);
    }

    private boolean checkAndWrapMember(List<IDVTElementWrapper> result, RfDefElement def, RfNamedElement member, StringMatcher stringMatcher, IMembersLabelProvider defaultLabelProvider, boolean applyContentFilters) {
        boolean hasGUIFilteredMembers = false;
        if (member == null) {
            return hasGUIFilteredMembers;
        }
        if (member instanceof RfVar) {
            return hasGUIFilteredMembers;
        }
        if (member instanceof RfExpect && ((RfExpect)member).isAnonymous()) {
            return hasGUIFilteredMembers;
        }
        if (member instanceof RfMethod && ((RfMethod)member).isByEvent()) {
            return hasGUIFilteredMembers;
        }
        AbstractRfTreeElementWrapper elementWrapper = this.getPluginConfig().createElementTreeWrapper(member, true);
        if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)defaultLabelProvider.getText((Object)elementWrapper))) {
            return hasGUIFilteredMembers;
        }
        if (applyContentFilters && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES_MEMBERS, (IRfNamedElement)member, () -> defaultLabelProvider.getText((Object)elementWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
            hasGUIFilteredMembers = true;
            return hasGUIFilteredMembers;
        }
        if (member.getDeclaration() != def || member.isPredefined()) {
            elementWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.TYPES_MEMBERS_DEF, def);
        }
        result.add(elementWrapper);
        return hasGUIFilteredMembers;
    }

    public IMembersLabelProvider getMembersLabelProvider() {
        return new TypesViewMembersLabelProvider();
    }
}

