/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.IEModule;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;

public abstract class AbstractEReflectionContributorCommon
implements IReflectionContributor {
    public boolean hasHits(IFile file, String[] names, Matcher matcher, boolean isRegexp) {
        return IdentifierIndexerManager.getInstance().hasHits(this.getPluginConfig().getIndexerClass(), file, names, matcher, isRegexp);
    }

    public boolean hasHits(ParserPath file, IProject project, String[] names, Matcher matcher, boolean isRegexp) {
        return IdentifierIndexerManager.getInstance().hasHits(this.getPluginConfig().getIndexerClass(), file, project, names, matcher, isRegexp);
    }

    public boolean isEnabled(IProject project) {
        try {
            return project.hasNature(this.getNature());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public abstract IEPluginConfig getPluginConfig();

    public IRfNamedElementAndScope getRfElement(IFile file, IDocument document, int offset, boolean validateContentType) {
        boolean validContentType;
        if (validateContentType && !(validContentType = RfSearchUtils.validContentType((IProject)file.getProject(), (IDocument)document, (int)offset))) {
            return null;
        }
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(file.getProject());
        return RfUtils.getRfElement(rfProject, file, document, offset, false);
    }

    public IRfSingleLangProject makeRfProject(IProject project, RfMixedLangProject rfMixedLangProject) {
        return new RfProject(project, rfMixedLangProject, this.getPluginConfig().getRfManager());
    }

    public PersistenceBase makePersistence(IProject project) {
        return null;
    }

    public IRfKind getKind(IRfNamedElement e) {
        return RfKind.of(e);
    }

    public void clearBacklogElements(IProject project) {
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
        if (rfProject != null) {
            rfProject.getChangedFilesManager().clear();
        }
    }

    public void addBacklogElement(IProject project, FileCompileInfo info) {
        RfProject rfProjectWithoutRestore = this.getPluginConfig().getRfManager().getRfProjectWithoutRestore(project);
        if (rfProjectWithoutRestore == null) {
            return;
        }
        IEModule module = this.getPluginConfig().getModelManager().getEModel().getEModule(info.getFile());
        if (module != null) {
            rfProjectWithoutRestore.getChangedFilesManager().addBacklogElements(new LinkedHashSet<FileCompileInfo>(Collections.singleton(info)));
        }
    }

    public Set<FileCompileInfo> getChangedElements(IProject project) {
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
        if (rfProject != null) {
            rfProject.getChangedFilesManager().getBacklogElements();
        }
        return null;
    }

    public void cbIncrementalBuild(IProgressMonitor monitor, FileCompileInfo changedElement, IDocument document, IProject project) {
        this.getPluginConfig().getModelManager().cbIncrementalBuild(monitor, changedElement, document, true);
    }
}

