/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.edt.base.model.reflection.AbstractRfManagerCommon;
import ro.amiq.edt.base.model.reflection.RfProject;

public abstract class AbstractRfManager
extends AbstractRfManagerCommon {
    public boolean hasDictionary(IProject project) {
        try {
            String file = BuildConfigManager.getModelPersistenceLocation((IProject)project, (String)this.getRFDMDirName(), (boolean)true, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
            return new File(file).exists();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    @Override
    protected void openRebuildDialog(IProject project) {
        if (this.fFullBuildProjectLockMap.contains(project)) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "DVT Version Changed", null, "DVT version changed. It is recommended to rebuild '" + project.getName() + "' project for refreshing dictionary, errors etc.", 4, new String[]{"Rebuild Now", "Later"}, 0);
            if (dialog.open() != 0) {
                return;
            }
            if (this.fFullBuildProjectLockMap.contains(project)) {
                return;
            }
            DVTBuildUtils.runInternalBuilder((IProject)project);
        });
    }

    public void activeTestChangedNotification(IProject project) {
        if (project != null) {
            RfProject rfProject = this.getRfProject(project);
            rfProject.activeTestChangedNotification();
            BuildEventManager.getInstance().notifyIncrementalBuild(project, null, ViewsUtils.ALL_VIEWS);
        }
    }
}

