/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.ChecksKindWrapper;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTMixedLangBuildListener;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversManager;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.reflection.IDVTRfManager;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.IIdleListener;
import ro.amiq.dvt.model.reflection.util.IdleHandler;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.utils.MemUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.IEBuildListener;
import ro.amiq.edt.base.model.IEModule;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;

public abstract class AbstractRfManagerCommon
implements IDVTRfManager,
IEBuildListener,
IDVTMixedLangBuildListener {
    public static final int MAX_PROJECTS_CACHE_SIZE = 20;
    protected Set<IProject> fFullBuildProjectLockMap = Collections.newSetFromMap(new ConcurrentHashMap());
    protected BlockingQueue<SaveModuleRunnable> fSaveModuleInfoPipe = new ArrayBlockingQueue<SaveModuleRunnable>(500);
    private Thread fSaveModuleInfoThread = new Thread(() -> {
        try {
            while (true) {
                SaveModuleRunnable runnable = this.fSaveModuleInfoPipe.take();
                runnable.run();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
    });
    protected final Comparator<RfModule> fModuleSorter = (o1, o2) -> {
        if (o1.getModuleIndex() < o2.getModuleIndex()) {
            return -1;
        }
        return 1;
    };

    protected void init() {
        this.fSaveModuleInfoThread.start();
        IdleHandler.addIdleListener((IIdleListener)new IIdleListener(){

            public void platformIsIdle() {
            }

            public boolean isWriteDone() {
                return AbstractRfManagerCommon.this.fSaveModuleInfoPipe.isEmpty();
            }
        });
    }

    public abstract IEPluginConfig getPluginConfig();

    public void postIncrementalBuild(DVTFileInfo info) {
    }

    public void postBuildConfigIncrementalBuild(IProject project) {
    }

    public void postIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) {
    }

    public void performExtendedChecks(IProject project, ChecksKindWrapper checksKindWrapper) {
    }

    public RfProject getRfProject(IProject project) {
        return (RfProject)RfMixedLangManager.getInstance().getRfSingleLangProject(project, this.getPluginConfig().getNature(), true);
    }

    public RfProject getRfProjectWithoutRestore(IProject project) {
        return (RfProject)RfMixedLangManager.getInstance().getRfSingleLangProject(project, this.getPluginConfig().getNature(), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeRFDM(RfProject rfProject) {
        String file = BuildConfigManager.getModelPersistenceLocation((IProject)rfProject.getProject(), (String)this.getRFDMDirName(), (boolean)false, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
        if (file == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedOutputStream bof = new BufferedOutputStream(new FileOutputStream(file), 32768);
                try {
                    try (ObjectOutputStream oos = new ObjectOutputStream(bof);){
                        this.writeObject(oos, rfProject);
                        IIdentifierIndexerExtension indexer = IdentifierIndexerManager.getInstance().getProjectIndexer(this.getPluginConfig().getIndexerClass(), rfProject.getProject());
                        indexer.write(BuildConfigManagerCommon.PersistenceModeWrapper.regular());
                    }
                    if (bof == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bof == null) throw throwable;
                    bof.close();
                    throw throwable;
                }
                bof.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.writeRfDM()", (Throwable)e);
        }
    }

    public void clean(IDVTProject iDVTProject) {
        IEProject eProject = this.getModelManager().getIEProject(iDVTProject);
        if (eProject == null) {
            return;
        }
        IProject project = eProject.getProject();
        if (project == null) {
            return;
        }
        IdentifierIndexerManager.getInstance().getProjectIndexer(this.getPluginConfig().getIndexerClass(), eProject.getProject()).clean();
        RfProject rfProject = this.getRfProjectWithoutRestore(eProject.getProject());
        if (rfProject == null) {
            return;
        }
        rfProject.clean();
        try {
            if (MemUtils.COLLECT_STATS) {
                MemUtils.forceGC();
            }
        }
        catch (Exception exception) {}
    }

    public void fullBuild(DVTFileInfo dvtFileInfo) {
        RfProject rfProject;
        EModuleInfo info = this.getModelManager().getModuleInfo(dvtFileInfo);
        IProject project = info.getProject();
        if (project == null) {
            return;
        }
        if (!this.fFullBuildProjectLockMap.contains(project)) {
            this.fFullBuildProjectLockMap.add(project);
        }
        if ((rfProject = this.getRfProject(project)) == null) {
            return;
        }
        rfProject.build(info, false, true);
        if (!rfProject.isInSDLMode()) {
            this.getPluginConfig().getNameCheckerWarningsManager().build(1, info, project);
        }
        this.fSaveModuleInfoPipe.add(new SaveModuleRunnable(project, info));
    }

    public void postFullBuild(IDVTProject iDVTProject, boolean success) {
        IProject project = iDVTProject.getProject();
        this.fFullBuildProjectLockMap.remove(project);
        IEProject eProject = this.getModelManager().getIEProject(iDVTProject);
        if (!success) {
            this.clean(eProject);
        } else {
            RfProject rfProject = this.getRfProject(project);
            rfProject.postFullBuild(true, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void saveModuleInfo(IProject project, EModuleInfo moduleInfo) {
        ParserPath parserPath = moduleInfo.getParserPath();
        String file = BuildConfigManager.getModelPersistenceLocation((IProject)project, (String)(String.valueOf(Integer.toHexString(parserPath.hashCode())) + "_" + moduleInfo.getModuleIndex()), (boolean)false, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
        if (file == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                BufferedOutputStream bof = new BufferedOutputStream(new FileOutputStream(file), 32768);
                try {
                    try (ObjectOutputStream oos = new ObjectOutputStream(bof);){
                        oos.writeObject(moduleInfo);
                    }
                    if (bof == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bof == null) throw throwable;
                    bof.close();
                    throw throwable;
                }
                bof.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Error saving module '" + moduleInfo.getParserPath() + "' ", (Throwable)e);
        }
    }

    public void postMixedLangFullBuildPreElab(IProject project) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangFullBuild();
    }

    public void postMixedLangIncrementalBuildPreElab(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangIncrementalBuild(changedFiles.get(this.getPluginConfig().getLanguageKind()), updateViewIds);
    }

    public void clean(IDVTFile iDVTFile) {
        IEModule eModule = this.getModelManager().getIEModule(iDVTFile);
        IProject project = eModule.getFile().getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.clean(eModule);
    }

    public void remove(IDVTFile iDVTFile) {
        IEModule eModule = this.getModelManager().getIEModule(iDVTFile);
        IProject project = eModule.getFile().getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.remove(eModule);
        BuildEventManager.getInstance().notifyIncrementalBuild(project, null, null);
    }

    public void incrementalBuild(DVTFileInfo dvtFileInfo) {
        EModuleInfo info = this.getModelManager().getModuleInfo(dvtFileInfo);
        IProject project = info.getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        boolean saveRFDM = info.isSaveRFDM();
        rfProject.build(info, true, saveRFDM);
        if (!rfProject.isInSDLMode()) {
            this.getPluginConfig().getNameCheckerWarningsManager().build(0, info, project);
        }
        DVTProblemCategory category = rfProject.isInSLNMode() ? EProblemCategories.SLN_NAME_CHECKING : EProblemCategories.E_NAME_CHECKING;
        DVTProblemsUiUpdaterRegistry.get((String)category.getId()).scheduleObjectionsClear(project);
        if (saveRFDM) {
            this.fSaveModuleInfoPipe.add(new SaveModuleRunnable(project, info));
        }
    }

    public boolean preRestoreRfProject(RfProject rfProject) {
        block3: {
            try {
                IProject project = rfProject.getProject();
                if (project.exists() && project.isOpen() && project.isAccessible()) break block3;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return this.initRFDM(rfProject);
    }

    /*
     * Loose catch block
     */
    private boolean initRFDM(RfProject rfProject) {
        ObjectInputStream ois;
        BufferedInputStream bif;
        Throwable throwable;
        IProject project;
        block23: {
            block22: {
                project = rfProject.getProject();
                DVTProblemManager.getInstance().clearWaivers(project);
                CompileWaiversManager.INSTANCE.loadWaivers(project);
                DVTNature.updateDeprecatedProject((IProject)project);
                String fileName = BuildConfigManager.getModelPersistenceLocation((IProject)project, (String)this.getRFDMDirName(), (boolean)true, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
                if (fileName == null) {
                    return false;
                }
                File file = new File(fileName);
                if (!file.isFile()) {
                    return false;
                }
                throwable = null;
                Object var6_9 = null;
                bif = new BufferedInputStream(new FileInputStream(file), 32768);
                ois = new ObjectInputStream(bif);
                Object fullBuildList = ois.readObject();
                rfProject.setFullBuildModuleInfos((List)fullBuildList);
                IIdentifierIndexerExtension indexer = IdentifierIndexerManager.getInstance().getProjectIndexer(this.getPluginConfig().getIndexerClass(), rfProject.getProject());
                indexer.read(BuildConfigManagerCommon.PersistenceModeWrapper.regular());
                if (ois == null) break block22;
                ois.close();
            }
            if (bif == null) break block23;
            bif.close();
        }
        return true;
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (bif != null) {
                                bif.close();
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (InvalidClassException | OptionalDataException | ClassCastException | ClassNotFoundException e) {
                    DVTLogger.INSTANCE.logError("RfProject.initRfDM()", (Throwable)e);
                    this.openRebuildDialog(project);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError("RfProject.initRfDM()" + e.getMessage());
                }
            }
        }
        return false;
    }

    public void writeObject(ObjectOutputStream oos, RfProject rfProject) throws IOException {
        oos.writeObject(rfProject.getFullBuildModuleInfos());
    }

    protected AbstractEModelManager getModelManager() {
        return this.getPluginConfig().getModelManager();
    }

    public abstract String getRFDMDirName();

    protected abstract void openRebuildDialog(IProject var1);

    class SaveModuleRunnable
    implements Runnable {
        private IProject fProject;
        private EModuleInfo fInfo;

        public SaveModuleRunnable(IProject project, EModuleInfo info) {
            this.fProject = project;
            this.fInfo = info;
        }

        @Override
        public void run() {
            AbstractRfManagerCommon.this.saveModuleInfo(this.fProject, this.fInfo);
            this.fInfo.setModuleAST(null);
        }
    }
}

