/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.RfTemplateParam;

public class Determinant {
    private static final Pattern fWhitespace = Pattern.compile("\\s++");
    private static final Pattern fCustomize = Pattern.compile("\\s++'\\s++");
    private static final Pattern fDelPackage = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*::");
    private String[] fDeterminant;
    private List<IRfAssociatedType> fParameters;

    public Determinant(String fullName) {
        fullName = fDelPackage.matcher(fullName).replaceAll("");
        fullName = fCustomize.matcher(fullName).replaceAll("'");
        List<String> rawChunks = Arrays.asList(fWhitespace.split(fullName, 0));
        this.fDeterminant = Determinant.uniquify(rawChunks);
    }

    public void deepClean() {
        try {
            this.fParameters = null;
            this.fDeterminant = null;
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private static String[] uniquify(List<String> rawChunks) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        ArrayList<String> chunks = new ArrayList<String>();
        int i = rawChunks.size() - 1;
        while (i >= 0) {
            String rawChunk = rawChunks.get(i);
            if (rawChunk.startsWith("TRUE'")) {
                tickIndex = rawChunk.indexOf(39);
                booleanFieldName = rawChunk.substring(tickIndex + 1);
                if (!indexes.containsKey(rawChunk)) {
                    if (indexes.containsKey(booleanFieldName)) {
                        index = (Integer)indexes.get(booleanFieldName);
                        existingChunk = (String)chunks.get(index);
                        if (!rawChunk.equals(existingChunk) && booleanFieldName.equals(existingChunk)) {
                            chunks.set(index, rawChunk);
                            indexes.put(rawChunk, index);
                        }
                    } else {
                        indexes.put(booleanFieldName, chunks.size());
                        indexes.put(rawChunk, chunks.size());
                        chunks.add(rawChunk);
                    }
                }
            } else if (rawChunk.startsWith("FALSE'")) {
                tickIndex = rawChunk.indexOf(39);
                booleanFieldName = rawChunk.substring(tickIndex + 1);
                if (!indexes.containsKey(rawChunk) && !indexes.containsKey(booleanFieldName)) {
                    indexes.put(booleanFieldName, chunks.size());
                    indexes.put(rawChunk, chunks.size());
                    chunks.add(rawChunk);
                }
            } else {
                tickIndex = rawChunk.indexOf(39);
                if (tickIndex < 0) {
                    if (!indexes.containsKey(rawChunk)) {
                        indexes.put(rawChunk, chunks.size());
                        chunks.add(rawChunk);
                    }
                } else {
                    String enumItemName = rawChunk.substring(0, tickIndex);
                    if (!indexes.containsKey(rawChunk)) {
                        if (indexes.containsKey(enumItemName)) {
                            index = (Integer)indexes.get(enumItemName);
                            existingChunk = (String)chunks.get(index);
                            if (!rawChunk.equals(existingChunk)) {
                                if (enumItemName.equals(existingChunk)) {
                                    chunks.set(index, rawChunk);
                                    indexes.put(rawChunk, index);
                                } else {
                                    indexes.put(enumItemName, chunks.size());
                                    indexes.put(rawChunk, chunks.size());
                                    chunks.add(rawChunk);
                                }
                            }
                        } else {
                            indexes.put(enumItemName, chunks.size());
                            indexes.put(rawChunk, chunks.size());
                            chunks.add(rawChunk);
                        }
                    }
                }
            }
            --i;
        }
        Collections.reverse(chunks);
        return chunks.toArray(new String[chunks.size()]);
    }

    public Determinant(String[] determinant) {
        this.fDeterminant = determinant;
    }

    public Determinant(String[] prefix, String[] determinant) {
        ArrayList<String> rawChunks = new ArrayList<String>(Arrays.asList(prefix));
        rawChunks.addAll(Arrays.asList(determinant));
        this.fDeterminant = Determinant.uniquify(rawChunks);
    }

    public Determinant(String[] prefix, int fromIndex, String[] suffix) {
        this.fDeterminant = new String[prefix.length - fromIndex + suffix.length];
        System.arraycopy(prefix, fromIndex, this.fDeterminant, 0, prefix.length - fromIndex);
        System.arraycopy(suffix, 0, this.fDeterminant, prefix.length - fromIndex, suffix.length);
    }

    public static Determinant merge(String[] determinant1, String[] determinant2) {
        if (determinant1 != null && determinant2 != null && determinant1.length > 1 && determinant2.length > 0) {
            ArrayList<String> rawChunks = new ArrayList<String>(determinant1.length - 1 + determinant2.length);
            rawChunks.addAll(Arrays.asList(determinant1));
            rawChunks.remove(determinant1.length - 1);
            rawChunks.addAll(Arrays.asList(determinant2));
            String[] determinant = Determinant.uniquify(rawChunks);
            return new Determinant(determinant);
        }
        return new Determinant(determinant2);
    }

    public String[] toArray() {
        return this.fDeterminant;
    }

    public void setArray(String[] determinant) {
        this.fDeterminant = determinant;
    }

    public void removeLastName() {
        String[] temp = new String[this.fDeterminant.length - 1];
        System.arraycopy(this.fDeterminant, 0, temp, 0, this.fDeterminant.length - 1);
        this.fDeterminant = temp;
    }

    public boolean equals(Object obj) {
        if (this.fDeterminant == null) {
            return false;
        }
        if (obj instanceof Determinant) {
            Determinant determinant = (Determinant)obj;
            if (determinant.fDeterminant == null) {
                return false;
            }
            if (this.fDeterminant.length != determinant.fDeterminant.length) {
                return false;
            }
            if (this.fParameters != null && determinant.fParameters != null && this.fParameters.size() != determinant.fParameters.size()) {
                return false;
            }
            HashSet<Integer> ignoreIndexes = new HashSet<Integer>(this.fDeterminant.length);
            int i = this.fDeterminant.length - 1;
            while (i >= 0) {
                block13: {
                    String chunk1 = this.fDeterminant[i];
                    boolean true1 = chunk1.startsWith("TRUE'");
                    int index1 = chunk1.startsWith("FALSE'") ? -1 : chunk1.indexOf(39);
                    int j = determinant.fDeterminant.length - 1;
                    while (j >= 0) {
                        if (!ignoreIndexes.contains(j)) {
                            int index2;
                            String chunk2 = determinant.fDeterminant[j];
                            if (chunk1.equals(chunk2)) {
                                ignoreIndexes.add(j);
                                break block13;
                            }
                            boolean true2 = chunk2.startsWith("TRUE'");
                            if (true1 && !true2 && chunk1.substring(index1 + 1).equals(chunk2)) {
                                determinant.fDeterminant[j] = chunk1;
                                ignoreIndexes.add(j);
                                break block13;
                            }
                            int n = index2 = chunk2.startsWith("FALSE'") ? -1 : chunk2.indexOf(39);
                            if (!true1 && true2 && chunk1.equals(chunk2.substring(index2 + 1))) {
                                this.fDeterminant[i] = chunk2;
                                ignoreIndexes.add(j);
                                break block13;
                            }
                            if (!true1 && !true2 && index1 != -1 && index2 == -1 && chunk1.substring(0, index1).equals(chunk2)) {
                                determinant.fDeterminant[j] = chunk1;
                                ignoreIndexes.add(j);
                                break block13;
                            }
                            if (!true1 && !true2 && index1 == -1 && index2 != -1 && chunk1.equals(chunk2.substring(0, index2))) {
                                this.fDeterminant[i] = chunk2;
                                ignoreIndexes.add(j);
                                break block13;
                            }
                        }
                        --j;
                    }
                    return false;
                }
                --i;
            }
            return this.equalsParameters(determinant);
        }
        return false;
    }

    public boolean contains(Determinant subDeterminant) {
        return this.contains(subDeterminant, false);
    }

    public boolean contains(Determinant subDeterminant, boolean equals) {
        int distance = this.fDeterminant.length - subDeterminant.toArray().length;
        boolean result = false;
        if (this.fParameters != null ? subDeterminant.fParameters != null && this.fParameters.size() != subDeterminant.fParameters.size() : subDeterminant.fParameters != null) {
            return false;
        }
        if (distance < 0 || distance == 0 && !equals) {
            return false;
        }
        HashSet<Integer> ignoreIndexes = new HashSet<Integer>(this.fDeterminant.length);
        int i = this.fDeterminant.length - 1;
        while (i >= 0) {
            String chunk1 = this.fDeterminant[i];
            boolean true1 = chunk1.startsWith("TRUE'");
            int index1 = chunk1.indexOf(39);
            int j = subDeterminant.fDeterminant.length - 1;
            while (j >= 0) {
                if (!ignoreIndexes.contains(j)) {
                    String chunk2 = subDeterminant.fDeterminant[j];
                    if (chunk1.equals(chunk2)) {
                        ignoreIndexes.add(j);
                        break;
                    }
                    boolean true2 = chunk2.startsWith("TRUE'");
                    if (true1 && !true2 && chunk1.substring(index1 + 1).equals(chunk2)) {
                        subDeterminant.fDeterminant[j] = chunk1;
                        ignoreIndexes.add(j);
                        break;
                    }
                    int index2 = chunk2.indexOf(39);
                    if (!true1 && true2 && chunk1.equals(chunk2.substring(index2 + 1))) {
                        this.fDeterminant[i] = chunk2;
                        ignoreIndexes.add(j);
                        break;
                    }
                    if (!true1 && !true2 && index1 != -1 && index2 == -1 && chunk1.substring(0, index1).equals(chunk2)) {
                        subDeterminant.fDeterminant[j] = chunk1;
                        ignoreIndexes.add(j);
                        break;
                    }
                    if (!true1 && !true2 && index1 == -1 && index2 != -1 && chunk1.equals(chunk2.substring(0, index2))) {
                        this.fDeterminant[i] = chunk2;
                        ignoreIndexes.add(j);
                        break;
                    }
                }
                --j;
            }
            if (ignoreIndexes.size() == subDeterminant.fDeterminant.length) {
                result = true;
                break;
            }
            --i;
        }
        if (!result) {
            return false;
        }
        if (this.fParameters != null && subDeterminant.fParameters != null) {
            i = 0;
            while (i < this.fParameters.size()) {
                IRfAssociatedType param1 = this.fParameters.get(i);
                IRfAssociatedType param2 = subDeterminant.fParameters.get(i);
                if (param1 != null && param2 != null) {
                    IRfNamedElement assocType1 = param1.getAssociatedType();
                    IRfNamedElement assocType2 = param2.getAssociatedType();
                    if (assocType1 == null || !assocType1.equals(assocType2)) {
                        return false;
                    }
                } else {
                    return false;
                }
                ++i;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.internalCannonicRepresentation().hashCode();
    }

    private String internalCannonicRepresentation() {
        StringBuilder result = new StringBuilder();
        if (this.fDeterminant != null) {
            Object[] determinant = new String[this.fDeterminant.length];
            System.arraycopy(this.fDeterminant, 0, determinant, 0, this.fDeterminant.length - 1);
            Arrays.sort(determinant, 0, determinant.length - 1);
            determinant[determinant.length - 1] = this.fDeterminant[determinant.length - 1];
            Object[] objectArray = determinant;
            int n = determinant.length;
            int n2 = 0;
            while (n2 < n) {
                int index;
                Object chunk = objectArray[n2];
                boolean startTrue = ((String)chunk).startsWith("TRUE'");
                int n3 = index = ((String)chunk).startsWith("FALSE'") ? -1 : ((String)chunk).indexOf(39);
                if (startTrue) {
                    chunk = ((String)chunk).substring(index + 1);
                } else if (index > 0) {
                    chunk = ((String)chunk).substring(0, index);
                }
                if (result.length() == 0) {
                    result.append((String)chunk);
                } else {
                    result.append(':').append((String)chunk);
                }
                ++n2;
            }
        }
        if (this.fParameters != null) {
            for (IRfAssociatedType parameter : this.fParameters) {
                if (result.length() == 0) {
                    result.append(parameter == null ? "" : parameter.getAssociatedFullTypeName());
                    continue;
                }
                result.append(':').append(parameter == null ? "" : parameter.getAssociatedFullTypeName());
            }
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean replace) {
        StringBuilder result = new StringBuilder();
        if (this.fDeterminant != null) {
            String[] stringArray = this.fDeterminant;
            int n = this.fDeterminant.length;
            int n2 = 0;
            while (n2 < n) {
                String chunk = stringArray[n2];
                if (result.length() == 0) {
                    result.append(chunk);
                } else {
                    result.append(" ").append(chunk);
                }
                ++n2;
            }
        }
        if (this.fParameters != null) {
            result.append(" (");
            int i = 0;
            while (i < this.fParameters.size()) {
                String paramName;
                IRfAssociatedType param = this.fParameters.get(i);
                String string = paramName = param == null ? "" : param.getAssociatedFullTypeName();
                if (replace) {
                    paramName = paramName.replace("type>", "T>").replace("Type>", "T>").replace("exp>", "E>");
                }
                if (i == this.fParameters.size() - 1) {
                    result.append(paramName);
                } else {
                    result.append(paramName).append(", ");
                }
                ++i;
            }
            result.append(")");
        }
        return result.toString();
    }

    public String getName() {
        if (this.fDeterminant == null || this.fDeterminant.length == 0) {
            return null;
        }
        return this.fDeterminant[this.fDeterminant.length - 1];
    }

    public static final Determinant resolveTypeParam(Determinant determinant, IRfNamedElement paramValue) {
        if (determinant == null || determinant.fDeterminant == null || determinant.fDeterminant.length == 0) {
            return null;
        }
        String structName = determinant.fDeterminant[determinant.fDeterminant.length - 1];
        if (structName == null || structName.isEmpty()) {
            return null;
        }
        if (paramValue == null || structName.charAt(0) != '<') {
            return determinant;
        }
        String paramValueName = paramValue.getName();
        if (paramValue instanceof RfTemplateParam && ((RfTemplateParam)paramValue).getAssociatedTypeName() != null) {
            paramValueName = ((RfTemplateParam)paramValue).getAssociatedTypeName();
        }
        if (paramValueName == null) {
            return determinant;
        }
        if (paramValueName.equals(structName)) {
            return determinant;
        }
        String[] newDeterminant = new String[determinant.fDeterminant.length];
        System.arraycopy(determinant.fDeterminant, 0, newDeterminant, 0, newDeterminant.length - 1);
        newDeterminant[determinant.fDeterminant.length - 1] = paramValueName;
        return new Determinant(newDeterminant);
    }

    public void setTemplateInstanceParameters(List<IRfAssociatedType> parameters) {
        this.fParameters = parameters;
    }

    public boolean hasParameters() {
        return this.fParameters != null;
    }

    public List<IRfAssociatedType> getParameters() {
        return this.fParameters;
    }

    public String javaName() {
        if (this.fDeterminant == null || this.fDeterminant.length <= 1) {
            return "";
        }
        Object[] sortedDeterminant = new String[this.fDeterminant.length - 1];
        System.arraycopy(this.fDeterminant, 0, sortedDeterminant, 0, sortedDeterminant.length);
        Arrays.sort(sortedDeterminant);
        StringBuilder result = new StringBuilder();
        Object[] objectArray = sortedDeterminant;
        int n = sortedDeterminant.length;
        int n2 = 0;
        while (n2 < n) {
            Object determinantChunk = objectArray[n2];
            determinantChunk = ((String)determinantChunk).replace('\'', '_');
            result.append((String)determinantChunk).append("____");
            ++n2;
        }
        return result.toString();
    }

    public boolean equalsParameters(Determinant determinant) {
        if (this.fParameters == null || determinant.fParameters == null) {
            return true;
        }
        if (this.fParameters.size() != determinant.fParameters.size()) {
            return false;
        }
        int i = 0;
        while (i < this.fParameters.size()) {
            IRfAssociatedType param1 = this.fParameters.get(i);
            IRfAssociatedType param2 = determinant.fParameters.get(i);
            if (param1 != null && param2 != null) {
                IRfNamedElement assocType1 = param1.getAssociatedType();
                IRfNamedElement assocType2 = param2.getAssociatedType();
                if (assocType1 == null || !assocType1.equals(assocType2)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }
}

