/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import antlr.collections.AST;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.PePe;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.TypesWalker;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedCompiler;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedProcessor;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedWalker;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.ascomputed.ExprEvalWalker;
import ro.amiq.edt.base.model.reflection.ascomputed.RfValueHolder;
import ro.amiq.edt.base.model.reflection.ascomputed.base.AsComputedBase;
import ro.amiq.edt.base.model.reflection.ascomputed.base._Int;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.semantic.SemanticWalker;
import ro.amiq.etools.eparser.EGroup;
import ro.amiq.etools.eparser.EParser;
import ro.amiq.etools.eparser.IParsingInfo;
import ro.amiq.etools.eparser.IParsingListener;
import ro.amiq.etools.eparser.ModuleLoadedParsingInfo;

public class ExpEvaluator {
    private static final String AS_COMPUTED_NAME = "ExpEvalDummy";
    private static final String CLASS_NAME_BASE = "ExpEvalWrapper";
    private static final File EXP_EVAL_FILE;
    private static int UID;
    private String className = "ExpEvalWrapper" + UID++;
    private RfProject rfProject;
    private EModuleInfo eModuleInfo;
    private RfModule rfModule;
    private IEProject eProject;
    private AsComputedProcessor asComputedProcessor;

    static {
        File expEvalFile = null;
        try {
            expEvalFile = File.createTempFile("__dvt__exp_eval", ".e");
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
        EXP_EVAL_FILE = expEvalFile;
    }

    public ExpEvaluator(RfProject rfProject, EModuleInfo eModuleInfo, RfModule rfModule, AsComputedProcessor asComputedProcessor) {
        this.rfProject = rfProject;
        this.eModuleInfo = eModuleInfo;
        this.rfModule = rfModule;
        this.asComputedProcessor = asComputedProcessor;
    }

    private _Int quickTryNumber(String string) {
        if (!DVTStringUtil.isNumber((String)string)) {
            return null;
        }
        return new _Int(string);
    }

    private __etools_string quickTryLiteralString(String string) {
        if (string.length() < 2 || !string.startsWith("\"") || !string.endsWith("\"")) {
            return null;
        }
        if (string.charAt(string.length() - 2) == '\\' && string.length() > 2 && string.charAt(string.length() - 3) != '\\') {
            return null;
        }
        int i = 1;
        while (i < string.length() - 1) {
            char ch = string.charAt(i);
            if (ch == '\"') {
                if (string.charAt(i - 1) != '\\') {
                    return null;
                }
                if (i > 2 && string.charAt(i - 2) == '\\') {
                    return null;
                }
            }
            ++i;
        }
        return new __etools_string(StringEscapeUtils.unescapeJava((String)string.substring(1, string.length() - 1)));
    }

    public RfValueHolder eval(__etools_string expression_string) {
        if (expression_string == null) {
            return null;
        }
        String expressionString = expression_string.toString();
        Comparable<BigInteger> quickResult = this.quickTryNumber(expressionString);
        if (quickResult != null) {
            return new RfValueHolder(this.rfProject, quickResult);
        }
        quickResult = this.quickTryLiteralString(expressionString);
        if (quickResult != null) {
            return new RfValueHolder(this.rfProject, quickResult);
        }
        try {
            AST expAst;
            this.sanityCheck();
            IProject project = this.rfProject.getProject();
            this.eProject = this.rfProject.getModelManager().getEModel().getEProject(project);
            if (this.eProject == null) {
                throw new ExpEvaluatorException("Internal error: eProject is null.");
            }
            EParser eparser = this.rfProject.fFullBuildEParser;
            if (eparser == null) {
                eparser = this.eProject.getEParser();
            }
            if ((expAst = this.computeExpAst(eparser, expressionString)) == null) {
                throw new ExpEvaluatorException("Failed to parse expression:'" + expressionString + "'");
            }
            try {
                ExprEvalWalker wk = new ExprEvalWalker();
                RfValueHolder rfValueHolder = new RfValueHolder(this.rfProject, wk.expr(expAst));
                return rfValueHolder;
            }
            catch (Exception exception) {
                try {
                    this.rfProject.setTempDisableSemanticErrorReporting(true);
                    TypesWalker tw = new TypesWalker(this.rfProject, this.eModuleInfo, this.rfModule);
                    tw.setMaxModuleIndex();
                    tw.expr(expAst);
                    SemanticWalker smw = new SemanticWalker(this.rfProject, this.eModuleInfo, this.rfModule, false);
                    smw.setMaxModuleIndex();
                    smw.expr(expAst);
                    AsComputedWalker acw = new AsComputedWalker(this.rfProject, this.eModuleInfo, this.rfModule, this.eProject, false);
                    acw.start();
                    String translatedExp = acw.expr(expAst);
                    if (translatedExp == null) {
                        throw new ExpEvaluatorException("Translation failed.");
                    }
                    Set<RfType> referredTypes = acw.getReferredTypes();
                    Object execResult = this.evalExp(translatedExp, referredTypes);
                    if (execResult == null) {
                        throw new ExpEvaluatorException("Wrapper execution failed.");
                    }
                    RfValueHolder rfValueHolder = new RfValueHolder(this.rfProject, execResult);
                    this.rfProject.setTempDisableSemanticErrorReporting(false);
                    return rfValueHolder;
                }
                catch (Exception e) {
                    if (e instanceof ExpEvaluatorException) {
                        this.buildLogError(expressionString, e.getMessage());
                    } else {
                        this.buildLogError(expressionString, "Internal error: " + e.getMessage());
                    }
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.rfProject.setTempDisableSemanticErrorReporting(false);
        }
    }

    private void sanityCheck() throws ExpEvaluatorException {
        if (EXP_EVAL_FILE == null) {
            throw new ExpEvaluatorException("Failed to create temp file");
        }
    }

    private void buildLogError(String exp, String message) {
        DVTBuildConsole console;
        if (!this.asComputedProcessor.debugLog()) {
            return;
        }
        if (exp.length() > 100) {
            exp = exp.substring(0, 99).concat("...");
        }
        if ((console = DVTBuildConsoleRegistry.getConsole((IProject)this.getProject())) == null) {
            return;
        }
        String messageToPrint = "*** Error: '" + message + "' \n while evaluating expression: '" + exp + "'";
        console.print(messageToPrint);
    }

    private AST computeExpAst(EParser eParser, String expressionString) {
        try {
            int line = -1234567890;
            if (eParser != null) {
                return PePe.parseExpression(eParser, new EGroup(expressionString, line, 0, 1, expressionString.length(), false), "exp", false);
            }
            EGroup eGroup = new EGroup(expressionString, line, 0, 1, expressionString.length(), false);
            if (AsComputedBase.__etools_e_module != null) {
                return AsComputedBase.__etools_e_module.pE(eGroup, "exp", false);
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object evalExp(String expr, Set<RfType> references) {
        try {
            AsComputedCompiler.getInstance().clean(false);
            boolean debugLog = this.asComputedProcessor.debugLog();
            StringBuilder content = new StringBuilder("package ").append("ro.amiq.edt.base.debug.ascomputed").append(";\n").append("import ro.amiq.dvt.model.reflection.*;\n").append("import static ro.amiq.edt.base.debug.ascomputed.__etools_main_global.*;\n").append("import ro.amiq.edt.base.model.reflection.*;\n").append("import ro.amiq.edt.base.model.reflection.ascomputed.*;\n\n").append("import ro.amiq.etools.eparser.EModuleLexer;\n").append("import ro.amiq.edt.base.model.reflection.ascomputed.base.*;\n\n").append("import java.util.regex.*;\n").append("import java.util.*;\n\n").append("public final class ").append(this.className).append(" extends __etools_main_ntv {\n\n").append("    public final Object evaluate() throws Exception {\n").append("        try {\n").append("return ").append(expr).append(";").append("        \n").append("        } catch (AsComputedReturnException e) {\n").append("                return null;\n").append("        } catch (Exception e) {\n").append("        } finally {\n").append("        }\n").append("        return null;\n").append("    }\n\n").append("}\n");
            references.add(this.rfProject.getType("main", true, 1, "base_struct", -1));
            references.add(this.rfProject.getType("main", true, 1, "any_struct", -1));
            references.add(this.rfProject.getType("main", true, 1, "ntv", -1));
            references.add(this.rfProject.getType("main", true, 1, "global", -1));
            ClassEncap classEncap = new ClassEncap(content.toString(), references, false);
            AsComputedCompiler.getInstance().setDebugLog(debugLog);
            Map<String, Map<String, String>> cachedModuleClasses = this.asComputedProcessor.getCachedModuleClasses();
            boolean generateAndCompileClasses = false;
            Map<String, String> macroCachedModuleClasses = cachedModuleClasses.get(this.className);
            if (macroCachedModuleClasses == null) {
                macroCachedModuleClasses = new HashMap<String, String>();
                cachedModuleClasses.put(this.className, macroCachedModuleClasses);
                generateAndCompileClasses = true;
            }
            if (generateAndCompileClasses) {
                try {
                    boolean newElementsToTranslate = true;
                    while (newElementsToTranslate) {
                        macroCachedModuleClasses.clear();
                        newElementsToTranslate = this.asComputedProcessor.genClassEncaps(macroCachedModuleClasses, classEncap.getRefered());
                    }
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                }
                String classContent = classEncap.getContent();
                macroCachedModuleClasses.put(this.className, classContent);
                boolean[] nothingToCompile = new boolean[1];
                boolean success = AsComputedCompiler.getInstance().doCompile(macroCachedModuleClasses, null, nothingToCompile);
                if (!success) {
                    macroCachedModuleClasses.clear();
                    if (debugLog) {
                        DVTLogger logger = DVTLogger.INSTANCE;
                        logger.logDebug("AS_COMPUTED: *** ERROR: Java class '" + this.className + "' or a dependency has compilation errors.");
                        AsComputedCompiler.getInstance().printErrors(this.getProject(), this.asComputedProcessor.getDebugPath());
                    }
                    return null;
                }
            }
            Object result = null;
            Class<?> javaClass = AsComputedCompiler.getInstance().getClassLoader().loadClass("ro.amiq.edt.base.debug.ascomputed" + '.' + this.className);
            if (javaClass == null) {
                DVTBuildConsole console;
                DVTLogger.INSTANCE.logDebug("AS_COMPUTED: *** ERROR: Cannot load compiled class '" + this.className + "'");
                if (debugLog && (console = DVTBuildConsoleRegistry.getConsole((IProject)this.getProject())) != null) {
                    String messageToPrint = "*** Error: COMPILER_ERROR: Cannot load compiled class '" + this.className + "'";
                    console.print(messageToPrint);
                }
                return null;
            }
            if (debugLog) {
                DVTLogger.INSTANCE.logDebug("AS_COMPUTED: Look for class '" + AS_COMPUTED_NAME + "' ...");
                DVTLogger.INSTANCE.logDebug("AS_COMPUTED: Class '" + AS_COMPUTED_NAME + "' found. Invoke constructor...");
            }
            Object theObject = javaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method theMethod = javaClass.getDeclaredMethod("evaluate", new Class[0]);
            try {
                result = theMethod.invoke(theObject, new Object[0]);
                if (result == null) {
                    return null;
                }
            }
            catch (InvocationTargetException e) {
                DVTBuildConsole console;
                Throwable invocationException = e.getCause();
                if (debugLog && (console = DVTBuildConsoleRegistry.getConsole((IProject)this.rfProject.getProject())) != null) {
                    this.printExecutionError(invocationException, console);
                }
                DVTLogger.INSTANCE.logError(invocationException);
            }
            if (result != null) {
                return result;
            }
            if (debugLog) {
                DVTLogger logger = DVTLogger.INSTANCE;
                logger.logDebug("AS_COMPUTED: *** CLASS RESULT IS NULL: " + this.className);
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private void printExecutionError(Throwable invocationException, DVTBuildConsole console) {
        StackTraceElement[] stack = invocationException.getStackTrace();
        if (stack != null && stack[0] != null) {
            String messageToPrint = "*** Error: EXECUTION_ERROR: " + invocationException + "\n    at line " + stack[0].getLineNumber() + " in " + stack[0].getFileName();
            console.print(messageToPrint);
        } else {
            String messageToPrint = "*** Error: EXECUTION_ERROR: " + invocationException;
            console.print(messageToPrint);
        }
    }

    private IProject getProject() {
        return this.rfProject.getProject();
    }

    private AST recursiveLookupNodeWithText(AST ast, String text) {
        if (text == null || ast == null) {
            return null;
        }
        if (text.equals(ast.getText())) {
            return ast;
        }
        AST candidate = this.recursiveLookupNodeWithText(ast.getFirstChild(), text);
        if (candidate != null) {
            return candidate;
        }
        return this.recursiveLookupNodeWithText(ast.getNextSibling(), text);
    }

    static class AstCollector
    implements IParsingListener {
        private AST resultAst;

        AstCollector() {
        }

        public void parsing(IParsingInfo arg0) {
            try {
                if (!(arg0 instanceof ModuleLoadedParsingInfo)) {
                    return;
                }
                this.resultAst = ((ModuleLoadedParsingInfo)arg0).getModuleAST();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        public AST getAst() {
            return this.resultAst;
        }
    }

    static class ExpEvaluatorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ExpEvaluatorException(String message) {
            super(message);
        }
    }
}

