/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.WrapperType;

public class RfArg
extends RfVar
implements ListContainer<RfArg> {
    public static final String ARG_IGNORE_ARGS = "__dvt_ignore_args";
    public static final String ARG_VARIABLE_NOF_ARGS = "__dvt_variable_nof_args";
    private RfMethod fMethod;

    public RfArg(RfProject project, RfModule module, String name, WrapperType type, RfMethod method, RfStruct parentStruct) {
        super(project, module, parentStruct, name, type, false);
        this.fMethod = method;
    }

    @Override
    public void deepClean() {
        try {
            this.fMethod = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    public String getSignature() {
        String typeName = this.getAssociatedFullTypeName();
        if (typeName != null && this.getAssociatedTypeKind() == 13) {
            typeName = typeName.replace("<", "&lt;").replace(">", "&gt;");
        }
        int i = 0;
        while (i < this.getAssociatedTypeList()) {
            typeName = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeName});
            ++i;
        }
        return "argument " + this.getName() + (typeName == null ? "" : " : " + typeName);
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (super.checkEquals(obj)) {
            return true;
        }
        return obj instanceof RfArg && ((RfArg)obj).getName().equals(this.getName()) && this.getMethod() == ((RfArg)obj).getMethod();
    }

    public RfMethod getMethod() {
        return this.fMethod;
    }

    @Override
    public String getComment(boolean removeHTMLTags) {
        String result = super.getComment(removeHTMLTags);
        if (result == null || result.isEmpty()) {
            result = "";
            RfMethod enclosingScope = this.getMethod();
            String enclosingScopeComment = enclosingScope != null ? enclosingScope.getComment() : null;
            result = DVTUtilsCommon.INSTANCE.getAtParamComment(this.getName(), enclosingScopeComment);
        }
        return result;
    }

    public RfArg internalThis() {
        return this;
    }
}

