/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfConstraintLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.WrapperType;

public class RfConstraint
extends RfStructMember {
    public RfConstraint(RfProject project, RfStruct parentStruct, FullName name) {
        super(project, name, parentStruct);
    }

    public String getSignature() {
        return this.getSignature(null);
    }

    @Override
    public String getSignature(String typeName) {
        return "constraint " + this.getParentStruct().getName() + "." + this.getName();
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        try {
            if (currLayer instanceof RfConstraintLayer) {
                String name = this.getName();
                RfStructMember.FirstAndPrevLayer firstAndPrevLayer = this.getFirstAndPrevLayer(project, (RfConstraintLayer)currLayer);
                RfStruct parentStruct = this.getParentStruct();
                if (firstAndPrevLayer == null || firstAndPrevLayer.prevRawLayer == null) {
                    RfStruct firstStruct = firstAndPrevLayer == null ? null : firstAndPrevLayer.firstStruct;
                    boolean isFirstLayer = this.isFirstLayer(currLayer);
                    if (!(firstStruct != null && firstStruct != parentStruct || isFirstLayer)) {
                        String errorMessage = "UNDEFINED_CONSTRAINT: Constraint ''{0}.{1}'' was not defined previously";
                        project.addSemanticError1(1, errorMessage, lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), this.getName());
                    }
                    return;
                }
                RfDefElement firstLayer = firstAndPrevLayer.firstLayer;
                RfDefElement prevLayer = firstAndPrevLayer.prevLayer;
                RfDefElement prevRawLayer = firstAndPrevLayer.prevRawLayer;
                if (prevRawLayer != null && this.isFirstLayer(currLayer)) {
                    project.addSemanticError1(1, "REDEFINED_CONSTRAINT: Constraint ''{0}.{1}'' was previously defined (must use ''is only'')\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, prevRawLayer.getStartLine(), prevRawLayer.getLayerModule().getParserPath());
                    return;
                }
                if (firstLayer instanceof RfConstraintLayer && prevLayer != null && ((RfConstraintLayer)currLayer).getNamedElement() == ((RfConstraintLayer)prevLayer).getNamedElement() && this.isFirstLayer(currLayer) && this.isFirstLayer(prevLayer)) {
                    project.addSemanticError1(1, "REDEFINED_CONSTRAINT: Constraint ''{0}.{1}'' was previously defined (must use ''is only'')\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, prevLayer.getStartLine(), prevLayer.getLayerModule().getParserPath());
                }
            }
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean isFirstLayer(RfDefElement layer) {
        return layer.getLayerKind() == 378;
    }

    @Override
    public boolean isLocalPredefined() {
        return false;
    }

    @Override
    public String getAssociatedFullTypeName() {
        return null;
    }

    @Override
    public void setAssociatedType(RfModule module, WrapperType typeInfo) {
    }

    public String getAssociatedTypeName() {
        return null;
    }

    @Override
    public String getDefStructLayerName() {
        return null;
    }

    @Override
    int getMemberKind() {
        return 7;
    }
}

