/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.WrapperType;

public class RfCoverItem
extends RfVar {
    private int fCoverItemKind = 0;
    private List<String> fCoverCrossItems;

    public RfCoverItem(RfProject project, RfModule module, RfStruct parentStruct, String name, WrapperType typeInfo, boolean takeVarOrFieldType) {
        super(project, module, parentStruct, name, typeInfo, takeVarOrFieldType);
    }

    public RfCoverItem(RfProject project, String name) {
        super(project, name);
    }

    @Override
    public String getSignature() {
        switch (this.fCoverItemKind) {
            case 0: {
                String typeName = this.getAssociatedFullTypeName();
                if (typeName != null && this.getAssociatedTypeKind() == 13) {
                    typeName = typeName.replace("<", "&lt;").replace(">", "&gt;");
                }
                int i = 0;
                while (i < this.getAssociatedTypeList()) {
                    typeName = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeName});
                    ++i;
                }
                return "coverage item " + this.getName() + (typeName == null ? "" : " : " + typeName);
            }
            case 1: {
                return "coverage cross " + this.getName();
            }
        }
        return "coverage transition " + this.getName();
    }

    @Override
    public boolean resolveType(boolean incremental, ParserPath parserPath, RfProject project, IRfScope enclosing) {
        return false;
    }

    @Override
    public void setKind(int coverItemKind) {
        this.fCoverItemKind = coverItemKind;
    }

    @Override
    public void setCoverCrossItems(List<String> coverCrossItems) {
        this.fCoverCrossItems = coverCrossItems;
    }

    public List<String> getCoverCrossItems() {
        return this.fCoverCrossItems;
    }

    @Override
    public int getKind() {
        return this.fCoverItemKind;
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj instanceof RfField && ((RfField)obj).getParentStruct() == this.fParentStruct && this.getName().equals(((RfField)obj).getName())) {
            return true;
        }
        return super.checkEquals(obj);
    }
}

