/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.reflection.IModuleDocumentListener;
import ro.amiq.edt.base.model.reflection.IRfLayersParent;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfVarLayer;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedModule;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.utils.Utils;
import ro.amiq.etools.eparser.ReparseElement;

public abstract class RfDefElement
implements IAdaptable,
IModuleDocumentListener,
Comparable<RfDefElement>,
IRfDefElement,
IRfLayersParent,
IRfVHBreadcrumbElement,
ListContainer<RfDefElement> {
    public static final LineInfo MAX_LINE_INFO = new LineInfo(Integer.MAX_VALUE, Integer.MAX_VALUE, -1);
    public static final int IS_LAYER = 0;
    public static final int EXTEND_LAYER = 1;
    public static final int WHEN_LAYER = 2;
    public static final int SM_ON_EVENT_LAYER = 74;
    public static final int SM_IS_EMPTY_LAYER = 371;
    public static final int SM_IS_UNDEFINED_LAYER = 372;
    public static final int SM_IS_INLINE_LAYER = 373;
    public static final int SM_IS_INLINE_ONLY_LAYER = 374;
    public static final int SM_IS_FIRST_LAYER = 375;
    public static final int SM_IS_ALSO_LAYER = 376;
    public static final int SM_IS_ONLY_LAYER = 377;
    public static final int SM_IS_LAYER = 378;
    public static final int ALL_OF_ACTION = 172;
    public static final int FIRST_OF_ACTION = 173;
    public static final int START_ACTION = 141;
    private int fStartLine;
    private int fEndLine;
    private int fStartRealOffset;
    private int fStartVirtualOffset;
    private int fEndRealOffset;
    private int fEndVirtualOffset;
    private int fLayerKind;
    private CommentBlock fLayerComment;
    private boolean fImplicit;
    private RfNamedElement fNamedElement;
    private Position fPosition;
    private RfModule fLayerModule;
    private ListContainer<RfDefElement> fChildrenDefs;
    private ReparseElement[] fReparseStack;

    public RfDefElement(RfModule module, IRfLayersParent parent, int kind, LineInfo startLine, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        this.fLayerModule = module;
        this.fStartLine = startLine == null ? -1 : startLine.line;
        this.fEndLine = endLine == null ? -1 : endLine.line;
        this.fStartRealOffset = startLine == null ? -1 : startLine.realOffset;
        this.fStartVirtualOffset = startLine == null ? -1 : startLine.virtOffset;
        this.fEndRealOffset = endLine == null ? -1 : endLine.realOffset;
        this.fEndVirtualOffset = endLine == null ? -1 : endLine.virtOffset;
        this.fLayerKind = kind;
        this.fLayerComment = comment;
        this.fReparseStack = reparseStack;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void deepClean() {
        this.fLayerModule = null;
        this.fLayerComment = null;
        this.fNamedElement = null;
        this.fPosition = null;
        this.fReparseStack = null;
        if (this.fChildrenDefs != null && !this.fChildrenDefs.isEmpty()) {
            for (RfDefElement layer : this.fChildrenDefs) {
                RfNamedElement namedElement;
                if (layer.getChildren() == this.fChildrenDefs || (namedElement = layer.getNamedElement()) == null) continue;
                namedElement.deepClean();
            }
        }
    }

    public RfModule getLayerModule() {
        return this.fLayerModule;
    }

    public IRfFileDef getDefFile() {
        return this.fLayerModule;
    }

    public IRfScope getEnclosingScope() {
        return null;
    }

    public ParserPath getParserPath() {
        if (this.fLayerModule == null) {
            return null;
        }
        return this.fLayerModule.getParserPath();
    }

    public LanguageKind getLanguageKind() {
        if (this.fLayerModule == null) {
            return null;
        }
        return this.fLayerModule.getLanguageKind();
    }

    public ReparseElement[] getReparseStack() {
        return this.fReparseStack;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public LibraryPackageScope getLibPkgScope() {
        return new LibraryPackageScope("work", this.getPackageName(), null);
    }

    public Object getInternalAdapter(Class adapter) {
        if (adapter == IResource.class && this.fLayerModule != null) {
            return this.fLayerModule.getAdapter(adapter);
        }
        return null;
    }

    public void setLayerComment(CommentBlock comment) {
        this.fLayerComment = comment;
    }

    public String getLayerComment() {
        return this.getLayerComment(true);
    }

    public CommentBlock getLayerCommentBlock() {
        return this.fLayerComment;
    }

    public String getLayerComment(boolean removeHTMLTags) {
        String comment;
        String string = comment = this.fLayerComment == null ? null : this.fLayerComment.toRawString();
        if (comment == null) {
            return "";
        }
        if (!removeHTMLTags) {
            return comment;
        }
        comment = DVTStringUtil.replaceAll((Pattern)RfUtils.HTML_TAGS_PATTERN, (CharSequence)comment, (String)"");
        comment = comment.replace("&lt;", "<").replace("&gt;", ">");
        return comment;
    }

    public void setNamedElement(RfNamedElement element) {
        this.fNamedElement = element;
        if (this.fNamedElement != null && this.getLayerComment(false).contains("@non_standard")) {
            this.fNamedElement.setNonStandard(true);
        }
    }

    public RfNamedElement getNamedElement() {
        return this.fNamedElement;
    }

    @Override
    public void addChild(RfDefElement child) {
        this.fChildrenDefs = OptimizedUtils.listContainerAdd(this.fChildrenDefs, (Object)child);
    }

    @NotNull
    public List<RfDefElement> getChildren() {
        if (this.fChildrenDefs == null) {
            return Collections.emptyList();
        }
        return OptimizedUtils.asList(this.fChildrenDefs, (boolean)false);
    }

    protected void cleanChildrenLayers() {
        if (this.fChildrenDefs == null || this.fChildrenDefs.isEmpty()) {
            return;
        }
        for (RfDefElement layer : this.fChildrenDefs) {
            if (layer.getChildren() == this.fChildrenDefs) continue;
            RfNamedElement namedElement = layer.getNamedElement();
            if (namedElement != null) {
                namedElement.removeLayer(layer);
            }
            layer.cleanChildrenLayers();
        }
        this.fChildrenDefs = OptimizedUtils.listContainerClear(this.fChildrenDefs);
    }

    @Override
    public void connectPositionToDocument(IDocument document, List<Position> reflectionPositions) {
        try {
            if (document == null) {
                return;
            }
            if (this.fStartVirtualOffset > 0) {
                return;
            }
            if (this.fStartRealOffset > 0 && this.fEndRealOffset >= this.fStartRealOffset && document.getLength() > this.fEndRealOffset) {
                DVTPosition position = new DVTPosition(this.fStartRealOffset, this.fEndRealOffset - this.fStartRealOffset + 1);
                this.fPosition = position;
                reflectionPositions.add(this.fPosition);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void removePosition() {
        this.fPosition = null;
    }

    public boolean isUsingOffsets() {
        return this.fPosition != null;
    }

    public boolean containsOffset(int offset) {
        return this.getStartOffset() <= offset && offset <= this.getEndOffset();
    }

    public int getStartLine() {
        int result;
        if (this.fPosition != null && !this.fPosition.isDeleted && this.fPosition.length > 0 && this.fLayerModule != null && (result = this.fPosition.offset) >= 0) {
            this.fStartRealOffset = result;
            this.fStartLine = Utils.convertPositionToLine(this.fLayerModule.getDocument(), this.fStartRealOffset);
        }
        return this.fStartLine;
    }

    public int getEndLine() {
        int result;
        if (this.fPosition != null && !this.fPosition.isDeleted && this.fPosition.length > 0 && this.fLayerModule != null && (result = this.fPosition.offset + this.fPosition.length - 1) >= 0) {
            this.fEndRealOffset = result;
            this.fEndLine = Utils.convertPositionToLine(this.fLayerModule.getDocument(), this.fEndRealOffset);
        }
        return this.fEndLine;
    }

    public int getStartOffset() {
        int result;
        if (this.fPosition != null && !this.fPosition.isDeleted && this.fPosition.length > 0 && this.fLayerModule != null && (result = this.fPosition.offset) >= 0) {
            this.fStartRealOffset = result;
            this.fStartLine = Utils.convertPositionToLine(this.fLayerModule.getDocument(), this.fStartRealOffset);
        }
        return this.fStartRealOffset;
    }

    public LineInfo getStartInfo() {
        return new LineInfo(this.fStartLine, this.fStartRealOffset, this.fStartVirtualOffset);
    }

    public LineInfo getEndInfo() {
        return new LineInfo(this.fEndLine, this.fEndRealOffset, this.fEndVirtualOffset);
    }

    public int getEndOffset() {
        int result;
        if (this.fPosition != null && !this.fPosition.isDeleted && this.fPosition.length > 0 && this.fLayerModule != null && (result = this.fPosition.offset + this.fPosition.length - 1) >= 0) {
            this.fEndRealOffset = result;
            this.fEndLine = Utils.convertPositionToLine(this.fLayerModule.getDocument(), this.fEndRealOffset);
        }
        return this.fEndRealOffset;
    }

    public String getKindAsString() {
        switch (this.getLayerKind()) {
            case 74: {
                return "on";
            }
            case 371: {
                return "is empty";
            }
            case 372: {
                return "is undefined";
            }
            case 373: {
                return "is inline";
            }
            case 374: {
                return "is inline only";
            }
            case 375: {
                return "is first";
            }
            case 376: {
                return "is also";
            }
            case 377: {
                return "is only";
            }
            case 378: {
                return "is";
            }
        }
        return "";
    }

    public RfProject getRfProject() {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getRfProject();
        }
        if (this.fLayerModule != null) {
            return this.fLayerModule.getRfProject();
        }
        return null;
    }

    public String getName() {
        if (this.getNamedElement() != null) {
            return this.getNamedElement().getName();
        }
        return null;
    }

    public void overwriteLayerEnd(LineInfo endLine) {
        this.fEndLine = endLine == null ? -1 : Math.max(this.fStartLine, endLine.line);
        this.fEndRealOffset = endLine == null ? -1 : Math.max(this.fStartRealOffset, endLine.realOffset);
    }

    public boolean isImplicit() {
        return this.fImplicit;
    }

    public void setImplicit(boolean isImplicit) {
        this.fImplicit = isImplicit;
    }

    public void setLayerKind(int layerKind) {
        this.fLayerKind = layerKind;
    }

    public int getLayerKind() {
        return this.fLayerKind;
    }

    public boolean isWhen() {
        return this.getLayerKind() == 2;
    }

    public boolean isExtend() {
        return this.getLayerKind() == 1;
    }

    public boolean isIs() {
        return this.getLayerKind() == 0;
    }

    public boolean isLike() {
        return this.getLayerKind() == 1 || this.getLayerKind() == 0;
    }

    public boolean isEmptyLayer() {
        return this.getLayerKind() == 371;
    }

    public String getPackageName() {
        if (this.fLayerModule == null) {
            return "main";
        }
        return this.fLayerModule.getPackageName();
    }

    public String getQualifiedPackageName() {
        return null;
    }

    public boolean isEnumType() {
        return false;
    }

    protected void setLayerModule(RfModule module) {
        this.fLayerModule = module;
    }

    public RfStructLayer getStructLayer() {
        return null;
    }

    public boolean isPredefined() {
        return false;
    }

    public boolean hasQualifiedName() {
        return false;
    }

    @Override
    public int compareTo(RfDefElement candidate) {
        int index2;
        RfModule module1 = this.getLayerModule();
        RfModule module2 = candidate.getLayerModule();
        if (module1 instanceof RfPredefinedModule && !(module2 instanceof RfPredefinedModule)) {
            return -1;
        }
        if (module2 instanceof RfPredefinedModule && !(module1 instanceof RfPredefinedModule)) {
            return 1;
        }
        if (module1 != null && module1 == module2) {
            return this.getStartOffset() - candidate.getStartOffset();
        }
        int index1 = module1 == null ? 0 : module1.getModuleIndex();
        int n = index2 = module2 == null ? 0 : module2.getModuleIndex();
        if (index1 >= 0 && index2 >= 0) {
            return index1 - index2;
        }
        if (index2 < 0) {
            return -1;
        }
        return 1;
    }

    public IResource getFileAdapter() {
        return (IResource)this.getInternalAdapter(IResource.class);
    }

    public boolean isSamePackageDefAs(RfDefElement layer) {
        RfStructLayer structLayer1 = this.getStructLayer();
        RfStructLayer structLayer2 = layer.getStructLayer();
        if (structLayer1 != null && structLayer2 != null) {
            RfStruct parent1 = structLayer1.getStruct();
            RfStruct parent2 = structLayer2.getStruct();
            if (parent1 != null && parent2 != null) {
                return parent1.getPackageName().equals(parent2.getPackageName());
            }
        }
        return true;
    }

    public int getModuleIndex() {
        RfModule layerModule = this.getLayerModule();
        if (layerModule == null) {
            return -1;
        }
        return layerModule.getModuleIndex();
    }

    public int getMaxModuleIndex() {
        RfModule layerModule = this.getLayerModule();
        if (layerModule == null) {
            return -1;
        }
        return layerModule.getMaxModuleIndex();
    }

    public String getUnderlineStartAliasName(String fieldName) {
        if (fieldName == null || fieldName.length() == 0 || fieldName.charAt(0) != '_') {
            return null;
        }
        RfModule layerModule = this.getLayerModule();
        if (layerModule == null) {
            return null;
        }
        String moduleName = layerModule.getName();
        if (moduleName == null) {
            return null;
        }
        int index = moduleName.lastIndexOf(46);
        if (index == -1) {
            return String.valueOf(moduleName) + "__" + fieldName;
        }
        return String.valueOf(moduleName.substring(0, index)) + "__" + fieldName;
    }

    public List<? extends IRfPackageElement> getPackagesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfPackageElement getPackageWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfNamedElement getLastNamedElement() {
        return this.getNamedElement();
    }

    public RfNamedElement semanticGetMember(RfProject project, String packageName, String name, EnumSet<IRfNamedElement.ElementKind> allowedElements, LineInfo lineInfo, int maxModuleIndex, ParserPath parserPath, RfNamedElement exclude) {
        return null;
    }

    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
    }

    public void setDefComment(CommentBlock comment) {
    }

    public RfModule get_module() {
        return this.getLayerModule();
    }

    protected void slnCollectActionBlockLabelRecursive(List<RfVarLayer> result, Set<RfDefElement> visited, RfActionBlockLayer.ActionKind actionKind, String name, LineInfo lineInfo, RfActionBlockLayer exclude, int maxNofCollectedElements) {
        try {
            this.internalSlnCollectActionBlockLabelRecursive(result, visited, actionKind, name, lineInfo, exclude, maxNofCollectedElements);
        }
        catch (StopDueToExcludeException stopDueToExcludeException) {}
    }

    protected void internalSlnCollectActionBlockLabelRecursive(List<RfVarLayer> result, Set<RfDefElement> visited, RfActionBlockLayer.ActionKind actionKind, String name, LineInfo lineInfo, RfActionBlockLayer exclude, int maxNofCollectedElements) throws StopDueToExcludeException {
        if (visited.contains(this)) {
            if (exclude == this) {
                throw new StopDueToExcludeException();
            }
            return;
        }
        visited.add(this);
        Collection defElements = this.getChildren();
        if (defElements == null || defElements.isEmpty()) {
            return;
        }
        for (RfDefElement defElement : defElements) {
            if (defElement.getClass() != RfActionBlockLayer.class) continue;
            if (exclude == defElement) {
                throw new StopDueToExcludeException();
            }
            if (((RfActionBlockLayer)defElement).getActionKind() == actionKind) {
                ((RfActionBlockLayer)defElement).collectLocalVariables(result, name, lineInfo, null, maxNofCollectedElements);
                if (result.size() >= maxNofCollectedElements) {
                    return;
                }
            }
            ((RfActionBlockLayer)defElement).internalSlnCollectActionBlockLabelRecursive(result, visited, actionKind, name, lineInfo, exclude, maxNofCollectedElements);
            if (result.size() < maxNofCollectedElements) continue;
            return;
        }
    }

    public boolean isPredefinedDef() {
        return this.getLayerModule() == null || this.getLayerModule().isPredefined();
    }

    public int getStartVirtualOffset() {
        return this.fStartVirtualOffset;
    }

    public int getEndVirtualOffset() {
        return this.fEndVirtualOffset;
    }

    public RfDefElement internalThis() {
        return this;
    }

    protected static class StopDueToExcludeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected StopDueToExcludeException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

