/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.diagrams.wavedrom.BitField;
import ro.amiq.dvt.diagrams.wavedrom.IBitFieldRegister;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.ascomputed.base.AsComputedBase;
import ro.amiq.edt.base.model.reflection.ascomputed.base._Int;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.regbitfields.BitfieldsUtils;
import ro.amiq.edt.base.model.reflection.util.RfUtils;

public class RfEnum
extends RfScalarType
implements IBitFieldRegister {
    private static final long TWO_TO_32_MINUS_1 = 0xFFFFFFFFL;
    protected String fValue;
    private LineInfo fLineInfo;
    private CommentBlock fCommentBlock;
    private boolean fIsExpression;
    public static final int MAX_VALUE_TEXT_SIZE = 15;

    public RfEnum(RfProject project, String name, LineInfo lineInfo, CommentBlock commentBlock, String valueText, boolean isExpression) {
        this(project, name, lineInfo, valueText, isExpression);
        this.fCommentBlock = commentBlock;
    }

    public RfEnum(RfProject project, String name, LineInfo lineInfo, String valueText, boolean isExpression) {
        this(project, name, lineInfo);
        this.fValue = DVTStringUtil.intern((String)valueText);
        this.fLineInfo = lineInfo;
        this.fIsExpression = isExpression;
    }

    public RfEnum(RfProject project, String name, LineInfo lineInfo) {
        super(project, name);
        this.fLineInfo = lineInfo;
    }

    @Override
    public int getLine() {
        if (this.fLineInfo == null) {
            return -1;
        }
        return this.fLineInfo.line;
    }

    public int getStartOffset() {
        if (this.fLineInfo == null || this.fLineInfo.virtOffset > 0) {
            return -1;
        }
        return this.fLineInfo.realOffset;
    }

    public int getOffset() {
        return this.getStartOffset();
    }

    public int getEndOffset() {
        if (this.fLineInfo == null || this.fLineInfo.virtOffset > 0) {
            return -1;
        }
        return this.fLineInfo.realOffset + this.getName().length();
    }

    public CommentBlock getCommentBlock() {
        return this.fCommentBlock;
    }

    @Override
    public String getComment() {
        return this.getComment(false);
    }

    @Override
    public String getComment(boolean removeHTMLTags) {
        String comment;
        String string = comment = this.fCommentBlock == null ? null : this.fCommentBlock.toRawString();
        if (comment == null) {
            return "";
        }
        if (!removeHTMLTags) {
            return comment;
        }
        comment = DVTStringUtil.replaceAll((Pattern)RfUtils.HTML_TAGS_PATTERN, (CharSequence)comment, (String)"");
        comment = comment.replace("&lt;", "<").replace("&gt;", ">");
        return comment;
    }

    @Override
    public String getRawUntrimmedComment(String inlineAboveDelimiter) {
        if (this.fCommentBlock == null) {
            return "";
        }
        return this.fCommentBlock.toRawUntrimmedString(inlineAboveDelimiter);
    }

    @Override
    public String getSignature() {
        RfModule layerModule;
        RfType assocType = this.getAssociatedType();
        if (assocType == null) {
            return null;
        }
        String predefined = "";
        RfDefElement parentLayer = this.getParentLayer();
        if (parentLayer != null && (layerModule = parentLayer.getLayerModule()) != null && layerModule.isInternalModule()) {
            predefined = "[predefined] ";
        }
        StringBuilder signatureBuilder = new StringBuilder();
        signatureBuilder.append("enum " + predefined + (((RfScalarType)assocType).isAnonymous() ? "" : String.valueOf(assocType.getName()) + ".") + this.getName());
        if (!this.fIsExpression) {
            _Int value = this.getValue(this.getRfProject());
            if (value != null) {
                signatureBuilder.append(" = " + value);
            }
        } else if (this.fValue.length() < 15) {
            signatureBuilder.append(" = " + this.fValue);
        } else {
            signatureBuilder.append(" = " + this.fValue.substring(0, 15) + "...");
        }
        return signatureBuilder.toString();
    }

    public String getSignatureTypeName() {
        RfType assocType = this.getAssociatedType();
        if (assocType == null) {
            return null;
        }
        return assocType.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public _Int getValue(RfProject project) {
        try {
            if (this.fValue != null) {
                _Int value = AsComputedBase.as_a(new __etools_string(this.fValue), _Int.class);
                if (value.intValue() >= 0) return value;
                return new _Int(Long.toString(0xFFFFFFFFL)).add(value).add(_Int.ONE);
            }
            String name = this.getName();
            if (name == null) return null;
            if (project == null) {
                return null;
            }
            RfType assocType = this.getAssociatedType();
            if (!(assocType instanceof RfScalarType)) {
                return null;
            }
            LinkedHashMap<String, RfEnum> allEnums = new LinkedHashMap<String, RfEnum>();
            ((RfScalarType)assocType).internalGetEnumsWithPrefix(project, allEnums, 2, "");
            if (allEnums.isEmpty()) {
                return null;
            }
            _Int value = new _Int(-1);
            Iterator iterator = allEnums.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return new _Int(value);
                }
                RfEnum enumItem = (RfEnum)iterator.next();
                if (enumItem.isExpression()) {
                    return null;
                }
                if (enumItem.fValue != null) {
                    _Int valueCandidate = AsComputedBase.as_a(new __etools_string(enumItem.fValue), _Int.class);
                    value = value.intValue() > valueCandidate.intValue() ? value : valueCandidate;
                    continue;
                }
                value = value.add(_Int.ONE);
                if (enumItem == this || name.equals(enumItem.getName())) break;
            }
            if (value.intValue() >= 0) return value;
            return new _Int(Long.toString(0xFFFFFFFFL)).add(value).add(_Int.ONE);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public RfDefElement getParentLayer() {
        List<RfDefElement> layers = this.internalGetLayers();
        if (layers.isEmpty()) {
            return null;
        }
        return layers.get(0);
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getParentLayer() == null) {
            return false;
        }
        if (!super.checkEquals(obj)) {
            return false;
        }
        if (((RfEnum)obj).getParentLayer() == null) {
            return false;
        }
        RfType parent1 = this.getAssociatedType();
        RfType parent2 = ((RfEnum)obj).getAssociatedType();
        if (parent1 == null || parent2 == null) {
            return false;
        }
        return parent1 == parent2;
    }

    @Override
    public void setAssociatedTypeFrom(RfProject project, RfNamedElement typeContainer) {
        super.setAssociatedTypeFrom(project, typeContainer);
    }

    @Override
    public RfType getAssociatedType() {
        return super.getAssociatedType();
    }

    @Override
    public String javaName() {
        return String.valueOf(this.javaTypeName()) + "." + this.javaBaseName();
    }

    public String javaBaseName() {
        return super.javaName();
    }

    @Override
    public String javaTypeName() {
        RfType assocType = this.getAssociatedType();
        if (assocType == null) {
            return "__INTERNAL_ERROR";
        }
        return ((RfNamedElement)assocType).javaName();
    }

    public Object getValueText() {
        return null;
    }

    public boolean isExpression() {
        return this.fIsExpression;
    }

    public int getBitFieldDiagramSize(ElementPath path) {
        return BitfieldsUtils.INSTANCE.getRegDataWidth(this.getRfProject());
    }

    public Map<Integer, List<BitField>> getBitFields(ElementPath path, int size) {
        LinkedHashMap<Integer, List<BitField>> lanes = new LinkedHashMap<Integer, List<BitField>>();
        Map<String, BitField> bitfields = BitfieldsUtils.INSTANCE.computeBitfields(this);
        if (bitfields == null || bitfields.isEmpty()) {
            return lanes;
        }
        LinkedList<BitField> lane = new LinkedList<BitField>();
        BitField.Color color = BitField.Color.GREEN;
        int used = 0;
        for (BitField bitField : bitfields.values()) {
            bitField.setColor(color);
            lane.add(bitField);
            color = BitField.Color.values()[(color.ordinal() + 1) % BitField.Color.values().length];
            color = color == BitField.Color.PADDING ? BitField.Color.RED : color;
            used += bitField.getSize();
        }
        if (used < size) {
            lane.add(BitField.BitfieldBuilder.createUnused((int)(size - used), (int)used));
        }
        lanes.put(0, lane);
        return lanes;
    }

    public IBitFieldRegister.BitFieldKind getBitFieldKind() {
        return IBitFieldRegister.BitFieldKind.ELANG_VR_AD;
    }

    public String getBitFieldDiagramHeader() {
        return "Bit Fields of vr_ad_reg";
    }

    @Override
    public __etools_string get_value() {
        _Int val = this.getValue(this.getRfProject());
        return new __etools_string(val.toString());
    }
}

