/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfOnEventLayer;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedEvent;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedModule;

public class RfEvent
extends RfStructMember {
    public RfEvent(RfProject project, RfStruct parent, FullName name) {
        super(project, name, parent);
    }

    @Override
    int getMemberKind() {
        return 5;
    }

    public String getSignature() {
        return this.getSignature(null);
    }

    @Override
    public boolean checkEquals(Object obj) {
        String eventMethodName;
        if (obj instanceof RfMethod && ((RfMethod)obj).isByEvent() && this.getParentStruct() == ((RfMethod)obj).getParentStruct() && (eventMethodName = ((RfMethod)obj).getName()).startsWith("on_") && this.getName().equals(eventMethodName.substring(3))) {
            return true;
        }
        return super.checkEquals(obj);
    }

    @Override
    public String getSignature(String typeName) {
        return "event " + this.getFullName().getDeterminant().toString() + "." + this.getName();
    }

    @Override
    public String getDefStructLayerName() {
        RfDefElement declaration = this.getDeclaration(false);
        if (declaration != null && declaration instanceof RfEventLayer) {
            return ((RfEventLayer)declaration).getDefStructLayerName();
        }
        return "";
    }

    @Override
    public int getAssociatedTypeKind() {
        return 0;
    }

    public String getAssociatedTypeName() {
        return "";
    }

    @Override
    public void setAssociatedType(RfModule module, WrapperType typeInfo) {
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        try {
            if (currLayer instanceof RfEventLayer && !(currLayer instanceof RfOnEventLayer)) {
                String name = this.getName();
                RfStructMember.FirstAndPrevLayer firstAndPrevLayer = this.getFirstAndPrevLayer(project, (RfEventLayer)currLayer);
                RfStruct parentStruct = this.getParentStruct();
                boolean hasLocalUnknownParentStruct = parentStruct.hasLocalUnknownParentStruct();
                if (!hasLocalUnknownParentStruct && (firstAndPrevLayer == null || firstAndPrevLayer.prevRawLayer == null && !this.isPredefined())) {
                    RfStruct firstStruct = firstAndPrevLayer == null ? null : firstAndPrevLayer.firstStruct;
                    boolean isFirstOrEmptyLayer = this.isFirstOrEmptyLayer(currLayer);
                    if (isFirstOrEmptyLayer && currLayer instanceof RfCoverLayer && !this.isPredefined() && this.getDeclaration(RfEventLayer.class) == null) {
                        project.addSemanticError1(1, "UNDEFINED_EVENT: Event ''{0}.{1}'' was not defined previously", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), this.getName());
                    } else if (!(firstStruct != null && firstStruct != parentStruct || isFirstOrEmptyLayer)) {
                        String errorMessage = currLayer.getClass() == RfCoverLayer.class ? "UNDEFINED_COVER: Cover group ''{0}.{1}'' was not defined previously (cannot use ''is also'')" : "UNDEFINED_EVENT: Event ''{0}.{1}'' was not defined previously";
                        project.addSemanticError1(1, errorMessage, lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), this.getName());
                    }
                    return;
                }
                RfDefElement firstLayer = firstAndPrevLayer.firstLayer;
                RfDefElement prevLayer = firstAndPrevLayer.prevLayer;
                RfDefElement prevRawLayer = firstAndPrevLayer.prevRawLayer;
                if (prevRawLayer != null && this.isEmptyLayer(currLayer) && currLayer.getClass() == prevRawLayer.getClass()) {
                    project.addSemanticError1(1, "REDEFINED_EVENT: Event ''{0}.{1}'' was previously defined (must use ''is only'')\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, prevRawLayer.getStartLine(), prevRawLayer.getParserPath());
                    return;
                }
                if (firstLayer instanceof RfEventLayer && !(firstLayer instanceof RfCoverLayer) && !(firstLayer instanceof RfOnEventLayer) && prevLayer != null) {
                    if ((this.isPrivate() || this.isPackage()) && !firstLayer.getPackageName().equals(currLayer.getPackageName())) {
                        project.addSemanticError1(1, "EVENT_ACCESS: Cannot access event ''{1}.{0}'' of package ''{2}''", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, this.getName(), parentStruct.getName(), this.getPackageName());
                    }
                    if (((RfEventLayer)currLayer).getNamedElement() == ((RfEventLayer)prevLayer).getNamedElement() && this.isFirstOrEmptyLayer(currLayer) && this.isFirstLayer(prevLayer)) {
                        project.addSemanticError1(1, "REDEFINED_EVENT: Event ''{0}.{1}'' was previously defined (must use ''is only'')\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, prevLayer.getStartLine(), prevLayer.getParserPath());
                    }
                }
            }
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean isFirstLayer(RfDefElement layer) {
        if (layer.getLayerKind() == 378) {
            return true;
        }
        return layer.getLayerKind() == 373;
    }

    private boolean isEmptyLayer(RfDefElement layer) {
        if (layer.getLayerKind() == 371) {
            return true;
        }
        return layer.getLayerKind() == 372;
    }

    private boolean isFirstOrEmptyLayer(RfDefElement layer) {
        if (this.isFirstLayer(layer)) {
            return true;
        }
        return this.isEmptyLayer(layer);
    }

    public boolean hasEventInLikeParent(Class<? extends RfEventLayer> clazz) {
        return this.getEventInLikeParent(clazz, false) != this.getParentStruct();
    }

    public RfStruct getEventInLikeParent(Class<? extends RfEventLayer> clazz, boolean breakOnFirst) {
        String name = this.getName();
        RfStruct parent = this.getParentStruct();
        if (parent == null) {
            return null;
        }
        RfStruct firstStruct = parent;
        while ((parent = parent.getParentStruct()) != null) {
            if (!parent.hasLocalMember(name, clazz, 5)) continue;
            firstStruct = parent;
            if (breakOnFirst) break;
        }
        return firstStruct;
    }

    @Override
    public int getAssociatedTypeList() {
        return 0;
    }

    @Override
    public String getAssociatedTypeListKey() {
        return null;
    }

    @Override
    public String getAssociatedFullTypeName() {
        return null;
    }

    @Override
    public Determinant getAssociatedTypeDeterminant() {
        return this.getFullName().getDeterminant();
    }

    public String getCoverGroupComment() {
        StringBuilder comments = new StringBuilder();
        String comment = null;
        List<RfDefElement> layers = this.getLayers();
        for (RfDefElement layer : layers) {
            if (!(layer instanceof RfCoverLayer) || (comment = layer.getLayerComment(true)).length() <= 0) continue;
            comments.append(comment);
            if (!comment.endsWith(".")) {
                comments.append(".");
            }
            comments.append(" ");
        }
        return comments.toString();
    }

    @Override
    public RfDefElement getFirstLayer() {
        block4: {
            if (!this.hasNoLayers()) break block4;
            return null;
        }
        try {
            for (RfDefElement layer : this.getLayers()) {
                if (layer.getLayerModule() == null || layer.getLayerModule() instanceof RfPredefinedModule || layer instanceof RfOnEventLayer) continue;
                return layer;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public RfDefElement getDeclaration(Class<? extends RfDefElement> clazz) {
        block4: {
            if (!this.hasNoLayers()) break block4;
            return null;
        }
        try {
            for (RfDefElement layer : this.getLayers()) {
                if (layer.getClass() != clazz) continue;
                return layer;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public List<RfVar> getCoverItems() {
        ArrayList<RfVar> result = new ArrayList<RfVar>();
        List<RfDefElement> layers = this.getLayers();
        if (layers == null || layers.isEmpty()) {
            return result;
        }
        for (RfDefElement layer : layers) {
            List<RfVar> variables;
            if (!(layer instanceof RfCoverLayer) || (variables = ((RfCoverLayer)layer).getSuperVariablesWithPrefix(Integer.MAX_VALUE, 2, "")) == null || variables.isEmpty()) continue;
            result.addAll(variables);
        }
        return result;
    }

    @Override
    public boolean isPredefined() {
        RfStruct parentStruct = this.getEventInLikeParent(RfEventLayer.class, true);
        if (parentStruct == this.getParentStruct() && !(this instanceof RfPredefinedEvent)) {
            return false;
        }
        if (parentStruct != null) {
            return parentStruct.isPredefined();
        }
        return false;
    }

    @Override
    public boolean isLocalPredefined() {
        return this instanceof RfPredefinedEvent;
    }
}

