/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.text.MessageFormat;
import java.util.List;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.WrapperType;

public class RfExpect
extends RfStructMember {
    private static final String ANONYMOUS_EXPECT = "[anonymous_{0}]";
    private static final String ANONYMOUS_EXPECT_PREFIX = "[anonymous_";
    private boolean fExpectNoAssume;

    public RfExpect(RfProject project, RfStruct parent, FullName name, boolean expectNoAssume) {
        super(project, name, parent);
        this.fExpectNoAssume = expectNoAssume;
    }

    @Override
    int getMemberKind() {
        return 6;
    }

    protected static String getExpectName(RfProject project, String name) {
        if (name != null) {
            return name;
        }
        return MessageFormat.format(ANONYMOUS_EXPECT, project.getAnonymousExpectCounter());
    }

    public boolean isAnonymous() {
        return this.getName().startsWith(ANONYMOUS_EXPECT_PREFIX);
    }

    public boolean isExpect() {
        return this.fExpectNoAssume;
    }

    public String getSignature() {
        return this.getSignature(null);
    }

    @Override
    public String getSignature(String typeName) {
        return "expect " + this.getParentStruct().getName() + "." + this.getName();
    }

    @Override
    public boolean isLocalPredefined() {
        return false;
    }

    @Override
    public String getDefStructLayerName() {
        RfDefElement declaration = this.getDeclaration(false);
        if (declaration != null && declaration instanceof RfExpectLayer) {
            return ((RfExpectLayer)declaration).getDefStructLayerName();
        }
        return "";
    }

    @Override
    public int getAssociatedTypeKind() {
        return 0;
    }

    public String getAssociatedTypeName() {
        return "";
    }

    @Override
    public void setAssociatedType(RfModule module, WrapperType typeInfo) {
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        try {
            if (currLayer instanceof RfExpectLayer) {
                String name = this.getName();
                RfStructMember.FirstAndPrevLayer firstAndPrevLayer = this.getFirstAndPrevLayer(project, (RfExpectLayer)currLayer);
                RfStruct parentStruct = this.getParentStruct();
                boolean hasLocalUnknownParentStruct = parentStruct.hasLocalUnknownParentStruct();
                if (!(hasLocalUnknownParentStruct || firstAndPrevLayer != null && firstAndPrevLayer.prevRawLayer != null)) {
                    RfStruct firstStruct = firstAndPrevLayer == null ? null : firstAndPrevLayer.firstStruct;
                    boolean isFirstOrEmptyLayer = this.isFirstOrEmptyLayer(currLayer);
                    if (!(firstStruct != null && firstStruct != parentStruct || isFirstOrEmptyLayer)) {
                        String errorMessage = "UNDEFINED_EXPECT: Expect ''{0}.{1}'' was not defined previously";
                        project.addSemanticError1(1, errorMessage, lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), this.getName());
                    }
                    return;
                }
                RfDefElement firstLayer = firstAndPrevLayer.firstLayer;
                RfDefElement prevLayer = firstAndPrevLayer.prevLayer;
                RfDefElement prevRawLayer = firstAndPrevLayer.prevRawLayer;
                if (prevRawLayer != null && this.isEmptyLayer(currLayer)) {
                    project.addSemanticError1(1, "REDEFINED_EXPECT: Expect ''{0}.{1}'' was previously defined\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, prevRawLayer.getStartLine(), prevRawLayer.getParserPath());
                    return;
                }
                if (firstLayer instanceof RfExpectLayer && prevLayer != null && ((RfExpectLayer)currLayer).getNamedElement() == ((RfExpectLayer)prevLayer).getNamedElement() && this.isFirstOrEmptyLayer(currLayer) && this.isFirstLayer(prevLayer)) {
                    project.addSemanticError1(1, "REDEFINED_EXPECT: Expect ''{0}.{1}'' was previously defined\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, prevLayer.getStartLine(), prevLayer.getParserPath());
                }
            }
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean isFirstOrEmptyLayer(RfDefElement layer) {
        if (this.isFirstLayer(layer)) {
            return true;
        }
        return this.isEmptyLayer(layer);
    }

    private boolean isFirstLayer(RfDefElement layer) {
        return layer.getLayerKind() == 378;
    }

    private boolean isEmptyLayer(RfDefElement layer) {
        return layer.getLayerKind() == 372;
    }

    @Override
    public int getAssociatedTypeList() {
        return 0;
    }

    @Override
    public String getAssociatedTypeListKey() {
        return null;
    }

    @Override
    public String getAssociatedFullTypeName() {
        return null;
    }

    public boolean isDefaultDutError() {
        List<RfDefElement> layers = this.getLayers();
        if (layers == null) {
            return false;
        }
        boolean defaultDutError = false;
        for (RfDefElement layer : layers) {
            if (layer.getLayerKind() == 378) {
                defaultDutError = ((RfExpectLayer)layer).isDefaultDutError();
                continue;
            }
            if (layer.getLayerKind() != 377) continue;
            return ((RfExpectLayer)layer).isDefaultDutError();
        }
        return defaultDutError;
    }

    @Override
    public Determinant getAssociatedTypeDeterminant() {
        return this.getFullName().getDeterminant();
    }
}

