/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfFieldAlias;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfFieldTypeConstraint;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfPropConstraint;
import ro.amiq.edt.base.model.reflection.RfPseudoListField;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfSpecman;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.WrapperParam;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.ascomputed.RfValueHolder;
import ro.amiq.edt.base.model.reflection.ascomputed.TransientField;
import ro.amiq.edt.base.model.reflection.ascomputed.base.IRfType;
import ro.amiq.edt.base.model.reflection.ascomputed.base._Int;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;

public class RfField
extends RfStructMember {
    private String fTypeName;
    private boolean fIsInstance;
    private String fBaseName;
    private boolean fTypeFromName;
    private boolean fGenerated;
    private boolean fPhysical;
    private int fDirection;
    private WrapperType fTypeWrapper;
    private transient boolean fAsComputedTranslate;

    public RfField(RfProject project, RfStruct parentStruct, FullName name) {
        super(project, name, parentStruct);
    }

    @Override
    public void deepClean() {
        try {
            this.fTypeWrapper = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    int getMemberKind() {
        return 2;
    }

    @Override
    public boolean hasTypeFromName() {
        return this.fTypeFromName;
    }

    public boolean isGenerated() {
        return this.fGenerated;
    }

    public boolean isPhysical() {
        return this.fPhysical;
    }

    public boolean isSDLParam() {
        if (this.fTypeWrapper != null && this.fTypeWrapper.isGenerated) {
            RfStructLayer structLayer;
            if (this.fTypeWrapper.isNotSDLParam) {
                return false;
            }
            if (this.getName().startsWith("H_")) {
                return false;
            }
            RfDefElement declaration = this.getDeclaration();
            return declaration == null || (structLayer = declaration.getStructLayer()) == null || !structLayer.isWhen();
        }
        return false;
    }

    @Override
    public void setAssociatedType(RfModule module, WrapperType typeInfo) {
        this.fTypeWrapper = typeInfo;
        if (typeInfo == null) {
            return;
        }
        this.fTypeFromName = typeInfo.typeFromName;
        this.fGenerated = typeInfo.isGenerated;
        this.fPhysical = typeInfo.isPhysical;
        WrapperParam wrapperParam = new WrapperParam(typeInfo.elemTypeName);
        wrapperParam.typeValue = new WrapperType();
        wrapperParam.typeValue.baseName = DVTStringUtil.intern((String)typeInfo.elemTypeName);
        wrapperParam.typeValue.packageName = DVTStringUtil.intern((String)typeInfo.packageName);
        wrapperParam.line = typeInfo.line;
        if (typeInfo.baseType == 4) {
            this.fBaseName = "any_simple_port";
            this.fTypeName = this.getTypeName(typeInfo.def, typeInfo.listDepth);
        } else if (typeInfo.baseType == 5) {
            this.fBaseName = "any_buffer_port";
            this.fTypeName = this.getTypeName(typeInfo.def, typeInfo.listDepth);
        } else if (typeInfo.baseType == 6) {
            this.fBaseName = "any_method_port";
            this.fTypeName = this.getTypeName(typeInfo.def, typeInfo.listDepth);
        } else if (typeInfo.baseType == 7) {
            this.fBaseName = "any_event_port";
            this.fTypeName = this.getTypeName(typeInfo.def, typeInfo.listDepth);
        } else if (typeInfo.baseType == 12) {
            this.fBaseName = typeInfo.elemTypeName;
            this.fTypeName = this.getTypeName(typeInfo.def, typeInfo.listDepth);
        } else if (typeInfo.baseType == 10) {
            this.fBaseName = typeInfo.baseName;
            this.fTypeName = this.getTypeName(typeInfo.def, typeInfo.listDepth);
        } else if (typeInfo.baseType == 9) {
            this.fBaseName = typeInfo.baseName;
            this.fTypeName = this.getTypeName(typeInfo.def == null ? this.getName() : typeInfo.def, typeInfo.listDepth);
        } else {
            this.fBaseName = typeInfo.baseName == null ? this.getName() : typeInfo.baseName;
            this.fTypeName = this.getTypeName(typeInfo.def == null ? this.getName() : typeInfo.def, typeInfo.listDepth);
        }
        this.fBaseName = DVTStringUtil.intern((String)this.fBaseName);
        this.fTypeName = DVTStringUtil.intern((String)this.fTypeName);
        this.fDirection = typeInfo.direction;
        this.fIsInstance = typeInfo.isInstance;
    }

    public void updateTypeNameFromAssociatedType() {
        if (this.fAssocType != null) {
            this.fTypeName = this.fAssocType.getName();
        }
    }

    public WrapperType getTypeInfo() {
        return this.fTypeWrapper;
    }

    @Override
    protected void addLayer(RfDefElement layer) {
        String fieldAliasName;
        String fieldName;
        super.addLayer(layer);
        RfStruct parentStruct = this.getParentStruct();
        if (parentStruct != null && (fieldName = this.getName()) != null && fieldName.length() > 0 && fieldName.charAt(0) == '_' && (fieldAliasName = layer.getUnderlineStartAliasName(fieldName)) != null) {
            RfProject project = this.getRfProject();
            parentStruct.addField(new RfFieldAlias(project, this, fieldAliasName));
        }
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        try {
            if (!(this instanceof RfFieldTypeConstraint)) {
                this.performUndefRefedCheck(project, this.getLayers(), currLayer, lineInfo, parserPath);
                if (this.isMethodPort() && this.isInput()) {
                    this.performMethodPortImplemetationCheck(project, lineInfo, parserPath);
                }
            }
            super.performAdditionalSemanticChecks(project, currLayer, lineInfo, parserPath);
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void performMethodPortImplemetationCheck(RfProject project, LineInfo lineInfo, ParserPath parserPath) {
        RfStruct struct = this.getParentStruct();
        FullName fullName = this.getFullName();
        Determinant fieldDeterminant = fullName.getDeterminant();
        RfMethod method = struct.getMethod(fullName);
        if (method != null) {
            Determinant methodDeterminant = method.getDeterminant();
            if (methodDeterminant.toArray().length == 1) {
                return;
            }
            if (fieldDeterminant.contains(methodDeterminant, true)) {
                return;
            }
        }
        project.addSemanticError1(1, "UNIMPLEMENTED_METHOD: In method port ''{0}.{1}()'' is not implemented", lineInfo.realOffset, lineInfo.realOffset + this.getName().length(), null, lineInfo.line, parserPath, struct.getName(), this.getName());
    }

    private void performUndefRefedCheck(RfProject project, List<RfDefElement> layers, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        RfStruct parent;
        if (layers == null || layers.isEmpty()) {
            return;
        }
        String name = this.getName();
        for (RfDefElement layer : layers) {
            if (layer == currLayer) break;
            if (!project.importedBySameTest(layer, currLayer)) continue;
            project.addSemanticError1(1, "REDEFINED_FIELD: Field ''{0}.{1}'' was previously defined\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, this.getParentStruct().getName(), name, layer.getStartLine(), layer.getParserPath());
            return;
        }
        if ((parent = this.getParentStruct()) != null) {
            while ((parent = parent.getParentStruct()) != null) {
                if (!parent.hasLocalMember(name, null, this.getMemberKind())) continue;
                if (parent.isPredefined()) {
                    project.addSemanticError1(1, "REDEFINED_FIELD: Field ''{0}.{1}'' was previously defined in predefined struct ''{2}''", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, this.getParentStruct().getName(), name, parent.getName());
                } else {
                    RfField field = (RfField)parent.getLocalMember(new FullName(name, new Determinant(new String[]{parent.getName()})), 2);
                    RfDefElement layer = field.getDeclaration();
                    if (layer != null && project.importedBySameTest(layer, currLayer)) {
                        project.addSemanticError1(1, "REDEFINED_FIELD: Field ''{0}.{1}'' was previously defined\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, this.getParentStruct().getName(), name, layer.getStartLine(), layer.getParserPath());
                    }
                }
                return;
            }
        }
    }

    public String getSignature() {
        String typeName = this.getSignatureTypeName();
        return this.getSignature(typeName);
    }

    public String getSignatureTypeName() {
        String typeName = this.getAssociatedFullTypeName();
        int i = 0;
        while (i < this.getAssociatedTypeList()) {
            typeName = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeName});
            ++i;
        }
        return typeName;
    }

    @Override
    public boolean isLocalPredefined() {
        return this instanceof RfPredefinedField;
    }

    @Override
    public String getSignature(String typeName) {
        if (this.getRfProject() != null && this.getRfProject().isInSDLMode()) {
            if (this.getParentStruct() != null && this.getParentStruct().isSDLScenario()) {
                RfStruct parentAgent = this.getParentStruct().getSDLEnclosingAgent();
                return "field " + (parentAgent != null ? String.valueOf(parentAgent.getName()) + "::" : "") + this.getFullName().getDeterminant().toString() + "." + this.getName() + " : " + typeName;
            }
            return "field " + this.getFullName().getDeterminant().toString() + "." + this.getName() + " : " + typeName;
        }
        return String.valueOf(this.fIsInstance ? "instance " : "field ") + this.getFullName().getDeterminant().toString() + "." + this.getName() + " : " + typeName;
    }

    public boolean isInstance() {
        return this.fIsInstance;
    }

    @Override
    public String getDefStructLayerName() {
        RfDefElement declaration = this.getDeclaration(false);
        if (declaration != null && declaration instanceof RfFieldLayer) {
            return ((RfFieldLayer)declaration).getDefStructLayerName();
        }
        return "";
    }

    public int getModuleIndex() {
        return this.getModule().getModuleIndex();
    }

    public boolean resolveVariableTypes() {
        return false;
    }

    public int getDirection() {
        return this.fDirection;
    }

    @Override
    public String getAssociatedFullTypeName() {
        Determinant determinant;
        if (this.fAssocType instanceof RfTemplateParam && (determinant = this.getAssociatedTypeDeterminant()) != null) {
            return determinant.toString();
        }
        return this.fTypeName;
    }

    public String getAssociatedTypeName() {
        return this.fBaseName;
    }

    public List<RfEnum> getAssociatedTypeEnums() {
        RfType assocType = this.getAssociatedType();
        if (assocType == null) {
            return null;
        }
        return assocType.getEnumsWithPrefix(2, "");
    }

    protected RfField newField() {
        try {
            return (RfField)this.clone();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public RfType get_type() {
        return this.getAssociatedType();
    }

    public RfDefElement get_declaration() {
        return this.getDeclaration();
    }

    public boolean is_const() {
        return this.isConst();
    }

    public boolean is_physical() {
        return this.isPhysical();
    }

    public boolean is_visible() {
        return !this.isPrivate();
    }

    public boolean is_port_instance() {
        return this.isInstance() && this.isPort();
    }

    public boolean is_ungenerated() {
        return !this.isGenerated();
    }

    public boolean is_unit_instance() {
        return this.isInstance();
    }

    @Override
    public ClassEncap toClassEncap(RfProject rfProject) {
        return this.toClassEncap(false);
    }

    public ClassEncap toClassEncap(boolean initFields) {
        RfType assocType = this.getAssociatedBaseType();
        if (assocType == null) {
            return null;
        }
        HashSet<RfType> references = new HashSet<RfType>();
        references.add(assocType);
        ArrayList<TransientField> transientFields = new ArrayList<TransientField>();
        StringBuilder javaCode = null;
        String staticAccess = this.isStatic() ? "static " : "";
        String javaTypeName = this.javaTypeName();
        String assocTypeListKey = this.getAssociatedTypeListKey();
        int assocTypeListDepth = this.getAssociatedTypeList();
        boolean isGenerated = this.isGenerated();
        if (assocTypeListDepth > 0) {
            javaCode = assocTypeListKey == null ? new StringBuilder(staticAccess).append(javaTypeName).append(" ").append(this.javaName()).append(" = new ").append(javaTypeName).append("()") : new StringBuilder(staticAccess).append(javaTypeName).append(" ").append(this.javaName()).append(" = new ").append(javaTypeName).append("(\"").append(assocTypeListKey).append("\")");
        } else if (javaTypeName.equals("Boolean")) {
            javaCode = new StringBuilder(staticAccess).append(javaTypeName).append(" ").append(this.javaName()).append(" = false");
        } else if (javaTypeName.equals("Double")) {
            javaCode = new StringBuilder(staticAccess).append(javaTypeName).append(" ").append(this.javaName()).append(" = 0D");
        } else if (javaTypeName.equals("_Int")) {
            javaCode = new StringBuilder(staticAccess).append(javaTypeName).append(" ").append(this.javaName()).append(" = _Int.ZERO");
        } else if (assocType instanceof RfScalarType && ((RfScalarType)assocType).isEnumType() && ((RfScalarType)assocType).isAnonymous()) {
            List<RfEnum> enums = this.getAssociatedTypeEnums();
            if (enums == null || enums.isEmpty()) {
                return null;
            }
            javaCode = new StringBuilder("static class ").append(javaTypeName).append(" extends ").append("AsComputedEnum").append(" {\n\n").append("    public ").append(javaTypeName).append("() {\n").append("    }\n\n").append("    public ").append(javaTypeName).append("(String name, int value) {\n").append("        fName = name;\n").append("        fValue = value;\n").append("        getEnumList().add(this);\n").append("    }\n\n");
            javaCode.append("    public List<ERange> getValueRanges(boolean full) {\n").append("    \tList<ERange> ranges = new ArrayList<ERange>();\n").append("    \ttry {\n").append("    \t\tint min = 0;\n").append("    \t\tint prevValue = 0;\n").append("    \t\tint currValue = 0;\n").append("    \t\tif (fEnumList == null || full) {\n").append("    \t\t\tranges.add(new ERange(0, AsComputedBase.MAX_UINT));\n").append("    \t\t} else {\n").append("    \t\t\tfor (int i = 0; i < fEnumList.size(); i++) {\n").append("    \t\t\t\tcurrValue = fEnumList.get(i).fValue;\n").append("    \t\t\t\tif (i == 0) {\n").append("    \t\t\t\t\tmin = currValue;\n").append("    \t\t\t\t} else if (currValue != prevValue + 1) {\n").append("    \t\t\t\t\tranges.add(new ERange(min, prevValue));\n").append("    \t\t\t\t\tmin = currValue;\n").append("    \t\t\t\t}\n").append("    \t\t\t\tprevValue = currValue;\n").append("    \t\t\t}\n\n").append("    \t\t\tif (currValue != min)\n").append("    \t\t\t\tranges.add(new ERange(min, currValue));\n").append("    \t\t}\n").append("    \t} catch (Exception e) {\n").append("    \t}\n").append("    \treturn ranges;\n").append("    }\n\n");
            int i = 0;
            while (i < enums.size()) {
                RfEnum enumElement = enums.get(i);
                javaCode.append("    public static ").append(javaTypeName).append(" ").append(enumElement.javaBaseName()).append(" = new ").append(javaTypeName).append("(\"").append(enumElement.getName()).append("\", ").append(i).append(");\n");
                ++i;
            }
            javaCode.append("\n").append("    private static ArrayList<").append(javaTypeName).append("> fEnumList;\n\n").append("    public List<").append(javaTypeName).append("> getEnumList() {\n").append("        if (fEnumList == null)\n").append("            fEnumList = new ArrayList<").append(javaTypeName).append(">();\n").append("        return fEnumList;\n").append("    }\n\n").append("    public void setEnumList(List<? extends AsComputedEnum> enumList) {\n").append("        fEnumList = (ArrayList<").append(javaTypeName).append(">)enumList;\n").append("    }\n\n").append("    public ").append(javaTypeName).append(" getDefaultValue() {\n").append("        if (fEnumList == null || fEnumList.isEmpty())\n").append("            return this;\n").append("        return fEnumList.get(0);\n").append("    }\n\n").append("\n}\n").append(javaTypeName).append(" ").append(this.javaName()).append(" = new ").append(javaTypeName).append("().getDefaultValue()");
        } else if (javaTypeName.equals("RfType") || javaTypeName.equals("RfStruct") || javaTypeName.equals("RfScalarType") || javaTypeName.equals("RfField")) {
            javaCode = new StringBuilder(staticAccess).append("transient ").append(javaTypeName).append(" ").append(this.javaName()).append(" = null");
            transientFields.add(new TransientField(javaTypeName, this.javaName()));
        } else if (javaTypeName.equals("__etools_string")) {
            javaCode = new StringBuilder(staticAccess).append(javaTypeName).append(" ").append(this.javaName()).append(" = new __etools_string()");
        } else if (initFields) {
            javaCode = new StringBuilder(staticAccess).append(javaTypeName).append(" ").append(this.javaName()).append(" = new ").append("ro.amiq.edt.base.debug.ascomputed").append(".").append(javaTypeName).append("()");
        } else {
            boolean isTemplateStruct;
            RfStruct parentStruct = this.getParentStruct();
            boolean bl = isTemplateStruct = parentStruct instanceof RfTemplateStruct && !(parentStruct instanceof RfPredefinedStruct);
            javaCode = !isGenerated ? new StringBuilder(staticAccess).append(javaTypeName).append(" ").append(this.javaName()).append(" = null") : (isTemplateStruct && ((RfTemplateStruct)parentStruct).getParameter(this.getAssociatedTypeName()) != null ? new StringBuilder(staticAccess).append(javaTypeName).append(" ").append(this.javaName()).append(" = null") : new StringBuilder(staticAccess).append(javaTypeName).append(" ").append(this.javaName()).append(" = ").append("ro.amiq.edt.base.debug.ascomputed").append(".").append(javaTypeName).append(".getDefaultValue()"));
        }
        return new ClassEncap(javaCode.toString(), this.javaName(), javaTypeName, references, false, transientFields);
    }

    public void toClassEncapInitField(boolean initFields, StringBuilder javaCode) {
        String javaName = this.javaName();
        javaCode.append("if (restoredFields == null || !restoredFields.contains(\"").append(javaName).append("\")) {\n");
        this.javaInitField(initFields, javaCode);
        javaCode.append(";\n}\n");
    }

    private void javaInitField(boolean initFields, StringBuilder javaCode) {
        RfType assocType = this.getAssociatedBaseType();
        if (assocType == null) {
            return;
        }
        String javaName = this.javaName();
        String javaTypeName = this.javaTypeName();
        int assocTypeListDepth = this.getAssociatedTypeList();
        String assocTypeListKey = this.getAssociatedTypeListKey();
        boolean isGenerated = this.isGenerated();
        if (assocTypeListDepth > 0) {
            if (assocTypeListKey == null) {
                javaCode.append(javaName).append(" = new ").append(javaTypeName).append("()");
            } else {
                javaCode.append(javaName).append(" = new ").append(javaTypeName).append("(\"").append(assocTypeListKey).append("\")");
            }
        } else if (javaTypeName.equals("Boolean")) {
            javaCode.append(javaName).append(" = false");
        } else if (javaTypeName.equals("Double")) {
            javaCode.append(javaName).append(" = 0D");
        } else if (javaTypeName.equals("_Int")) {
            javaCode.append(javaName).append(" = _Int.ZERO");
        } else if (assocType instanceof RfScalarType && ((RfScalarType)assocType).isEnumType() && ((RfScalarType)assocType).isAnonymous()) {
            List<RfEnum> enums = this.getAssociatedTypeEnums();
            if (enums == null || enums.isEmpty()) {
                return;
            }
            javaCode.append(javaName).append(" = new ").append(javaTypeName).append("().getDefaultValue()");
        } else if (javaTypeName.equals("RfType") || javaTypeName.equals("RfStruct") || javaTypeName.equals("RfScalarType") || javaTypeName.equals("RfField")) {
            javaCode.append(javaName).append(" = null");
        } else if (javaTypeName.equals("__etools_string")) {
            javaCode.append(javaName).append(" = new __etools_string()");
        } else if (initFields) {
            javaCode.append(javaName).append(" = new ").append("ro.amiq.edt.base.debug.ascomputed").append(".").append(javaTypeName).append("()");
        } else {
            boolean isTemplateStruct;
            RfStruct parentStruct = this.getParentStruct();
            boolean bl = isTemplateStruct = parentStruct instanceof RfTemplateStruct && !(parentStruct instanceof RfPredefinedStruct);
            if (!isGenerated) {
                javaCode.append(javaName).append(" = null");
            } else if (isTemplateStruct && ((RfTemplateStruct)parentStruct).getParameter(this.getAssociatedTypeName()) != null) {
                javaCode.append(javaName).append(" = null");
            } else {
                javaCode.append(javaName).append(" = ").append("ro.amiq.edt.base.debug.ascomputed").append(".").append(javaTypeName).append(".getDefaultValue()");
            }
        }
    }

    @Override
    public String toString() {
        FullName fullName = this.getFullName();
        if (fullName == null) {
            return "";
        }
        return fullName.toString();
    }

    public boolean isSimplePort() {
        if (this.getAssociatedTypeName() == null) {
            return false;
        }
        return this.getAssociatedTypeName().equals("any_simple_port");
    }

    public boolean isEventPort() {
        if (this.getAssociatedTypeName() == null) {
            return false;
        }
        return this.getAssociatedTypeName().equals("any_event_port");
    }

    public boolean isBufferPort() {
        if (this.getAssociatedTypeName() == null) {
            return false;
        }
        return this.getAssociatedTypeName().equals("any_buffer_port");
    }

    public boolean isMethodPort() {
        if (this.getAssociatedTypeName() == null) {
            return false;
        }
        return this.getAssociatedTypeName().equals("any_method_port");
    }

    public boolean isTLMPort() {
        if (this.getAssociatedTypeName() == null) {
            return false;
        }
        return RfSpecman.isTLMPort(this.getAssociatedTypeName());
    }

    public boolean isInput() {
        return this.getDirection() == 1;
    }

    public boolean isOutput() {
        return this.getDirection() == 2;
    }

    public boolean isInout() {
        return this.getDirection() == 3;
    }

    public boolean isInputPort() {
        return this.isInput() && this.isPort();
    }

    public boolean isOutputPort() {
        return this.isOutput() && this.isPort();
    }

    public boolean isInoutPort() {
        return this.isInout() && this.isPort();
    }

    public boolean isPort() {
        return this.isSimplePort() || this.isBufferPort() || this.isEventPort() || this.isMethodPort() || this.isTLMPort();
    }

    @Override
    public boolean checkEquals(Object obj) {
        boolean result = super.checkEquals(obj);
        if (result) {
            return true;
        }
        if (obj instanceof RfCoverItem && ((RfCoverItem)obj).fParentStruct == this.getParentStruct() && this.getName().equals(((RfCoverItem)obj).getName())) {
            return true;
        }
        if (obj instanceof RfFieldTypeConstraint) {
            return ((RfFieldTypeConstraint)obj).checkEquals(this);
        }
        if (obj instanceof RfPropConstraint) {
            return ((RfPropConstraint)obj).checkEquals(this);
        }
        if (obj instanceof RfMethod && this.getEnclosingScope().equals(((RfMethod)obj).getEnclosingScope()) && (this.isInputPort() || this.isInoutPort()) && this.getAssociatedTypeName().equals("any_method_port")) {
            RfMethod method = (RfMethod)obj;
            return this.getName().equals(method.getName());
        }
        if (obj instanceof RfType && this.hasTypeFromName()) {
            return this.getName().equals(((RfType)obj).getName());
        }
        if (!(obj instanceof RfField)) {
            return false;
        }
        if ((obj instanceof RfPseudoListField || this instanceof RfPseudoListField) && ((RfField)obj).getName().equals(this.getName())) {
            RfField objParentField = (RfField)obj;
            if (obj instanceof RfPseudoListField) {
                objParentField = ((RfPseudoListField)obj).getParentField();
            }
            if (objParentField == null) {
                return false;
            }
            RfField parentField = this;
            if (this instanceof RfPseudoListField) {
                parentField = ((RfPseudoListField)this).getParentField();
            }
            if (parentField == null) {
                return false;
            }
            if (parentField == objParentField) {
                return true;
            }
        }
        if (((RfField)obj).getName().equals(this.getName())) {
            RfStruct objParentStruct;
            RfStruct parentType = this.getParentStruct();
            if (parentType instanceof RfTemplateStructInstance) {
                parentType = ((RfTemplateStructInstance)parentType).getTemplateStruct();
            }
            if ((objParentStruct = ((RfField)obj).getParentStruct()) instanceof RfTemplateStructInstance) {
                objParentStruct = ((RfTemplateStructInstance)objParentStruct).getTemplateStruct();
            }
            if (objParentStruct instanceof RfTemplateStruct && parentType instanceof RfTemplateStruct) {
                if (objParentStruct == parentType) {
                    return true;
                }
                if (SemanticUtils.isChildOf(objParentStruct, parentType) || SemanticUtils.isChildOf(parentType, objParentStruct)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IRfScopeElement getEnclosingScope() {
        return this.getParentStruct();
    }

    public void asComputedTranslate() {
        this.fAsComputedTranslate = true;
    }

    public boolean isAsComputedTranslate() {
        return this.fAsComputedTranslate;
    }

    public RfNamedElement get_value(IRfType type) {
        Field[] javaFields = type.getClass().getFields();
        if (javaFields == null || javaFields.length == 0) {
            return this;
        }
        HashMap<String, Field> javaFieldsMap = new HashMap<String, Field>();
        Field[] fieldArray = javaFields;
        int n = javaFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field javaField = fieldArray[n2];
            javaFieldsMap.put(javaField.getName(), javaField);
            ++n2;
        }
        String javaFieldName = this.javaName();
        String javaTypeName = this.javaTypeName();
        Field javaField = (Field)javaFieldsMap.get(javaFieldName);
        RfProject rfProject = this.getRfProject();
        if (javaField != null) {
            try {
                javaField.setAccessible(true);
                Object javaValue = javaField.get(type);
                if (javaValue != null) {
                    return new RfValueHolder(rfProject, javaValue);
                }
            }
            catch (Exception exception) {}
        }
        if (javaTypeName.equals("Boolean")) {
            return new RfValueHolder(rfProject, false);
        }
        if (javaTypeName.equals("Double")) {
            return new RfValueHolder(rfProject, 0.0);
        }
        if (javaTypeName.equals("_Int")) {
            return new RfValueHolder(rfProject, _Int.ZERO);
        }
        if (javaTypeName.equals("__etools_string")) {
            return new RfValueHolder(rfProject, new __etools_string());
        }
        return new RfValueHolder(rfProject, (Object)null);
    }

    public __etools_string get_declaration_string() {
        return new __etools_string(String.valueOf(this.getName()) + " : " + this.fTypeWrapper.def + ";");
    }

    public Object clone_deep() throws Exception {
        return this.clone();
    }
}

