/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;

public class RfFieldPropConstraint
extends RfField {
    private RfField field;
    private String fromFieldName;
    private String toFieldName;

    public RfFieldPropConstraint(RfProject project, RfStruct parentStruct, FullName name, String fromFieldName, String toFieldName) {
        super(project, parentStruct, name);
        this.fromFieldName = fromFieldName;
        this.toFieldName = toFieldName;
    }

    @Override
    public void deepClean() {
        try {
            this.field = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public RfField getField() {
        return this.field;
    }

    public void setField(RfField field) {
        this.field = field;
    }

    public Determinant translateDeterminant(Determinant determinant) {
        if (determinant == null) {
            return determinant;
        }
        String[] chunks = determinant.toArray();
        if (chunks == null || chunks.length == 0) {
            return determinant;
        }
        int fromLength = this.fromFieldName.length();
        int i = 0;
        while (i < chunks.length) {
            String chunk = chunks[i];
            int chunkLength = chunk.length();
            chunks[i] = chunkLength == fromLength && chunk.equals(this.fromFieldName) ? this.toFieldName : (chunkLength > fromLength && chunk.endsWith(this.fromFieldName) && chunk.charAt(chunkLength - fromLength - 1) == '\'' ? String.valueOf(chunk.substring(0, chunkLength - fromLength)) + this.toFieldName : chunk);
            ++i;
        }
        return determinant;
    }
}

